/*
 * Decompiled with CFR 0.152.
 */
import edu.sdsc.grid.io.FileFactory;
import edu.sdsc.grid.io.GeneralAccount;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralFileSystem;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataField;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.MetaDataTable;
import edu.sdsc.grid.io.srb.SRBAccount;
import edu.sdsc.grid.io.srb.SRBFile;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import edu.sdsc.grid.io.srb.SRBMetaDataRecordList;
import edu.sdsc.grid.io.srb.SRBMetaDataSet;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;

public class MoreTests {
    GeneralAccount account = null;
    GeneralFileSystem fileSystem = null;
    GeneralFile file = null;
    MetaDataRecordList[] rl = null;
    MetaDataCondition[] conditions;
    MetaDataSelect[] selects;
    MetaDataTable metaDataTable;

    public MoreTests() throws Throwable {
        this(new String[0]);
    }

    public MoreTests(GeneralFile generalFile) throws Throwable {
        if (generalFile != null) {
            this.file = generalFile;
            this.fileSystem = generalFile.getFileSystem();
            this.run();
        } else {
            String[] stringArray = new String[]{generalFile.toString()};
            new MetaDataTest(stringArray);
        }
    }

    public MoreTests(String[] stringArray) throws Throwable {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        System.out.println("\n Connect to the fileSystem.");
        if (stringArray.length == 1) {
            this.file = FileFactory.newFile(new URI(stringArray[0]));
            this.fileSystem = this.file.getFileSystem();
        } else if (stringArray.length == 0) {
            this.fileSystem = FileFactory.newFileSystem(new SRBAccount());
            String string = "myJARGONMoreTestsFile";
            this.file = FileFactory.newFile(this.fileSystem, string);
        } else {
            throw new IllegalArgumentException("Wrong number of arguments sent to Test.");
        }
        this.run();
    }

    public void run() throws Throwable {
        this.file.createNewFile();
        if (this.fileSystem instanceof SRBFileSystem) {
            Object[] objectArray;
            int n;
            SRBFileSystem sRBFileSystem = (SRBFileSystem)this.fileSystem;
            this.rl = this.fileSystem.query(new MetaDataCondition[]{MetaDataSet.newCondition("user name", 0, sRBFileSystem.getUserName())}, new MetaDataSelect[]{MetaDataSet.newSelection("User Type")});
            for (n = 0; n < this.rl.length; ++n) {
                if (!this.rl[n].getStringValue(0).equals("sysadmin")) continue;
                System.out.println("Add a DN for GSI");
                sRBFileSystem.srbModifyUser(0, "testuser@sdsc", "GSI_AUTH:/C=US/O=UCSD/OU=SDSC/CN=Test User/UID=testuser", 38);
            }
            System.out.println("Add annotation");
            for (n = 0; n < this.rl.length; ++n) {
                this.rl[n] = new SRBMetaDataRecordList(SRBMetaDataSet.getField("file annotation"), "anno" + n);
                this.rl[n].addRecord(SRBMetaDataSet.getField("file annotation position"), n);
                this.file.modifyMetaData(this.rl[n]);
                Thread.sleep(1000L);
            }
            this.conditions = new MetaDataCondition[]{MetaDataSet.newCondition("file name", 0, this.file.getName())};
            this.selects = new MetaDataSelect[]{MetaDataSet.newSelection("file annotation"), MetaDataSet.newSelection("file annotation position"), MetaDataSet.newSelection("file annotation timestamp")};
            this.rl = this.fileSystem.query(this.conditions, this.selects);
            MetaDataTest.printQueryResults(this.rl);
            this.rl[0] = new SRBMetaDataRecordList(SRBMetaDataSet.getField("file annotation timestamp"), this.rl[0].getValue("file annotation timestamp").toString());
            this.rl[0].addRecord(SRBMetaDataSet.getField("file annotation"), (String)null);
            this.file.modifyMetaData(this.rl[0]);
            this.rl = this.fileSystem.query(this.conditions, this.selects);
            MetaDataTest.printQueryResults(this.rl);
            System.out.println("Shadow files");
            new ShadowFileTest(this.file, "shadow");
            System.out.println("Create a whole bunch of metadata");
            this.createTestDefinableMetaData();
            String[][] stringArray = new String[3][2];
            stringArray[1][0] = "a";
            stringArray[1][1] = "1";
            stringArray[0][0] = "b";
            stringArray[0][1] = "2";
            int[] nArray = new int[stringArray.length];
            nArray[0] = 0;
            nArray[1] = 0;
            this.metaDataTable = new MetaDataTable(nArray, stringArray);
            this.conditions = new MetaDataCondition[]{MetaDataSet.newCondition("definable metadata for files", this.metaDataTable)};
            this.selects = new MetaDataSelect[]{MetaDataSet.newSelection("definable metadata for files")};
            this.rl = sRBFileSystem.query(this.conditions, this.selects, 2);
            System.out.println(this.rl);
            MetaDataTest.printQueryResults(this.rl);
            System.out.println(this.rl);
            MetaDataTest.printQueryResults(this.rl);
            System.out.println(this.rl[0].isQueryComplete());
            while (!this.rl[0].isQueryComplete()) {
                this.rl = this.rl[0].getMoreResults(2);
                MetaDataTest.printQueryResults(this.rl);
            }
            System.out.println("md5 and proxy command");
            InputStream inputStream = sRBFileSystem.executeProxyCommand("mdfive", ((SRBFile)this.file).getServerLocalPath(), null, null, 2);
            int n2 = inputStream.read();
            if (n2 == -1) {
                // empty if block
            }
            do {
                System.out.print((char)n2);
            } while ((n2 = inputStream.read()) != -1);
            System.out.println("extensible schema");
            try {
                SRBMetaDataSet.setExtensibleSchema(this.fileSystem, "mySchema");
                this.conditions = new MetaDataCondition[]{MetaDataSet.newCondition("myExtensibleAttribute", 0, "127.0.0.1")};
                this.selects = new MetaDataSelect[]{MetaDataSet.newSelection("myExtensibleOtherAttribute"), MetaDataSet.newSelection("user name")};
                objectArray = this.fileSystem.query(this.conditions, this.selects);
                MetaDataTest.printQueryResults((MetaDataRecordList[])objectArray);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            objectArray = SRBMetaDataSet.getMetaDataGroups(this.fileSystem);
            MetaDataField[] metaDataFieldArray = objectArray[0].getFields();
        }
    }

    void createTestDefinableMetaData() throws IOException {
        GeneralFile generalFile = !this.file.isDirectory() ? FileFactory.newFile(this.file.getParentFile(), Test.TEST_DIR) : this.file;
        GeneralFile generalFile2 = null;
        GeneralFile generalFile3 = null;
        String[][] stringArrayArray = new String[][]{{"a", "1"}, {"b", "2", "b3"}, {"c", "3", "c3", "c3"}, {"d", "4", "d3", "d4", "c3"}, {"e", "5", "e3", "e4", "e5", "e6"}, {"f", "6", "f3", "f4", "f5", "f6", "f7"}, {"g", "7", "g3", "g4", "g5", "g6", "g7", "g8"}, {"h", "8", "h3", "h4", "h5", "h6", "h7", "h8", "h9"}, {"i", "9", "i3", "i4", "i5", "i6", "i7", "i8", "i9", "i10"}};
        int[] nArray = new int[]{0};
        String[][] stringArray = new String[][]{{"test", "metadata"}};
        MetaDataTable metaDataTable = new MetaDataTable(nArray, stringArray);
        for (int i = 0; i < 11; ++i) {
            SRBMetaDataRecordList sRBMetaDataRecordList = new SRBMetaDataRecordList(MetaDataSet.getField("definable metadata for directories"), metaDataTable);
            generalFile3 = FileFactory.newFile(generalFile, "dir" + i);
            generalFile3.mkdirs();
            generalFile3.modifyMetaData(sRBMetaDataRecordList);
            sRBMetaDataRecordList = new SRBMetaDataRecordList(MetaDataSet.getField("definable metadata for files"), metaDataTable);
            generalFile2 = FileFactory.newFile(generalFile, "f" + i);
            generalFile2.createNewFile();
            generalFile2.modifyMetaData(sRBMetaDataRecordList);
            generalFile2 = FileFactory.newFile(generalFile3, "dirF" + i);
            generalFile2.createNewFile();
            generalFile2.modifyMetaData(sRBMetaDataRecordList);
            metaDataTable.addRow(stringArrayArray[i], nArray[0]);
        }
    }

    public static void main(String[] stringArray) {
        try {
            MoreTests moreTests = new MoreTests(stringArray);
        }
        catch (Throwable throwable) {
            System.out.println("\nJava Error Message: " + throwable.toString());
            throwable.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

