/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.gui;

import edu.sdsc.grid.gui.ClausesPanel;
import edu.sdsc.grid.gui.ConditionChooser;
import edu.sdsc.grid.gui.MetaDataDisplay;
import edu.sdsc.grid.gui.SelectionChooser;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralFileSystem;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataField;
import edu.sdsc.grid.io.MetaDataGroup;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.srb.SRBFile;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class QueryPanel
extends JScrollPane
implements ActionListener {
    public static String LIST_BUTTON_TEXT = "List";
    static String LIST_BUTTON_IMG = "list.gif";
    public static String GRAPH_BUTTON_TEXT = "Graph";
    static String GRAPH_BUTTON_IMG = "graph.gif";
    public static String CLEAR_BUTTON_TEXT = "Clear";
    static String CLEAR_BUTTON_IMG = "clear.gif";
    public static String MORE_BUTTON_TEXT = "More Results";
    static String MORE_BUTTON_IMG = "More Results";
    public static String NO_RESULT = "No Result";
    private GeneralFileSystem fileSystem;
    private MetaDataGroup[] groups;
    private MetaDataField[] fields;
    private ClausesPanel conditionPanel;
    private ClausesPanel selectionPanel;
    private JButton listButton;
    private JButton graphButton;
    private JButton clearButton;
    private MetaDataRecordList[] rl;
    private JFrame frame;
    private JPanel panel;
    private GridBagConstraints gridBagConstraints;
    JScrollPane jScrollPane;
    private JButton moreButton;
    private JPanel containingPanel;

    public QueryPanel(GeneralFileSystem generalFileSystem) {
        this(generalFileSystem, MetaDataSet.getMetaDataGroups(true));
    }

    public QueryPanel(GeneralFileSystem generalFileSystem, MetaDataGroup[] metaDataGroupArray) {
        this.fileSystem = generalFileSystem;
        this.groups = metaDataGroupArray;
        this.conditionPanel = new ClausesPanel(new ConditionChooser(metaDataGroupArray), "Where:");
        this.selectionPanel = new ClausesPanel(new SelectionChooser(metaDataGroupArray), "Select:");
        this.init();
    }

    public QueryPanel(GeneralFileSystem generalFileSystem, MetaDataField[] metaDataFieldArray) {
        this.fileSystem = generalFileSystem;
        this.fields = metaDataFieldArray;
        this.conditionPanel = new ClausesPanel(new ConditionChooser(metaDataFieldArray), "Where:");
        this.selectionPanel = new ClausesPanel(new SelectionChooser(metaDataFieldArray), "Select:");
        this.init();
    }

    public QueryPanel(GeneralFile generalFile) {
        this(generalFile, MetaDataSet.getMetaDataGroups(true));
    }

    public QueryPanel(GeneralFile generalFile, MetaDataGroup[] metaDataGroupArray) {
        this.fileSystem = generalFile.getFileSystem();
        this.groups = metaDataGroupArray;
        this.conditionPanel = new ClausesPanel(new ConditionChooser(metaDataGroupArray), "Where:");
        this.selectionPanel = new ClausesPanel(new SelectionChooser(metaDataGroupArray), "Select:");
        this.addConditions(generalFile);
        this.init();
    }

    public QueryPanel(GeneralFile generalFile, MetaDataField[] metaDataFieldArray) {
        this.fileSystem = generalFile.getFileSystem();
        this.fields = metaDataFieldArray;
        this.conditionPanel = new ClausesPanel(new ConditionChooser(metaDataFieldArray), "Where:");
        this.selectionPanel = new ClausesPanel(new SelectionChooser(metaDataFieldArray), "Select:");
        this.addConditions(generalFile);
        this.init();
    }

    private void init() {
        this.containingPanel = new JPanel();
        this.containingPanel.setLayout(new GridBagLayout());
        this.containingPanel.setBackground(Color.WHITE);
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.gridwidth = 0;
        this.gridBagConstraints.anchor = 17;
        this.setPreferredSize(new Dimension(640, 180));
        this.setMinimumSize(new Dimension(640, 180));
        this.setBackground(Color.WHITE);
        this.containingPanel.add((Component)this.conditionPanel, this.gridBagConstraints);
        this.containingPanel.add((Component)this.selectionPanel, this.gridBagConstraints);
        this.gridBagConstraints.insets = new Insets(0, 30, 0, 0);
        this.gridBagConstraints.gridwidth = 1;
        this.listButton = new JButton(new ImageIcon(LIST_BUTTON_IMG));
        this.listButton.setActionCommand(LIST_BUTTON_TEXT);
        this.listButton.setToolTipText(LIST_BUTTON_TEXT);
        this.listButton.setMargin(new Insets(0, 0, 0, 0));
        this.setListButton(this.listButton);
        this.containingPanel.add((Component)this.listButton, this.gridBagConstraints);
        this.gridBagConstraints.gridwidth = -1;
        this.graphButton = new JButton(new ImageIcon(GRAPH_BUTTON_IMG));
        this.graphButton.setActionCommand(GRAPH_BUTTON_TEXT);
        this.graphButton.setToolTipText(GRAPH_BUTTON_TEXT);
        this.graphButton.setMargin(new Insets(0, 0, 0, 0));
        this.setGraphButton(this.graphButton);
        this.containingPanel.add((Component)this.graphButton, this.gridBagConstraints);
        this.gridBagConstraints.gridwidth = 0;
        this.clearButton = new JButton(new ImageIcon(CLEAR_BUTTON_IMG));
        this.clearButton.setActionCommand(CLEAR_BUTTON_TEXT);
        this.clearButton.setToolTipText(CLEAR_BUTTON_TEXT);
        this.clearButton.setMargin(new Insets(0, 0, 0, 0));
        this.setClearButton(this.clearButton);
        this.containingPanel.add((Component)this.clearButton, this.gridBagConstraints);
        this.gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        this.panel.setBackground(Color.WHITE);
        this.containingPanel.add((Component)this.panel, this.gridBagConstraints);
        this.setViewportView(this.containingPanel);
        this.conditionPanel.setContainer(this);
        this.selectionPanel.setContainer(this);
    }

    public void setFileSystem(GeneralFileSystem generalFileSystem) {
        if (generalFileSystem != null) {
            this.fileSystem = generalFileSystem;
        }
    }

    void setListButton(JButton jButton) {
        this.listButton = jButton;
        this.listButton.addActionListener(this);
    }

    void setGraphButton(JButton jButton) {
        this.graphButton = jButton;
        this.graphButton.addActionListener(this);
    }

    void setClearButton(JButton jButton) {
        this.clearButton = jButton;
        this.clearButton.addActionListener(this);
    }

    public GeneralFileSystem getFileSystem() {
        return this.fileSystem;
    }

    public MetaDataCondition[] getConditions() {
        return (MetaDataCondition[])this.conditionPanel.getClauses(new MetaDataCondition[0]);
    }

    public MetaDataSelect[] getSelects() {
        return (MetaDataSelect[])this.selectionPanel.getClauses(new MetaDataSelect[0]);
    }

    public void addCondition(MetaDataCondition metaDataCondition) {
        MetaDataCondition[] metaDataConditionArray = new MetaDataCondition[]{metaDataCondition};
        this.addConditions(metaDataConditionArray);
    }

    public void addConditions(MetaDataCondition[] metaDataConditionArray) {
        this.conditionPanel.addClauses(metaDataConditionArray);
    }

    void addConditions(GeneralFile generalFile) {
        Object[] objectArray = null;
        String string = null;
        int n = 0;
        String string2 = null;
        if (generalFile.isDirectory()) {
            objectArray = new MetaDataCondition[1];
            string = "directory name";
            n = 0;
            string2 = generalFile.getAbsolutePath();
            objectArray[0] = MetaDataSet.newCondition(string, n, string2);
        } else {
            int n2;
            objectArray = new MetaDataCondition[3];
            string = "directory name";
            n = 0;
            string2 = generalFile.getParent();
            objectArray[0] = MetaDataSet.newCondition(string, n, string2);
            string = "file name";
            string2 = generalFile.getName();
            objectArray[1] = MetaDataSet.newCondition(string, n, string2);
            if (generalFile instanceof SRBFile && (n2 = ((SRBFile)generalFile).getReplicaNumber()) >= 0) {
                string = "File Replica Number";
                string2 = "" + n2;
                objectArray[2] = MetaDataSet.newCondition(string, n, string2);
            }
        }
        this.conditionPanel.addClauses(objectArray);
    }

    public void addSelect(MetaDataSelect metaDataSelect) {
        MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{metaDataSelect};
        this.addSelects(metaDataSelectArray);
    }

    public void addSelects(MetaDataSelect[] metaDataSelectArray) {
        this.selectionPanel.addClauses(metaDataSelectArray);
    }

    public MetaDataRecordList[] submitQuery() throws IOException, NullPointerException {
        if (this.fileSystem != null) {
            this.rl = this.fileSystem.query(this.getConditions(), this.getSelects());
            return this.rl;
        }
        throw new NullPointerException("FileSystem cannot be null");
    }

    void displayList() {
        if (this.rl == null) {
            this.panel.add((Component)new JLabel(NO_RESULT), this.gridBagConstraints);
            this.containingPanel.validate();
            this.containingPanel.repaint();
            return;
        }
        MetaDataDisplay metaDataDisplay = new MetaDataDisplay(this.fileSystem, this.rl);
        Dimension dimension = metaDataDisplay.getPreferredSize();
        this.panel.add((Component)metaDataDisplay.getTableHeader(), this.gridBagConstraints);
        this.panel.add((Component)metaDataDisplay, this.gridBagConstraints);
        if (!this.rl[this.rl.length - 1].isQueryComplete()) {
            this.moreButton = new JButton(MORE_BUTTON_TEXT);
            dimension = new Dimension(40, 20);
            this.moreButton.setPreferredSize(dimension);
            this.moreButton.setMaximumSize(dimension);
            this.moreButton.setMinimumSize(dimension);
            this.moreButton.addActionListener(this);
            this.containingPanel.add((Component)this.moreButton, this.gridBagConstraints);
        }
        this.containingPanel.validate();
        this.containingPanel.repaint();
    }

    JPanel getResultsPanel() {
        MetaDataDisplay metaDataDisplay = new MetaDataDisplay(this.fileSystem, this.rl);
        Dimension dimension = metaDataDisplay.getPreferredSize();
        JPanel jPanel = new JPanel();
        if (this.rl == null) {
            JLabel jLabel = new JLabel(NO_RESULT);
            jPanel.add(jLabel);
            return jPanel;
        }
        this.jScrollPane = new JScrollPane(metaDataDisplay);
        dimension.setSize(dimension.width + 4, dimension.height + MetaDataDisplay.fontPixelHeight + 40);
        this.jScrollPane.setPreferredSize(dimension);
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this.jScrollPane, this.gridBagConstraints);
        if (this.rl != null && !this.rl[this.rl.length - 1].isQueryComplete()) {
            this.moreButton = new JButton(MORE_BUTTON_TEXT);
            dimension = new Dimension(40, 20);
            this.moreButton.setPreferredSize(dimension);
            this.moreButton.setMaximumSize(dimension);
            this.moreButton.setMinimumSize(dimension);
            this.moreButton.addActionListener(this);
            jPanel.add((Component)this.moreButton, this.gridBagConstraints);
        }
        return jPanel;
    }

    void displayList(boolean bl) throws IOException {
        if (bl) {
            this.rl = MetaDataRecordList.getAllResults(this.rl);
        }
        this.displayList();
    }

    void displayGraph() {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.listButton.getActionCommand().equals(actionEvent.getActionCommand())) {
            try {
                this.submitQuery();
                this.displayList();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else if (this.graphButton.getActionCommand().equals(actionEvent.getActionCommand())) {
            try {
                this.submitQuery();
                this.displayGraph();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else if (this.clearButton.getActionCommand().equals(actionEvent.getActionCommand())) {
            try {
                this.panel.removeAll();
                this.panel.validate();
                this.panel.repaint();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else if (this.moreButton.getText().equals(actionEvent.getActionCommand())) {
            try {
                if (this.rl == null) {
                    return;
                }
                MetaDataRecordList[] metaDataRecordListArray = this.rl[this.rl.length - 1].getMoreResults();
                if (metaDataRecordListArray == null) {
                    return;
                }
                MetaDataRecordList[] metaDataRecordListArray2 = new MetaDataRecordList[this.rl.length + metaDataRecordListArray.length];
                System.arraycopy(this.rl, 0, metaDataRecordListArray2, 0, this.rl.length);
                System.arraycopy(metaDataRecordListArray, 0, metaDataRecordListArray2, this.rl.length, metaDataRecordListArray.length);
                this.rl = metaDataRecordListArray2;
                this.containingPanel.add((Component)new MetaDataDisplay(this.fileSystem, this.rl), this.gridBagConstraints);
                if (this.rl[this.rl.length - 1].isQueryComplete()) {
                    this.containingPanel.remove(this.containingPanel.getComponentCount() - 1);
                    this.moreButton.validate();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

