/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io;

import edu.sdsc.grid.io.FileFactory;
import edu.sdsc.grid.io.GeneralFileInputStream;
import edu.sdsc.grid.io.GeneralFileSystem;
import edu.sdsc.grid.io.GeneralRandomAccessFile;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataSet;
import java.io.EOFException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Vector;

public class GeneralFile
implements Comparable {
    public static final int BUFFER_MAX_SIZE = 65535;
    public static char separatorChar = (char)47;
    public static String separator = "" + separatorChar;
    public static char pathSeparatorChar = (char)58;
    public static String pathSeparator = "" + pathSeparatorChar;
    public static String PATH_SEPARATOR = "/";
    public static char PATH_SEPARATOR_CHAR = (char)47;
    protected int DEBUG = GeneralFileSystem.DEBUG;
    protected GeneralFileSystem fileSystem;
    protected Vector directory;
    protected String fileName;

    protected GeneralFile(GeneralFileSystem generalFileSystem, String string, String string2) throws NullPointerException {
        this.setFileSystem(generalFileSystem);
        this.setDirectory(string);
        this.setFileName(string2);
    }

    protected GeneralFile(URI uRI) throws NullPointerException, IllegalArgumentException {
    }

    protected void finalize() throws Throwable {
        if (this.fileSystem != null) {
            this.fileSystem = null;
        }
        if (this.directory != null) {
            this.directory = null;
        }
        if (this.fileName != null) {
            this.fileName = null;
        }
    }

    protected void setFileSystem(GeneralFileSystem generalFileSystem) throws IllegalArgumentException, ClassCastException {
        if (generalFileSystem == null) {
            throw new IllegalArgumentException("Illegal fileSystem, cannot be null");
        }
        this.fileSystem = generalFileSystem;
    }

    protected void setFileName(String string) {
        int n;
        String string2 = System.getProperty("file.separator");
        if (string == null) {
            throw new NullPointerException("The file name cannot be null");
        }
        if (!string2.equals(PATH_SEPARATOR)) {
            n = string.lastIndexOf(string2);
            while (n >= 0 && string.substring(n + 1).length() > 0) {
                string = string.substring(0, n) + PATH_SEPARATOR + string.substring(n + 1);
                n = string.lastIndexOf(string2);
            }
        }
        this.fileName = string;
        if (this.fileName.length() > 1) {
            n = this.fileName.lastIndexOf(PATH_SEPARATOR);
            while (n == this.fileName.length() - 1 && n >= 0) {
                this.fileName = this.fileName.substring(0, n);
                n = this.fileName.lastIndexOf(PATH_SEPARATOR);
            }
            if (n >= 0 && this.fileName.substring(n + 1).length() > 0) {
                this.setDirectory(this.fileName.substring(0, n + 1));
                this.fileName = this.fileName.substring(n + 1);
            }
        }
    }

    protected void setDirectory(String string) {
        String string2;
        int n;
        if (this.directory == null) {
            this.directory = new Vector();
        }
        if (string == null) {
            this.directory.add("");
            return;
        }
        if (!string.startsWith(PATH_SEPARATOR)) {
            this.directory.add("");
        }
        if ((n = string.lastIndexOf(string2 = System.getProperty("file.separator"))) >= 0 && string.substring(n + 1).length() > 0) {
            string = string.substring(0, n) + PATH_SEPARATOR + string.substring(n + 1);
            n = string.lastIndexOf(string2);
        }
        while (this.directory.size() > 0 && string.startsWith(PATH_SEPARATOR)) {
            string = string.substring(1);
        }
        n = string.indexOf(PATH_SEPARATOR);
        if (n >= 0) {
            do {
                this.directory.add(string.substring(0, n));
                while ((n = (string = string.substring(n + 1)).indexOf(PATH_SEPARATOR)) == 0) {
                }
            } while (n >= 0);
        }
        if (!string.equals("") && string != null) {
            this.directory.add(string);
        }
    }

    public String getPathSeparator() {
        return PATH_SEPARATOR;
    }

    public char getPathSeparatorChar() {
        return PATH_SEPARATOR_CHAR;
    }

    public GeneralFileSystem getFileSystem() throws NullPointerException {
        if (this.fileSystem != null) {
            return this.fileSystem;
        }
        throw new NullPointerException("fileSystem is null.");
    }

    public String firstQueryResult(String string) throws IOException {
        MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[]{MetaDataSet.newSelection(string)};
        MetaDataRecordList[] metaDataRecordListArray = this.query(metaDataSelectArray);
        if (metaDataRecordListArray != null) {
            return metaDataRecordListArray[0].getStringValue(0);
        }
        return null;
    }

    public MetaDataRecordList[] query(MetaDataCondition[] metaDataConditionArray, MetaDataSelect[] metaDataSelectArray) throws IOException {
        MetaDataCondition[] metaDataConditionArray2 = null;
        String string = null;
        int n = 0;
        String string2 = null;
        int n2 = 0;
        if (metaDataConditionArray == null) {
            metaDataConditionArray = new MetaDataCondition[]{};
        } else {
            n2 = metaDataConditionArray.length;
        }
        if (this.isDirectory()) {
            metaDataConditionArray2 = new MetaDataCondition[n2 + 1];
            System.arraycopy(metaDataConditionArray, 0, metaDataConditionArray2, 0, n2);
            string = "directory name";
            n = 0;
            string2 = this.getAbsolutePath();
            metaDataConditionArray2[n2] = MetaDataSet.newCondition(string, n, string2);
        } else {
            metaDataConditionArray2 = new MetaDataCondition[n2 + 3];
            System.arraycopy(metaDataConditionArray, 0, metaDataConditionArray2, 0, n2);
            string = "directory name";
            n = 0;
            string2 = this.getParent();
            metaDataConditionArray2[n2] = MetaDataSet.newCondition(string, n, string2);
            string = "file name";
            string2 = this.fileName;
            metaDataConditionArray2[n2 + 1] = MetaDataSet.newCondition(string, n, string2);
        }
        return this.fileSystem.query(metaDataConditionArray2, metaDataSelectArray);
    }

    public MetaDataRecordList[] query(MetaDataSelect[] metaDataSelectArray) throws IOException {
        return this.query(null, metaDataSelectArray);
    }

    public MetaDataRecordList[] query(String[] stringArray) throws IOException {
        MetaDataSelect[] metaDataSelectArray = new MetaDataSelect[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            metaDataSelectArray[i] = MetaDataSet.newSelection(stringArray[i]);
        }
        return this.query(null, metaDataSelectArray);
    }

    public void modifyMetaData(MetaDataRecordList metaDataRecordList) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void copyTo(GeneralFile generalFile) throws IOException {
        this.copyTo(generalFile, false);
    }

    public void copyTo(GeneralFile generalFile, boolean bl) throws IOException {
        byte[] byArray = null;
        GeneralRandomAccessFile generalRandomAccessFile = null;
        GeneralRandomAccessFile generalRandomAccessFile2 = null;
        if (generalFile == null) {
            throw new NullPointerException();
        }
        if (this.isDirectory()) {
            GeneralFile[] generalFileArray = this.listFiles();
            generalFile.mkdir();
            if (generalFileArray != null) {
                for (int i = 0; i < generalFileArray.length; ++i) {
                    generalFileArray[i].copyTo(FileFactory.newFile(generalFile.getFileSystem(), generalFile.getAbsolutePath(), generalFileArray[i].getName()), bl);
                }
            }
        } else {
            int n;
            if (generalFile.isDirectory()) {
                generalFile = FileFactory.newFile(generalFile, this.getName());
            }
            long l = this.length();
            generalRandomAccessFile = FileFactory.newRandomAccessFile(this, "r");
            generalRandomAccessFile2 = FileFactory.newRandomAccessFile(generalFile, "rw");
            if (bl) {
                try {
                    generalRandomAccessFile2.setLength(this.length());
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    generalFile.delete();
                    generalRandomAccessFile2 = FileFactory.newRandomAccessFile(generalFile, "rw");
                }
            } else {
                generalRandomAccessFile2.seek(generalRandomAccessFile2.length());
            }
            if (l > 65535L) {
                byArray = new byte[65535];
                do {
                    if ((n = generalRandomAccessFile.read(byArray)) < 0) {
                        throw new EOFException();
                    }
                    generalRandomAccessFile2.write(byArray, 0, n);
                } while ((l -= (long)n) > 65535L);
            }
            byArray = new byte[(int)l];
            do {
                if ((n = generalRandomAccessFile.read(byArray)) < 0) {
                    throw new EOFException();
                }
                generalRandomAccessFile2.write(byArray, 0, n);
            } while ((l -= (long)n) > 0L);
            generalRandomAccessFile.close();
            generalRandomAccessFile2.close();
        }
    }

    public void copyFrom(GeneralFile generalFile) throws IOException {
        this.copyFrom(generalFile, false);
    }

    public void copyFrom(GeneralFile generalFile, boolean bl) throws IOException {
        byte[] byArray = null;
        GeneralRandomAccessFile generalRandomAccessFile = null;
        GeneralRandomAccessFile generalRandomAccessFile2 = null;
        if (generalFile == null) {
            throw new NullPointerException();
        }
        if (generalFile.isDirectory()) {
            GeneralFile[] generalFileArray = generalFile.listFiles();
            this.mkdir();
            if (generalFileArray != null) {
                for (int i = 0; i < generalFileArray.length; ++i) {
                    FileFactory.newFile(this, generalFileArray[i].getName()).copyFrom(generalFileArray[i], bl);
                }
            }
        } else {
            if (this.isDirectory()) {
                GeneralFile generalFile2 = FileFactory.newFile(this, generalFile.getName());
                generalFile2.copyFrom(generalFile);
                return;
            }
            long l = generalFile.length();
            generalRandomAccessFile = FileFactory.newRandomAccessFile(generalFile, "r");
            generalRandomAccessFile2 = FileFactory.newRandomAccessFile(this, "rw");
            if (bl) {
                try {
                    generalRandomAccessFile2.setLength(this.length());
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    this.delete();
                }
            } else {
                generalRandomAccessFile2.seek(generalRandomAccessFile2.length());
            }
            if (l > 65535L) {
                byArray = new byte[65535];
                do {
                    generalRandomAccessFile.read(byArray);
                    generalRandomAccessFile2.write(byArray);
                } while ((l -= 65535L) > 65535L);
            }
            byArray = new byte[(int)l];
            generalRandomAccessFile.read(byArray);
            generalRandomAccessFile2.write(byArray);
            generalRandomAccessFile.close();
            generalRandomAccessFile2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String checksum() throws IOException {
        if (this.isFile()) {
            long l = 0L;
            long l2 = 0L;
            GeneralFileInputStream generalFileInputStream = null;
            try {
                generalFileInputStream = FileFactory.newFileInputStream(this);
                int n = 0;
                byte[] byArray = new byte[65535];
                while ((n = generalFileInputStream.read(byArray)) > -1) {
                    for (int i = 0; i < n; ++i) {
                        l += (long)(byArray[i] & 0xFF);
                        ++l2;
                    }
                }
            }
            finally {
                if (generalFileInputStream != null) {
                    generalFileInputStream.close();
                }
            }
            if (l2 - this.length() != 0L) {
                // empty if block
            }
            long l3 = (l & 0xFFFFL) + ((l & 0xFFFFFFFFFFFFFFFFL) >> 16 & 0xFFFFL);
            l = (l3 & 0xFFFFL) + (l3 >> 16);
            return "" + l;
        }
        return null;
    }

    public boolean canRead() {
        throw new UnsupportedOperationException();
    }

    public boolean canWrite() {
        throw new UnsupportedOperationException();
    }

    public int compareTo(GeneralFile generalFile) {
        return generalFile.getAbsolutePath().compareTo(this.getAbsolutePath());
    }

    public int compareTo(Object object) throws ClassCastException {
        return this.compareTo((GeneralFile)object);
    }

    public boolean createNewFile() throws IOException {
        throw new UnsupportedOperationException();
    }

    public static GeneralFile createTempFile(String string, String string2) throws IOException, IllegalArgumentException {
        return GeneralFile.createTempFile(string, string2, null);
    }

    public static GeneralFile createTempFile(String string, String string2, GeneralFile generalFile) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean delete() {
        throw new UnsupportedOperationException();
    }

    public void deleteOnExit() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean exists() {
        throw new UnsupportedOperationException();
    }

    public GeneralFile getAbsoluteFile() {
        return FileFactory.newFile(this.fileSystem, this.getAbsolutePath());
    }

    public String getAbsolutePath() {
        if (this.directory != null && !this.directory.isEmpty()) {
            int n = this.directory.size();
            String string = (String)this.directory.firstElement();
            for (int i = 1; i < n; ++i) {
                string = string + this.getPathSeparator() + this.directory.get(i);
            }
            return string + this.getPathSeparator() + this.getName();
        }
        return this.getName();
    }

    public GeneralFile getCanonicalFile() throws IOException {
        return FileFactory.newFile(this.fileSystem, this.getCanonicalPath());
    }

    public String getCanonicalPath() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return this.fileName;
    }

    public String getParent() {
        if (this.directory != null && !this.directory.isEmpty()) {
            int n = this.directory.size();
            String string = (String)this.directory.firstElement();
            for (int i = 1; i < n; ++i) {
                string = string + separator + this.directory.get(i);
            }
            return string;
        }
        return null;
    }

    public GeneralFile getParentFile() {
        return FileFactory.newFile(this.fileSystem, this.getParent());
    }

    public String getPath() {
        return this.getAbsolutePath();
    }

    public boolean isAbsolute() {
        throw new UnsupportedOperationException();
    }

    public boolean isDirectory() {
        throw new UnsupportedOperationException();
    }

    public boolean isFile() {
        throw new UnsupportedOperationException();
    }

    public boolean isHidden() {
        throw new UnsupportedOperationException();
    }

    public long lastModified() {
        throw new UnsupportedOperationException();
    }

    public long length() {
        long l = 0L;
        String string = null;
        try {
            string = this.firstQueryResult("file size");
        }
        catch (IOException iOException) {
            if (GeneralFileSystem.DEBUG > 0) {
                iOException.printStackTrace();
            }
            return 0L;
        }
        if (string != null) {
            l = Long.parseLong(string);
        }
        return l;
    }

    public String[] list() {
        throw new UnsupportedOperationException();
    }

    public String[] list(MetaDataCondition[] metaDataConditionArray) {
        throw new UnsupportedOperationException();
    }

    public GeneralFile[] listFiles() {
        String[] stringArray = this.list();
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        GeneralFile[] generalFileArray = new GeneralFile[n];
        for (int i = 0; i < n; ++i) {
            generalFileArray[i] = FileFactory.newFile(this, stringArray[i]);
        }
        return generalFileArray;
    }

    public static GeneralFile[] listRoots() {
        throw new UnsupportedOperationException();
    }

    public static GeneralFile[] listRoots(GeneralFileSystem generalFileSystem) {
        String[] stringArray = GeneralFileSystem.roots;
        GeneralFile[] generalFileArray = new GeneralFile[stringArray.length];
        for (int i = 0; i < generalFileArray.length; ++i) {
            generalFileArray[i] = FileFactory.newFile(generalFileSystem, stringArray[i]);
        }
        return generalFileArray;
    }

    public boolean mkdir() {
        throw new UnsupportedOperationException();
    }

    public boolean mkdirs() {
        if (!this.isDirectory()) {
            int n = this.directory.size();
            GeneralFile generalFile = FileFactory.newFile(this.fileSystem, this.directory.get(0).toString());
            for (int i = 0; i < n; ++i) {
                if (generalFile.exists()) continue;
                generalFile.mkdir();
                generalFile = FileFactory.newFile(generalFile, this.directory.get(i).toString());
            }
            this.mkdir();
            return true;
        }
        return false;
    }

    public boolean renameTo(GeneralFile generalFile) throws IllegalArgumentException, NullPointerException {
        throw new UnsupportedOperationException();
    }

    public boolean setLastModified(long l) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public boolean setReadOnly() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.getPath();
    }

    public URI toURI() {
        throw new UnsupportedOperationException();
    }

    public URL toURL() throws MalformedURLException {
        throw new UnsupportedOperationException();
    }
}

