/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io;

public final class Host {
    public static final int CHAR = 0;
    public static final int SHORT = 1;
    public static final int INT = 2;
    public static final int LONG = 3;
    public static final int LONGLONG = 4;
    public static final int FLOAT = 5;
    public static final int DOUBLE = 6;
    public static final int LONGDOUBLE = 7;
    public static final int NUMBER_TYPES = 8;
    public static final int MAX_TYPE_SIZE = 64;
    private static boolean isMBF = true;
    private static final String[] typeName = new String[]{"char", "short", "int", "long", "long long", "float", "double", "long double"};
    private static final byte[] typeSize = new byte[]{1, 2, 4, 8, 8, 4, 8, 8};
    private static final short[] typeBits = new short[]{8, 16, 32, 64, 64, 32, 64, 64};
    private static final byte[] typeCompilerAlignment = new byte[]{1, 2, 4, 8, 8, 4, 8, 8};

    public static final boolean isMBFByteOrder() {
        return isMBF;
    }

    public static final boolean isLBFByteOrder() {
        return !isMBF;
    }

    public static final String getName(int n) {
        return typeName[n];
    }

    public static final byte getStorageSize(int n) {
        return typeSize[n];
    }

    public static final int getSignificantBits(int n) {
        return typeBits[n];
    }

    public static final int getCompilerAlignment(int n) {
        return typeCompilerAlignment[n];
    }

    public static final void swap(byte[] byArray, int n) {
        switch (n) {
            case 1: {
                return;
            }
            case 2: {
                byte by = byArray[0];
                byArray[0] = byArray[1];
                byArray[1] = by;
                return;
            }
            case 4: {
                byte by = byArray[0];
                byArray[0] = byArray[3];
                byArray[3] = by;
                by = byArray[1];
                byArray[1] = byArray[2];
                byArray[2] = by;
                return;
            }
            case 8: {
                byte by = byArray[0];
                byArray[0] = byArray[7];
                byArray[7] = by;
                by = byArray[1];
                byArray[1] = byArray[6];
                byArray[6] = by;
                by = byArray[2];
                byArray[2] = byArray[5];
                byArray[5] = by;
                by = byArray[3];
                byArray[3] = byArray[4];
                byArray[4] = by;
                return;
            }
        }
        int n2 = n >>> 1;
        int n3 = 0;
        int n4 = n - 1;
        while (n3 < n2) {
            byte by = byArray[n3];
            byArray[n3] = byArray[n4];
            byArray[n4] = by;
            ++n3;
            --n4;
        }
    }

    public static final void swap(byte[] byArray, int n, int n2) {
        switch (n2) {
            case 1: {
                return;
            }
            case 2: {
                byte by = byArray[n + 0];
                byArray[n + 0] = byArray[n + 1];
                byArray[n + 1] = by;
                return;
            }
            case 4: {
                byte by = byArray[n + 0];
                byArray[n + 0] = byArray[n + 3];
                byArray[n + 3] = by;
                by = byArray[n + 1];
                byArray[n + 1] = byArray[n + 2];
                byArray[n + 2] = by;
                return;
            }
            case 8: {
                byte by = byArray[n + 0];
                byArray[n + 0] = byArray[n + 7];
                byArray[n + 7] = by;
                by = byArray[n + 1];
                byArray[n + 1] = byArray[n + 6];
                byArray[n + 6] = by;
                by = byArray[n + 2];
                byArray[n + 2] = byArray[n + 5];
                byArray[n + 5] = by;
                by = byArray[n + 3];
                byArray[n + 3] = byArray[n + 4];
                byArray[n + 4] = by;
                return;
            }
        }
        int n3 = n2 >>> 1;
        int n4 = 0;
        int n5 = n2 - 1;
        while (n4 < n3) {
            byte by = byArray[n + n4];
            byArray[n + n4] = byArray[n + n5];
            byArray[n + n5] = by;
            ++n4;
            --n5;
        }
    }

    public static final void swapMultiple(byte[] byArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            Host.swap(byArray, n3, n);
            n3 += n;
        }
    }

    public static final void swapMultiple(byte[] byArray, int n, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            Host.swap(byArray, n, n2);
            n += n2;
        }
    }

    public static final short castToByte(byte[] byArray) {
        return (short)(byArray[0] & 0xFF);
    }

    public static final short castToShort(byte[] byArray) {
        return (short)((byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF);
    }

    public static final int castToUnsignedShort(byte[] byArray) {
        return (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
    }

    public static final int castToInt(byte[] byArray) {
        return (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
    }

    public static final long castToUnsignedInt(byte[] byArray) {
        return ((long)byArray[0] & 0xFFL) << 24 | ((long)byArray[1] & 0xFFL) << 16 | ((long)byArray[2] & 0xFFL) << 8 | (long)byArray[3] & 0xFFL;
    }

    public static final long castToLong(byte[] byArray) {
        return ((long)byArray[0] & 0xFFL) << 56 | ((long)byArray[1] & 0xFFL) << 48 | ((long)byArray[2] & 0xFFL) << 40 | ((long)byArray[3] & 0xFFL) << 32 | ((long)byArray[4] & 0xFFL) << 24 | ((long)byArray[5] & 0xFFL) << 16 | ((long)byArray[6] & 0xFFL) << 8 | (long)byArray[7] & 0xFFL;
    }

    public static final long castToUnsignedLong(byte[] byArray) {
        return ((long)byArray[0] & 0xFFL) << 56 | ((long)byArray[1] & 0xFFL) << 48 | ((long)byArray[2] & 0xFFL) << 40 | ((long)byArray[3] & 0xFFL) << 32 | ((long)byArray[4] & 0xFFL) << 24 | ((long)byArray[5] & 0xFFL) << 16 | ((long)byArray[6] & 0xFFL) << 8 | (long)byArray[7] & 0xFFL;
    }

    public static final long castToLongLong(byte[] byArray) {
        return ((long)byArray[0] & 0xFFL) << 56 | ((long)byArray[1] & 0xFFL) << 48 | ((long)byArray[2] & 0xFFL) << 40 | ((long)byArray[3] & 0xFFL) << 32 | ((long)byArray[4] & 0xFFL) << 24 | ((long)byArray[5] & 0xFFL) << 16 | ((long)byArray[6] & 0xFFL) << 8 | (long)byArray[7] & 0xFFL;
    }

    public static final long castToUnsignedLongLong(byte[] byArray) {
        return ((long)byArray[0] & 0xFFL) << 56 | ((long)byArray[1] & 0xFFL) << 48 | ((long)byArray[2] & 0xFFL) << 40 | ((long)byArray[3] & 0xFFL) << 32 | ((long)byArray[4] & 0xFFL) << 24 | ((long)byArray[5] & 0xFFL) << 16 | ((long)byArray[6] & 0xFFL) << 8 | (long)byArray[7] & 0xFFL;
    }

    public static final float castToFloat(byte[] byArray) {
        int n = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        return Float.intBitsToFloat(n);
    }

    public static final double castToDouble(byte[] byArray) {
        long l = ((long)byArray[0] & 0xFFL) << 56 | ((long)byArray[1] & 0xFFL) << 48 | ((long)byArray[2] & 0xFFL) << 40 | ((long)byArray[3] & 0xFFL) << 32 | ((long)byArray[4] & 0xFFL) << 24 | ((long)byArray[5] & 0xFFL) << 16 | ((long)byArray[6] & 0xFFL) << 8 | (long)byArray[7] & 0xFFL;
        return Double.longBitsToDouble(l);
    }

    public static final double castToLongDouble(byte[] byArray) {
        long l = ((long)byArray[0] & 0xFFL) << 56 | ((long)byArray[1] & 0xFFL) << 48 | ((long)byArray[2] & 0xFFL) << 40 | ((long)byArray[3] & 0xFFL) << 32 | ((long)byArray[4] & 0xFFL) << 24 | ((long)byArray[5] & 0xFFL) << 16 | ((long)byArray[6] & 0xFFL) << 8 | (long)byArray[7] & 0xFFL;
        return Double.longBitsToDouble(l);
    }

    public static final short castToByte(byte[] byArray, int n) {
        return (short)(byArray[n] & 0xFF);
    }

    public static final short castToShort(byte[] byArray, int n) {
        return (short)((byArray[n + 0] & 0xFF) << 8 | byArray[n + 1] & 0xFF);
    }

    public static final int castToUnsignedShort(byte[] byArray, int n) {
        return (byArray[n + 0] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
    }

    public static final int castToInt(byte[] byArray, int n) {
        return (byArray[n + 0] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    public static final long castToUnsignedInt(byte[] byArray, int n) {
        return ((long)byArray[n + 0] & 0xFFL) << 24 | ((long)byArray[n + 1] & 0xFFL) << 16 | ((long)byArray[n + 2] & 0xFFL) << 8 | (long)byArray[n + 3] & 0xFFL;
    }

    public static final long castToLong(byte[] byArray, int n) {
        return ((long)byArray[n + 0] & 0xFFL) << 56 | ((long)byArray[n + 1] & 0xFFL) << 48 | ((long)byArray[n + 2] & 0xFFL) << 40 | ((long)byArray[n + 3] & 0xFFL) << 32 | ((long)byArray[n + 4] & 0xFFL) << 24 | ((long)byArray[n + 5] & 0xFFL) << 16 | ((long)byArray[n + 6] & 0xFFL) << 8 | (long)byArray[n + 7] & 0xFFL;
    }

    public static final long castToUnsignedLong(byte[] byArray, int n) {
        return ((long)byArray[n + 0] & 0xFFL) << 56 | ((long)byArray[n + 1] & 0xFFL) << 48 | ((long)byArray[n + 2] & 0xFFL) << 40 | ((long)byArray[n + 3] & 0xFFL) << 32 | ((long)byArray[n + 4] & 0xFFL) << 24 | ((long)byArray[n + 5] & 0xFFL) << 16 | ((long)byArray[n + 6] & 0xFFL) << 8 | (long)byArray[n + 7] & 0xFFL;
    }

    public static final long castToLongLong(byte[] byArray, int n) {
        return ((long)byArray[n + 0] & 0xFFL) << 56 | ((long)byArray[n + 1] & 0xFFL) << 48 | ((long)byArray[n + 2] & 0xFFL) << 40 | ((long)byArray[n + 3] & 0xFFL) << 32 | ((long)byArray[n + 4] & 0xFFL) << 24 | ((long)byArray[n + 5] & 0xFFL) << 16 | ((long)byArray[n + 6] & 0xFFL) << 8 | (long)byArray[n + 7] & 0xFFL;
    }

    public static final long castToUnsignedLongLong(byte[] byArray, int n) {
        return ((long)byArray[n + 0] & 0xFFL) << 56 | ((long)byArray[n + 1] & 0xFFL) << 48 | ((long)byArray[n + 2] & 0xFFL) << 40 | ((long)byArray[n + 3] & 0xFFL) << 32 | ((long)byArray[n + 4] & 0xFFL) << 24 | ((long)byArray[n + 5] & 0xFFL) << 16 | ((long)byArray[n + 6] & 0xFFL) << 8 | (long)byArray[n + 7] & 0xFFL;
    }

    public static final float castToFloat(byte[] byArray, int n) {
        int n2 = (byArray[n + 0] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
        return Float.intBitsToFloat(n2);
    }

    public static final double castToDouble(byte[] byArray, int n) {
        long l = ((long)byArray[n + 0] & 0xFFL) << 56 | ((long)byArray[n + 1] & 0xFFL) << 48 | ((long)byArray[n + 2] & 0xFFL) << 40 | ((long)byArray[n + 3] & 0xFFL) << 32 | ((long)byArray[n + 4] & 0xFFL) << 24 | ((long)byArray[n + 5] & 0xFFL) << 16 | ((long)byArray[n + 6] & 0xFFL) << 8 | (long)byArray[n + 7] & 0xFFL;
        return Double.longBitsToDouble(l);
    }

    public static final double castToLongDouble(byte[] byArray, int n) {
        long l = ((long)byArray[n + 0] & 0xFFL) << 56 | ((long)byArray[n + 1] & 0xFFL) << 48 | ((long)byArray[n + 2] & 0xFFL) << 40 | ((long)byArray[n + 3] & 0xFFL) << 32 | ((long)byArray[n + 4] & 0xFFL) << 24 | ((long)byArray[n + 5] & 0xFFL) << 16 | ((long)byArray[n + 6] & 0xFFL) << 8 | (long)byArray[n + 7] & 0xFFL;
        return Double.longBitsToDouble(l);
    }

    public static final void copyShort(byte by, byte[] byArray) {
        short s = by;
        byArray[0] = (byte)(s >> 8);
        byArray[1] = (byte)s;
    }

    public static final void copyShort(short s, byte[] byArray) {
        byArray[0] = (byte)(s >> 8);
        byArray[1] = (byte)s;
    }

    public static final void copyShort(int n, byte[] byArray) {
        byArray[0] = (byte)(n >> 8);
        byArray[1] = (byte)n;
    }

    public static final void copyShort(long l, byte[] byArray) {
        byArray[0] = (byte)(l >> 8);
        byArray[1] = (byte)l;
    }

    public static final void copyUnsignedShort(byte by, byte[] byArray) {
        byArray[0] = 0;
        byArray[1] = by;
    }

    public static final void copyUnsignedShort(short s, byte[] byArray) {
        byArray[0] = (byte)(s >>> 8);
        byArray[1] = (byte)s;
    }

    public static final void copyUnsignedShort(int n, byte[] byArray) {
        byArray[0] = (byte)(n >>> 8);
        byArray[1] = (byte)n;
    }

    public static final void copyUnsignedShort(long l, byte[] byArray) {
        byArray[0] = (byte)(l >>> 8);
        byArray[1] = (byte)l;
    }

    public static final void copyInt(byte by, byte[] byArray) {
        byte by2 = by;
        byArray[0] = (byte)(by2 >> 24);
        byArray[1] = (byte)(by2 >> 16);
        byArray[2] = (byte)(by2 >> 8);
        byArray[3] = by2;
    }

    public static final void copyInt(short s, byte[] byArray) {
        short s2 = s;
        byArray[0] = (byte)(s2 >> 24);
        byArray[1] = (byte)(s2 >> 16);
        byArray[2] = (byte)(s2 >> 8);
        byArray[3] = (byte)s2;
    }

    public static final void copyInt(int n, byte[] byArray) {
        byArray[0] = (byte)(n >> 24);
        byArray[1] = (byte)(n >> 16);
        byArray[2] = (byte)(n >> 8);
        byArray[3] = (byte)n;
    }

    public static final void copyInt(long l, byte[] byArray) {
        byArray[0] = (byte)(l >> 24);
        byArray[1] = (byte)(l >> 16);
        byArray[2] = (byte)(l >> 8);
        byArray[3] = (byte)l;
    }

    public static final void copyUnsignedInt(byte by, byte[] byArray) {
        byArray[0] = 0;
        byArray[1] = 0;
        byArray[2] = 0;
        byArray[3] = by;
    }

    public static final void copyUnsignedInt(short s, byte[] byArray) {
        byArray[0] = 0;
        byArray[1] = 0;
        byArray[2] = (byte)(s >>> 8);
        byArray[3] = (byte)s;
    }

    public static final void copyUnsignedInt(int n, byte[] byArray) {
        byArray[0] = (byte)(n >>> 24);
        byArray[1] = (byte)(n >>> 16);
        byArray[2] = (byte)(n >>> 8);
        byArray[3] = (byte)n;
    }

    public static final void copyUnsignedInt(long l, byte[] byArray) {
        byArray[0] = (byte)(l >>> 24);
        byArray[1] = (byte)(l >>> 16);
        byArray[2] = (byte)(l >>> 8);
        byArray[3] = (byte)l;
    }

    public static final void copyLong(byte by, byte[] byArray) {
        long l = by;
        byArray[0] = (byte)(l >> 56);
        byArray[1] = (byte)(l >> 48);
        byArray[2] = (byte)(l >> 40);
        byArray[3] = (byte)(l >> 32);
        byArray[4] = (byte)(l >> 24);
        byArray[5] = (byte)(l >> 16);
        byArray[6] = (byte)(l >> 8);
        byArray[7] = (byte)l;
    }

    public static final void copyLong(short s, byte[] byArray) {
        long l = s;
        byArray[0] = (byte)(l >> 56);
        byArray[1] = (byte)(l >> 48);
        byArray[2] = (byte)(l >> 40);
        byArray[3] = (byte)(l >> 32);
        byArray[4] = (byte)(l >> 24);
        byArray[5] = (byte)(l >> 16);
        byArray[6] = (byte)(l >> 8);
        byArray[7] = (byte)l;
    }

    public static final void copyLong(int n, byte[] byArray) {
        long l = n;
        byArray[0] = (byte)(l >> 56);
        byArray[1] = (byte)(l >> 48);
        byArray[2] = (byte)(l >> 40);
        byArray[3] = (byte)(l >> 32);
        byArray[4] = (byte)(l >> 24);
        byArray[5] = (byte)(l >> 16);
        byArray[6] = (byte)(l >> 8);
        byArray[7] = (byte)l;
    }

    public static final void copyLong(long l, byte[] byArray) {
        byArray[0] = (byte)(l >> 56);
        byArray[1] = (byte)(l >> 48);
        byArray[2] = (byte)(l >> 40);
        byArray[3] = (byte)(l >> 32);
        byArray[4] = (byte)(l >> 24);
        byArray[5] = (byte)(l >> 16);
        byArray[6] = (byte)(l >> 8);
        byArray[7] = (byte)l;
    }

    public static final void copyUnsignedLong(byte by, byte[] byArray) {
        byArray[0] = 0;
        byArray[1] = 0;
        byArray[2] = 0;
        byArray[3] = 0;
        byArray[4] = 0;
        byArray[5] = 0;
        byArray[6] = 0;
        byArray[7] = by;
    }

    public static final void copyUnsignedLong(short s, byte[] byArray) {
        byArray[0] = 0;
        byArray[1] = 0;
        byArray[2] = 0;
        byArray[3] = 0;
        byArray[4] = 0;
        byArray[5] = 0;
        byArray[6] = (byte)(s >>> 8);
        byArray[7] = (byte)s;
    }

    public static final void copyUnsignedLong(int n, byte[] byArray) {
        byArray[0] = 0;
        byArray[1] = 0;
        byArray[2] = 0;
        byArray[3] = 0;
        byArray[4] = (byte)(n >>> 24);
        byArray[5] = (byte)(n >>> 16);
        byArray[6] = (byte)(n >>> 8);
        byArray[7] = (byte)n;
    }

    public static final void copyUnsignedLong(long l, byte[] byArray) {
        byArray[0] = (byte)(l >>> 56);
        byArray[1] = (byte)(l >>> 48);
        byArray[2] = (byte)(l >>> 40);
        byArray[3] = (byte)(l >>> 32);
        byArray[4] = (byte)(l >>> 24);
        byArray[5] = (byte)(l >>> 16);
        byArray[6] = (byte)(l >>> 8);
        byArray[7] = (byte)l;
    }

    public static final void copyLongLong(byte by, byte[] byArray) {
        long l = by;
        byArray[0] = (byte)(l >> 56);
        byArray[1] = (byte)(l >> 48);
        byArray[2] = (byte)(l >> 40);
        byArray[3] = (byte)(l >> 32);
        byArray[4] = (byte)(l >> 24);
        byArray[5] = (byte)(l >> 16);
        byArray[6] = (byte)(l >> 8);
        byArray[7] = (byte)l;
    }

    public static final void copyLongLong(short s, byte[] byArray) {
        long l = s;
        byArray[0] = (byte)(l >> 56);
        byArray[1] = (byte)(l >> 48);
        byArray[2] = (byte)(l >> 40);
        byArray[3] = (byte)(l >> 32);
        byArray[4] = (byte)(l >> 24);
        byArray[5] = (byte)(l >> 16);
        byArray[6] = (byte)(l >> 8);
        byArray[7] = (byte)l;
    }

    public static final void copyLongLong(int n, byte[] byArray) {
        long l = n;
        byArray[0] = (byte)(l >> 56);
        byArray[1] = (byte)(l >> 48);
        byArray[2] = (byte)(l >> 40);
        byArray[3] = (byte)(l >> 32);
        byArray[4] = (byte)(l >> 24);
        byArray[5] = (byte)(l >> 16);
        byArray[6] = (byte)(l >> 8);
        byArray[7] = (byte)l;
    }

    public static final void copyLongLong(long l, byte[] byArray) {
        byArray[0] = (byte)(l >> 56);
        byArray[1] = (byte)(l >> 48);
        byArray[2] = (byte)(l >> 40);
        byArray[3] = (byte)(l >> 32);
        byArray[4] = (byte)(l >> 24);
        byArray[5] = (byte)(l >> 16);
        byArray[6] = (byte)(l >> 8);
        byArray[7] = (byte)l;
    }

    public static final void copyUnsignedLongLong(byte by, byte[] byArray) {
        byArray[0] = 0;
        byArray[1] = 0;
        byArray[2] = 0;
        byArray[3] = 0;
        byArray[4] = 0;
        byArray[5] = 0;
        byArray[6] = 0;
        byArray[7] = by;
    }

    public static final void copyUnsignedLongLong(short s, byte[] byArray) {
        byArray[0] = 0;
        byArray[1] = 0;
        byArray[2] = 0;
        byArray[3] = 0;
        byArray[4] = 0;
        byArray[5] = 0;
        byArray[6] = (byte)(s >>> 8);
        byArray[7] = (byte)s;
    }

    public static final void copyUnsignedLongLong(int n, byte[] byArray) {
        byArray[0] = 0;
        byArray[1] = 0;
        byArray[2] = 0;
        byArray[3] = 0;
        byArray[4] = (byte)(n >>> 24);
        byArray[5] = (byte)(n >>> 16);
        byArray[6] = (byte)(n >>> 8);
        byArray[7] = (byte)n;
    }

    public static final void copyUnsignedLongLong(long l, byte[] byArray) {
        byArray[0] = (byte)(l >>> 56);
        byArray[1] = (byte)(l >>> 48);
        byArray[2] = (byte)(l >>> 40);
        byArray[3] = (byte)(l >>> 32);
        byArray[4] = (byte)(l >>> 24);
        byArray[5] = (byte)(l >>> 16);
        byArray[6] = (byte)(l >>> 8);
        byArray[7] = (byte)l;
    }

    public static final void copyFloat(float f, byte[] byArray) {
        int n = Float.floatToIntBits(f);
        byArray[0] = (byte)(n >> 24);
        byArray[1] = (byte)(n >> 16);
        byArray[2] = (byte)(n >> 8);
        byArray[3] = (byte)n;
    }

    public static final void copyFloat(double d, byte[] byArray) {
        int n = Float.floatToIntBits((float)d);
        byArray[0] = (byte)(n >> 24);
        byArray[1] = (byte)(n >> 16);
        byArray[2] = (byte)(n >> 8);
        byArray[3] = (byte)n;
    }

    public static final void copyDouble(double d, byte[] byArray) {
        long l = Double.doubleToLongBits(d);
        byArray[0] = (byte)(l >> 56);
        byArray[1] = (byte)(l >> 48);
        byArray[2] = (byte)(l >> 40);
        byArray[3] = (byte)(l >> 32);
        byArray[4] = (byte)(l >> 24);
        byArray[5] = (byte)(l >> 16);
        byArray[6] = (byte)(l >> 8);
        byArray[7] = (byte)l;
    }

    public static final void copyLongDouble(double d, byte[] byArray) {
        long l = Double.doubleToLongBits(d);
        byArray[0] = (byte)(l >> 56);
        byArray[1] = (byte)(l >> 48);
        byArray[2] = (byte)(l >> 40);
        byArray[3] = (byte)(l >> 32);
        byArray[4] = (byte)(l >> 24);
        byArray[5] = (byte)(l >> 16);
        byArray[6] = (byte)(l >> 8);
        byArray[7] = (byte)l;
    }

    public static final void copyShort(byte by, byte[] byArray, int n) {
        short s = by;
        byArray[n + 0] = (byte)(s >> 8);
        byArray[n + 1] = (byte)s;
    }

    public static final void copyShort(short s, byte[] byArray, int n) {
        byArray[n + 0] = (byte)(s >> 8);
        byArray[n + 1] = (byte)s;
    }

    public static final void copyShort(int n, byte[] byArray, int n2) {
        byArray[n2 + 0] = (byte)(n >> 8);
        byArray[n2 + 1] = (byte)n;
    }

    public static final void copyShort(long l, byte[] byArray, int n) {
        byArray[n + 0] = (byte)(l >> 8);
        byArray[n + 1] = (byte)l;
    }

    public static final void copyUnsignedShort(byte by, byte[] byArray, int n) {
        byArray[n + 0] = 0;
        byArray[n + 1] = by;
    }

    public static final void copyUnsignedShort(short s, byte[] byArray, int n) {
        byArray[n + 0] = (byte)(s >>> 8);
        byArray[n + 1] = (byte)s;
    }

    public static final void copyUnsignedShort(int n, byte[] byArray, int n2) {
        byArray[n2 + 0] = (byte)(n >>> 8);
        byArray[n2 + 1] = (byte)n;
    }

    public static final void copyUnsignedShort(long l, byte[] byArray, int n) {
        byArray[n + 0] = (byte)(l >>> 8);
        byArray[n + 1] = (byte)l;
    }

    public static final void copyInt(byte by, byte[] byArray, int n) {
        byte by2 = by;
        byArray[n + 0] = (byte)(by2 >> 24);
        byArray[n + 1] = (byte)(by2 >> 16);
        byArray[n + 2] = (byte)(by2 >> 8);
        byArray[n + 3] = by2;
    }

    public static final void copyInt(short s, byte[] byArray, int n) {
        short s2 = s;
        byArray[n + 0] = (byte)(s2 >> 24);
        byArray[n + 1] = (byte)(s2 >> 16);
        byArray[n + 2] = (byte)(s2 >> 8);
        byArray[n + 3] = (byte)s2;
    }

    public static final void copyInt(int n, byte[] byArray, int n2) {
        byArray[n2 + 0] = (byte)(n >> 24);
        byArray[n2 + 1] = (byte)(n >> 16);
        byArray[n2 + 2] = (byte)(n >> 8);
        byArray[n2 + 3] = (byte)n;
    }

    public static final void copyInt(long l, byte[] byArray, int n) {
        byArray[n + 0] = (byte)(l >> 24);
        byArray[n + 1] = (byte)(l >> 16);
        byArray[n + 2] = (byte)(l >> 8);
        byArray[n + 3] = (byte)l;
    }

    public static final void copyUnsignedInt(byte by, byte[] byArray, int n) {
        byArray[n + 0] = 0;
        byArray[n + 1] = 0;
        byArray[n + 2] = 0;
        byArray[n + 3] = by;
    }

    public static final void copyUnsignedInt(short s, byte[] byArray, int n) {
        byArray[n + 0] = 0;
        byArray[n + 1] = 0;
        byArray[n + 2] = (byte)(s >>> 8);
        byArray[n + 3] = (byte)s;
    }

    public static final void copyUnsignedInt(int n, byte[] byArray, int n2) {
        byArray[n2 + 0] = (byte)(n >>> 24);
        byArray[n2 + 1] = (byte)(n >>> 16);
        byArray[n2 + 2] = (byte)(n >>> 8);
        byArray[n2 + 3] = (byte)n;
    }

    public static final void copyUnsignedInt(long l, byte[] byArray, int n) {
        byArray[n + 0] = (byte)(l >>> 24);
        byArray[n + 1] = (byte)(l >>> 16);
        byArray[n + 2] = (byte)(l >>> 8);
        byArray[n + 3] = (byte)l;
    }

    public static final void copyLong(byte by, byte[] byArray, int n) {
        long l = by;
        byArray[n + 0] = (byte)(l >> 56);
        byArray[n + 1] = (byte)(l >> 48);
        byArray[n + 2] = (byte)(l >> 40);
        byArray[n + 3] = (byte)(l >> 32);
        byArray[n + 4] = (byte)(l >> 24);
        byArray[n + 5] = (byte)(l >> 16);
        byArray[n + 6] = (byte)(l >> 8);
        byArray[n + 7] = (byte)l;
    }

    public static final void copyLong(short s, byte[] byArray, int n) {
        long l = s;
        byArray[n + 0] = (byte)(l >> 56);
        byArray[n + 1] = (byte)(l >> 48);
        byArray[n + 2] = (byte)(l >> 40);
        byArray[n + 3] = (byte)(l >> 32);
        byArray[n + 4] = (byte)(l >> 24);
        byArray[n + 5] = (byte)(l >> 16);
        byArray[n + 6] = (byte)(l >> 8);
        byArray[n + 7] = (byte)l;
    }

    public static final void copyLong(int n, byte[] byArray, int n2) {
        long l = n;
        byArray[n2 + 0] = (byte)(l >> 56);
        byArray[n2 + 1] = (byte)(l >> 48);
        byArray[n2 + 2] = (byte)(l >> 40);
        byArray[n2 + 3] = (byte)(l >> 32);
        byArray[n2 + 4] = (byte)(l >> 24);
        byArray[n2 + 5] = (byte)(l >> 16);
        byArray[n2 + 6] = (byte)(l >> 8);
        byArray[n2 + 7] = (byte)l;
    }

    public static final void copyLong(long l, byte[] byArray, int n) {
        byArray[n + 0] = (byte)(l >> 56);
        byArray[n + 1] = (byte)(l >> 48);
        byArray[n + 2] = (byte)(l >> 40);
        byArray[n + 3] = (byte)(l >> 32);
        byArray[n + 4] = (byte)(l >> 24);
        byArray[n + 5] = (byte)(l >> 16);
        byArray[n + 6] = (byte)(l >> 8);
        byArray[n + 7] = (byte)l;
    }

    public static final void copyUnsignedLong(byte by, byte[] byArray, int n) {
        byArray[n + 0] = 0;
        byArray[n + 1] = 0;
        byArray[n + 2] = 0;
        byArray[n + 3] = 0;
        byArray[n + 4] = 0;
        byArray[n + 5] = 0;
        byArray[n + 6] = 0;
        byArray[n + 7] = by;
    }

    public static final void copyUnsignedLong(short s, byte[] byArray, int n) {
        byArray[n + 0] = 0;
        byArray[n + 1] = 0;
        byArray[n + 2] = 0;
        byArray[n + 3] = 0;
        byArray[n + 4] = 0;
        byArray[n + 5] = 0;
        byArray[n + 6] = (byte)(s >>> 8);
        byArray[n + 7] = (byte)s;
    }

    public static final void copyUnsignedLong(int n, byte[] byArray, int n2) {
        byArray[n2 + 0] = 0;
        byArray[n2 + 1] = 0;
        byArray[n2 + 2] = 0;
        byArray[n2 + 3] = 0;
        byArray[n2 + 4] = (byte)(n >>> 24);
        byArray[n2 + 5] = (byte)(n >>> 16);
        byArray[n2 + 6] = (byte)(n >>> 8);
        byArray[n2 + 7] = (byte)n;
    }

    public static final void copyUnsignedLong(long l, byte[] byArray, int n) {
        byArray[n + 0] = (byte)(l >>> 56);
        byArray[n + 1] = (byte)(l >>> 48);
        byArray[n + 2] = (byte)(l >>> 40);
        byArray[n + 3] = (byte)(l >>> 32);
        byArray[n + 4] = (byte)(l >>> 24);
        byArray[n + 5] = (byte)(l >>> 16);
        byArray[n + 6] = (byte)(l >>> 8);
        byArray[n + 7] = (byte)l;
    }

    public static final void copyLongLong(byte by, byte[] byArray, int n) {
        long l = by;
        byArray[n + 0] = (byte)(l >> 56);
        byArray[n + 1] = (byte)(l >> 48);
        byArray[n + 2] = (byte)(l >> 40);
        byArray[n + 3] = (byte)(l >> 32);
        byArray[n + 4] = (byte)(l >> 24);
        byArray[n + 5] = (byte)(l >> 16);
        byArray[n + 6] = (byte)(l >> 8);
        byArray[n + 7] = (byte)l;
    }

    public static final void copyLongLong(short s, byte[] byArray, int n) {
        long l = s;
        byArray[n + 0] = (byte)(l >> 56);
        byArray[n + 1] = (byte)(l >> 48);
        byArray[n + 2] = (byte)(l >> 40);
        byArray[n + 3] = (byte)(l >> 32);
        byArray[n + 4] = (byte)(l >> 24);
        byArray[n + 5] = (byte)(l >> 16);
        byArray[n + 6] = (byte)(l >> 8);
        byArray[n + 7] = (byte)l;
    }

    public static final void copyLongLong(int n, byte[] byArray, int n2) {
        long l = n;
        byArray[n2 + 0] = (byte)(l >> 56);
        byArray[n2 + 1] = (byte)(l >> 48);
        byArray[n2 + 2] = (byte)(l >> 40);
        byArray[n2 + 3] = (byte)(l >> 32);
        byArray[n2 + 4] = (byte)(l >> 24);
        byArray[n2 + 5] = (byte)(l >> 16);
        byArray[n2 + 6] = (byte)(l >> 8);
        byArray[n2 + 7] = (byte)l;
    }

    public static final void copyLongLong(long l, byte[] byArray, int n) {
        byArray[n + 0] = (byte)(l >> 56);
        byArray[n + 1] = (byte)(l >> 48);
        byArray[n + 2] = (byte)(l >> 40);
        byArray[n + 3] = (byte)(l >> 32);
        byArray[n + 4] = (byte)(l >> 24);
        byArray[n + 5] = (byte)(l >> 16);
        byArray[n + 6] = (byte)(l >> 8);
        byArray[n + 7] = (byte)l;
    }

    public static final void copyUnsignedLongLong(byte by, byte[] byArray, int n) {
        byArray[n + 0] = 0;
        byArray[n + 1] = 0;
        byArray[n + 2] = 0;
        byArray[n + 3] = 0;
        byArray[n + 4] = 0;
        byArray[n + 5] = 0;
        byArray[n + 6] = 0;
        byArray[n + 7] = by;
    }

    public static final void copyUnsignedLongLong(short s, byte[] byArray, int n) {
        byArray[n + 0] = 0;
        byArray[n + 1] = 0;
        byArray[n + 2] = 0;
        byArray[n + 3] = 0;
        byArray[n + 4] = 0;
        byArray[n + 5] = 0;
        byArray[n + 6] = (byte)(s >>> 8);
        byArray[n + 7] = (byte)s;
    }

    public static final void copyUnsignedLongLong(int n, byte[] byArray, int n2) {
        byArray[n2 + 0] = 0;
        byArray[n2 + 1] = 0;
        byArray[n2 + 2] = 0;
        byArray[n2 + 3] = 0;
        byArray[n2 + 4] = (byte)(n >>> 24);
        byArray[n2 + 5] = (byte)(n >>> 16);
        byArray[n2 + 6] = (byte)(n >>> 8);
        byArray[n2 + 7] = (byte)n;
    }

    public static final void copyUnsignedLongLong(long l, byte[] byArray, int n) {
        byArray[n + 0] = (byte)(l >>> 56);
        byArray[n + 1] = (byte)(l >>> 48);
        byArray[n + 2] = (byte)(l >>> 40);
        byArray[n + 3] = (byte)(l >>> 32);
        byArray[n + 4] = (byte)(l >>> 24);
        byArray[n + 5] = (byte)(l >>> 16);
        byArray[n + 6] = (byte)(l >>> 8);
        byArray[n + 7] = (byte)l;
    }

    public static final void copyFloat(float f, byte[] byArray, int n) {
        int n2 = Float.floatToIntBits(f);
        byArray[n + 0] = (byte)(n2 >> 24);
        byArray[n + 1] = (byte)(n2 >> 16);
        byArray[n + 2] = (byte)(n2 >> 8);
        byArray[n + 3] = (byte)n2;
    }

    public static final void copyFloat(double d, byte[] byArray, int n) {
        int n2 = Float.floatToIntBits((float)d);
        byArray[n + 0] = (byte)(n2 >> 24);
        byArray[n + 1] = (byte)(n2 >> 16);
        byArray[n + 2] = (byte)(n2 >> 8);
        byArray[n + 3] = (byte)n2;
    }

    public static final void copyDouble(double d, byte[] byArray, int n) {
        long l = Double.doubleToLongBits(d);
        byArray[n + 0] = (byte)(l >> 56);
        byArray[n + 1] = (byte)(l >> 48);
        byArray[n + 2] = (byte)(l >> 40);
        byArray[n + 3] = (byte)(l >> 32);
        byArray[n + 4] = (byte)(l >> 24);
        byArray[n + 5] = (byte)(l >> 16);
        byArray[n + 6] = (byte)(l >> 8);
        byArray[n + 7] = (byte)l;
    }

    public static final void copyLongDouble(double d, byte[] byArray, int n) {
        long l = Double.doubleToLongBits(d);
        byArray[n + 0] = (byte)(l >> 56);
        byArray[n + 1] = (byte)(l >> 48);
        byArray[n + 2] = (byte)(l >> 40);
        byArray[n + 3] = (byte)(l >> 32);
        byArray[n + 4] = (byte)(l >> 24);
        byArray[n + 5] = (byte)(l >> 16);
        byArray[n + 6] = (byte)(l >> 8);
        byArray[n + 7] = (byte)l;
    }

    public static final void print() {
        System.out.println("Host attributes:");
        System.out.println("  Type            Size Bits CC align");
        for (int i = 0; i < 8; ++i) {
            int n;
            StringBuffer stringBuffer = new StringBuffer("  ");
            stringBuffer.append(typeName[i]);
            int n2 = 15 - typeName[i].length();
            for (n = 0; n < n2; ++n) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(' ');
            String string = String.valueOf(typeSize[i]);
            stringBuffer.append(string);
            n2 = 4 - string.length();
            for (n = 0; n < n2; ++n) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(' ');
            string = String.valueOf(typeBits[i]);
            stringBuffer.append(string);
            n2 = 4 - string.length();
            for (n = 0; n < n2; ++n) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(' ');
            string = String.valueOf(typeCompilerAlignment[i]);
            stringBuffer.append(string);
            n2 = 4 - string.length();
            for (n = 0; n < n2; ++n) {
                stringBuffer.append(' ');
            }
            System.out.println(stringBuffer);
        }
    }
}

