/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io;

import edu.sdsc.grid.io.MetaDataField;
import edu.sdsc.grid.io.MetaDataTable;

public final class MetaDataCondition {
    public static final int EQUAL = 0;
    public static final int NOT_EQUAL = 1;
    public static final int LESS_THAN = 2;
    public static final int GREATER_THAN = 3;
    public static final int LESS_OR_EQUAL = 4;
    public static final int GREATER_OR_EQUAL = 5;
    public static final int IN = 6;
    public static final int NOT_IN = 7;
    public static final int BETWEEN = 8;
    public static final int NOT_BETWEEN = 9;
    public static final int LIKE = 10;
    public static final int NOT_LIKE = 11;
    public static final int SOUNDS_LIKE = 12;
    public static final int SOUNDS_NOT_LIKE = 13;
    public static final int SCALAR = 0;
    public static final int RANGEPAIR = 1;
    public static final int ENUM = 2;
    public static final int TABLE = 14;
    MetaDataField field;
    int operator;
    Object[] values;
    int style;
    int type;
    private static String[] operatorStrings = new String[15];

    MetaDataCondition(MetaDataField metaDataField, int n, int n2) {
        if (metaDataField == null) {
            throw new NullPointerException("field cannot be null.");
        }
        this.field = metaDataField;
        this.values = new Object[1];
        this.values[0] = new Integer(n2);
        this.type = 0;
        this.style = 0;
        this.operator = n;
    }

    MetaDataCondition(MetaDataField metaDataField, int n, float f) {
        if (metaDataField == null) {
            throw new NullPointerException("field cannot be null.");
        }
        this.field = metaDataField;
        this.values = new Object[1];
        this.values[0] = new Float(f);
        this.type = 2;
        this.style = 0;
        this.operator = n;
    }

    MetaDataCondition(MetaDataField metaDataField, int n, String string) {
        if (metaDataField == null) {
            throw new NullPointerException("field cannot be null.");
        }
        this.field = metaDataField;
        this.values = new Object[1];
        this.values[0] = string;
        this.type = 3;
        this.style = 0;
        this.operator = n;
    }

    MetaDataCondition(MetaDataField metaDataField, int n, int n2, int n3) {
        if (metaDataField == null) {
            throw new NullPointerException("field cannot be null.");
        }
        this.field = metaDataField;
        this.values = new Object[2];
        this.values[0] = new Integer(n2);
        this.values[1] = new Integer(n3);
        this.type = 0;
        this.style = 1;
        if (n != 8 && n != 9) {
            throw new IllegalArgumentException("Wrong operator.");
        }
        this.operator = n;
    }

    MetaDataCondition(MetaDataField metaDataField, int n, float f, float f2) {
        if (metaDataField == null) {
            throw new NullPointerException("field cannot be null.");
        }
        this.field = metaDataField;
        this.values = new Object[2];
        this.values[0] = new Float(f);
        this.values[1] = new Float(f2);
        this.type = 2;
        this.style = 1;
        if (n != 8 && n != 9) {
            throw new IllegalArgumentException("Wrong operator.");
        }
        this.operator = n;
    }

    MetaDataCondition(MetaDataField metaDataField, int n, String string, String string2) {
        if (metaDataField == null) {
            throw new NullPointerException("field cannot be null.");
        }
        this.field = metaDataField;
        this.values = new Object[2];
        this.values[0] = string;
        this.values[1] = string2;
        this.type = 3;
        this.style = 1;
        if (n != 8 && n != 9) {
            throw new IllegalArgumentException("Wrong operator.");
        }
        this.operator = n;
    }

    MetaDataCondition(MetaDataField metaDataField, int n, int[] nArray) {
        if (metaDataField == null) {
            throw new NullPointerException("field cannot be null.");
        }
        this.field = metaDataField;
        this.values = new Object[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this.values[i] = new Integer(nArray[i]);
        }
        this.type = 0;
        this.style = 2;
        if (n != 6 && n != 7) {
            throw new IllegalArgumentException("Wrong operator.");
        }
        this.operator = n;
    }

    MetaDataCondition(MetaDataField metaDataField, int n, float[] fArray) {
        if (metaDataField == null) {
            throw new NullPointerException("field cannot be null.");
        }
        this.field = metaDataField;
        this.values = new Object[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            this.values[i] = new Float(fArray[i]);
        }
        this.type = 2;
        this.style = 2;
        if (n != 6 && n != 7) {
            throw new IllegalArgumentException("Wrong operator.");
        }
        this.operator = n;
    }

    MetaDataCondition(MetaDataField metaDataField, int n, String[] stringArray) {
        if (metaDataField == null) {
            throw new NullPointerException("field cannot be null.");
        }
        this.field = metaDataField;
        this.values = new Object[stringArray.length];
        this.values = stringArray;
        this.type = 3;
        this.style = 2;
        if (n != 6 && n != 7) {
            throw new IllegalArgumentException("Wrong operator.");
        }
        this.operator = n;
    }

    MetaDataCondition(MetaDataField metaDataField, MetaDataTable metaDataTable) {
        if (metaDataField == null) {
            throw new NullPointerException("field cannot be null.");
        }
        this.field = metaDataField;
        this.values = new Object[1];
        this.values[0] = metaDataTable;
        this.type = 14;
        this.style = 14;
        this.operator = 0;
    }

    MetaDataCondition(MetaDataField metaDataField, int n, MetaDataTable metaDataTable) {
        if (metaDataField == null) {
            throw new NullPointerException("field cannot be null.");
        }
        this.field = metaDataField;
        this.values = new Object[1];
        this.values[0] = metaDataTable;
        this.type = 14;
        this.style = 14;
        this.operator = n;
    }

    protected void finalize() {
        if (this.field != null) {
            this.field = null;
        }
        if (this.values != null) {
            this.values = null;
        }
    }

    public MetaDataField getField() {
        return this.field;
    }

    public String getFieldName() {
        return this.field.getName();
    }

    public int getFieldType() {
        return this.field.getType();
    }

    public int getOperator() {
        return this.operator;
    }

    public int getStyle() {
        return this.style;
    }

    public int getCount() {
        return this.values.length;
    }

    public int getIntValue(int n) {
        if (n < this.values.length && n >= 0) {
            if (this.style == 14) {
                throw new UnsupportedOperationException();
            }
            if (this.type == 0) {
                return (Integer)this.values[n];
            }
            if (this.type == 2) {
                return ((Float)this.values[n]).intValue();
            }
            if (this.type == 3) {
                return new Integer(this.values[n].toString());
            }
        }
        throw new IllegalArgumentException();
    }

    public float getFloatValue(int n) {
        if (n < this.values.length && n >= 0) {
            if (this.style == 14) {
                throw new UnsupportedOperationException();
            }
            if (this.type == 0) {
                return ((Integer)this.values[n]).floatValue();
            }
            if (this.type == 2) {
                return ((Float)this.values[n]).floatValue();
            }
            if (this.type == 3) {
                return new Float(this.values[n].toString()).floatValue();
            }
        }
        throw new IllegalArgumentException();
    }

    public String getStringValue(int n) {
        if (n < this.values.length && n >= 0) {
            if (this.style == 14) {
                return "TABLE";
            }
            if (this.type == 0) {
                return ((Integer)this.values[n]).toString();
            }
            if (this.type == 2) {
                return ((Float)this.values[n]).toString();
            }
            if (this.type == 3) {
                if (this.values[n] == null) {
                    return "";
                }
                return this.values[n].toString();
            }
        }
        throw new IllegalArgumentException();
    }

    public int getIntValue() {
        return this.getIntValue(0);
    }

    public float getFloatValue() {
        return this.getFloatValue(0);
    }

    public String getStringValue() {
        return this.getStringValue(0);
    }

    public MetaDataTable getTableValue() {
        if (this.style != 14) {
            return null;
        }
        return (MetaDataTable)this.values[0];
    }

    public String toString() {
        String string = new String(this.field.getName());
        string = string + " " + MetaDataCondition.getOperatorString(this.operator);
        for (int i = 0; i < this.values.length; ++i) {
            string = string + " " + this.values[i];
        }
        return string;
    }

    public boolean equals(Object object) {
        try {
            if (object == null) {
                return false;
            }
            MetaDataCondition metaDataCondition = (MetaDataCondition)object;
            if (this.getField().equals(metaDataCondition.getField()) && this.getOperator() == metaDataCondition.getOperator()) {
                for (int i = 0; i < this.values.length; ++i) {
                    if (this.values[i].equals(metaDataCondition.values[i])) continue;
                    return false;
                }
                return true;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return false;
    }

    public static String getOperatorString(int n) {
        if (n < 0 || n >= operatorStrings.length) {
            throw new IllegalArgumentException();
        }
        return operatorStrings[n];
    }

    public static String[] getOperatorStrings() {
        return operatorStrings;
    }

    public String getOperatorString() {
        if (this.operator < 0 || this.operator >= operatorStrings.length) {
            throw new IllegalArgumentException();
        }
        return operatorStrings[this.operator];
    }

    static {
        MetaDataCondition.operatorStrings[0] = "=";
        MetaDataCondition.operatorStrings[1] = "<>";
        MetaDataCondition.operatorStrings[2] = "<";
        MetaDataCondition.operatorStrings[3] = ">";
        MetaDataCondition.operatorStrings[4] = "<=";
        MetaDataCondition.operatorStrings[5] = ">=";
        MetaDataCondition.operatorStrings[6] = "in";
        MetaDataCondition.operatorStrings[7] = "not in";
        MetaDataCondition.operatorStrings[8] = "between";
        MetaDataCondition.operatorStrings[9] = "not between";
        MetaDataCondition.operatorStrings[10] = "like";
        MetaDataCondition.operatorStrings[11] = "not like";
        MetaDataCondition.operatorStrings[12] = "sounds like";
        MetaDataCondition.operatorStrings[13] = "sounds not like";
        MetaDataCondition.operatorStrings[14] = "TABLE";
    }
}

