/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io;

import edu.sdsc.grid.io.MetaDataField;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.MetaDataTable;
import java.io.IOException;
import java.util.Vector;

public abstract class MetaDataRecordList {
    protected MetaDataField[] fields;
    protected Object[] records;

    protected MetaDataRecordList(MetaDataField[] metaDataFieldArray, Object[] objectArray) {
        if (metaDataFieldArray == null) {
            throw new NullPointerException("fields cannot be null");
        }
        int n = metaDataFieldArray.length;
        if (n != objectArray.length) {
            throw new IllegalArgumentException();
        }
        this.fields = metaDataFieldArray;
        this.records = new Object[n];
        System.arraycopy(objectArray, 0, this.records, 0, objectArray.length);
    }

    public MetaDataRecordList(MetaDataField metaDataField, int n) {
        if (metaDataField == null) {
            throw new NullPointerException("field cannot be null");
        }
        this.fields = new MetaDataField[1];
        this.fields[0] = metaDataField;
        this.records = new Object[1];
        this.records[0] = new Integer(n);
    }

    public MetaDataRecordList(MetaDataField metaDataField, float f) {
        if (metaDataField == null) {
            throw new NullPointerException("field cannot be null");
        }
        this.fields = new MetaDataField[1];
        this.fields[0] = metaDataField;
        this.records = new Object[1];
        this.records[0] = new Float(f);
    }

    public MetaDataRecordList(MetaDataField metaDataField, Integer n) {
        if (metaDataField == null) {
            throw new NullPointerException("field cannot be null");
        }
        this.fields = new MetaDataField[1];
        this.fields[0] = metaDataField;
        this.records = new Object[1];
        this.records[0] = n;
    }

    public MetaDataRecordList(MetaDataField metaDataField, Float f) {
        if (metaDataField == null) {
            throw new NullPointerException("field cannot be null");
        }
        this.fields = new MetaDataField[1];
        this.fields[0] = metaDataField;
        this.records = new Object[1];
        this.records[0] = f;
    }

    public MetaDataRecordList(MetaDataField metaDataField, String string) {
        if (metaDataField == null) {
            throw new NullPointerException("field cannot be null");
        }
        this.fields = new MetaDataField[1];
        this.fields[0] = metaDataField;
        this.records = new Object[1];
        this.records[0] = string;
    }

    public MetaDataRecordList(MetaDataField metaDataField, MetaDataTable metaDataTable) {
        if (metaDataField == null) {
            throw new NullPointerException("field cannot be null");
        }
        this.fields = new MetaDataField[1];
        this.fields[0] = metaDataField;
        this.records = new Object[1];
        this.records[0] = metaDataTable;
    }

    protected void finalize() {
        if (this.records != null) {
            this.records = null;
        }
        if (this.fields != null) {
            this.fields = null;
        }
    }

    public int getFieldCount() {
        if (this.fields != null) {
            return this.fields.length;
        }
        return -1;
    }

    public MetaDataField[] getFields() {
        return this.fields;
    }

    public MetaDataField getField(int n) {
        if (this.fields != null) {
            return this.fields[n];
        }
        return null;
    }

    public String getFieldName(int n) {
        if (this.fields != null && n < this.fields.length) {
            return this.fields[n].getName();
        }
        return null;
    }

    public int getFieldType(int n) {
        if (this.fields != null) {
            return this.fields[n].getType();
        }
        return -1;
    }

    public int getFieldIndex(String string) {
        if (this.fields != null && string != null) {
            for (int i = 0; i < this.fields.length; ++i) {
                if (!this.fields[i].getName().equals(string)) continue;
                return i;
            }
        }
        return -1;
    }

    public int getRecordCount() {
        if (this.records != null) {
            return this.records.length;
        }
        return -1;
    }

    public int getIntValue(int n) {
        if (this.records == null) {
            throw new NullPointerException();
        }
        if (this.records[n] == null) {
            throw new NullPointerException("Value at index is null.");
        }
        if (this.records[n] instanceof MetaDataTable) {
            throw new IllegalArgumentException("Value at this index is a table.");
        }
        if (this.records[n] instanceof Integer) {
            return (Integer)this.records[n];
        }
        if (this.records[n] instanceof Float) {
            return ((Float)this.records[n]).intValue();
        }
        return Integer.parseInt(this.records[n].toString());
    }

    public float getFloatValue(int n) {
        if (this.records == null) {
            throw new NullPointerException();
        }
        if (this.records[n] == null) {
            throw new NullPointerException("Value at index is null.");
        }
        if (this.records[n] instanceof MetaDataTable) {
            throw new IllegalArgumentException("Value at this index is a table.");
        }
        if (this.records[n] instanceof Integer) {
            return ((Integer)this.records[n]).floatValue();
        }
        if (this.records[n] instanceof Float) {
            return ((Float)this.records[n]).floatValue();
        }
        return Float.parseFloat(this.records[n].toString());
    }

    public String getStringValue(int n) {
        if (this.records == null) {
            throw new NullPointerException();
        }
        if (this.records[n] == null) {
            return null;
        }
        if (this.records[n] instanceof MetaDataTable) {
            throw new IllegalArgumentException("Value at this index is a table.");
        }
        if (this.records[n] instanceof Integer) {
            return this.records[n].toString();
        }
        if (this.records[n] instanceof Float) {
            return this.records[n].toString();
        }
        return this.records[n].toString();
    }

    public MetaDataTable getTableValue(int n) {
        if (this.records == null) {
            throw new NullPointerException();
        }
        if (this.records[n] == null) {
            return null;
        }
        if (this.records[n] instanceof MetaDataTable) {
            try {
                return (MetaDataTable)this.records[n];
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return null;
    }

    Object[] getAllValues() {
        return this.records;
    }

    public Object getValue(int n) {
        return this.records[n];
    }

    public Object getValue(MetaDataField metaDataField) {
        for (int i = 0; i < this.fields.length; ++i) {
            if (!this.fields[i].equals(metaDataField)) continue;
            return this.records[i];
        }
        return null;
    }

    public Object getValue(String string) {
        return this.getValue(MetaDataSet.getField(string));
    }

    public void setValue(int n, int n2) throws ArrayIndexOutOfBoundsException {
        int n3 = this.fields[n].getType();
        if (n3 == 2) {
            this.records[n] = new Float(n2);
        } else if (n3 == 3) {
            this.records[n] = new Integer(n2).toString();
        } else {
            if (n3 == 14) {
                throw new IllegalArgumentException(this.fields[n] + " only accepts MetaDataTable values.");
            }
            this.records[n] = new Integer(n2);
        }
    }

    public void setValue(int n, float f) throws ArrayIndexOutOfBoundsException {
        int n2 = this.fields[n].getType();
        if (n2 == 0) {
            this.records[n] = new Integer((int)f);
        } else if (n2 == 3) {
            this.records[n] = new Float(f).toString();
        } else {
            if (n2 == 14) {
                throw new IllegalArgumentException(this.fields[n] + " only accepts MetaDataTable values.");
            }
            this.records[n] = new Float(f);
        }
    }

    public void setValue(int n, String string) throws ArrayIndexOutOfBoundsException {
        int n2 = this.fields[n].getType();
        if (n2 == 0) {
            this.records[n] = new Integer(string);
        } else if (n2 == 2) {
            this.records[n] = new String(string);
        } else {
            if (n2 == 14) {
                throw new IllegalArgumentException(this.fields[n] + " only accepts MetaDataTable values.");
            }
            this.records[n] = string;
        }
    }

    public void setValue(int n, MetaDataTable metaDataTable) throws ArrayIndexOutOfBoundsException {
        int n2 = this.fields[n].getType();
        if (n2 != 14) {
            throw new IllegalArgumentException(this.fields[n] + " does not accept MetaDataTable values.");
        }
        this.records[n] = metaDataTable;
    }

    public boolean setValue(MetaDataField metaDataField, int n) throws ArrayIndexOutOfBoundsException {
        for (int i = 0; i < this.fields.length; ++i) {
            if (!this.fields[i].equals(metaDataField)) continue;
            this.setValue(i, n);
            return true;
        }
        return false;
    }

    public boolean setValue(MetaDataField metaDataField, float f) throws ArrayIndexOutOfBoundsException {
        for (int i = 0; i < this.fields.length; ++i) {
            if (!this.fields[i].equals(metaDataField)) continue;
            this.setValue(i, f);
            return true;
        }
        return false;
    }

    public boolean setValue(MetaDataField metaDataField, String string) throws ArrayIndexOutOfBoundsException {
        for (int i = 0; i < this.fields.length; ++i) {
            if (!this.fields[i].equals(metaDataField)) continue;
            this.setValue(i, string);
            return true;
        }
        return false;
    }

    public boolean setValue(MetaDataField metaDataField, MetaDataTable metaDataTable) throws ArrayIndexOutOfBoundsException {
        for (int i = 0; i < this.fields.length; ++i) {
            if (!this.fields[i].equals(metaDataField)) continue;
            this.setValue(i, metaDataTable);
            return true;
        }
        return false;
    }

    protected boolean addRecord(MetaDataField metaDataField, Object object) {
        for (int i = 0; i < this.fields.length; ++i) {
            if (!this.fields[i].equals(metaDataField)) continue;
            this.records[i] = object;
            return false;
        }
        MetaDataField[] metaDataFieldArray = this.fields;
        Object[] objectArray = this.records;
        int n = metaDataFieldArray.length;
        this.fields = new MetaDataField[n + 1];
        System.arraycopy(metaDataFieldArray, 0, this.fields, 0, n);
        this.fields[n] = metaDataField;
        this.records = new Object[n + 1];
        System.arraycopy(objectArray, 0, this.records, 0, n);
        this.records[n] = object;
        return true;
    }

    public void addRecord(MetaDataField metaDataField, int n) {
        this.addRecord(metaDataField, new Integer(n));
        this.setValue(metaDataField, n);
    }

    public void addRecord(MetaDataField metaDataField, float f) {
        this.addRecord(metaDataField, new Float(f));
        this.setValue(metaDataField, f);
    }

    public void addRecord(MetaDataField metaDataField, String string) {
        this.addRecord(metaDataField, (Object)string);
        this.setValue(metaDataField, string);
    }

    public void addRecord(MetaDataField metaDataField, MetaDataTable metaDataTable) {
        if (metaDataField.getType() != 14) {
            throw new IllegalArgumentException(metaDataField + " only accepts MetaDataTable values.");
        }
        this.addRecord(metaDataField, (Object)metaDataTable);
    }

    public void removeRecord(int n) {
        MetaDataField[] metaDataFieldArray = this.fields;
        Object[] objectArray = this.records;
        this.fields = new MetaDataField[metaDataFieldArray.length - 1];
        this.records = new Object[objectArray.length - 1];
        if (n > 0) {
            System.arraycopy(metaDataFieldArray, 0, this.fields, 0, n);
            System.arraycopy(objectArray, 0, this.records, 0, n);
        }
        System.arraycopy(metaDataFieldArray, n + 1, this.fields, n, metaDataFieldArray.length - 1 - n);
        System.arraycopy(objectArray, n + 1, this.records, n, objectArray.length - 1 - n);
    }

    public void removeRecord(MetaDataField metaDataField) {
        for (int i = 0; i < this.fields.length; ++i) {
            if (!this.fields[i].equals(metaDataField)) continue;
            this.removeRecord(i);
        }
    }

    public abstract boolean isQueryComplete();

    public abstract MetaDataRecordList[] getMoreResults() throws IOException;

    public abstract MetaDataRecordList[] getMoreResults(int var1) throws IOException;

    public static MetaDataRecordList[] getAllResults(MetaDataRecordList[] metaDataRecordListArray) throws IOException {
        int n;
        if (metaDataRecordListArray == null) {
            return null;
        }
        if (metaDataRecordListArray[metaDataRecordListArray.length - 1].isQueryComplete()) {
            return metaDataRecordListArray;
        }
        Vector<MetaDataRecordList> vector = new Vector<MetaDataRecordList>();
        while (metaDataRecordListArray != null && metaDataRecordListArray[metaDataRecordListArray.length - 1] != null && !metaDataRecordListArray[metaDataRecordListArray.length - 1].isQueryComplete()) {
            for (n = 0; n < metaDataRecordListArray.length; ++n) {
                vector.add(metaDataRecordListArray[n]);
            }
            metaDataRecordListArray = metaDataRecordListArray[metaDataRecordListArray.length - 1].getMoreResults();
        }
        for (n = 0; n < metaDataRecordListArray.length; ++n) {
            vector.add(metaDataRecordListArray[n]);
        }
        return vector.toArray(metaDataRecordListArray);
    }

    public String toString() {
        int n = this.getRecordCount();
        String string = "Total records: " + n + "\n";
        for (int i = 0; i < n; ++i) {
            string = this.records[i] != null ? string + this.getFieldName(i) + ": " + this.records[i].toString() + "\n" : string + this.getFieldName(i) + ": null\n";
        }
        return string;
    }

    public boolean equals(Object object) {
        try {
            int n;
            int n2;
            if (object == null) {
                return false;
            }
            MetaDataRecordList metaDataRecordList = (MetaDataRecordList)object;
            MetaDataField[] metaDataFieldArray = metaDataRecordList.fields;
            Object[] objectArray = metaDataRecordList.records;
            boolean bl = false;
            for (n2 = 0; n2 < this.fields.length; ++n2) {
                for (n = n2; n < metaDataFieldArray.length; ++n) {
                    if (!this.fields[n2].equals(metaDataFieldArray[n])) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    return false;
                }
                bl = false;
            }
            for (n2 = 0; n2 < this.records.length; ++n2) {
                for (n = n2; n < objectArray.length; ++n) {
                    if (!this.records[n2].equals(objectArray[n])) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    return false;
                }
                bl = false;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return true;
    }
}

