/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.ftp;

import edu.sdsc.grid.io.GeneralAccount;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.RemoteFileSystem;
import edu.sdsc.grid.io.ftp.FTPAccount;
import java.io.IOException;
import java.net.URI;
import org.globus.ftp.FTPClient;
import org.globus.ftp.exception.FTPException;
import org.globus.ftp.exception.ServerException;

public class FTPFileSystem
extends RemoteFileSystem {
    public static final String FTP_ROOT = "/";
    private FTPAccount ftpAccount;
    private FTPClient ftpClient;

    public FTPFileSystem(FTPAccount fTPAccount) throws IOException {
        this.setAccount(fTPAccount);
        try {
            this.ftpClient = new FTPClient(fTPAccount.getHost(), fTPAccount.getPort());
            if (this.getUserName() == null) {
                fTPAccount.setUserName("anonymous");
                fTPAccount.setPassword("");
            }
            this.ftpClient.authorize(fTPAccount.getUserName(), fTPAccount.getPassword());
        }
        catch (FTPException fTPException) {
            IOException iOException = new IOException();
            iOException.initCause(fTPException);
            throw iOException;
        }
    }

    public FTPFileSystem(URI uRI) throws IOException {
        this.setAccount(uRI);
        try {
            this.ftpClient = new FTPClient(this.ftpAccount.getHost(), this.ftpAccount.getPort());
            if (this.getUserName() == null) {
                this.ftpAccount.setUserName("anonymous");
                this.ftpAccount.setPassword("");
            }
            this.ftpClient.authorize(this.ftpAccount.getUserName(), this.ftpAccount.getPassword());
        }
        catch (FTPException fTPException) {
            IOException iOException = new IOException();
            iOException.initCause(fTPException);
            throw iOException;
        }
    }

    protected void setAccount(GeneralAccount generalAccount) throws IOException {
        if (generalAccount == null) {
            throw new NullPointerException("Account information cannot be null");
        }
        this.ftpAccount = (FTPAccount)generalAccount.clone();
        this.account = this.ftpAccount;
    }

    protected void setAccount(URI uRI) throws IOException {
        if (uRI == null) {
            throw new NullPointerException("Account information cannot be null");
        }
        this.ftpAccount = new FTPAccount(uRI.getHost(), uRI.getPort(), uRI.getUserInfo(), "", uRI.getPath());
        this.account = this.ftpAccount;
    }

    FTPClient getFTPClient() {
        return this.ftpClient;
    }

    public MetaDataRecordList[] query(MetaDataCondition[] metaDataConditionArray, MetaDataSelect[] metaDataSelectArray) throws IOException {
        throw new UnsupportedOperationException();
    }

    public MetaDataRecordList[] query(MetaDataCondition[] metaDataConditionArray, MetaDataSelect[] metaDataSelectArray, int n) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String[] getRootDirectories() {
        String[] stringArray = new String[]{FTP_ROOT};
        return stringArray;
    }

    public boolean equals(Object object) {
        return object instanceof FTPFileSystem && this.toString().equals(object.toString());
    }

    public String toString() {
        return new String("ftp://" + this.getUserName() + "@" + this.getHost() + ":" + this.getPort() + this.getHomeDirectory());
    }

    public void close() throws IOException, ServerException {
        this.ftpClient.close();
    }
}

