/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.http;

import edu.sdsc.grid.io.GeneralAccount;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.RemoteFileSystem;
import edu.sdsc.grid.io.http.HTTPAccount;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URLConnection;

public class HTTPFileSystem
extends RemoteFileSystem {
    public static final String HTTP_ROOT = "/";
    private HTTPAccount httpAccount;
    URLConnection conn;

    public HTTPFileSystem(HTTPAccount hTTPAccount) throws IOException {
        this.setAccount(hTTPAccount);
        this.conn = hTTPAccount.getURL().openConnection();
    }

    public HTTPFileSystem(URI uRI) throws IOException {
        this.setAccount(uRI);
        this.conn = uRI.toURL().openConnection();
    }

    protected void setAccount(GeneralAccount generalAccount) throws IOException {
        if (generalAccount == null) {
            throw new NullPointerException("Account information cannot be null");
        }
        this.httpAccount = (HTTPAccount)generalAccount.clone();
        this.account = this.httpAccount;
    }

    protected void setAccount(URI uRI) throws IOException {
        if (uRI == null) {
            throw new NullPointerException("Account information cannot be null");
        }
        this.httpAccount = new HTTPAccount(uRI.getHost(), uRI.getPort(), uRI.getUserInfo(), "", uRI.getPath());
        this.account = this.httpAccount;
    }

    URLConnection getNewConn() throws IOException {
        return this.httpAccount.getURL().openConnection();
    }

    InputStream getNewInputStream() throws IOException {
        return this.getNewConn().getInputStream();
    }

    OutputStream getNewOutputStream() throws IOException {
        return this.getNewConn().getOutputStream();
    }

    public MetaDataRecordList[] query(MetaDataCondition[] metaDataConditionArray, MetaDataSelect[] metaDataSelectArray) throws IOException {
        throw new UnsupportedOperationException();
    }

    public MetaDataRecordList[] query(MetaDataCondition[] metaDataConditionArray, MetaDataSelect[] metaDataSelectArray, int n) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String[] getRootDirectories() {
        String[] stringArray = new String[]{HTTP_ROOT};
        return stringArray;
    }

    public boolean equals(Object object) {
        return object instanceof HTTPFileSystem && this.toString().equals(object.toString());
    }

    public String toString() {
        return this.conn.getURL().toString();
    }

    public void close() throws IOException {
        this.conn = null;
    }
}

