/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.irods;

import edu.sdsc.grid.io.FileFactory;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralFileInputStream;
import edu.sdsc.grid.io.RemoteAccount;
import edu.sdsc.grid.io.local.LocalFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.StringTokenizer;

public class IRODSAccount
extends RemoteAccount {
    public static final String IRODS_VERSION_0_9 = "rods0.9jargon2.0";
    public static final String IRODS_VERSION_1_0 = "rods1.0jargon2.0";
    public static final String IRODS_API_VERSION = "b";
    protected String defaultStorageResource;
    protected String authenticationScheme = "PASSWORD";
    protected String serverDN;
    protected String zone;
    protected static String version = "rods0.9jargon2.0";
    static String apiVersion = "b";
    static HashMap versionNumber = new HashMap(10, 1.0f);

    public IRODSAccount() throws FileNotFoundException, IOException {
        super("", 0, "", "", "");
        LocalFile localFile = new LocalFile(System.getProperty("user.home") + "/.irods/");
        if (!localFile.exists()) {
            localFile = new LocalFile(System.getProperty("user.home") + "/irods/");
        }
        if (!localFile.exists()) {
            throw new FileNotFoundException("Cannot find default iRODS account info");
        }
        this.setUserInfo(localFile);
    }

    public IRODSAccount(GeneralFile generalFile) throws FileNotFoundException, IOException {
        super("", 0, "", "", "");
        if (generalFile.equals(null)) {
            throw new NullPointerException("UserInfoDirectory cannot be null");
        }
        this.setUserInfo(generalFile);
    }

    public IRODSAccount(GeneralFile generalFile, GeneralFile generalFile2) throws FileNotFoundException, IOException {
        super("", 0, "", "", "");
        if (generalFile.equals(null) || generalFile2.equals(null)) {
            throw new NullPointerException("iRODS files cannot be null");
        }
        this.setUserInfo(generalFile);
    }

    public IRODSAccount(String string, int n, String string2, String string3, String string4, String string5, String string6) {
        super(string, n, string2, string3, string4);
        this.setUserName(string2);
        this.setZone(string5);
        this.setDefaultStorageResource(string6);
    }

    protected void finalize() {
        super.finalize();
    }

    public void setPort(int n) {
        this.port = n > 0 ? n : 1247;
    }

    public void setHomeDirectory(String string) {
        if (string == null) {
            string = "/";
        }
        this.homeDirectory = string;
    }

    public void setDefaultStorageResource(String string) {
        if (string == null) {
            throw new NullPointerException("The default storage resource cannot be null");
        }
        this.defaultStorageResource = string;
    }

    public void setAuthenticationScheme(String string) {
        this.authenticationScheme = string;
    }

    public void setZone(String string) {
        this.zone = string;
    }

    void setVersion(String string) {
        version = string;
    }

    public String getDefaultStorageResource() {
        return this.defaultStorageResource;
    }

    public String getAuthenticationScheme() {
        return this.authenticationScheme;
    }

    public static String getVersion() {
        return version;
    }

    static float getVersionNumber() {
        return ((Float)versionNumber.get(version)).floatValue();
    }

    static String getAPIVersion() {
        return apiVersion;
    }

    static int getOption() {
        return 0;
    }

    public String getServerDN() {
        return this.serverDN;
    }

    public String getZone() {
        return this.zone;
    }

    public boolean equals(Object object) {
        try {
            if (object == null) {
                return false;
            }
            IRODSAccount iRODSAccount = (IRODSAccount)object;
            if (!this.getHost().equals(iRODSAccount.getHost())) {
                return false;
            }
            if (this.getPort() != iRODSAccount.getPort()) {
                return false;
            }
            if (!this.getUserName().equals(iRODSAccount.getUserName())) {
                return false;
            }
            return this.getPassword().equals(iRODSAccount.getPassword());
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public String toString() {
        return new String("irods://" + this.getUserName() + "@" + this.getHost() + ":" + this.getPort());
    }

    public void setUserInfo(GeneralFile generalFile) throws FileNotFoundException, IOException {
        GeneralFile generalFile2 = FileFactory.newFile(generalFile, ".irodsEnv");
        if (!generalFile2.exists()) {
            generalFile2 = FileFactory.newFile(generalFile, "irodsEnv");
        }
        int n = 0;
        GeneralFileInputStream generalFileInputStream = null;
        byte[] byArray = new byte[(int)generalFile2.length()];
        generalFileInputStream = FileFactory.newFileInputStream(generalFile2);
        generalFileInputStream.read(byArray);
        String string = new String(byArray);
        while (n >= 0) {
            n = string.indexOf("#", n);
            while (n >= 0) {
                string = string.substring(0, n) + string.substring(string.indexOf(10, n + 1), string.length());
                n = string.indexOf("#", n);
            }
            n = string.indexOf("\"", n);
            while (n >= 0) {
                string = string.substring(0, n) + string.substring(n + 1, string.length());
                n = string.indexOf("\"", n);
            }
            n = string.indexOf("'", n);
            while (n >= 0) {
                string = string.substring(0, n) + string.substring(n + 1, string.length());
                n = string.indexOf("'", n);
            }
            n = string.indexOf("=", n);
            while (n >= 0) {
                string = string.substring(0, n) + " " + string.substring(n + 1, string.length());
                n = string.indexOf("=", n);
            }
            n = string.indexOf("\r", n);
            while (n >= 0) {
                string = string.substring(0, n) + string.substring(string.indexOf(10, n + 1), string.length());
                n = string.indexOf("\r", n);
            }
        }
        n = (string = string + "\n").indexOf("irodsHost");
        if (n < 0) {
            throw new NullPointerException("No host name found in env file.");
        }
        n = string.indexOf(32, n) + 1;
        this.setHost(string.substring(n, string.indexOf(10, n)));
        n = string.indexOf("irodsPort");
        if (n < 0) {
            this.setPort(1247);
        } else {
            n = string.indexOf(32, n) + 1;
            this.setPort(Integer.parseInt(string.substring(n, string.indexOf(10, n))));
        }
        n = string.indexOf("irodsUserName");
        if (n < 0) {
            throw new NullPointerException("No user name found in env file.");
        }
        n = string.indexOf(32, n) + 1;
        this.setUserName(string.substring(n, string.indexOf(10, n)));
        n = string.indexOf("irodsDefResource");
        if (n < 0) {
            throw new NullPointerException("No default resource found in env file.");
        }
        n = string.indexOf(32, n) + 1;
        this.setDefaultStorageResource(string.substring(n, string.indexOf(10, n)));
        n = string.indexOf("irodsHome");
        if (n >= 0) {
            n = string.indexOf(32, n) + 1;
            this.setHomeDirectory(string.substring(n, string.indexOf(10, n)));
        }
        if ((n = string.indexOf("irodsZone")) >= 0) {
            n = string.indexOf(32, n) + 1;
            this.setZone(string.substring(n, string.indexOf(10, n)));
        }
        if (!(generalFile2 = FileFactory.newFile(generalFile, ".irodsA")).exists()) {
            generalFile2 = FileFactory.newFile(generalFile, "irodsA");
        }
        this.readAuth(generalFile2);
    }

    public void readAuth(GeneralFile generalFile) throws FileNotFoundException, IOException {
        int n = 0;
        GeneralFileInputStream generalFileInputStream = FileFactory.newFileInputStream(generalFile);
        byte[] byArray = new byte[(int)generalFile.length()];
        generalFileInputStream.read(byArray);
        String string = new String(byArray);
        StringTokenizer stringTokenizer = new StringTokenizer(string, System.getProperty("line.separator") + "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("#")) continue;
            n = string2.indexOf(System.getProperty("line.separator")) + string2.indexOf("\n") + 1;
            if (n >= 0) {
                string = string2.substring(0, n);
                continue;
            }
            string = string2;
        }
        this.setPassword(string);
    }

    static {
        versionNumber.put(IRODS_VERSION_0_9, new Float(0.9));
        versionNumber.put(IRODS_VERSION_1_0, new Float(1.0f));
    }
}

