/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.irods;

import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.RemoteFileOutputStream;
import edu.sdsc.grid.io.irods.IRODSFile;
import edu.sdsc.grid.io.irods.IRODSFileSystem;
import java.io.IOException;

public class IRODSFileOutputStream
extends RemoteFileOutputStream {
    protected IRODSFileSystem fileSystem;

    public IRODSFileOutputStream(IRODSFileSystem iRODSFileSystem, String string) throws IOException {
        super(iRODSFileSystem, string);
        this.fileSystem = iRODSFileSystem;
    }

    public IRODSFileOutputStream(IRODSFile iRODSFile) throws IOException {
        super(iRODSFile);
        this.fileSystem = (IRODSFileSystem)iRODSFile.getFileSystem();
    }

    protected void open(GeneralFile generalFile) throws IOException {
        this.fd = ((IRODSFileSystem)generalFile.getFileSystem()).commands.fileOpen((IRODSFile)generalFile);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.fileSystem.commands.fileWrite(this.fd, byArray, n, n2);
    }

    public void close() throws IOException {
        if (this.fileSystem != null) {
            this.fileSystem.commands.fileClose(this.fd);
            this.fileSystem = null;
        }
    }
}

