/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.irods;

import edu.sdsc.grid.io.GeneralAccount;
import edu.sdsc.grid.io.GeneralFileSystem;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.ProtocolCatalog;
import edu.sdsc.grid.io.RemoteFileSystem;
import edu.sdsc.grid.io.irods.IRODSAccount;
import edu.sdsc.grid.io.irods.IRODSCommands;
import edu.sdsc.grid.io.irods.IRODSProtocol;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Vector;

public class IRODSFileSystem
extends RemoteFileSystem {
    public static final String IRODS_ROOT = "/";
    static int BUFFER_SIZE = 65535;
    static int DEBUG = GeneralFileSystem.DEBUG;
    private IRODSAccount iRODSAccount;
    IRODSCommands commands;

    public IRODSFileSystem() throws IOException {
        this(new IRODSAccount());
    }

    public IRODSFileSystem(IRODSAccount iRODSAccount) throws IOException, NullPointerException {
        this.setAccount(iRODSAccount);
        this.commands = new IRODSCommands();
        this.commands.connect(iRODSAccount);
    }

    protected void finalize() throws Throwable {
        this.close();
        if (this.account != null) {
            this.account = null;
        }
        if (this.commands != null) {
            this.commands = null;
        }
        super.finalize();
    }

    protected void setAccount(GeneralAccount generalAccount) throws IOException {
        if (generalAccount == null) {
            generalAccount = new IRODSAccount();
        }
        this.iRODSAccount = (IRODSAccount)generalAccount.clone();
        this.account = this.iRODSAccount;
    }

    public GeneralAccount getAccount() throws NullPointerException {
        if (this.iRODSAccount != null) {
            return (IRODSAccount)this.iRODSAccount.clone();
        }
        throw new NullPointerException();
    }

    public String[] getRootDirectories() {
        String[] stringArray = new String[]{IRODS_ROOT};
        return stringArray;
    }

    void setDefaultStorageResource(String string) {
        this.iRODSAccount.setDefaultStorageResource(string);
    }

    public String getDefaultStorageResource() {
        return this.iRODSAccount.getDefaultStorageResource();
    }

    public String getAuthenticationScheme() {
        return this.iRODSAccount.getAuthenticationScheme();
    }

    public String getServerDN() {
        return this.iRODSAccount.getServerDN();
    }

    public String getVersion() {
        return IRODSAccount.version;
    }

    public float getVersionNumber() {
        return ((Float)IRODSAccount.versionNumber.get(IRODSAccount.version)).floatValue();
    }

    public boolean equals(Object object) {
        try {
            if (object == null) {
                return false;
            }
            IRODSFileSystem iRODSFileSystem = (IRODSFileSystem)object;
            if (this.getAccount().equals(iRODSFileSystem.getAccount()) && this.isConnected() == iRODSFileSystem.isConnected()) {
                return true;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return false;
    }

    public boolean isConnected() {
        return this.commands.isConnected();
    }

    public String toString() {
        return new String("irods://" + this.getUserName() + "@" + this.getHost() + ":" + this.getPort());
    }

    public void close() throws IOException {
        this.commands.close();
    }

    public boolean isClosed() throws IOException {
        return this.commands.isClosed();
    }

    public MetaDataRecordList[] query(MetaDataCondition[] metaDataConditionArray, MetaDataSelect[] metaDataSelectArray, int n) throws IOException {
        metaDataConditionArray = (MetaDataCondition[])IRODSFileSystem.cleanNulls(metaDataConditionArray);
        metaDataSelectArray = (MetaDataSelect[])IRODSFileSystem.cleanNulls(metaDataSelectArray);
        return this.commands.query(metaDataConditionArray, metaDataSelectArray, n);
    }

    static final Object[] cleanNulls(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        Vector<Object> vector = new Vector<Object>(objectArray.length);
        boolean bl = false;
        int n = 0;
        boolean bl2 = false;
        for (n = 0; n < objectArray.length; ++n) {
            if (objectArray[n] == null) continue;
            vector.add(objectArray[n]);
            if (bl) continue;
            bl = true;
        }
        if (!bl) {
            return null;
        }
        if (objectArray.length == 1 && objectArray[0] == null) {
            return null;
        }
        return vector.toArray((Object[])Array.newInstance(vector.get(0).getClass(), 0));
    }

    static final Object[] cleanNullsAndDuplicates(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        Vector<Object> vector = new Vector<Object>(objectArray.length);
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        for (n = 0; n < objectArray.length; ++n) {
            if (objectArray[n] == null) continue;
            for (n2 = n + 1; n2 < objectArray.length; ++n2) {
                if (!objectArray[n].equals(objectArray[n2])) continue;
                objectArray[n2] = null;
                n2 = objectArray.length;
            }
            if (objectArray[n] == null) continue;
            vector.add(objectArray[n]);
            if (bl) continue;
            bl = true;
        }
        if (!bl) {
            return null;
        }
        if (objectArray.length == 1 && objectArray[0] == null) {
            return null;
        }
        return vector.toArray((Object[])Array.newInstance(vector.get(0).getClass(), 0));
    }

    static {
        if (!ProtocolCatalog.has(new IRODSProtocol())) {
            ProtocolCatalog.add(new IRODSProtocol());
        }
    }
}

