/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.irods;

import edu.sdsc.grid.io.DirectoryMetaData;
import edu.sdsc.grid.io.FileMetaData;
import edu.sdsc.grid.io.MetaDataField;
import edu.sdsc.grid.io.MetaDataGroup;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.ResourceMetaData;
import edu.sdsc.grid.io.UserMetaData;
import edu.sdsc.grid.io.ZoneMetaData;
import edu.sdsc.grid.io.irods.IRODSFileSystem;
import edu.sdsc.grid.io.irods.IRODSProtocol;
import java.util.HashMap;

public final class IRODSMetaDataSet
extends MetaDataSet
implements DirectoryMetaData,
FileMetaData,
ResourceMetaData,
UserMetaData,
ZoneMetaData {
    private static int TOTAL_METADATA_FIELDS = 250;
    private static HashMap jargonToIRODS = new HashMap(TOTAL_METADATA_FIELDS);
    private static HashMap iRODSToJargon = new HashMap(TOTAL_METADATA_FIELDS);
    static IRODSProtocol protocol;
    static final Integer COL_ZONE_ID;
    static final Integer COL_ZONE_NAME;
    static final Integer COL_USER_ID;
    static final Integer COL_USER_NAME;
    static final Integer COL_USER_TYPE;
    static final Integer COL_USER_ZONE;
    static final Integer COL_USER_DN;
    static final Integer COL_USER_INFO;
    static final Integer COL_USER_COMMENT;
    static final Integer COL_USER_CREATE_TIME;
    static final Integer COL_USER_MODIFY_TIME;
    static final Integer COL_R_RESC_ID;
    static final Integer COL_R_RESC_NAME;
    static final Integer COL_R_ZONE_NAME;
    static final Integer COL_R_TYPE_NAME;
    static final Integer COL_R_CLASS_NAME;
    static final Integer COL_R_LOC;
    static final Integer COL_R_VAULT_PATH;
    static final Integer COL_R_FREE_SPACE;
    static final Integer COL_R_RESC_INFO;
    static final Integer COL_R_RESC_COMMENT;
    static final Integer COL_R_CREATE_TIME;
    static final Integer COL_R_MODIFY_TIME;
    static final Integer COL_D_DATA_ID;
    static final Integer COL_D_COLL_ID;
    static final Integer COL_DATA_NAME;
    static final Integer COL_DATA_REPL_NUM;
    static final Integer COL_DATA_VERSION;
    static final Integer COL_DATA_TYPE_NAME;
    static final Integer COL_DATA_SIZE;
    static final Integer COL_D_RESC_GROUP_NAME;
    static final Integer COL_D_RESC_NAME;
    static final Integer COL_D_DATA_PATH;
    static final Integer COL_D_OWNER_NAME;
    static final Integer COL_D_OWNER_ZONE;
    static final Integer COL_D_REPL_STATUS;
    static final Integer COL_D_DATA_STATUS;
    static final Integer COL_D_DATA_CHECKSUM;
    static final Integer COL_D_EXPIRY;
    static final Integer COL_D_MAP_ID;
    static final Integer COL_D_COMMENTS;
    static final Integer COL_D_CREATE_TIME;
    static final Integer COL_D_MODIFY_TIME;
    static final Integer COL_COLL_ID;
    static final Integer COL_COLL_NAME;
    static final Integer COL_COLL_PARENT_NAME;
    static final Integer COL_COLL_OWNER_NAME;
    static final Integer COL_COLL_OWNER_ZONE;
    static final Integer COL_COLL_MAP_ID;
    static final Integer COL_COLL_INHERITANCE;
    static final Integer COL_COLL_COMMENTS;
    static final Integer COL_COLL_CREATE_TIME;
    static final Integer COL_COLL_MODIFY_TIME;
    static final Integer COL_META_DATA_ATTR_NAME;
    static final Integer COL_META_DATA_ATTR_VALUE;
    static final Integer COL_META_DATA_ATTR_UNITS;
    static final Integer COL_META_COLL_ATTR_NAME;
    static final Integer COL_META_COLL_ATTR_VALUE;
    static final Integer COL_META_COLL_ATTR_UNITS;
    static final Integer COL_META_NAMESPACE_COLL;
    static final Integer COL_META_NAMESPACE_DATA;
    static final Integer COL_META_NAMESPACE_RESC;
    static final Integer COL_META_NAMESPACE_USER;
    static final Integer COL_META_RESC_ATTR_NAME;
    static final Integer COL_META_RESC_ATTR_VALUE;
    static final Integer COL_META_RESC_ATTR_UNITS;
    static final Integer COL_META_USER_ATTR_NAME;
    static final Integer COL_META_USER_ATTR_VALUE;
    static final Integer COL_META_USER_ATTR_UNITS;
    static final Integer COL_DATA_ACCESS_TYPE;
    static final Integer COL_DATA_ACCESS_NAME;
    static final Integer COL_DATA_TOKEN_NAMESPACE;
    static final Integer COL_DATA_ACCESS_USER_ID;
    static final Integer COL_DATA_ACCESS_DATA_ID;
    static final Integer COL_RESC_GROUP_RESC_ID;
    static final Integer COL_RESC_GROUP_NAME;
    static final Integer COL_USER_GROUP_ID;
    static final Integer COL_USER_GROUP_NAME;
    static final Integer COL_RULE_EXEC_ID;
    static final Integer COL_RULE_EXEC_NAME;
    static final Integer COL_RULE_EXEC_REI_FILE_PATH;
    static final Integer COL_RULE_EXEC_USER_NAME;
    static final Integer COL_RULE_EXEC_ADDRESS;
    static final Integer COL_RULE_EXEC_TIME;
    static final Integer COL_RULE_EXEC_FREQUENCY;
    static final Integer COL_RULE_EXEC_PRIORITY;
    static final Integer COL_RULE_EXEC_ESTIMATED_EXE_TIME;
    static final Integer COL_RULE_EXEC_NOTIFICATION_ADDR;
    static final Integer COL_RULE_EXEC_LAST_EXE_TIME;
    static final Integer COL_RULE_EXEC_STATUS;
    static final Integer COL_TOKEN_NAMESPACE;
    static final Integer COL_TOKEN_ID;
    static final Integer COL_TOKEN_NAME;
    static final Integer COL_TOKEN_VALUE;
    static final Integer COL_TOKEN_VALUE2;
    static final Integer COL_TOKEN_VALUE3;
    static final Integer COL_TOKEN_COMMENT;
    static final String ALL_KW = "all";
    static final String COPIES_KW = "copies";
    static final String EXEC_LOCALLY_KW = "execLocally";
    static final String FORCE_FLAG_KW = "forceFlag";
    static final String CLI_IN_SVR_FIREWALL_KW = "cliInSvrFirewall";
    static final String REG_CHKSUM_KW = "regChksum";
    static final String VERIFY_CHKSUM_KW = "verifyChksum";
    static final String VERIFY_BY_SIZE_KW = "verifyBySize";
    static final String OBJ_PATH_KW = "objPath";
    static final String RESC_NAME_KW = "rescName";
    static final String DEST_RESC_NAME_KW = "destRescName";
    static final String BACKUP_RESC_NAME_KW = "backupRescName";
    static final String DATA_TYPE_KW = "dataType";
    static final String DATA_SIZE_KW = "dataSize";
    static final String CHKSUM_KW = "chksum";
    static final String VERSION_KW = "version";
    static final String FILE_PATH_KW = "filePath";
    static final String REPL_NUM_KW = "replNum";
    static final String REPL_STATUS_KW = "replStatus";
    static final String ALL_REPL_STATUS_KW = "allReplStatus";
    static final String DATA_INCLUDED_KW = "dataIncluded";
    static final String DATA_OWNER_KW = "dataOwner";
    static final String DATA_OWNER_ZONE_KW = "dataOwnerZone";
    static final String DATA_EXPIRY_KW = "dataExpiry";
    static final String DATA_COMMENTS_KW = "dataComments";
    static final String DATA_CREATE_KW = "dataCreate";
    static final String DATA_MODIFY_KW = "dataModify";
    static final String DATA_ACCESS_KW = "dataAccess";
    static final String DATA_ACCESS_INX_KW = "dataAccessInx";
    static final String NO_OPEN_FLAG_KW = "noOpenFlag";
    static final String STREAMING_KW = "streaming";
    static final String DATA_ID_KW = "dataId";
    static final String COLL_ID_KW = "collId";
    static final String RESC_GROUP_NAME_KW = "rescGroupName";
    static final String STATUS_STRING_KW = "statusString";
    static final String DATA_MAP_ID_KW = "dataMapId";
    static final String NO_PARA_OP_KW = "noParaOpr";
    static final String LOCAL_PATH_KW = "localPath";
    static final String RSYNC_MODE_KW = "rsyncMode";
    static final String RSYNC_DEST_PATH_KW = "rsyncDestPath";
    static final String RSYNC_CHKSUM_KW = "rsyncChksum";
    static final String CHKSUM_ALL_KW = "ChksumAll";
    static final String FORCE_CHKSUM_KW = "forceChksum";
    static final String COLLECTION_KW = "collection";
    static final String IRODS_ADMIN_KW = "irodsAdmin";
    static final String IRODS_ADMIN_RMTRASH_KW = "irodsAdminRmTrash";
    static final String IRODS_RMTRASH_KW = "irodsRmTrash";
    static final String RECURSIVE_OPR__KW = "recursiveOpr";
    static final String RESC_ZONE_KW = "zoneName";
    static final String RESC_LOC_KW = "rescLoc";
    static final String RESC_TYPE_KW = "rescType";
    static final String RESC_CLASS_KW = "rescClass";
    static final String RESC_VAULT_PATH_KW = "rescVaultPath";
    static final String NUM_OPEN_PORTS_KW = "numOpenPorts";
    static final String PARA_OPR_KW = "paraOpr";
    static final String GATEWAY_ADDR_KW = "gateWayAddr";
    static final String RESC_MAX_OBJ_SIZE_KW = "rescMaxObjSize";
    static final String FREE_SPACE_KW = "freeSpace";
    static final String FREE_SPACE_TIME_KW = "freeSpaceTime";
    static final String FREE_SPACE_TIMESTAMP_KW = "freeSpaceTimeStamp";
    static final String RESC_TYPE_INX_KW = "rescTypeInx";
    static final String RESC_CLASS_INX_KW = "rescClassInx";
    static final String RESC_ID_KW = "rescId";
    static final String RESC_INFO_KW = "rescInfo";
    static final String RESC_COMMENTS_KW = "rescComments";
    static final String RESC_CREATE_KW = "rescCreate";
    static final String RESC_MODIFY_KW = "rescModify";
    static final String USER_NAME_CLIENT_KW = "userNameClient";
    static final String RODS_ZONE_CLIENT_KW = "rodsZoneClient";
    static final String HOST_CLIENT_KW = "hostClient";
    static final String USER_TYPE_CLIENT_KW = "userTypeClient";
    static final String AUTH_STR_CLIENT_KW = "authStrClient";
    static final String USER_AUTH_SCHEME_CLIENT_KW = "userAuthSchemeClient";
    static final String USER_INFO_CLIENT_KW = "userInfoClient";
    static final String USER_COMMENT_CLIENT_KW = "userCommentClient";
    static final String USER_CREATE_CLIENT_KW = "userCreateClient";
    static final String USER_MODIFY_CLIENT_KW = "userModifyClient";
    static final String USER_NAME_PROXY_KW = "userNameProxy";
    static final String RODS_ZONE_PROXY_KW = "rodsZoneProxy";
    static final String HOST_PROXY_KW = "hostProxy";
    static final String USER_TYPE_PROXY_KW = "userTypeProxy";
    static final String AUTH_STR_PROXY_KW = "authStrProxy";
    static final String USER_AUTH_SCHEME_PROXY_KW = "userAuthSchemeProxy";
    static final String USER_INFO_PROXY_KW = "userInfoProxy";
    static final String USER_COMMENT_PROXY_KW = "userCommentProxy";
    static final String USER_CREATE_PROXY_KW = "userCreateProxy";
    static final String USER_MODIFY_PROXY_KW = "userModifyProxy";
    static final String ACCESS_PERMISSION_KW = "accessPermission";
    static final String COLL_NAME_KW = "collName";
    static final String COLL_PARENT_NAME_KW = "collParentName";
    static final String COLL_OWNER_NAME_KW = "collOwnername";
    static final String COLL_OWNER_ZONE_KW = "collOwnerZone";
    static final String COLL_MAP_ID_KW = "collMapId";
    static final String COLL_INHERITANCE_KW = "collInheritance";
    static final String COLL_COMMENTS_KW = "collComments";
    static final String COLL_EXPIRY_KW = "collExpiry";
    static final String COLL_CREATE_KW = "collCreate";
    static final String COLL_MODIFY_KW = "collModify";
    static final String COLL_ACCESS_KW = "collAccess";
    static final String COLL_ACCESS_INX_KW = "collAccessInx";
    static final String RULE_NAME_KW = "ruleName";
    static final String RULE_REI_FILE_PATH_KW = "reiFilePath";
    static final String RULE_USER_NAME_KW = "userName";
    static final String RULE_EXE_ADDRESS_KW = "exeAddress";
    static final String RULE_EXE_TIME_KW = "exeTime";
    static final String RULE_EXE_FREQUENCY_KW = "exeFrequency";
    static final String RULE_PRIORITY_KW = "priority";
    static final String RULE_ESTIMATE_EXE_TIME_KW = "estimateExeTime";
    static final String RULE_NOTIFICATION_ADDR_KW = "notificationAddr";
    static final String RULE_LAST_EXE_TIME_KW = "lastExeTime";
    static final String RULE_EXE_STATUS_KW = "exeStatus";
    static final String FILE_ID = "File Identifier";
    static final String DIRECTORY_ID = "Directory Identifier";
    static final String RESOURCE_ID = "Resource Identifier";
    static final String USER_ID = "User Identifier";
    static final String ZONE_ID = "Zone Identifier";

    IRODSMetaDataSet(IRODSProtocol iRODSProtocol) {
        protocol = iRODSProtocol;
    }

    public static MetaDataField getField(String string) {
        MetaDataField metaDataField;
        block5: {
            if (string == null) {
                throw new NullPointerException("The fieldName cannot be null.");
            }
            metaDataField = (MetaDataField)metaDataFields.get(string);
            if (metaDataField == null) {
                try {
                    metaDataField = (MetaDataField)metaDataFields.get(iRODSToJargon.get(Integer.decode(string)));
                }
                catch (NumberFormatException numberFormatException) {
                    if (IRODSFileSystem.DEBUG <= 0) break block5;
                    numberFormatException.printStackTrace();
                }
            }
        }
        if (metaDataField == null) {
            throw new IllegalArgumentException("The fieldName, " + string + ", does not correspond to any registered fields.");
        }
        return metaDataField;
    }

    static String getID(String string) {
        Object v = jargonToIRODS.get(string);
        if (v == null) {
            return string;
        }
        return v.toString();
    }

    static {
        COL_ZONE_ID = new Integer(101);
        COL_ZONE_NAME = new Integer(102);
        COL_USER_ID = new Integer(201);
        COL_USER_NAME = new Integer(202);
        COL_USER_TYPE = new Integer(203);
        COL_USER_ZONE = new Integer(204);
        COL_USER_DN = new Integer(205);
        COL_USER_INFO = new Integer(206);
        COL_USER_COMMENT = new Integer(207);
        COL_USER_CREATE_TIME = new Integer(208);
        COL_USER_MODIFY_TIME = new Integer(209);
        COL_R_RESC_ID = new Integer(301);
        COL_R_RESC_NAME = new Integer(302);
        COL_R_ZONE_NAME = new Integer(303);
        COL_R_TYPE_NAME = new Integer(304);
        COL_R_CLASS_NAME = new Integer(305);
        COL_R_LOC = new Integer(306);
        COL_R_VAULT_PATH = new Integer(307);
        COL_R_FREE_SPACE = new Integer(308);
        COL_R_RESC_INFO = new Integer(309);
        COL_R_RESC_COMMENT = new Integer(310);
        COL_R_CREATE_TIME = new Integer(311);
        COL_R_MODIFY_TIME = new Integer(312);
        COL_D_DATA_ID = new Integer(401);
        COL_D_COLL_ID = new Integer(402);
        COL_DATA_NAME = new Integer(403);
        COL_DATA_REPL_NUM = new Integer(404);
        COL_DATA_VERSION = new Integer(405);
        COL_DATA_TYPE_NAME = new Integer(406);
        COL_DATA_SIZE = new Integer(407);
        COL_D_RESC_GROUP_NAME = new Integer(408);
        COL_D_RESC_NAME = new Integer(409);
        COL_D_DATA_PATH = new Integer(410);
        COL_D_OWNER_NAME = new Integer(411);
        COL_D_OWNER_ZONE = new Integer(412);
        COL_D_REPL_STATUS = new Integer(413);
        COL_D_DATA_STATUS = new Integer(414);
        COL_D_DATA_CHECKSUM = new Integer(415);
        COL_D_EXPIRY = new Integer(416);
        COL_D_MAP_ID = new Integer(417);
        COL_D_COMMENTS = new Integer(418);
        COL_D_CREATE_TIME = new Integer(419);
        COL_D_MODIFY_TIME = new Integer(420);
        COL_COLL_ID = new Integer(500);
        COL_COLL_NAME = new Integer(501);
        COL_COLL_PARENT_NAME = new Integer(502);
        COL_COLL_OWNER_NAME = new Integer(503);
        COL_COLL_OWNER_ZONE = new Integer(504);
        COL_COLL_MAP_ID = new Integer(505);
        COL_COLL_INHERITANCE = new Integer(506);
        COL_COLL_COMMENTS = new Integer(507);
        COL_COLL_CREATE_TIME = new Integer(508);
        COL_COLL_MODIFY_TIME = new Integer(509);
        COL_META_DATA_ATTR_NAME = new Integer(600);
        COL_META_DATA_ATTR_VALUE = new Integer(601);
        COL_META_DATA_ATTR_UNITS = new Integer(602);
        COL_META_COLL_ATTR_NAME = new Integer(610);
        COL_META_COLL_ATTR_VALUE = new Integer(611);
        COL_META_COLL_ATTR_UNITS = new Integer(612);
        COL_META_NAMESPACE_COLL = new Integer(620);
        COL_META_NAMESPACE_DATA = new Integer(621);
        COL_META_NAMESPACE_RESC = new Integer(622);
        COL_META_NAMESPACE_USER = new Integer(623);
        COL_META_RESC_ATTR_NAME = new Integer(630);
        COL_META_RESC_ATTR_VALUE = new Integer(631);
        COL_META_RESC_ATTR_UNITS = new Integer(632);
        COL_META_USER_ATTR_NAME = new Integer(640);
        COL_META_USER_ATTR_VALUE = new Integer(641);
        COL_META_USER_ATTR_UNITS = new Integer(642);
        COL_DATA_ACCESS_TYPE = new Integer(700);
        COL_DATA_ACCESS_NAME = new Integer(701);
        COL_DATA_TOKEN_NAMESPACE = new Integer(702);
        COL_DATA_ACCESS_USER_ID = new Integer(703);
        COL_DATA_ACCESS_DATA_ID = new Integer(704);
        COL_RESC_GROUP_RESC_ID = new Integer(800);
        COL_RESC_GROUP_NAME = new Integer(801);
        COL_USER_GROUP_ID = new Integer(900);
        COL_USER_GROUP_NAME = new Integer(901);
        COL_RULE_EXEC_ID = new Integer(1000);
        COL_RULE_EXEC_NAME = new Integer(1001);
        COL_RULE_EXEC_REI_FILE_PATH = new Integer(1002);
        COL_RULE_EXEC_USER_NAME = new Integer(1003);
        COL_RULE_EXEC_ADDRESS = new Integer(1004);
        COL_RULE_EXEC_TIME = new Integer(1005);
        COL_RULE_EXEC_FREQUENCY = new Integer(1006);
        COL_RULE_EXEC_PRIORITY = new Integer(1007);
        COL_RULE_EXEC_ESTIMATED_EXE_TIME = new Integer(1008);
        COL_RULE_EXEC_NOTIFICATION_ADDR = new Integer(1009);
        COL_RULE_EXEC_LAST_EXE_TIME = new Integer(1010);
        COL_RULE_EXEC_STATUS = new Integer(1011);
        COL_TOKEN_NAMESPACE = new Integer(1100);
        COL_TOKEN_ID = new Integer(1101);
        COL_TOKEN_NAME = new Integer(1102);
        COL_TOKEN_VALUE = new Integer(1103);
        COL_TOKEN_VALUE2 = new Integer(1104);
        COL_TOKEN_VALUE3 = new Integer(1105);
        COL_TOKEN_COMMENT = new Integer(1106);
        if (protocol == null) {
            protocol = new IRODSProtocol();
        }
        jargonToIRODS.put("Zone Name", COL_ZONE_NAME);
        jargonToIRODS.put(USER_ID, COL_USER_ID);
        jargonToIRODS.put("user name", COL_USER_NAME);
        jargonToIRODS.put("User Type", COL_USER_TYPE);
        jargonToIRODS.put("User Zone", COL_USER_ZONE);
        jargonToIRODS.put("User DN", COL_USER_DN);
        jargonToIRODS.put("User Information", COL_USER_INFO);
        jargonToIRODS.put("User Comment", COL_USER_COMMENT);
        jargonToIRODS.put("User Time created (Unix Time)", COL_USER_CREATE_TIME);
        jargonToIRODS.put("User Time last modified (Unix Time)", COL_USER_MODIFY_TIME);
        jargonToIRODS.put(RESOURCE_ID, COL_R_RESC_ID);
        jargonToIRODS.put("Resource Name", COL_R_RESC_NAME);
        jargonToIRODS.put("Resource Zone Name", COL_R_ZONE_NAME);
        jargonToIRODS.put("Resource Type", COL_R_TYPE_NAME);
        jargonToIRODS.put("Resource Class", COL_R_CLASS_NAME);
        jargonToIRODS.put("Resource Location", COL_R_LOC);
        jargonToIRODS.put("Resource Vault Path", COL_R_VAULT_PATH);
        jargonToIRODS.put("Resource Free Space", COL_R_FREE_SPACE);
        jargonToIRODS.put("Resource Information", COL_R_RESC_INFO);
        jargonToIRODS.put("Resource Comment", COL_R_RESC_COMMENT);
        jargonToIRODS.put("Resource Time created (Unix Time)", COL_R_CREATE_TIME);
        jargonToIRODS.put("Resource Time last modified (Unix Time)", COL_R_MODIFY_TIME);
        jargonToIRODS.put(FILE_ID, COL_D_DATA_ID);
        jargonToIRODS.put("file name", COL_DATA_NAME);
        jargonToIRODS.put("File Replica Number", COL_DATA_REPL_NUM);
        jargonToIRODS.put("File Version", COL_DATA_VERSION);
        jargonToIRODS.put("File Type", COL_DATA_TYPE_NAME);
        jargonToIRODS.put("file size", COL_DATA_SIZE);
        jargonToIRODS.put("File Resource Group Name", COL_D_RESC_GROUP_NAME);
        jargonToIRODS.put("Resource Name", COL_D_RESC_NAME);
        jargonToIRODS.put("PATH_NAME", COL_D_DATA_PATH);
        jargonToIRODS.put("file owner", COL_D_OWNER_NAME);
        jargonToIRODS.put("File Owner Zone", COL_D_OWNER_ZONE);
        jargonToIRODS.put("File Replica Status", COL_D_REPL_STATUS);
        jargonToIRODS.put("File Data Status", COL_D_DATA_STATUS);
        jargonToIRODS.put("File Checksum", COL_D_DATA_CHECKSUM);
        jargonToIRODS.put("File Expiration time", COL_D_EXPIRY);
        jargonToIRODS.put("File Map Identifier", COL_D_MAP_ID);
        jargonToIRODS.put("File Comments", COL_D_COMMENTS);
        jargonToIRODS.put("file creation date", COL_D_CREATE_TIME);
        jargonToIRODS.put("file modification date", COL_D_MODIFY_TIME);
        jargonToIRODS.put("directory name", COL_COLL_NAME);
        jargonToIRODS.put("parent directory name", COL_COLL_PARENT_NAME);
        jargonToIRODS.put("directory owner", COL_COLL_OWNER_NAME);
        jargonToIRODS.put("Directory Owner Zone", COL_COLL_OWNER_ZONE);
        jargonToIRODS.put("Directory Inheritance", COL_COLL_INHERITANCE);
        jargonToIRODS.put("directory comments", COL_COLL_COMMENTS);
        jargonToIRODS.put("directory creation timestamp", COL_COLL_CREATE_TIME);
        jargonToIRODS.put("Directory Time last modified (Unix Time)", COL_COLL_MODIFY_TIME);
        jargonToIRODS.put("File Access Type", COL_DATA_ACCESS_TYPE);
        jargonToIRODS.put("File Access Name", COL_DATA_ACCESS_NAME);
        jargonToIRODS.put("File Access User Identifier", COL_DATA_ACCESS_USER_ID);
        jargonToIRODS.put("File Access Data Identifier", COL_DATA_ACCESS_DATA_ID);
        jargonToIRODS.put("Resource Group Identifier", COL_RESC_GROUP_RESC_ID);
        jargonToIRODS.put("Resource Group Name", COL_RESC_GROUP_NAME);
        jargonToIRODS.put("User Group Name", COL_USER_GROUP_NAME);
        iRODSToJargon.put(COL_ZONE_ID, ZONE_ID);
        iRODSToJargon.put(COL_ZONE_NAME, "Zone Name");
        iRODSToJargon.put(COL_USER_ID, USER_ID);
        iRODSToJargon.put(COL_USER_NAME, "user name");
        iRODSToJargon.put(COL_USER_TYPE, "User Type");
        iRODSToJargon.put(COL_USER_ZONE, "User Zone");
        iRODSToJargon.put(COL_USER_DN, "User DN");
        iRODSToJargon.put(COL_USER_INFO, "User Information");
        iRODSToJargon.put(COL_USER_COMMENT, "User Comment");
        iRODSToJargon.put(COL_USER_CREATE_TIME, "User Time created (Unix Time)");
        iRODSToJargon.put(COL_USER_MODIFY_TIME, "User Time last modified (Unix Time)");
        iRODSToJargon.put(COL_R_RESC_ID, RESOURCE_ID);
        iRODSToJargon.put(COL_R_RESC_NAME, "Resource Name");
        iRODSToJargon.put(COL_R_ZONE_NAME, "Resource Zone Name");
        iRODSToJargon.put(COL_R_TYPE_NAME, "Resource Type");
        iRODSToJargon.put(COL_R_CLASS_NAME, "Resource Class");
        iRODSToJargon.put(COL_R_LOC, "Resource Location");
        iRODSToJargon.put(COL_R_VAULT_PATH, "Resource Vault Path");
        iRODSToJargon.put(COL_R_FREE_SPACE, "Resource Free Space");
        iRODSToJargon.put(COL_R_RESC_INFO, "Resource Information");
        iRODSToJargon.put(COL_R_RESC_COMMENT, "Resource Comment");
        iRODSToJargon.put(COL_R_CREATE_TIME, "Resource Time created (Unix Time)");
        iRODSToJargon.put(COL_R_MODIFY_TIME, "Resource Time last modified (Unix Time)");
        iRODSToJargon.put(COL_D_DATA_ID, FILE_ID);
        iRODSToJargon.put(COL_DATA_NAME, "file name");
        iRODSToJargon.put(COL_DATA_REPL_NUM, "File Replica Number");
        iRODSToJargon.put(COL_DATA_VERSION, "File Version");
        iRODSToJargon.put(COL_DATA_TYPE_NAME, "File Type");
        iRODSToJargon.put(COL_DATA_SIZE, "file size");
        iRODSToJargon.put(COL_D_RESC_GROUP_NAME, "File Resource Group Name");
        iRODSToJargon.put(COL_D_RESC_NAME, "Resource Name");
        iRODSToJargon.put(COL_D_DATA_PATH, "PATH_NAME");
        iRODSToJargon.put(COL_D_OWNER_NAME, "file owner");
        iRODSToJargon.put(COL_D_OWNER_ZONE, "File Owner Zone");
        iRODSToJargon.put(COL_D_REPL_STATUS, "File Replica Status");
        iRODSToJargon.put(COL_D_DATA_STATUS, "File Data Status");
        iRODSToJargon.put(COL_D_DATA_CHECKSUM, "File Checksum");
        iRODSToJargon.put(COL_D_EXPIRY, "File Expiration time");
        iRODSToJargon.put(COL_D_MAP_ID, "File Map Identifier");
        iRODSToJargon.put(COL_D_COMMENTS, "File Comments");
        iRODSToJargon.put(COL_D_CREATE_TIME, "file creation date");
        iRODSToJargon.put(COL_D_MODIFY_TIME, "file modification date");
        iRODSToJargon.put(COL_COLL_NAME, "directory name");
        iRODSToJargon.put(COL_COLL_PARENT_NAME, "parent directory name");
        iRODSToJargon.put(COL_COLL_OWNER_NAME, "directory owner");
        iRODSToJargon.put(COL_COLL_OWNER_ZONE, "Directory Owner Zone");
        iRODSToJargon.put(COL_COLL_INHERITANCE, "Directory Inheritance");
        iRODSToJargon.put(COL_COLL_COMMENTS, "directory comments");
        iRODSToJargon.put(COL_COLL_CREATE_TIME, "directory creation timestamp");
        iRODSToJargon.put(COL_COLL_MODIFY_TIME, "Directory Time last modified (Unix Time)");
        iRODSToJargon.put(COL_DATA_ACCESS_TYPE, "File Access Type");
        iRODSToJargon.put(COL_DATA_ACCESS_NAME, "File Access Name");
        iRODSToJargon.put(COL_DATA_ACCESS_USER_ID, "File Access User Identifier");
        iRODSToJargon.put(COL_DATA_ACCESS_DATA_ID, "File Access Data Identifier");
        iRODSToJargon.put(COL_RESC_GROUP_RESC_ID, "Resource Group Identifier");
        iRODSToJargon.put(COL_RESC_GROUP_NAME, "Resource Group Name");
        iRODSToJargon.put(COL_USER_GROUP_NAME, "User Group Name");
        MetaDataGroup metaDataGroup = new MetaDataGroup("Directory", "Core meta-information about directories");
        metaDataGroup.add(new MetaDataField("directory name", "directory path", 3, protocol));
        IRODSMetaDataSet.add(metaDataGroup);
        metaDataGroup = new MetaDataGroup("Data", "Core meta-information about datasets.");
        metaDataGroup.add(new MetaDataField(FILE_ID, "DataObject(file) Identifier (a number)", 3, protocol));
        metaDataGroup.add(new MetaDataField("File Replica Number", "DataObject Replica Number (0 to N)", 3, protocol));
        metaDataGroup.add(new MetaDataField("File Version", "DataObject Version", 3, protocol));
        metaDataGroup.add(new MetaDataField("File Type", "DataObject Type", 3, protocol));
        metaDataGroup.add(new MetaDataField("File Resource Group Name", "DataObject Resource Group Name", 3, protocol));
        metaDataGroup.add(new MetaDataField("Resource Name", "DataObject Resource Name ", 3, protocol));
        metaDataGroup.add(new MetaDataField("PATH_NAME", "DataObject Path (physical location)", 3, protocol));
        metaDataGroup.add(new MetaDataField("File Owner Zone", "DataObject Owner Zone", 3, protocol));
        metaDataGroup.add(new MetaDataField("File Replica Status", "DataObject Replica Status (?I believe this indicates if this replica is current)", 3, protocol));
        metaDataGroup.add(new MetaDataField("File Data Status", "DataObject Data Status (?)", 3, protocol));
        metaDataGroup.add(new MetaDataField("File Checksum", "DataObject Checksum", 3, protocol));
        metaDataGroup.add(new MetaDataField("File Expiration time", "DataObject Expiration time (currently unused)", 3, protocol));
        metaDataGroup.add(new MetaDataField("File Map Identifier", "DataObject Map Identifier (?)", 3, protocol));
        metaDataGroup.add(new MetaDataField("file name", "filename", 3, protocol));
        metaDataGroup.add(new MetaDataField("directory name", "directory path", 3, protocol));
        metaDataGroup.add(new MetaDataField("file size", "size of this file", 3, protocol));
        metaDataGroup.add(new MetaDataField("file owner", "onwer of this file", 3, protocol));
        metaDataGroup.add(new MetaDataField("File Comments", "comments about this file", 3, protocol));
        metaDataGroup.add(new MetaDataField("file creation date", "number of seconds this file was created after the unix epoch", 3, protocol));
        metaDataGroup.add(new MetaDataField("file modification date", "number of seconds this file was modified after the unix epoch", 3, protocol));
        IRODSMetaDataSet.add(metaDataGroup);
        metaDataGroup = new MetaDataGroup("Directory", "Core meta-information about directories/collections.");
        metaDataGroup.add(new MetaDataField(DIRECTORY_ID, "Collection (directory) Identifier", 3, protocol));
        metaDataGroup.add(new MetaDataField("directory name", "Collection Name", 3, protocol));
        metaDataGroup.add(new MetaDataField("parent directory name", "Collection Parent Name (up one level)", 3, protocol));
        metaDataGroup.add(new MetaDataField("directory owner", "Collection Owner Name", 3, protocol));
        metaDataGroup.add(new MetaDataField("Directory Owner Zone", "Collection Owner Zone", 3, protocol));
        metaDataGroup.add(new MetaDataField("Directory Inheritance", "Collection Inheritance (?)", 3, protocol));
        metaDataGroup.add(new MetaDataField("directory comments", "Collection Comments", 3, protocol));
        metaDataGroup.add(new MetaDataField("directory creation timestamp", "Time that this record was created (Unix Time)", 3, protocol));
        metaDataGroup.add(new MetaDataField("Directory Time last modified (Unix Time)", "Time that this record was last modified (Unix Time)", 3, protocol));
        IRODSMetaDataSet.add(metaDataGroup);
        metaDataGroup = new MetaDataGroup("Resource", "Core information about iRODS resources.");
        metaDataGroup.add(new MetaDataField(RESOURCE_ID, "Resource Identifier (a number)", 3, protocol));
        metaDataGroup.add(new MetaDataField("Resource Name", "Resource Name", 3, protocol));
        metaDataGroup.add(new MetaDataField("Resource Zone Name", "Zone Name", 3, protocol));
        metaDataGroup.add(new MetaDataField("Resource Type", "Resource Type", 3, protocol));
        metaDataGroup.add(new MetaDataField("Resource Class", "Resource Class", 3, protocol));
        metaDataGroup.add(new MetaDataField("Resource Location", "Resource Location (DNS hostname)", 3, protocol));
        metaDataGroup.add(new MetaDataField("Resource Vault Path", "Resource Vault Path (where physical files are stored)", 3, protocol));
        metaDataGroup.add(new MetaDataField("Resource Free Space", "Resource Free Space (currently unused)", 3, protocol));
        metaDataGroup.add(new MetaDataField("Resource Information", "Resource Information (set by admin)", 3, protocol));
        metaDataGroup.add(new MetaDataField("Resource Comment", "Resource Comment (set by admin)", 3, protocol));
        metaDataGroup.add(new MetaDataField("Resource Time created (Unix Time)", "Time that this record was created (Unix Time)", 3, protocol));
        metaDataGroup.add(new MetaDataField("Resource Time last modified (Unix Time)", "Time that this record was last modified (Unix Time)", 3, protocol));
        IRODSMetaDataSet.add(metaDataGroup);
        metaDataGroup = new MetaDataGroup("User", "Core information about iRODS-registered users.");
        metaDataGroup.add(new MetaDataField(USER_ID, "User Identifier (a number)", 3, protocol));
        metaDataGroup.add(new MetaDataField("user name", "User Name", 3, protocol));
        metaDataGroup.add(new MetaDataField("User Type", "User Type", 3, protocol));
        metaDataGroup.add(new MetaDataField("User Zone", "User Zone", 3, protocol));
        metaDataGroup.add(new MetaDataField("User DN", "User GSI Distinguished Name (currently unused)", 3, protocol));
        metaDataGroup.add(new MetaDataField("User Information", "User Information (set by the admin, like comment)", 3, protocol));
        metaDataGroup.add(new MetaDataField("User Comment", "User Comment (also set by the admin)", 3, protocol));
        metaDataGroup.add(new MetaDataField("User Time created (Unix Time)", "Time that this record was created (Unix Time)", 3, protocol));
        metaDataGroup.add(new MetaDataField("User Time last modified (Unix Time)", "Time that this record was last modified (Unix Time)", 3, protocol));
        IRODSMetaDataSet.add(metaDataGroup);
        metaDataGroup = new MetaDataGroup("Zone", "Core information about Zones.");
        metaDataGroup.add(new MetaDataField(ZONE_ID, "Zone Identifier (a number)", 3, protocol));
        metaDataGroup.add(new MetaDataField("Zone Name", "Zone Name", 3, protocol));
        IRODSMetaDataSet.add(metaDataGroup);
    }
}

