/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.srb;

import edu.sdsc.grid.io.Host;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.MetaDataTable;
import edu.sdsc.grid.io.srb.SRBCommands;
import edu.sdsc.grid.io.srb.SRBException;
import edu.sdsc.grid.io.srb.SRBMetaDataRecordList;
import edu.sdsc.grid.io.srb.SRBMetaDataSet;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Vector;

class SRBMetaDataCommands {
    private SRBCommands commands;

    SRBMetaDataCommands(SRBCommands sRBCommands) throws IOException {
        this.commands = sRBCommands;
    }

    protected void finalize() {
        if (this.commands != null) {
            this.commands = null;
        }
    }

    static String getOperator(MetaDataCondition metaDataCondition) {
        int n = metaDataCondition.getOperator();
        if (n == 6) {
            return " " + MetaDataCondition.getOperatorString(n) + " (";
        }
        return " " + MetaDataCondition.getOperatorString(n) + " ";
    }

    static String getOperator(int n) {
        if (n == 6) {
            return " " + MetaDataCondition.getOperatorString(n) + " (";
        }
        return " " + MetaDataCondition.getOperatorString(n) + " ";
    }

    static String getEndOperator(MetaDataCondition metaDataCondition) {
        if (metaDataCondition.getOperator() == 6) {
            return ")";
        }
        return "";
    }

    static String getEndOperator(int n) {
        if (n == 6) {
            return ")";
        }
        return "";
    }

    private String quotes(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                return "";
            }
        }
        return "'";
    }

    private String fixLIKE(String string) {
        String string2 = string;
        int n = string.indexOf("*");
        while (n >= 0) {
            string = string.substring(0, n) + "%" + string.substring(n + 1);
            n = string.indexOf("*");
        }
        n = string.indexOf("?");
        while (n >= 0) {
            string = string.substring(0, n) + "_" + string.substring(n + 1);
            n = string.indexOf("?");
        }
        if (string.indexOf("%") < 0 && string.indexOf("_") < 0) {
            string = "%" + string + "%";
        }
        return string;
    }

    private MetaDataTable fixLIKE(MetaDataTable metaDataTable, boolean bl) {
        int n = metaDataTable.getRowCount();
        int n2 = metaDataTable.getColumnCount();
        int n3 = -1;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                String string;
                if ((j != 1 || metaDataTable.getOperator(i) != 10 && metaDataTable.getOperator(i) != 11) && (j != 0 || !bl)) continue;
                String string2 = string = metaDataTable.getStringValue(i, j);
                n3 = string.indexOf("*");
                while (n3 >= 0) {
                    string = string.substring(0, n3) + "%" + string.substring(n3 + 1);
                    n3 = string.indexOf("*");
                }
                n3 = string.indexOf("?");
                while (n3 >= 0) {
                    string = string.substring(0, n3) + "_" + string.substring(n3 + 1);
                    n3 = string.indexOf("?");
                }
                if (string.indexOf("%") < 0 && string.indexOf("_") < 0) {
                    string = "%" + string + "%";
                }
                if (string2.equals(string)) continue;
                metaDataTable.setStringValue(i, j, string);
            }
        }
        return metaDataTable;
    }

    private String setTableGenQuery(MetaDataTable metaDataTable, MetaDataCondition metaDataCondition) {
        if (metaDataTable == null) {
            return "";
        }
        String string = metaDataCondition.getFieldName();
        String string2 = SRBMetaDataCommands.getOperator(metaDataCondition);
        String string3 = this.setTableGenQueryRow(0, metaDataTable, metaDataCondition);
        if (metaDataTable.getRowCount() >= 2) {
            string3 = string3 + " " + string2 + " " + this.setTableGenQueryRow(1, metaDataTable, metaDataCondition);
            if (metaDataTable.getRowCount() >= 3) {
                string3 = string3 + " " + string2 + " " + this.setTableGenQueryRow(2, metaDataTable, metaDataCondition);
                if (metaDataTable.getRowCount() >= 4) {
                    string3 = string3 + " " + string2 + " " + this.setTableGenQueryRow(3, metaDataTable, metaDataCondition);
                    if ((string.equals("definable metadata for files") || string.equals("definable metadata for directories")) && metaDataTable.getRowCount() >= 5) {
                        string3 = string3 + " " + string2 + " " + this.setTableGenQueryRow(4, metaDataTable, metaDataCondition);
                    }
                }
            }
        }
        return string3;
    }

    private String setTableGenQueryRow(int n, MetaDataTable metaDataTable, MetaDataCondition metaDataCondition) {
        String string;
        int n2 = metaDataTable.getOperator(n);
        if (n2 == 6 || n2 == 7) {
            string = "'" + metaDataTable.getStringValue(n, 0) + "'\u0000 " + MetaDataCondition.getOperatorString(n2) + " (";
            String string2 = metaDataTable.getStringValue(n, 1);
            String[] stringArray = string2.split(",");
            int n3 = stringArray.length;
            for (int i = 0; i < n3; ++i) {
                string = string + "'" + stringArray[i] + "'";
                if (i >= n3 - 1) continue;
                string = string + ",";
            }
            string = string + ")\u0000";
        } else {
            string = "'" + metaDataTable.getStringValue(n, 0) + "'\u0000";
            string = string + SRBMetaDataCommands.getOperator(metaDataTable.getOperator(n)) + "'" + metaDataTable.getStringValue(n, 1) + "'\u0000";
        }
        return string;
    }

    private int[] setTableConditionIDs(MetaDataTable metaDataTable, String string) {
        int[] nArray = null;
        int n = metaDataTable.getRowCount();
        if (n < 5) {
            nArray = new int[n * 2];
        } else if (string.equals("definable metadata for files") || string.equals("definable metadata for directories")) {
            nArray = new int[10];
        }
        nArray[0] = SRBMetaDataSet.getSRBID(string + "0_1");
        nArray[1] = SRBMetaDataSet.getSRBID(string + "1_1");
        if (nArray.length >= 4) {
            nArray[2] = SRBMetaDataSet.getSRBID(string + "0_2");
            nArray[3] = SRBMetaDataSet.getSRBID(string + "1_2");
            if (nArray.length >= 6) {
                nArray[4] = SRBMetaDataSet.getSRBID(string + "0_3");
                nArray[5] = SRBMetaDataSet.getSRBID(string + "1_3");
                if (nArray.length >= 8) {
                    nArray[6] = SRBMetaDataSet.getSRBID(string + "0_4");
                    nArray[7] = SRBMetaDataSet.getSRBID(string + "1_4");
                    if (nArray.length >= 10) {
                        nArray[8] = SRBMetaDataSet.getSRBID(string + "0_0");
                        nArray[9] = SRBMetaDataSet.getSRBID(string + "1_0");
                    }
                }
            }
        }
        return nArray;
    }

    static final Object[] cleanNulls(Object[] objectArray) {
        Vector<Object> vector = new Vector<Object>(objectArray.length);
        boolean bl = false;
        int n = 0;
        boolean bl2 = false;
        for (n = 0; n < objectArray.length; ++n) {
            if (objectArray[n] == null) continue;
            vector.add(objectArray[n]);
            if (bl) continue;
            bl = true;
        }
        if (!bl) {
            return null;
        }
        if (objectArray.length == 1 && objectArray[0] == null) {
            return null;
        }
        return vector.toArray((Object[])Array.newInstance(vector.get(0).getClass(), 0));
    }

    static final Object[] cleanNullsAndDuplicates(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        Vector<Object> vector = new Vector<Object>(objectArray.length);
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        for (n = 0; n < objectArray.length; ++n) {
            if (objectArray[n] == null) continue;
            for (n2 = n + 1; n2 < objectArray.length; ++n2) {
                if (!objectArray[n].equals(objectArray[n2])) continue;
                objectArray[n2] = null;
                n2 = objectArray.length;
            }
            if (objectArray[n] == null) continue;
            vector.add(objectArray[n]);
            if (bl) continue;
            bl = true;
        }
        if (!bl) {
            return null;
        }
        if (objectArray.length == 1 && objectArray[0] == null) {
            return null;
        }
        return vector.toArray((Object[])Array.newInstance(vector.get(0).getClass(), 0));
    }

    private String addValue(int n, MetaDataCondition metaDataCondition) {
        String string = "";
        string = string + SRBMetaDataCommands.getOperator(metaDataCondition);
        block0 : switch (n) {
            case 0: {
                switch (metaDataCondition.getFieldType()) {
                    case 3: 
                    case 4: {
                        string = string + "'" + metaDataCondition.getStringValue() + "'";
                        break block0;
                    }
                    case 0: {
                        string = string + metaDataCondition.getIntValue();
                        break block0;
                    }
                    case 2: {
                        string = string + metaDataCondition.getFloatValue();
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Invalid value type for the metadata attribute: " + metaDataCondition.getField());
            }
            case 1: {
                switch (metaDataCondition.getFieldType()) {
                    case 3: 
                    case 4: {
                        string = string + "'" + metaDataCondition.getStringValue(0) + "' and " + "'" + metaDataCondition.getStringValue(1) + "'";
                        break block0;
                    }
                    case 0: {
                        string = string + metaDataCondition.getIntValue(0) + " and " + metaDataCondition.getIntValue(1);
                        break block0;
                    }
                    case 2: {
                        string = string + metaDataCondition.getFloatValue(0) + " and " + metaDataCondition.getFloatValue(1);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Invalid value type for the metadata attribute: " + metaDataCondition.getField());
            }
            case 2: {
                switch (metaDataCondition.getFieldType()) {
                    case 3: 
                    case 4: {
                        for (int i = 0; i < metaDataCondition.getCount(); ++i) {
                            string = string + "'" + metaDataCondition.getStringValue(i) + "',";
                        }
                        break;
                    }
                    case 0: {
                        for (int i = 0; i < metaDataCondition.getCount(); ++i) {
                            string = string + metaDataCondition.getIntValue(i) + ",";
                        }
                        break;
                    }
                    case 2: {
                        for (int i = 0; i < metaDataCondition.getCount(); ++i) {
                            string = string + metaDataCondition.getFloatValue(i) + ",";
                        }
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid value type for the metadata attribute: " + metaDataCondition.getField());
                    }
                }
                string = string.substring(0, string.length() - 1);
                break;
            }
            case 14: {
                MetaDataTable metaDataTable = metaDataCondition.getTableValue();
                string = string + this.setTableGenQuery(metaDataTable, metaDataCondition);
                if (metaDataTable.getRowCount() <= 5) break;
                break;
            }
            default: {
                throw new RuntimeException("temp SRBMetaDataCommands.getdatadir,style");
            }
        }
        string = string + SRBMetaDataCommands.getEndOperator(metaDataCondition);
        return string;
    }

    SRBMetaDataRecordList[] srbGenQuery(int n, String string, MetaDataCondition[] metaDataConditionArray, MetaDataSelect[] metaDataSelectArray, int n2, boolean bl, boolean bl2) throws IOException {
        int[] nArray;
        if (SRBCommands.DEBUG > 0) {
            System.err.println("\n srbGenQuery");
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = Integer.MIN_VALUE;
        boolean bl3 = false;
        SRBMetaDataRecordList[] sRBMetaDataRecordListArray = null;
        SRBMetaDataRecordList[] sRBMetaDataRecordListArray2 = null;
        int n7 = 2;
        String string2 = "";
        byte[] byArray = new byte[2700];
        int n8 = metaDataSelectArray.length;
        MetaDataCondition[] metaDataConditionArray2 = null;
        Object[] objectArray = new MetaDataSelect[n8];
        int[] nArray2 = null;
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        int n9 = 0;
        if (metaDataConditionArray != null && (metaDataConditionArray = (MetaDataCondition[])SRBMetaDataCommands.cleanNullsAndDuplicates(metaDataConditionArray)) != null) {
            n9 = metaDataConditionArray.length;
            for (n3 = 0; n3 < n9; ++n3) {
                if (metaDataConditionArray[n3].getStyle() == 14) {
                    if (metaDataConditionArray[n3].getOperator() == 10 || metaDataConditionArray[n3].getOperator() == 11) {
                        metaDataConditionArray[n3] = MetaDataSet.newCondition(metaDataConditionArray[n3].getFieldName(), metaDataConditionArray[n3].getOperator(), this.fixLIKE(metaDataConditionArray[n3].getTableValue(), true));
                        continue;
                    }
                    metaDataConditionArray[n3] = MetaDataSet.newCondition(metaDataConditionArray[n3].getFieldName(), metaDataConditionArray[n3].getOperator(), this.fixLIKE(metaDataConditionArray[n3].getTableValue(), false));
                    continue;
                }
                if (metaDataConditionArray[n3].getOperator() != 10 && metaDataConditionArray[n3].getOperator() != 11) continue;
                metaDataConditionArray[n3] = MetaDataSet.newCondition(metaDataConditionArray[n3].getFieldName(), metaDataConditionArray[n3].getOperator(), this.fixLIKE(metaDataConditionArray[n3].getStringValue()));
            }
        }
        if (n9 > 0) {
            metaDataConditionArray2 = new MetaDataCondition[n9];
            System.arraycopy(metaDataConditionArray, 0, metaDataConditionArray2, 0, n9);
        }
        System.arraycopy(metaDataSelectArray, 0, objectArray, 0, n8);
        if (metaDataConditionArray2 != null) {
            n9 = metaDataConditionArray2.length;
            for (n3 = 0; n3 < metaDataConditionArray2.length; ++n3) {
                if (SRBCommands.DEBUG > 3) {
                    System.err.println("conditions\t\t " + metaDataConditionArray2[n3].getFieldName() + " " + metaDataConditionArray2[n3].getStringValue());
                }
                if (metaDataConditionArray2[n3].getStyle() != 14) continue;
                int n10 = metaDataConditionArray2[n3].getTableValue().getRowCount();
                if (n10 >= 5) {
                    if (metaDataConditionArray2[n3].getFieldName().equals("definable metadata for files") || metaDataConditionArray2[n3].getFieldName().equals("definable metadata for directories")) {
                        n9 += 5 * metaDataConditionArray2[n3].getTableValue().getColumnCount() - 1;
                        continue;
                    }
                    n9 += 4 * metaDataConditionArray2[n3].getTableValue().getColumnCount() - 1;
                    continue;
                }
                n9 += n10 * metaDataConditionArray2[n3].getTableValue().getColumnCount() - 1;
            }
            if (n9 > 0) {
                n5 = 0;
                nArray2 = new int[n9];
                for (n3 = 0; n3 < metaDataConditionArray2.length; ++n3) {
                    nArray2[n3] = SRBMetaDataSet.getSRBID(metaDataConditionArray2[n3].getFieldName());
                }
                for (n3 = 0; n3 < metaDataConditionArray2.length; ++n3) {
                    if (metaDataConditionArray2[n3] != null && nArray2[n3] != Integer.MIN_VALUE) {
                        for (n4 = n3 + 1; n4 < metaDataConditionArray2.length; ++n4) {
                            if (nArray2[n3] != nArray2[n4]) continue;
                            --n9;
                            nArray2[n4] = Integer.MIN_VALUE;
                        }
                        if (nArray2[n3] == Integer.MIN_VALUE) continue;
                        if (metaDataConditionArray2[n3].getStyle() == 14) {
                            int[] nArray3 = this.setTableConditionIDs(metaDataConditionArray2[n3].getTableValue(), metaDataConditionArray2[n3].getFieldName());
                            if (metaDataConditionArray2.length < nArray2.length + n5) {
                                nArray = new int[nArray2.length - n5 - 1];
                                System.arraycopy(nArray2, n5 + 1, nArray, 0, nArray.length);
                                System.arraycopy(nArray3, 0, nArray2, n5, nArray3.length);
                                for (n4 = n5 += nArray3.length; n4 < nArray2.length; ++n4) {
                                    nArray2[n4] = nArray[n4 - n5];
                                    ++n3;
                                }
                                continue;
                            }
                            System.arraycopy(nArray3, 0, nArray2, n5, nArray3.length);
                            n5 += nArray3.length;
                            continue;
                        }
                        nArray2[n5] = SRBMetaDataSet.getSRBID(metaDataConditionArray2[n3].getFieldName());
                        ++n5;
                        continue;
                    }
                    ++n5;
                }
            }
        } else {
            n9 = 0;
        }
        if ((objectArray = (MetaDataSelect[])SRBMetaDataCommands.cleanNullsAndDuplicates(objectArray)) == null) {
            return null;
        }
        n8 = objectArray.length;
        int[] nArray4 = new int[n8];
        nArray = new int[n8];
        int n11 = -1;
        Object var29_30 = null;
        Object var30_31 = null;
        n5 = n8;
        for (n3 = 0; n3 < n5; ++n3) {
            n6 = SRBMetaDataSet.getSRBID(((MetaDataSelect)objectArray[n3]).getFieldName());
            if (n6 > 0) {
                nArray4[n3] = n6;
                nArray[n3] = ((MetaDataSelect)objectArray[n3]).getOperation();
                continue;
            }
            if (n6 < 0 && n6 > -4) {
                int n12 = 0;
                MetaDataSelect[] metaDataSelectArray2 = new MetaDataSelect[3];
                if (n6 == -1) {
                    metaDataSelectArray2[0] = MetaDataSet.newSelection("file name");
                    metaDataSelectArray2[1] = MetaDataSet.newSelection("directory name");
                    metaDataSelectArray2[2] = MetaDataSet.newSelection("metadata number", 9);
                    n7 = 2;
                } else if (n6 == -2) {
                    metaDataSelectArray2[0] = MetaDataSet.newSelection("directory name");
                    metaDataSelectArray2[1] = MetaDataSet.newSelection("metadata number directory", 9);
                    n7 = 1;
                } else if (n6 == -3) {
                    metaDataSelectArray2[0] = MetaDataSet.newSelection("user name");
                    metaDataSelectArray2[1] = MetaDataSet.newSelection("user domain");
                    metaDataSelectArray2[2] = MetaDataSet.newSelection("metadata number for users", 9);
                    n7 = 2;
                } else if (n6 == -4) {
                    metaDataSelectArray2[0] = MetaDataSet.newSelection("Resource Name");
                    metaDataSelectArray2[1] = MetaDataSet.newSelection("metadata number for resources", 9);
                    n7 = 1;
                }
                sRBMetaDataRecordListArray2 = this.srbGenQuery(n, string, metaDataConditionArray2, metaDataSelectArray2, n2, true, bl2);
                if (sRBMetaDataRecordListArray2 != null) {
                    for (n4 = 0; n4 < sRBMetaDataRecordListArray2.length; ++n4) {
                        if (sRBMetaDataRecordListArray2[n4].getIntValue(n7) < 0) continue;
                        n12 += sRBMetaDataRecordListArray2[n4].getIntValue(n7);
                    }
                    if (n12 + sRBMetaDataRecordListArray2.length > n2) {
                        n2 = n12;
                    }
                }
                metaDataSelectArray2 = new MetaDataSelect[12];
                if (n6 == -1) {
                    metaDataSelectArray2[0] = MetaDataSet.newSelection("file name");
                    metaDataSelectArray2[1] = MetaDataSet.newSelection("directory name");
                    metaDataSelectArray2[2] = MetaDataSet.newSelection("definable metadata file0");
                    metaDataSelectArray2[3] = MetaDataSet.newSelection("definable metadata file1");
                    metaDataSelectArray2[4] = MetaDataSet.newSelection("definable metadata file2");
                    metaDataSelectArray2[5] = MetaDataSet.newSelection("definable metadata file3");
                    metaDataSelectArray2[6] = MetaDataSet.newSelection("definable metadata file4");
                    metaDataSelectArray2[7] = MetaDataSet.newSelection("definable metadata file5");
                    metaDataSelectArray2[8] = MetaDataSet.newSelection("definable metadata file6");
                    metaDataSelectArray2[9] = MetaDataSet.newSelection("definable metadata file7");
                    metaDataSelectArray2[10] = MetaDataSet.newSelection("definable metadata file8");
                    metaDataSelectArray2[11] = MetaDataSet.newSelection("definable metadata file9");
                }
                if (n6 == -2) {
                    metaDataSelectArray2[0] = MetaDataSet.newSelection("directory name");
                    metaDataSelectArray2[1] = MetaDataSet.newSelection("definable metadata directory0");
                    metaDataSelectArray2[2] = MetaDataSet.newSelection("definable metadata directory1");
                    metaDataSelectArray2[3] = MetaDataSet.newSelection("definable metadata directory2");
                    metaDataSelectArray2[4] = MetaDataSet.newSelection("definable metadata directory3");
                    metaDataSelectArray2[5] = MetaDataSet.newSelection("definable metadata directory4");
                    metaDataSelectArray2[6] = MetaDataSet.newSelection("definable metadata directory5");
                    metaDataSelectArray2[7] = MetaDataSet.newSelection("definable metadata directory6");
                    metaDataSelectArray2[8] = MetaDataSet.newSelection("definable metadata directory7");
                    metaDataSelectArray2[9] = MetaDataSet.newSelection("definable metadata directory8");
                    metaDataSelectArray2[10] = MetaDataSet.newSelection("definable metadata directory9");
                }
                if (n6 == -3) {
                    metaDataSelectArray2[0] = MetaDataSet.newSelection("user name");
                    metaDataSelectArray2[1] = MetaDataSet.newSelection("user domain");
                    metaDataSelectArray2[2] = MetaDataSet.newSelection("definable metadata user0");
                    metaDataSelectArray2[3] = MetaDataSet.newSelection("definable metadata user1");
                    metaDataSelectArray2[4] = MetaDataSet.newSelection("definable metadata user2");
                    metaDataSelectArray2[5] = MetaDataSet.newSelection("definable metadata user3");
                    metaDataSelectArray2[6] = MetaDataSet.newSelection("definable metadata user4");
                    metaDataSelectArray2[7] = MetaDataSet.newSelection("definable metadata user5");
                    metaDataSelectArray2[8] = MetaDataSet.newSelection("definable metadata user6");
                    metaDataSelectArray2[9] = MetaDataSet.newSelection("definable metadata user7");
                    metaDataSelectArray2[10] = MetaDataSet.newSelection("definable metadata user8");
                    metaDataSelectArray2[11] = MetaDataSet.newSelection("definable metadata user9");
                }
                if (n6 == -4) {
                    metaDataSelectArray2[0] = MetaDataSet.newSelection("Resource Name");
                    metaDataSelectArray2[1] = MetaDataSet.newSelection("definable metadata resource0");
                    metaDataSelectArray2[2] = MetaDataSet.newSelection("definable metadata resource1");
                    metaDataSelectArray2[3] = MetaDataSet.newSelection("definable metadata resource2");
                    metaDataSelectArray2[4] = MetaDataSet.newSelection("definable metadata resource3");
                    metaDataSelectArray2[5] = MetaDataSet.newSelection("definable metadata resource4");
                    metaDataSelectArray2[6] = MetaDataSet.newSelection("definable metadata resource5");
                    metaDataSelectArray2[7] = MetaDataSet.newSelection("definable metadata resource6");
                    metaDataSelectArray2[8] = MetaDataSet.newSelection("definable metadata resource7");
                    metaDataSelectArray2[9] = MetaDataSet.newSelection("definable metadata resource8");
                    metaDataSelectArray2[10] = MetaDataSet.newSelection("definable metadata resource9");
                }
                objectArray[n3] = null;
                bl = true;
                objectArray = MetaDataSet.mergeSelects(metaDataSelectArray2, (MetaDataSelect[])objectArray);
                if ((objectArray = (MetaDataSelect[])SRBMetaDataCommands.cleanNullsAndDuplicates(objectArray)) == null) {
                    return null;
                }
                n3 = -1;
                n5 = n8 = objectArray.length;
                nArray4 = new int[n8];
                nArray = new int[n8];
                continue;
            }
            throw new NullPointerException("Extensible metadata or invalid metadata attribute: " + ((MetaDataSelect)objectArray[n3]).getFieldName() + " not support in this version");
        }
        byte[] byArray2 = null;
        n5 = 0;
        if (bl2) {
            Host.copyInt(n8 + 1, byArray, n5);
            n5 += 4;
        } else {
            Host.copyInt(n8, byArray, n5);
            n5 += 4;
        }
        if (bl) {
            Host.copyInt(n9 + 1, byArray, n5);
            n5 += 4;
        } else {
            Host.copyInt(n9, byArray, n5);
            n5 += 4;
        }
        for (n3 = 0; n3 < n8; ++n3) {
            Host.copyInt(nArray4[n3], byArray, n5);
            n5 += 4;
        }
        if (bl2) {
            Host.copyInt(SRBMetaDataSet.getSRBID("nondistinct"), byArray, n5);
            n5 += 4;
        }
        for (n3 = 0; n3 < n8; ++n3) {
            Host.copyInt(nArray[n3], byArray, n5);
            n5 += 4;
        }
        if (bl2) {
            Host.copyInt(1, byArray, n5);
            n5 += 4;
        }
        if (n9 > 0) {
            for (n3 = 0; n3 < nArray2.length; ++n3) {
                if (nArray2[n3] < 0) continue;
                Host.copyInt(nArray2[n3], byArray, n5);
                n5 += 4;
                if (SRBCommands.DEBUG <= 4) continue;
                System.err.println("conditionID " + nArray2[n3]);
            }
        }
        if (bl) {
            Host.copyInt(SRBMetaDataSet.getSRBID("order by"), byArray, n5);
            n5 += 4;
        }
        if (n9 > 0) {
            for (n3 = 0; n3 < metaDataConditionArray2.length; ++n3) {
                if (metaDataConditionArray2[n3] == null) continue;
                int n13 = metaDataConditionArray2[n3].getStyle();
                string2 = string2 + this.addValue(n13, metaDataConditionArray2[n3]);
                System.arraycopy(string2.getBytes(), 0, byArray, n5, string2.getBytes().length);
                n5 = n13 == 14 ? (n5 += string2.getBytes().length) : (n5 += string2.getBytes().length + 1);
                string2 = "";
                for (n4 = n3 + 1; n4 < metaDataConditionArray2.length; ++n4) {
                    if (metaDataConditionArray2[n4] == null || !metaDataConditionArray2[n3].getField().equals(metaDataConditionArray2[n4].getField())) continue;
                    n13 = metaDataConditionArray2[n4].getStyle();
                    string2 = string2 + " && " + this.addValue(n13, metaDataConditionArray2[n4]);
                    System.arraycopy(string2.getBytes(), 0, byArray, --n5, string2.getBytes().length);
                    metaDataConditionArray2[n4] = null;
                    n5 = n13 == 14 ? (n5 += string2.getBytes().length) : (n5 += string2.getBytes().length + 1);
                    string2 = "";
                }
            }
        }
        if (bl) {
            string2 = SRBMetaDataSet.getSRBName(((MetaDataSelect)objectArray[0]).getFieldName());
            for (n4 = 1; n4 < objectArray.length; ++n4) {
                if (((MetaDataSelect)objectArray[n4]).getOperation() != 1) continue;
                string2 = string2 + ", " + SRBMetaDataSet.getSRBName(((MetaDataSelect)objectArray[n4]).getFieldName());
            }
            System.arraycopy(string2.getBytes(), 0, byArray, n5, string2.getBytes().length);
            n5 += string2.getBytes().length + 1;
        }
        byArray2 = new byte[n5 + 4];
        System.arraycopy(byArray, 0, byArray2, 4, n5);
        Host.copyInt(n5, byArray2, 0);
        if (SRBCommands.DEBUG > 1) {
            System.err.print("\nselects[j].getFieldName() " + n8);
            for (n4 = 0; n4 < n8; ++n4) {
                System.err.print("\n" + nArray4[n4]);
                System.err.print(" " + nArray[n4]);
            }
            if (SRBCommands.DEBUG > 4) {
                System.err.print("\ncorrectSizeQuery1.");
                for (n3 = 0; n3 < byArray2.length; ++n3) {
                    if (byArray2[n3] > 32) {
                        System.err.print((char)byArray2[n3] + "_");
                        continue;
                    }
                    System.err.print(byArray2[n3] + ".");
                }
                System.err.print("\n\n");
            }
        }
        this.commands.startSRBCommand(2155, 4);
        this.commands.sendArg(n);
        this.commands.sendArg(string);
        this.commands.sendArg(byArray2);
        this.commands.sendArg(n2);
        this.commands.flush();
        try {
            this.commands.commandStatus();
        }
        catch (SRBException sRBException) {
            if (sRBException.getType() == -3005) {
                return null;
            }
            throw sRBException;
        }
        sRBMetaDataRecordListArray = this.commands.returnSRBMetaDataRecordList(false, null);
        if (sRBMetaDataRecordListArray2 != null) {
            for (n3 = 0; n3 < sRBMetaDataRecordListArray.length; ++n3) {
                sRBMetaDataRecordListArray[n3].addMetaDataNums(sRBMetaDataRecordListArray2, n7);
            }
        }
        return sRBMetaDataRecordListArray;
    }
}

