/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.image;

import org.dcm4che2.image.LookupTable;
import org.dcm4che2.image.ShortLookupTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteLookupTable
extends LookupTable {
    private static final Logger log = LoggerFactory.getLogger(ByteLookupTable.class);
    private byte[] data;

    public ByteLookupTable(int inBits, boolean signed, int off, int outBits, byte[] data) {
        this(inBits, signed, off, outBits, data, false);
    }

    public ByteLookupTable(int inBits, boolean signed, int off, int outBits, byte[] data, boolean preserve) {
        super(inBits, signed, off, outBits, preserve);
        this.data = data;
    }

    public final int length() {
        return this.data.length;
    }

    public final byte lookupByte(int in) {
        int tmp = ((in & this.signbit) != 0 ? in | this.ormask : in & this.andmask) - this.off;
        return tmp <= 0 ? this.data[0] : (tmp >= this.data.length ? this.data[this.data.length - 1] : this.data[tmp]);
    }

    public final short lookupShort(int in) {
        return (short)(this.lookupByte(in) & 0xFF);
    }

    public final int lookup(int in) {
        return this.lookupByte(in) & 0xFF;
    }

    public final byte[] lookup(byte[] src, byte[] dst) {
        int len;
        if (dst == null) {
            dst = new byte[src.length];
        }
        if (dst.length < (len = src.length)) {
            log.warn("Destination length " + dst.length + " is shorter than src length " + src.length);
            len = dst.length;
        }
        for (int i = 0; i < len; ++i) {
            dst[i] = this.lookupByte(src[i]);
        }
        return dst;
    }

    public final short[] lookup(byte[] src, short[] dst) {
        int len;
        if (dst == null) {
            dst = new short[src.length];
        }
        if (dst.length < (len = src.length)) {
            log.warn("Destination length " + dst.length + " is shorter than src length " + src.length);
            len = dst.length;
        }
        for (int i = 0; i < len; ++i) {
            dst[i] = this.lookupShort(src[i]);
        }
        return dst;
    }

    public final int[] lookup(byte[] src, int[] dst, int alpha) {
        int len;
        if (dst == null) {
            dst = new int[src.length];
        }
        if (dst.length < (len = src.length)) {
            log.warn("Destination length " + dst.length + " is shorter than src length " + src.length);
            len = dst.length;
        }
        for (int i = 0; i < len; ++i) {
            int tmp = this.lookup(src[i]);
            dst[i] = tmp | tmp << 8 | tmp << 16 | alpha << 24;
        }
        return dst;
    }

    public final byte[] lookup(short[] src, byte[] dst) {
        int len;
        if (dst == null) {
            dst = new byte[src.length];
        }
        if (dst.length < (len = src.length)) {
            log.warn("Destination length " + dst.length + " is shorter than src length " + src.length);
            len = dst.length;
        }
        for (int i = 0; i < len; ++i) {
            dst[i] = this.lookupByte(src[i]);
        }
        return dst;
    }

    public final short[] lookup(short[] src, short[] dst) {
        int len;
        if (dst == null) {
            dst = new short[src.length];
        }
        if (dst.length < (len = src.length)) {
            log.warn("Destination length " + dst.length + " is shorter than src length " + src.length);
            len = dst.length;
        }
        for (int i = 0; i < len; ++i) {
            dst[i] = this.lookupShort(src[i]);
        }
        return dst;
    }

    public final int[] lookup(short[] src, int[] dst, int alpha) {
        if (dst == null) {
            dst = new int[src.length];
        }
        for (int i = 0; i < src.length; ++i) {
            int tmp = this.lookup(src[i]);
            dst[i] = tmp | tmp << 8 | tmp << 16 | alpha << 24;
        }
        return dst;
    }

    protected LookupTable scale(int outBits, boolean inverse, short[] pval2out) {
        if (outBits == this.outBits && !inverse && pval2out == null) {
            return this;
        }
        int outBits1 = pval2out == null ? outBits : ByteLookupTable.inBits(pval2out);
        int shift = outBits1 - this.outBits;
        int pval2outShift = 16 - outBits;
        int outMax = (1 << outBits1) - 1;
        if (outBits <= 8) {
            byte[] newData = this.preserve ? new byte[this.data.length] : this.data;
            for (int i = 0; i < newData.length; ++i) {
                int tmp = this.data[i] & 0xFF;
                tmp = shift < 0 ? (tmp >>>= -shift) : (tmp <<= shift);
                if (inverse) {
                    tmp = outMax - tmp;
                }
                if (pval2out != null) {
                    tmp = (pval2out[tmp] & 0xFFFF) >>> pval2outShift;
                }
                newData[i] = (byte)tmp;
            }
            if (this.preserve) {
                return new ByteLookupTable(this.inBits, this.signbit != 0, this.off, outBits, newData);
            }
            this.outBits = outBits;
            return this;
        }
        short[] newData = new short[this.data.length];
        for (int i = 0; i < newData.length; ++i) {
            int tmp = this.data[i] & 0xFF;
            tmp = shift < 0 ? (tmp >>>= -shift) : (tmp <<= shift);
            if (inverse) {
                tmp = outMax - tmp;
            }
            if (pval2out != null) {
                tmp = (pval2out[tmp] & 0xFFFF) >>> pval2outShift;
            }
            newData[i] = (short)tmp;
        }
        return new ShortLookupTable(this.inBits, this.signbit != 0, this.off, outBits, newData);
    }

    protected LookupTable combine(LookupTable other, int outBits, boolean inverse, short[] pval2out) {
        int shift1 = other.inBits - this.outBits;
        int outBits1 = pval2out == null ? outBits : ByteLookupTable.inBits(pval2out);
        int shift2 = outBits1 - other.outBits;
        int pval2outShift = 16 - outBits;
        int outMax = (1 << outBits1) - 1;
        if (outBits <= 8) {
            byte[] newData = new byte[this.data.length];
            for (int i = 0; i < newData.length; ++i) {
                int tmp = this.data[i] & 0xFF;
                tmp = other.lookup(shift1 < 0 ? tmp >>> -shift1 : tmp << shift1);
                tmp = shift2 < 0 ? (tmp >>>= -shift2) : (tmp <<= shift2);
                if (inverse) {
                    tmp = outMax - tmp;
                }
                if (pval2out != null) {
                    tmp = (pval2out[tmp] & 0xFFFF) >>> pval2outShift;
                }
                newData[i] = (byte)tmp;
            }
            return new ByteLookupTable(this.inBits, this.signbit != 0, this.off, outBits, newData);
        }
        short[] newData = new short[this.data.length];
        for (int i = 0; i < newData.length; ++i) {
            int tmp = this.data[i] & 0xFF;
            tmp = other.lookup(shift1 < 0 ? tmp >>> -shift1 : tmp << shift1);
            tmp = shift2 < 0 ? (tmp >>>= -shift2) : (tmp <<= shift2);
            if (inverse) {
                tmp = outMax - tmp;
            }
            if (pval2out != null) {
                tmp = (pval2out[tmp] & 0xFFFF) >>> pval2outShift;
            }
            newData[i] = (short)tmp;
        }
        return new ShortLookupTable(this.inBits, this.signbit != 0, this.off, outBits, newData);
    }

    protected LookupTable combine(LookupTable vlut, LookupTable plut, int outBits, boolean inverse, short[] pval2out) {
        int shift1 = plut.inBits - vlut.outBits;
        int outBits1 = pval2out == null ? outBits : ByteLookupTable.inBits(pval2out);
        int shift2 = outBits - plut.outBits;
        int pval2outShift = 16 - outBits;
        int outMax = (1 << outBits1) - 1;
        if (outBits <= 8) {
            byte[] newData = new byte[this.data.length];
            for (int i = 0; i < newData.length; ++i) {
                int tmp = vlut.lookup(this.data[i] & 0xFF);
                tmp = plut.lookup(shift1 < 0 ? tmp >>> -shift1 : tmp << shift1);
                tmp = shift2 < 0 ? (tmp >>>= -shift2) : (tmp <<= shift2);
                if (inverse) {
                    tmp = outMax - tmp;
                }
                if (pval2out != null) {
                    tmp = (pval2out[tmp] & 0xFFFF) >>> pval2outShift;
                }
                newData[i] = (byte)tmp;
            }
            return new ByteLookupTable(this.inBits, this.signbit != 0, this.off, outBits, newData);
        }
        short[] newData = new short[this.data.length];
        for (int i = 0; i < newData.length; ++i) {
            int tmp = vlut.lookup(this.data[i] & 0xFF);
            tmp = plut.lookup(shift1 < 0 ? tmp >>> -shift1 : tmp << shift1);
            tmp = shift2 < 0 ? (tmp >>>= -shift2) : (tmp <<= shift2);
            if (inverse) {
                tmp = outMax - tmp;
            }
            if (pval2out != null) {
                tmp = (pval2out[tmp] & 0xFFFF) >>> pval2outShift;
            }
            newData[i] = (short)tmp;
        }
        return new ShortLookupTable(this.inBits, this.signbit != 0, this.off, outBits, newData);
    }
}

