/*
 * Decompiled with CFR 0.152.
 */
package net.nbirn.mediator.client;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import net.nbirn.mediator.client.Kin;
import net.nbirn.mediator.client.Source;

public class Relation {
    public Hashtable ht = new Hashtable();
    public Vector vec = new Vector();
    private String name;
    private Source source;
    private Vector bindingPattern = new Vector();

    public Relation() {
    }

    public Relation(String name) {
        this.name = name;
    }

    public Relation(Source source, String name) {
        this.name = name;
        Relation r = source.getRelation(name);
        this.ht = r.getKins();
        this.vec = r.getKinVector();
        this.bindingPattern = r.getBindingPattern();
    }

    public Vector getKinVector() {
        return this.vec;
    }

    private Hashtable getKins() {
        return this.ht;
    }

    public void setKins(Hashtable kins) {
        this.ht = kins;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean add(Kin kin) {
        if (null == this.getKin(kin.getName())) {
            this.ht.put(kin.getName(), new Integer(this.vec.size()));
            this.vec.add(kin);
            return true;
        }
        return false;
    }

    public Kin getKin(String name) {
        if (null == name) {
            return null;
        }
        Integer index = (Integer)this.ht.get(name);
        if (null == index) {
            return null;
        }
        return (Kin)this.vec.get(index);
    }

    public Kin getKin(int pos) {
        if (pos <= 0) {
            return null;
        }
        return (Kin)this.vec.get(--pos);
    }

    public boolean change(Kin kin) {
        if (null == kin || null == this.getKin(kin.getName())) {
            return false;
        }
        this.ht.put(kin.getName(), kin);
        return true;
    }

    public boolean remove(String name) {
        return null != this.ht.remove(name);
    }

    public int arity() {
        return this.ht.size();
    }

    public Vector getKinNames() {
        Integer index = null;
        Vector<Object> vec = new Vector<Object>();
        String eachName = null;
        Object[] obj = new Object[this.ht.size()];
        Iterator itr = this.ht.keySet().iterator();
        while (itr.hasNext()) {
            eachName = itr.next().toString();
            index = (Integer)this.ht.get(eachName);
            obj[index.intValue()] = eachName;
        }
        int i = 0;
        while (i < obj.length) {
            vec.add(obj[i]);
            ++i;
        }
        return vec;
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public void addBindingPattern(String bp) {
        if (bp != null && !this.bindingPattern.contains(bp)) {
            this.bindingPattern.add(bp);
        }
    }

    public void setBindingPattern(Vector bpList) {
        this.bindingPattern = bpList;
    }

    public Vector getBindingPattern() {
        return this.bindingPattern;
    }

    public int getKinPosition(String name) {
        Integer pos = (Integer)this.ht.get(name);
        int intValue = pos;
        return ++intValue;
    }

    public String getKinName(int pos) {
        Kin k = (Kin)this.vec.get(--pos);
        return k.getName();
    }
}

