/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.image;

import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.image.ByteLookupTable;
import org.dcm4che2.image.ShortLookupTable;
import org.dcm4che2.image.VOIUtils;
import org.dcm4che2.util.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LookupTable {
    private static final Logger log = LoggerFactory.getLogger(LookupTable.class);
    public static final String LINEAR = "LINEAR";
    public static final String SIGMOID = "SIGMOID";
    private static final int OPAQUE = 255;
    protected final int inBits;
    protected final int andmask;
    protected final int ormask;
    protected final int signbit;
    protected final boolean preserve;
    protected int outBits;
    protected int off;

    protected LookupTable(int inBits, boolean signed, int off, int outBits, boolean preserve) {
        this.inBits = inBits;
        this.outBits = outBits;
        this.andmask = (1 << inBits) - 1;
        this.ormask = ~this.andmask;
        this.signbit = signed ? 1 << inBits - 1 : 0;
        this.off = (off & this.signbit) != 0 ? off | this.ormask : off;
        this.preserve = preserve;
    }

    public final int getOffset() {
        return this.off;
    }

    public abstract int length();

    public abstract byte lookupByte(int var1);

    public abstract short lookupShort(int var1);

    public abstract int lookup(int var1);

    public abstract byte[] lookup(byte[] var1, byte[] var2);

    public abstract short[] lookup(byte[] var1, short[] var2);

    public abstract int[] lookup(byte[] var1, int[] var2, int var3);

    public abstract byte[] lookup(short[] var1, byte[] var2);

    public abstract short[] lookup(short[] var1, short[] var2);

    public abstract int[] lookup(short[] var1, int[] var2, int var3);

    public void lookup(DataBuffer src, DataBuffer dst) {
        this.lookup(src, dst, 255);
    }

    public void lookup(DataBuffer src, DataBuffer dst, int alpha) {
        switch (dst.getDataType()) {
            case 0: {
                this.lookup(src, ((DataBufferByte)dst).getData());
                break;
            }
            case 1: {
                this.lookup(src, ((DataBufferUShort)dst).getData());
                break;
            }
            case 2: {
                this.lookup(src, ((DataBufferShort)dst).getData());
                break;
            }
            case 3: {
                this.lookup(src, ((DataBufferInt)dst).getData(), alpha);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal Type of Destination DataBuffer: " + dst);
            }
        }
    }

    public void lookup(DataBuffer src, byte[] dst) {
        switch (src.getDataType()) {
            case 0: {
                this.lookup(((DataBufferByte)src).getData(), dst);
                break;
            }
            case 1: {
                this.lookup(((DataBufferUShort)src).getData(), dst);
                break;
            }
            case 2: {
                this.lookup(((DataBufferShort)src).getData(), dst);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal Type of Source DataBuffer: " + src);
            }
        }
    }

    public void lookup(DataBuffer src, short[] dst) {
        switch (src.getDataType()) {
            case 0: {
                this.lookup(((DataBufferByte)src).getData(), dst);
                break;
            }
            case 1: {
                this.lookup(((DataBufferUShort)src).getData(), dst);
                break;
            }
            case 2: {
                this.lookup(((DataBufferShort)src).getData(), dst);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal Type of Source DataBuffer: " + src);
            }
        }
    }

    public void lookup(DataBuffer src, int[] dst, int alpha) {
        switch (src.getDataType()) {
            case 0: {
                this.lookup(((DataBufferByte)src).getData(), dst, alpha);
                break;
            }
            case 1: {
                this.lookup(((DataBufferUShort)src).getData(), dst, alpha);
                break;
            }
            case 2: {
                this.lookup(((DataBufferShort)src).getData(), dst, alpha);
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal Type of Source DataBuffer: " + src);
            }
        }
    }

    protected abstract LookupTable scale(int var1, boolean var2, short[] var3);

    protected abstract LookupTable combine(LookupTable var1, int var2, boolean var3, short[] var4);

    protected abstract LookupTable combine(LookupTable var1, LookupTable var2, int var3, boolean var4, short[] var5);

    protected final int toIndex(int in) {
        return ((in & this.signbit) != 0 ? in | this.ormask : in & this.andmask) - this.off;
    }

    static int inBits(short[] pval2out) {
        switch (pval2out.length) {
            case 256: {
                return 8;
            }
            case 512: {
                return 9;
            }
            case 1024: {
                return 10;
            }
            case 2048: {
                return 11;
            }
            case 4096: {
                return 12;
            }
            case 8192: {
                return 13;
            }
            case 16384: {
                return 14;
            }
            case 32768: {
                return 15;
            }
            case 65536: {
                return 16;
            }
        }
        throw new IllegalArgumentException("pval2out.length: " + pval2out.length + " != 2^[8..16]");
    }

    public static LookupTable createLut(int inBits, boolean signed, int outBits, float slope, float intercept, float center, float width, String vlutFct, boolean inverse, short[] pval2out) {
        log.debug("Creating a slope/intercept LUT  " + slope + "/" + intercept + " WL c/w= " + center + "/" + width);
        if (width == 0.0f || vlutFct == null || LINEAR.equals(vlutFct)) {
            return LookupTable.createRampLut(inBits, signed, outBits, slope, intercept, center, width, inverse, pval2out);
        }
        if (SIGMOID.equals(vlutFct)) {
            return LookupTable.createSigmoidLut(inBits, signed, outBits, slope, intercept, center, width, inverse, pval2out);
        }
        throw new UnsupportedOperationException("Unsupported VOI LUT function: " + vlutFct);
    }

    private static LookupTable createRampLut(int inBits, boolean signed, int outBits, float slope, float intercept, float center, float width, boolean inverse, short[] pval2out) {
        int out2;
        int out1;
        int in2;
        int in1;
        log.debug("Ramp LUT " + slope + "/" + intercept + " c/w=" + center + "/" + width + " inverse " + inverse);
        if (slope < 0.0f) {
            slope = -slope;
            intercept = -intercept;
            center = 1.0f - center;
            boolean bl = inverse = !inverse;
        }
        if (width < 0.0f) {
            width = -width;
            inverse = !inverse;
        }
        int inRange = 1 << inBits;
        int inMin = signed ? -inRange / 2 : 0;
        int inMax = inMin + inRange - 1;
        if (width == 0.0f) {
            in1 = inMin;
            in2 = inMax;
        } else {
            float c_05 = center - 0.5f;
            float w_2 = (width - 1.0f) / 2.0f;
            in1 = (int)((c_05 - w_2 - intercept) / slope);
            in2 = (int)((c_05 + w_2 - intercept) / slope);
        }
        int off = Math.max(in1, inMin);
        int iMax = Math.min(in2, inMax) - off;
        int size = iMax + 1;
        int outBits1 = pval2out == null ? outBits : LookupTable.inBits(pval2out);
        int outRange = 1 << outBits1;
        int pval2outShift = 16 - outBits;
        if (inverse) {
            out1 = outRange - 1;
            out2 = 0;
        } else {
            out1 = 0;
            out2 = outRange - 1;
        }
        float m = (float)(out2 - out1) / (float)(in2 - in1);
        float b = (float)out1 + m * (float)(off - in1) + 0.5f;
        if (outBits <= 8) {
            byte[] data = new byte[size];
            if (pval2out == null) {
                for (int i = 0; i < size; ++i) {
                    data[i] = (byte)(m * (float)i + b);
                }
                if (iMax + off == in2) {
                    data[iMax] = (byte)out2;
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    data[i] = (byte)((pval2out[(int)(m * (float)i + b)] & 0xFFFF) >>> pval2outShift);
                }
                if (iMax + off == in2) {
                    data[iMax] = (byte)((pval2out[out2] & 0xFFFF) >>> pval2outShift);
                }
            }
            return new ByteLookupTable(inBits, signed, off, outBits, data);
        }
        short[] data = new short[size];
        if (pval2out == null) {
            for (int i = 0; i < size; ++i) {
                data[i] = (short)(m * (float)i + b);
            }
            if (iMax + off == in2) {
                data[iMax] = (short)out2;
            }
        } else {
            for (int i = 0; i < size; ++i) {
                data[i] = (short)((pval2out[(int)(m * (float)i + b)] & 0xFFFF) >>> pval2outShift);
            }
            if (iMax + off == in2) {
                data[iMax] = (short)((pval2out[out2] & 0xFFFF) >>> pval2outShift);
            }
        }
        return new ShortLookupTable(inBits, signed, off, outBits, data);
    }

    private static LookupTable createSigmoidLut(int inBits, boolean signed, int outBits, float slope, float intercept, float center, float width, boolean inverse, short[] pval2out) {
        int size = 1 << inBits;
        int off = signed ? -size / 2 : 0;
        int outBits1 = pval2out == null ? outBits : LookupTable.inBits(pval2out);
        int outRange = 1 << outBits1;
        int outMax = outRange - 1;
        int pval2outShift = 16 - outBits;
        float ic = (center - intercept) / slope - (float)off;
        float k = -4.0f * slope / width;
        if (outBits <= 8) {
            byte[] data = new byte[size];
            for (int i = 0; i < size; ++i) {
                int tmp = (int)((double)outRange / (1.0 + Math.exp(((float)i - ic) * k)));
                if (inverse) {
                    tmp = outMax - tmp;
                }
                if (pval2out != null) {
                    tmp = (pval2out[tmp] & 0xFFFF) >>> pval2outShift;
                }
                data[i] = (byte)tmp;
            }
            return new ByteLookupTable(inBits, signed, off, outBits, data);
        }
        short[] data = new short[size];
        for (int i = 0; i < size; ++i) {
            int tmp = (int)((double)outRange / (1.0 + Math.exp(((float)i - ic) * k)));
            if (inverse) {
                tmp = outMax - tmp;
            }
            if (pval2out != null) {
                tmp = (pval2out[tmp] & 0xFFFF) >>> pval2outShift;
            }
            data[i] = (short)tmp;
        }
        return new ShortLookupTable(inBits, signed, off, outBits, data);
    }

    public static LookupTable createLut(int inBits, boolean signed, int outBits, DicomObject mLut, float center, float width, String vlutFct, boolean inverse, short[] pval2out) {
        log.debug("Creating MLUT WL c/w=" + center + "/" + width);
        LookupTable mlut = LookupTable.createLut(inBits, signed, mLut);
        if (width == 0.0f) {
            return mlut.scale(outBits, inverse, pval2out);
        }
        LookupTable vlut = LookupTable.createLut(mlut.outBits, false, outBits, 1.0f, 0.0f, center, width, vlutFct, inverse, pval2out);
        return mlut.combine(vlut, outBits, false, null);
    }

    private static LookupTable createLut(int inBits, boolean signed, DicomObject ds) {
        int[] desc = ds.getInts(2633730);
        byte[] data = ds.getBytes(2633734);
        if (desc == null) {
            throw new IllegalArgumentException("Missing LUT Descriptor!");
        }
        if (desc.length != 3) {
            throw new IllegalArgumentException("Illegal number of LUT Descriptor values: " + desc.length);
        }
        if (data == null) {
            throw new IllegalArgumentException("Missing LUT Data!");
        }
        int len = desc[0] == 0 ? 65536 : desc[0];
        int off = desc[1];
        int bits = desc[2];
        if (inBits == 0) {
            off = 0;
            for (int i = len - 1; i != 0; i >>>= 1) {
                ++inBits;
            }
        }
        if (data.length == len) {
            return new ByteLookupTable(inBits, signed, off, bits, data, true);
        }
        if (data.length == len << 1) {
            short[] sdata = ds.bigEndian() ? ByteUtils.bytesBE2shorts((byte[])data) : ByteUtils.bytesLE2shorts((byte[])data);
            bits = 0;
            for (int maxVal = Math.max(sdata[0] & 0xFFFF, sdata[sdata.length - 1] & 0xFFFF); maxVal != 0; maxVal >>>= 1) {
                ++bits;
            }
            ShortLookupTable ret = new ShortLookupTable(inBits, signed, off, bits, sdata, true);
            return ret;
        }
        throw new IllegalArgumentException("LUT Data length: " + data.length + " mismatch entry value: " + len + " in LUT Descriptor");
    }

    public static LookupTable createLut(int inBits, boolean signed, int outBits, float slope, float intercept, DicomObject voiLut, boolean inverse, short[] pval2out) {
        return LookupTable.createLut(inBits, signed, slope, intercept, voiLut).scale(outBits, inverse, pval2out);
    }

    private static LookupTable createLut(int inBits, boolean signed, float slope, float intercept, DicomObject voiLut) {
        log.debug("Creating slope/intercept LUT with V-LUT " + slope + "/" + intercept);
        if (slope == 1.0f) {
            LookupTable lut = LookupTable.createLut(inBits, signed, voiLut);
            lut.off = (int)((float)lut.off - intercept);
            return lut;
        }
        LookupTable vlut = LookupTable.createLut(32, true, voiLut);
        float in1 = ((float)vlut.off - intercept) / slope;
        float in2 = in1 + (float)vlut.length() / slope;
        int off = (int)Math.floor(Math.min(in1, in2));
        int len = (int)Math.ceil(Math.max(in1, in2)) - off;
        short[] data = new short[len];
        for (int i = 0; i < data.length; ++i) {
            data[i] = vlut.lookupShort(Math.round((float)i * slope + intercept));
        }
        return new ShortLookupTable(inBits, signed, off, vlut.outBits, data);
    }

    public static LookupTable createLut(int inBits, boolean signed, int outBits, float slope, float intercept, float center, float width, String vlutFct, DicomObject pLut, boolean inverse, short[] pval2out) {
        log.debug("Creating LUT for slope/intercept=" + slope + "/" + intercept + " center/width=" + center + "/" + width);
        LookupTable plut = LookupTable.createLut(0, false, pLut);
        LookupTable vlut = LookupTable.createLut(inBits, signed, plut.inBits, slope, intercept, center, width, vlutFct, false, null);
        return vlut.combine(plut, outBits, inverse, pval2out);
    }

    public static LookupTable createLut(int inBits, boolean signed, int outBits, DicomObject mLut, DicomObject voiLut, boolean inverse, short[] pval2out) {
        log.debug("Creating a combined m/v LUT, assuming MLUT output is unsigned.");
        LookupTable mlut = LookupTable.createLut(inBits, signed, voiLut);
        LookupTable vlut = LookupTable.createLut(mlut.outBits, false, voiLut);
        return mlut.combine(vlut, outBits, inverse, pval2out);
    }

    public static LookupTable createLut(int inBits, boolean signed, int outBits, float slope, float intercept, DicomObject voiLut, DicomObject pLut, boolean inverse, short[] pval2out) {
        LookupTable vlut = LookupTable.createLut(inBits, signed, slope, intercept, voiLut);
        LookupTable plut = LookupTable.createLut(0, false, pLut);
        return vlut.combine(plut, outBits, inverse, pval2out);
    }

    public static LookupTable createLut(int inBits, boolean signed, int outBits, DicomObject mLut, float center, float width, String vlutFct, DicomObject pLut, boolean inverse, short[] pval2out) {
        LookupTable mlut = LookupTable.createLut(inBits, signed, mLut);
        LookupTable plut = LookupTable.createLut(0, false, pLut);
        if (width == 0.0f) {
            return mlut.combine(plut, outBits, inverse, pval2out);
        }
        LookupTable vlut = LookupTable.createLut(mlut.outBits, false, plut.inBits, 1.0f, 0.0f, center, width, vlutFct, false, null);
        return mlut.combine(vlut, plut, outBits, inverse, pval2out);
    }

    public static LookupTable createLut(int inBits, boolean signed, int outBits, DicomObject mLut, DicomObject voiLut, DicomObject pLut, boolean inverse, short[] pval2out) {
        LookupTable mlut = LookupTable.createLut(inBits, signed, mLut);
        LookupTable vlut = LookupTable.createLut(mlut.outBits, false, voiLut);
        LookupTable plut = LookupTable.createLut(0, false, pLut);
        return mlut.combine(vlut, plut, outBits, inverse, pval2out);
    }

    public static LookupTable createLutForImage(DicomObject img, int outBits, short[] pval2out) {
        return LookupTable.createLutForImageWithPR(img, null, 1, 0.0f, 0.0f, null, outBits, pval2out);
    }

    public static LookupTable createLutFromWL(DicomObject img, DicomObject mLut, float center, float width, String vlutFct, boolean inverse, int outBits, short[] pval2out) {
        int allocated = img.getInt(2621696, 8);
        int stored = img.getInt(2621697, allocated);
        boolean signed = img.getInt(2621699) != 0;
        float slope = mLut.getFloat(2625619, 1.0f);
        float intercept = mLut.getFloat(2625618, 0.0f);
        DicomObject tableMLut = mLut.getNestedDicomObject(2633728);
        if (tableMLut != null) {
            return LookupTable.createLut(stored, signed, outBits, tableMLut, center, width, vlutFct, inverse, pval2out);
        }
        return LookupTable.createLut(stored, signed, outBits, slope, intercept, center, width, vlutFct, inverse, pval2out);
    }

    private static boolean isInverse(DicomObject img) {
        String shape = img.getString(0x20500020);
        return shape != null ? "INVERSE".equals(shape) : "MONOCHROME1".equals(img.getString(2621444));
    }

    public static LookupTable createLutFromVOISequence(DicomObject img, DicomObject mLut, DicomObject voiLut, boolean inverse, int outBits, short[] pval2out) {
        int allocated = img.getInt(2621696, 8);
        int stored = img.getInt(2621697, allocated);
        boolean signed = img.getInt(2621699) != 0;
        float slope = mLut.getFloat(2625619, 1.0f);
        float intercept = mLut.getFloat(2625618, 0.0f);
        DicomObject tableMLut = img.getNestedDicomObject(2633728);
        if (tableMLut != null) {
            return LookupTable.createLut(stored, signed, outBits, tableMLut, voiLut, inverse, pval2out);
        }
        return LookupTable.createLut(stored, signed, outBits, slope, intercept, voiLut, inverse, pval2out);
    }

    public static LookupTable createLutForImageWithPR(DicomObject img, DicomObject pr, int frame, float center, float width, String vlutFct, int outBits, short[] pval2out) {
        DicomObject mlutObj = VOIUtils.selectModalityLUTObject(img, pr, frame);
        DicomObject voiObj = VOIUtils.selectVoiObject(img, pr, frame);
        boolean inverse = pr != null ? "INVERSE".equals(pr.getString(0x20500020)) : LookupTable.isInverse(img);
        DicomObject pLut = pr != null ? pr.getNestedDicomObject(542113808) : null;
        return LookupTable.createLutForImage(img, mlutObj, voiObj, pLut, center, width, vlutFct, inverse, outBits, pval2out);
    }

    public static LookupTable createLutForImage(DicomObject img, DicomObject mlutObj, DicomObject voiObj, DicomObject pLut, float center, float width, String vlutFct, boolean inverse, int outBits, short[] pval2out) {
        DicomObject voiLut;
        int allocated = img.getInt(2621696, 8);
        int stored = img.getInt(2621697, allocated);
        boolean signed = img.getInt(2621699) != 0;
        float slope = mlutObj.getFloat(2625619, 1.0f);
        float intercept = mlutObj.getFloat(2625618, 0.0f);
        DicomObject mLut = mlutObj.getNestedDicomObject(2633728);
        DicomObject dicomObject = voiLut = voiObj != null && vlutFct == null ? voiObj.getNestedDicomObject(2633744) : null;
        if (voiLut == null && width == 0.0f && voiObj != null) {
            vlutFct = voiObj.getString(2625622);
            center = voiObj.getFloat(2625616, 0.0f);
            width = voiObj.getFloat(2625617, 0.0f);
        }
        if (mLut == null) {
            if (voiLut == null) {
                if (pLut == null) {
                    return LookupTable.createLut(stored, signed, outBits, slope, intercept, center, width, vlutFct, inverse, pval2out);
                }
                return LookupTable.createLut(stored, signed, outBits, slope, intercept, center, width, vlutFct, pLut, false, pval2out);
            }
            if (pLut == null) {
                return LookupTable.createLut(stored, signed, outBits, slope, intercept, voiLut, inverse, pval2out);
            }
            return LookupTable.createLut(stored, signed, outBits, slope, intercept, voiLut, pLut, false, pval2out);
        }
        if (voiLut == null) {
            if (pLut == null) {
                return LookupTable.createLut(stored, signed, outBits, mLut, center, width, vlutFct, inverse, pval2out);
            }
            return LookupTable.createLut(stored, signed, outBits, mLut, center, width, vlutFct, pLut, false, pval2out);
        }
        if (pLut == null) {
            return LookupTable.createLut(stored, signed, outBits, mLut, voiLut, inverse, pval2out);
        }
        return LookupTable.createLut(stored, signed, outBits, mLut, voiLut, pLut, false, pval2out);
    }
}

