/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.AccumulateMonitor;
import com.jamonapi.AccumulateMonitorInterface;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;

public class LastAccessMonitor
extends AccumulateMonitor {
    private static final String FIRSTACCESS = "First access";
    private static final String LASTACCESS = "Last access";
    private boolean isFirstAccess = true;
    private long firstAccessTime;

    public LastAccessMonitor() {
    }

    public LastAccessMonitor(AccumulateMonitorInterface childMonitor) {
        super(childMonitor);
    }

    protected synchronized void getDataThis(ArrayList rowData) {
        rowData.add(this.getDateString(this.firstAccessTime));
        rowData.add(this.getDateString(this.accrued));
    }

    private String getDateString(long time) {
        if (time == 0L) {
            return "";
        }
        return DateFormat.getDateTimeInstance(3, 2).format(new Date(time));
    }

    protected void getHeaderThis(ArrayList header) {
        header.add(FIRSTACCESS);
        header.add(LASTACCESS);
    }

    protected synchronized void increaseThis(long increaseValue) {
        this.accrued = System.currentTimeMillis();
    }

    public static void main(String[] args) throws Exception {
        LastAccessMonitor m = new LastAccessMonitor();
        m.start();
        System.out.println("current time=" + m);
        Thread.sleep(2000L);
        m.increase(1L);
        System.out.println("above time plus about 2 seconds=" + m);
    }

    protected synchronized void resetThis(long increaseValue) {
        this.firstAccessTime = System.currentTimeMillis();
        this.accrued = System.currentTimeMillis();
    }

    protected void startThis() {
        if (this.isFirstAccess) {
            this.isFirstAccess = false;
            this.firstAccessTime = System.currentTimeMillis();
        }
    }

    protected synchronized String toStringThis() {
        return String.valueOf(this.getDisplayString(FIRSTACCESS, this.getDateString(this.firstAccessTime), "")) + this.getDisplayString(LASTACCESS, this.getDateString(this.accrued), "");
    }
}

