/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.AccumulateMonitor;
import com.jamonapi.AccumulateMonitorInterface;
import com.jamonapi.Counter;
import java.util.ArrayList;

public class TimeStatsDistMonitor
extends AccumulateMonitor {
    private static Counter allActive = new Counter();
    private static Counter primaryActive = new Counter();
    private static boolean enableNegatives = false;
    private int active = 0;
    private static final int iNEGATIVE = 0;
    private static final int i10 = 1;
    private static final int i20 = 2;
    private static final int i40 = 3;
    private static final int i80 = 4;
    private static final int i160 = 5;
    private static final int i320 = 6;
    private static final int i640 = 7;
    private static final int i1280 = 8;
    private static final int i2560 = 9;
    private static final int i5120 = 10;
    private static final int i10240 = 11;
    private static final int i20480 = 12;
    private static final int iLAST_GROUP = 13;
    private static final int DIST_SIZE = 14;
    private FrequencyDist[] dist;

    public TimeStatsDistMonitor() {
        this.populateDist();
    }

    public TimeStatsDistMonitor(AccumulateMonitorInterface childMonitor) {
        super(childMonitor);
        this.populateDist();
    }

    private void distribution(long value) {
        this.getDist(value).increment(value);
    }

    protected synchronized void getDataThis(ArrayList rowData) {
        rowData.add(this.isPrimary() ? "Yes" : "&nbsp");
        int i = 0;
        while (i < 14) {
            if (i != 0 || enableNegatives) {
                rowData.add(this.dist[i].toString());
            }
            ++i;
        }
    }

    private FrequencyDist getDist(long value) {
        if (value < 0L) {
            return this.dist[0];
        }
        if (value <= 10L) {
            return this.dist[1];
        }
        if (value <= 20L) {
            return this.dist[2];
        }
        if (value <= 40L) {
            return this.dist[3];
        }
        if (value <= 80L) {
            return this.dist[4];
        }
        if (value <= 160L) {
            return this.dist[5];
        }
        if (value <= 320L) {
            return this.dist[6];
        }
        if (value <= 640L) {
            return this.dist[7];
        }
        if (value <= 1280L) {
            return this.dist[8];
        }
        if (value <= 2560L) {
            return this.dist[9];
        }
        if (value <= 5120L) {
            return this.dist[10];
        }
        if (value <= 10240L) {
            return this.dist[11];
        }
        if (value <= 20480L) {
            return this.dist[12];
        }
        return this.dist[13];
    }

    protected void getHeaderThis(ArrayList header) {
        String SUFFIX = "ms.";
        header.add("Primary");
        if (enableNegatives) {
            header.add("Negative ms.");
        }
        header.add("0-10ms.");
        header.add("11-20ms.");
        header.add("21-40ms.");
        header.add("41-80ms.");
        header.add("81-160ms.");
        header.add("161-320ms.");
        header.add("321-640ms.");
        header.add("641-1280ms.");
        header.add("1281-2560ms.");
        header.add("2561-5120ms.");
        header.add("5121-10240ms.");
        header.add("10241-20480ms.");
        header.add(">20480ms.");
    }

    protected synchronized void increaseThis(long value) {
        this.distribution(value);
    }

    public static void main(String[] args) throws Exception {
        TimeStatsDistMonitor mon = new TimeStatsDistMonitor();
        TimeStatsDistMonitor.setEnableNegatives(true);
        System.out.println("The first entry indicates whether the monitor is primary or not.");
        System.out.println("After that there should be 1 entry for each distribution range");
        System.out.println("All entries should have 5/low value of range/3");
        mon.start();
        mon.start();
        mon.start();
        int i = 1;
        while (i <= 5) {
            mon.increase(-100L);
            mon.increase(0L);
            mon.increase(20L);
            mon.increase(40L);
            mon.increase(80L);
            mon.increase(160L);
            mon.increase(320L);
            mon.increase(640L);
            mon.increase(1280L);
            mon.increase(2560L);
            mon.increase(5120L);
            mon.increase(10240L);
            mon.increase(20480L);
            mon.increase(50000L);
            ++i;
        }
        mon.stop();
        mon.stop();
        mon.stop();
        ArrayList rowData = new ArrayList();
        mon.getData(rowData);
        int i2 = 0;
        while (i2 < rowData.size()) {
            System.out.println("distribution index " + i2 + "=" + rowData.get(i2));
            ++i2;
        }
    }

    private void populateDist() {
        this.dist = new FrequencyDist[14];
        int i = 0;
        while (i < 14) {
            this.dist[i] = new FrequencyDist();
            ++i;
        }
    }

    protected synchronized void resetThis() {
        this.populateDist();
    }

    public static void setEnableNegatives(boolean enableNegatives) {
        TimeStatsDistMonitor.enableNegatives = enableNegatives;
    }

    protected synchronized void startThis() {
        allActive.increment();
        if (this.isPrimary()) {
            primaryActive.increment();
        }
        ++this.active;
    }

    protected synchronized void stopThis() {
        if (this.active > 0) {
            --this.active;
        }
        if (this.isPrimary()) {
            primaryActive.decrement();
        }
        allActive.decrement();
    }

    protected synchronized String toStringThis() {
        return "";
    }

    final class FrequencyDist {
        private int hits;
        private long totalTime;
        private long allActiveTotal;
        private long primaryActiveTotal;
        private int activeTotal;

        FrequencyDist() {
        }

        private float avgActive() {
            if (this.hits == 0) {
                return 0.0f;
            }
            return (float)this.activeTotal / (float)this.hits;
        }

        private float avgPrimaryActive() {
            if (this.hits == 0) {
                return 0.0f;
            }
            return (float)this.primaryActiveTotal / (float)this.hits;
        }

        private long avgTime() {
            if (this.hits == 0) {
                return 0L;
            }
            return this.totalTime / (long)this.hits;
        }

        private float avgTotalActive() {
            if (this.hits == 0) {
                return 0.0f;
            }
            return (float)this.allActiveTotal / (float)this.hits;
        }

        private void increment(long value) {
            ++this.hits;
            this.totalTime += value;
            this.allActiveTotal += (long)allActive.count;
            this.primaryActiveTotal += (long)primaryActive.count;
            this.activeTotal += TimeStatsDistMonitor.this.active;
        }

        public String toString() {
            String SPACE = "&nbsp";
            if (this.hits == 0) {
                return "&nbsp";
            }
            return String.valueOf(AccumulateMonitor.convertToString(this.hits)) + "/" + AccumulateMonitor.convertToString(this.avgTime()) + "&nbsp" + "(" + AccumulateMonitor.convertToString(this.avgActive()) + "/" + AccumulateMonitor.convertToString(this.avgPrimaryActive()) + "/" + AccumulateMonitor.convertToString(this.avgTotalActive()) + ")";
        }
    }
}

