/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.utils;

import java.util.Arrays;

class ArraySorter {
    private Object[][] array;
    private int sortCol;
    private String sortOrder;
    private static final Float zero = new Float(0.0f);

    public ArraySorter(Object[][] array, int sortCol, String sortOrder) {
        this.array = array;
        this.sortCol = sortCol;
        this.sortOrder = sortOrder;
    }

    private static void display(Object[][] array) {
        int rows = array.length;
        int cols = array[0].length;
        int i = 0;
        while (i < rows) {
            String rowData = "";
            int j = 0;
            while (j < cols) {
                rowData = String.valueOf(rowData) + array[i][j] + " ";
                ++j;
            }
            System.out.println(rowData);
            ++i;
        }
    }

    private ArraySorterEntry[] getArraySorterEntries() {
        Object[] arrayToSort = this.getArrayToSort();
        ArraySorterEntry[] arraySorterEntries = new ArraySorterEntry[this.getRows()];
        int i = 0;
        while (i < this.getRows()) {
            arraySorterEntries[i] = new ArraySorterEntry(arrayToSort[i], (Comparable)this.array[i][this.sortCol]);
            ++i;
        }
        return arraySorterEntries;
    }

    private Object[] getArrayToSort() {
        Object[] arrayToSort = new Object[this.getRows()];
        int i = 0;
        while (i < this.getRows()) {
            arrayToSort[i] = this.array[i];
            ++i;
        }
        return arrayToSort;
    }

    private int getCols() {
        return this.array[0].length;
    }

    private int getRows() {
        return this.array.length;
    }

    public static void main(String[] args) throws Exception {
        Object[][] array = new Object[][]{{"7", "8", "9"}, {"1", "2", "3"}, {"4", "5", "6"}};
        System.out.println("unsorted array");
        ArraySorter.display(array);
        System.out.println("sorted array: asc on col 0");
        ArraySorter sorter = new ArraySorter(array, 0, "asc");
        ArraySorter.display(sorter.sort());
        System.out.println("sorted array: desc on col 0");
        sorter = new ArraySorter(array, 0, "desc");
        ArraySorter.display(sorter.sort());
        System.out.println("sorted array invalid - RuntimeException will be thrown");
        sorter = new ArraySorter(array, 0, "invalid");
        ArraySorter.display(sorter.sort());
    }

    public Object[][] sort() {
        Object[] arraySorterEntries = this.getArraySorterEntries();
        Arrays.sort(arraySorterEntries);
        Object[][] returnArray = new Object[this.getRows()][this.getCols()];
        int i = 0;
        while (i < this.getRows()) {
            returnArray[i] = (Object[])((ArraySorterEntry)arraySorterEntries[i]).getSortedObject();
            ++i;
        }
        return returnArray;
    }

    private class ArraySorterEntry
    implements Comparable {
        private Object arrayValueToSort;
        private Comparable valueToSortBy;

        public ArraySorterEntry(Object arrayValueToSort, Comparable valueToSortBy) {
            this.arrayValueToSort = arrayValueToSort;
            this.valueToSortBy = this.convert((String)((Object)valueToSortBy));
        }

        public int compareTo(Object o) {
            ArraySorterEntry sorter = (ArraySorterEntry)o;
            int compare = this.valueToSortBy.compareTo(sorter.valueToSortBy);
            if (compare == 0 || "asc".equalsIgnoreCase(ArraySorter.this.sortOrder)) {
                return compare;
            }
            if ("desc".equalsIgnoreCase(ArraySorter.this.sortOrder)) {
                return -compare;
            }
            throw new RuntimeException("Programming error: The only valid sort orders are 'asc' and 'desc', but '" + ArraySorter.this.sortOrder + "' was passed");
        }

        private Comparable convert(String sortByStr) {
            if (ArraySorter.this.sortCol >= 1 && ArraySorter.this.sortCol <= 9) {
                return Float.valueOf(sortByStr.replace(',', '0'));
            }
            if (ArraySorter.this.sortCol >= 13) {
                int index = sortByStr.indexOf("/");
                if (index == -1) {
                    return zero;
                }
                return Float.valueOf(sortByStr.substring(0, index).replace(',', '0'));
            }
            return sortByStr;
        }

        public Object getSortedObject() {
            return this.arrayValueToSort;
        }
    }
}

