/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.utils;

import com.jamonapi.utils.CompositeNode;
import com.jamonapi.utils.LeafNode;
import java.util.StringTokenizer;

public class NodeTree {
    private CompositeNode compositeNodeFactory;
    private final boolean NODE_EXISTS = true;
    private final boolean NODE_NO_EXISTS = false;

    public NodeTree(CompositeNode compositeNodeFactory) {
        this.compositeNodeFactory = compositeNodeFactory;
    }

    public boolean compositeNodeExists(String locator) {
        StringTokenizer st = this.getStringTokenizer(locator);
        CompositeNode currentNode = this.getRootNode();
        while (st.hasMoreTokens()) {
            String nodeName = st.nextToken();
            if (currentNode.compositeNodeExists(nodeName)) {
                currentNode = currentNode.getCompositeNode(nodeName);
                continue;
            }
            return false;
        }
        return true;
    }

    public CompositeNode getCompositeNode(String locator) {
        StringTokenizer st = this.getStringTokenizer(locator);
        CompositeNode currentNode = this.getRootNode();
        while (st.hasMoreTokens()) {
            CompositeNode previousNode = currentNode;
            String nodeName = st.nextToken();
            currentNode = previousNode.getCompositeNode(nodeName);
            previousNode.addCompositeNode(nodeName, currentNode);
        }
        return currentNode;
    }

    private String getDelimiter(String locator) {
        int i = 0;
        while (i < locator.length()) {
            if (this.isTokenDelimiter(locator.charAt(i))) {
                return String.valueOf(locator.charAt(i));
            }
            ++i;
        }
        return "";
    }

    public LeafNode getLeafNode(String locator, String type) {
        String nodeName;
        StringTokenizer st = this.getStringTokenizer(locator);
        int lastToken = st.countTokens() - 1;
        CompositeNode currentNode = this.getRootNode();
        int i = 0;
        while (i < lastToken) {
            CompositeNode previousNode = currentNode;
            nodeName = st.nextToken();
            currentNode = previousNode.getCompositeNode(nodeName);
            previousNode.addCompositeNode(nodeName, currentNode);
            ++i;
        }
        nodeName = st.nextToken();
        LeafNode leafNode = currentNode.getLeafNode(nodeName, type);
        currentNode.addLeafNode(nodeName, leafNode);
        return leafNode;
    }

    public CompositeNode getRootNode() {
        return this.compositeNodeFactory.getRootNode();
    }

    private StringTokenizer getStringTokenizer(String locator) {
        return new StringTokenizer(locator, this.getDelimiter(locator));
    }

    private boolean isTokenDelimiter(char ch) {
        return (Character.isLetterOrDigit(ch) || Character.isWhitespace(ch)) ^ true;
    }

    public boolean leafNodeExists(String locator) {
        String nodeName;
        StringTokenizer st = this.getStringTokenizer(locator);
        int lastToken = st.countTokens() - 1;
        CompositeNode currentNode = this.getRootNode();
        int i = 0;
        while (i < lastToken) {
            nodeName = st.nextToken();
            if (!currentNode.compositeNodeExists(nodeName)) {
                return false;
            }
            currentNode = currentNode.getCompositeNode(nodeName);
            ++i;
        }
        nodeName = st.nextToken();
        return currentNode.leafNodeExists(nodeName);
    }

    public boolean nodeExists(String locator) {
        return this.compositeNodeExists(locator) || this.leafNodeExists(locator);
    }
}

