/*
 * Decompiled with CFR 0.152.
 */
package clinical.server.dao.oracle;

import clinical.server.vo.ScanParams;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ScanParamsDAO
implements clinical.server.dao.ScanParamsDAO {
    @Override
    public void insert(Connection con, ScanParams bean) throws Exception {
        PreparedStatement ps = null;
        StringBuffer buf = new StringBuffer(200);
        if (bean == null) {
            return;
        }
        try {
            buf.append("INSERT INTO nc_scan_params VALUES ");
            buf.append('(');
            int i = 0;
            while (i < 10) {
                buf.append('?');
                if (i < 9) {
                    buf.append(',');
                }
                ++i;
            }
            buf.append(")");
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            ps.setObject(1, (Object)bean.getUniqueid(), 2);
            ps.setObject(2, (Object)bean.getTableid(), 2);
            ps.setObject(3, (Object)bean.getSegmentid(), 2);
            ps.setObject(4, (Object)bean.getComponentid(), 2);
            ps.setObject(5, (Object)bean.getExperimentid(), 2);
            ps.setObject(6, (Object)bean.getSubjectid(), 12);
            ps.setObject(7, (Object)bean.getStoredtupleId(), 2);
            ps.setObject(8, (Object)bean.getOwner(), 2);
            ps.setObject(9, bean.getModTime() == null ? null : new Timestamp(bean.getModTime().getTime()));
            ps.setObject(10, (Object)bean.getModUser(), 2);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.close(ps);
            throw throwable;
        }
        DBUtils.close(ps);
    }

    protected String prepareColList(ScanParams bean) {
        StringBuffer buf = new StringBuffer(200);
        buf.append("uniqueid");
        buf.append(',');
        buf.append("tableid");
        buf.append(',');
        buf.append("segmentid");
        buf.append(',');
        buf.append("componentid");
        buf.append(',');
        buf.append("experimentid");
        buf.append(',');
        buf.append("subjectid");
        buf.append(',');
        buf.append("storedtuple_id");
        buf.append(',');
        buf.append("owner");
        buf.append(',');
        buf.append("mod_time");
        buf.append(',');
        buf.append("mod_user");
        buf.append(' ');
        return buf.toString();
    }

    protected QueryInfo prepareWhereClause(ScanParams bean) {
        StringBuffer buf = new StringBuffer(200);
        QueryInfo qi = new QueryInfo();
        boolean valueSet = false;
        buf.append("WHERE ");
        if (bean.getUniqueid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("uniqueid=?");
            qi.values.add(bean.getUniqueid());
            valueSet = true;
        }
        if (bean.getTableid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("tableid=?");
            qi.values.add(bean.getTableid());
            valueSet = true;
        }
        if (bean.getSegmentid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("segmentid=?");
            qi.values.add(bean.getSegmentid());
            valueSet = true;
        }
        if (bean.getComponentid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("componentid=?");
            qi.values.add(bean.getComponentid());
            valueSet = true;
        }
        if (bean.getExperimentid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("experimentid=?");
            qi.values.add(bean.getExperimentid());
            valueSet = true;
        }
        if (bean.getSubjectid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("subjectid=?");
            qi.values.add(bean.getSubjectid());
            valueSet = true;
        }
        if (bean.getStoredtupleId() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("storedtuple_id=?");
            qi.values.add(bean.getStoredtupleId());
            valueSet = true;
        }
        if (bean.getOwner() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("owner=?");
            qi.values.add(bean.getOwner());
            valueSet = true;
        }
        if (bean.getModTime() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("mod_time=?");
            qi.values.add(new Date(bean.getModTime().getTime()));
            valueSet = true;
        }
        if (bean.getModUser() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("mod_user=?");
            qi.values.add(bean.getModUser());
            valueSet = true;
        }
        qi.whereClause = !valueSet ? "" : buf.toString();
        return qi;
    }

    protected UpdateQueryInfo prepareUpdateQuery(ScanParams bean, ScanParams criteria) throws ValidationException {
        StringBuffer buf = new StringBuffer(200);
        UpdateQueryInfo uqi = new UpdateQueryInfo();
        boolean valueSet = false;
        buf.append("UPDATE nc_scan_params SET ");
        if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("uniqueid=? ");
            uqi.setValues.add(bean.getUniqueid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
            valueSet = true;
        }
        if (bean.getTableid() != null || bean.isNull("tableid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("tableid=? ");
            uqi.setValues.add(bean.getTableid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("tableid"), uqi);
            valueSet = true;
        }
        if (bean.getSegmentid() != null || bean.isNull("segmentid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("segmentid=? ");
            uqi.setValues.add(bean.getSegmentid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("segmentid"), uqi);
            valueSet = true;
        }
        if (bean.getComponentid() != null || bean.isNull("componentid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("componentid=? ");
            uqi.setValues.add(bean.getComponentid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("componentid"), uqi);
            valueSet = true;
        }
        if (bean.getExperimentid() != null || bean.isNull("experimentid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("experimentid=? ");
            uqi.setValues.add(bean.getExperimentid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("experimentid"), uqi);
            valueSet = true;
        }
        if (bean.getSubjectid() != null || bean.isNull("subjectid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("subjectid=? ");
            uqi.setValues.add(bean.getSubjectid());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("subjectid"), uqi);
            valueSet = true;
        }
        if (bean.getStoredtupleId() != null || bean.isNull("storedtupleId")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("storedtuple_id=? ");
            uqi.setValues.add(bean.getStoredtupleId());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("storedtupleId"), uqi);
            valueSet = true;
        }
        if (bean.getOwner() != null || bean.isNull("owner")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("owner=? ");
            uqi.setValues.add(bean.getOwner());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("owner"), uqi);
            valueSet = true;
        }
        if (bean.getModTime() != null || bean.isNull("modTime")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("mod_time=? ");
            uqi.setValues.add(new Timestamp(bean.getModTime().getTime()));
            uqi.sqlTypes.add(new Integer(93));
            this.prepareNullSetListValue(bean.isNull("modTime"), uqi);
            valueSet = true;
        }
        if (bean.getModUser() != null || bean.isNull("modUser")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("mod_user=? ");
            uqi.setValues.add(bean.getModUser());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("modUser"), uqi);
            valueSet = true;
        }
        if (!valueSet) {
            throw new ValidationException("At least one field needs to be set for update!");
        }
        uqi.query = buf.toString();
        QueryInfo qi = this.prepareWhereClause(criteria);
        uqi.query = String.valueOf(uqi.query) + qi.whereClause;
        uqi.whereValues = qi.values;
        return uqi;
    }

    protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
        if (wasNull) {
            uqi.nullSetList.add(new Boolean(true));
        } else {
            uqi.nullSetList.add(new Boolean(false));
        }
    }

    public ScanParams createObject(ResultSet rs) throws SQLException {
        ScanParams obj = new ScanParams();
        obj.setUniqueid(rs.getObject(1) != null ? new BigDecimal(rs.getObject(1).toString()) : null);
        obj.setTableid(rs.getObject(2) != null ? new BigDecimal(rs.getObject(2).toString()) : null);
        obj.setSegmentid(rs.getObject(3) != null ? new BigDecimal(rs.getObject(3).toString()) : null);
        obj.setComponentid(rs.getObject(4) != null ? new BigDecimal(rs.getObject(4).toString()) : null);
        obj.setExperimentid(rs.getObject(5) != null ? new BigDecimal(rs.getObject(5).toString()) : null);
        obj.setSubjectid((String)rs.getObject(6));
        obj.setStoredtupleId(rs.getObject(7) != null ? new BigDecimal(rs.getObject(7).toString()) : null);
        obj.setOwner(rs.getObject(8) != null ? new BigDecimal(rs.getObject(8).toString()) : null);
        obj.setModTime(rs.getObject(9) != null ? new java.util.Date(((Timestamp)rs.getObject(9)).getTime()) : null);
        obj.setModUser(rs.getObject(10) != null ? new BigDecimal(rs.getObject(10).toString()) : null);
        return obj;
    }

    @Override
    public List<ScanParams> find(Connection con, ScanParams criteria) throws Exception {
        PreparedStatement ps = null;
        ResultSet rs = null;
        LinkedList<ScanParams> results = new LinkedList<ScanParams>();
        StringBuffer buf = new StringBuffer(200);
        if (criteria == null) {
            return null;
        }
        buf.append("SELECT ");
        buf.append(this.prepareColList(criteria));
        buf.append(" FROM nc_scan_params ");
        QueryInfo qi = this.prepareWhereClause(criteria);
        buf.append(qi.whereClause);
        try {
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            int i = 0;
            Iterator<? super Object> it = qi.values.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                ScanParams item = this.createObject(rs);
                results.add(item);
            }
        }
        catch (Throwable throwable) {
            DBUtils.close(ps, rs);
            throw throwable;
        }
        DBUtils.close(ps, rs);
        return results;
    }

    @Override
    public void update(Connection con, ScanParams bean, ScanParams criteria) throws Exception {
        PreparedStatement ps = null;
        if (bean == null) {
            return;
        }
        UpdateQueryInfo uqi = this.prepareUpdateQuery(bean, criteria);
        try {
            ps = con.prepareStatement(uqi.query);
            ps.clearParameters();
            int i = 0;
            Iterator<Integer> it2 = uqi.sqlTypes.iterator();
            Iterator<Boolean> it3 = uqi.nullSetList.iterator();
            for (Object object : uqi.setValues) {
                Integer sqlType = it2.next();
                boolean nullSet = it3.next();
                if (nullSet) {
                    ps.setNull(++i, sqlType);
                    continue;
                }
                ps.setObject(++i, object);
            }
            Iterator<? super Object> it = uqi.whereValues.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.close(ps);
            throw throwable;
        }
        DBUtils.close(ps);
    }

    @Override
    public void delete(Connection con, ScanParams criteria) throws Exception {
        PreparedStatement ps = null;
        StringBuffer buf = new StringBuffer(200);
        buf.append("DELETE FROM nc_scan_params ");
        QueryInfo qi = this.prepareWhereClause(criteria);
        buf.append(qi.whereClause);
        try {
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            int i = 0;
            Iterator<? super Object> it = qi.values.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.close(ps);
            throw throwable;
        }
        DBUtils.close(ps);
    }

    public static class QueryInfo {
        String whereClause;
        List<? super Object> values = new LinkedList<Object>();

        public QueryInfo() {
        }

        public QueryInfo(String whereClause) {
            this.whereClause = whereClause;
        }
    }

    public static class UpdateQueryInfo {
        String query;
        List<? super Object> setValues = new LinkedList<Object>();
        List<Integer> sqlTypes = new LinkedList<Integer>();
        List<Boolean> nullSetList = new LinkedList<Boolean>();
        List<? super Object> whereValues = new LinkedList<Object>();
    }
}

