/*
 * Decompiled with CFR 0.152.
 */
package clinical.server.dao.oracle;

import clinical.server.utils.OracleUtils;
import clinical.server.vo.Schemaversion;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.sql.CLOB;

public class SchemaversionDAO
implements clinical.server.dao.SchemaversionDAO {
    @Override
    public void insert(Connection con, Schemaversion bean) throws Exception {
        Statement ps = null;
        StringBuffer buf = new StringBuffer(200);
        if (bean == null) {
            return;
        }
        try {
            buf.append("INSERT INTO NC_SCHEMAVERSION ");
            buf.append(" (MAJORVERSION,MINORVERSION,UPDATEVERSION,UPDATEFINISHED,UNIQUEID,TABLEID,OWNER,MODTIME,MODUSER,RELEASEDATE,DESCRIPTION) ");
            buf.append("VALUES ");
            buf.append('(');
            int i = 0;
            while (i < 11) {
                buf.append('?');
                if (i < 10) {
                    buf.append(',');
                }
                ++i;
            }
            buf.append(")");
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            ps.setObject(1, bean.getMajorversion(), 2);
            ps.setObject(2, bean.getMinorversion(), 2);
            ps.setObject(3, bean.getUpdateversion(), 2);
            ps.setObject(4, this.boolean2Number(bean.getUpdatefinished()), 2);
            ps.setObject(5, bean.getUniqueid(), 2);
            ps.setObject(6, bean.getTableid(), 2);
            ps.setObject(7, bean.getOwner(), 2);
            ps.setTimestamp(8, bean.getModtime() == null ? null : new Timestamp(bean.getModtime().getTime()));
            ps.setObject(9, bean.getModuser(), 2);
            ps.setTimestamp(10, bean.getReleasedate() == null ? null : new Timestamp(bean.getReleasedate().getTime()));
            ps.setObject(11, OracleUtils.getCLOB(con, bean.getDescription()), 2005);
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected String prepareColList(Schemaversion bean) {
        StringBuffer buf = new StringBuffer(200);
        buf.append("MAJORVERSION");
        buf.append(',');
        buf.append("MINORVERSION");
        buf.append(',');
        buf.append("UPDATEVERSION");
        buf.append(',');
        buf.append("UPDATEFINISHED");
        buf.append(',');
        buf.append("UNIQUEID");
        buf.append(',');
        buf.append("TABLEID");
        buf.append(',');
        buf.append("OWNER");
        buf.append(',');
        buf.append("MODTIME");
        buf.append(',');
        buf.append("MODUSER");
        buf.append(',');
        buf.append("RELEASEDATE");
        buf.append(',');
        buf.append("DESCRIPTION");
        buf.append(' ');
        return buf.toString();
    }

    protected QueryInfo prepareWhereClause(Schemaversion bean) {
        StringBuffer buf = new StringBuffer(200);
        QueryInfo qi = new QueryInfo();
        boolean valueSet = false;
        buf.append("WHERE ");
        if (bean.getMajorversion() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("MAJORVERSION=?");
            qi.values.add(bean.getMajorversion());
            valueSet = true;
        }
        if (bean.getMinorversion() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("MINORVERSION=?");
            qi.values.add(bean.getMinorversion());
            valueSet = true;
        }
        if (bean.getUpdateversion() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("UPDATEVERSION=?");
            qi.values.add(bean.getUpdateversion());
            valueSet = true;
        }
        if (bean.getUpdatefinished() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("UPDATEFINISHED=?");
            qi.values.add(this.boolean2Number(bean.getUpdatefinished()));
            valueSet = true;
        }
        if (bean.getUniqueid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("UNIQUEID=?");
            qi.values.add(bean.getUniqueid());
            valueSet = true;
        }
        if (bean.getTableid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("TABLEID=?");
            qi.values.add(bean.getTableid());
            valueSet = true;
        }
        if (bean.getOwner() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("OWNER=?");
            qi.values.add(bean.getOwner());
            valueSet = true;
        }
        if (bean.getModtime() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("MODTIME=?");
            qi.values.add(new Timestamp(bean.getModtime().getTime()));
            valueSet = true;
        }
        if (bean.getModuser() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("MODUSER=?");
            qi.values.add(bean.getModuser());
            valueSet = true;
        }
        if (bean.getReleasedate() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("RELEASEDATE=?");
            qi.values.add(new Timestamp(bean.getReleasedate().getTime()));
            valueSet = true;
        }
        if (bean.getDescription() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("DESCRIPTION=?");
            qi.values.add(bean.getDescription());
            valueSet = true;
        }
        qi.whereClause = !valueSet ? "" : buf.toString();
        return qi;
    }

    protected UpdateQueryInfo prepareUpdateQuery(Schemaversion bean, Schemaversion criteria) throws ValidationException {
        StringBuffer buf = new StringBuffer(200);
        UpdateQueryInfo uqi = new UpdateQueryInfo();
        boolean valueSet = false;
        buf.append("UPDATE NC_SCHEMAVERSION SET ");
        if (bean.getMajorversion() != null || bean.isNull("majorversion")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("MAJORVERSION=? ");
            uqi.setValues.add(bean.getMajorversion());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("majorversion"), uqi);
            valueSet = true;
        }
        if (bean.getMinorversion() != null || bean.isNull("minorversion")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("MINORVERSION=? ");
            uqi.setValues.add(bean.getMinorversion());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("minorversion"), uqi);
            valueSet = true;
        }
        if (bean.getUpdateversion() != null || bean.isNull("updateversion")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("UPDATEVERSION=? ");
            uqi.setValues.add(bean.getUpdateversion());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("updateversion"), uqi);
            valueSet = true;
        }
        if (bean.getUpdatefinished() != null || bean.isNull("updatefinished")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("UPDATEFINISHED=? ");
            uqi.setValues.add(this.boolean2Number(bean.getUpdatefinished()));
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("updatefinished"), uqi);
            valueSet = true;
        }
        if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("UNIQUEID=? ");
            uqi.setValues.add(bean.getUniqueid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
            valueSet = true;
        }
        if (bean.getTableid() != null || bean.isNull("tableid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("TABLEID=? ");
            uqi.setValues.add(bean.getTableid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("tableid"), uqi);
            valueSet = true;
        }
        if (bean.getOwner() != null || bean.isNull("owner")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("OWNER=? ");
            uqi.setValues.add(bean.getOwner());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("owner"), uqi);
            valueSet = true;
        }
        if (bean.getModtime() != null || bean.isNull("modtime")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("MODTIME=? ");
            uqi.setValues.add(new Timestamp(bean.getModtime().getTime()));
            uqi.sqlTypes.add(new Integer(91));
            this.prepareNullSetListValue(bean.isNull("modtime"), uqi);
            valueSet = true;
        }
        if (bean.getModuser() != null || bean.isNull("moduser")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("MODUSER=? ");
            uqi.setValues.add(bean.getModuser());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("moduser"), uqi);
            valueSet = true;
        }
        if (bean.getReleasedate() != null || bean.isNull("releasedate")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("RELEASEDATE=? ");
            uqi.setValues.add(new Timestamp(bean.getReleasedate().getTime()));
            uqi.sqlTypes.add(new Integer(91));
            this.prepareNullSetListValue(bean.isNull("releasedate"), uqi);
            valueSet = true;
        }
        if (bean.getDescription() != null || bean.isNull("description")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("DESCRIPTION=? ");
            uqi.setValues.add(bean.getDescription());
            uqi.sqlTypes.add(new Integer(2005));
            this.prepareNullSetListValue(bean.isNull("description"), uqi);
            valueSet = true;
        }
        if (!valueSet) {
            throw new ValidationException("At least one field needs to be set for update!");
        }
        uqi.query = buf.toString();
        QueryInfo qi = this.prepareWhereClause(criteria);
        uqi.query = String.valueOf(uqi.query) + qi.whereClause;
        uqi.whereValues = qi.values;
        return uqi;
    }

    protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
        if (wasNull) {
            uqi.nullSetList.add(new Boolean(true));
        } else {
            uqi.nullSetList.add(new Boolean(false));
        }
    }

    protected Boolean convert2Boolean(Object columnValue) {
        if (columnValue == null) {
            return null;
        }
        return ((BigDecimal)columnValue).intValue() > 0 ? new Boolean(true) : new Boolean(false);
    }

    protected BigDecimal boolean2Number(Boolean value) {
        if (value == null) {
            return null;
        }
        return value != false ? new BigDecimal("1") : new BigDecimal("0");
    }

    protected String boolean2YN(Boolean value) {
        if (value == null) {
            return null;
        }
        return value != false ? "Y" : "N";
    }

    public Schemaversion createObject(ResultSet rs) throws SQLException {
        Schemaversion obj = new Schemaversion();
        obj.setMajorversion((BigDecimal)rs.getObject(1));
        obj.setMinorversion((BigDecimal)rs.getObject(2));
        obj.setUpdateversion((BigDecimal)rs.getObject(3));
        obj.setUpdatefinished(this.convert2Boolean(rs.getObject(4)));
        obj.setUniqueid((BigDecimal)rs.getObject(5));
        obj.setTableid((BigDecimal)rs.getObject(6));
        obj.setOwner((BigDecimal)rs.getObject(7));
        if (rs.getTimestamp(8) != null) {
            obj.setModtime(new Date(rs.getTimestamp(8).getTime()));
        }
        obj.setModuser((BigDecimal)rs.getObject(9));
        if (rs.getTimestamp(10) != null) {
            obj.setReleasedate(new Date(rs.getTimestamp(10).getTime()));
        }
        obj.setDescription(OracleUtils.readCLOB((CLOB)rs.getObject(11)));
        return obj;
    }

    @Override
    public List<Schemaversion> find(Connection con, Schemaversion criteria) throws Exception {
        PreparedStatement ps = null;
        ResultSet rs = null;
        LinkedList<Schemaversion> results = new LinkedList<Schemaversion>();
        StringBuffer buf = new StringBuffer(200);
        if (criteria == null) {
            return null;
        }
        buf.append("SELECT ");
        buf.append(this.prepareColList(criteria));
        buf.append(" FROM NC_SCHEMAVERSION ");
        QueryInfo qi = this.prepareWhereClause(criteria);
        buf.append(qi.whereClause);
        try {
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            int i = 0;
            Iterator<? super Object> it = qi.values.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                Schemaversion item = this.createObject(rs);
                results.add(item);
            }
        }
        catch (Throwable throwable) {
            DBUtils.close(ps, rs);
            throw throwable;
        }
        DBUtils.close(ps, rs);
        return results;
    }

    @Override
    public void update(Connection con, Schemaversion bean, Schemaversion criteria) throws Exception {
        PreparedStatement ps = null;
        if (bean == null) {
            return;
        }
        UpdateQueryInfo uqi = this.prepareUpdateQuery(bean, criteria);
        try {
            ps = con.prepareStatement(uqi.query);
            ps.clearParameters();
            int i = 0;
            Iterator<Integer> it2 = uqi.sqlTypes.iterator();
            Iterator<Boolean> it3 = uqi.nullSetList.iterator();
            for (Object object : uqi.setValues) {
                Integer sqlType = it2.next();
                boolean nullSet = it3.next();
                if (nullSet) {
                    ps.setNull(++i, sqlType);
                    continue;
                }
                ps.setObject(++i, object);
            }
            Iterator<? super Object> it = uqi.whereValues.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.close(ps);
            throw throwable;
        }
        DBUtils.close(ps);
    }

    @Override
    public void delete(Connection con, Schemaversion criteria) throws Exception {
        PreparedStatement ps = null;
        StringBuffer buf = new StringBuffer(200);
        buf.append("DELETE FROM NC_SCHEMAVERSION ");
        QueryInfo qi = this.prepareWhereClause(criteria);
        buf.append(qi.whereClause);
        try {
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            int i = 0;
            Iterator<? super Object> it = qi.values.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.close(ps);
            throw throwable;
        }
        DBUtils.close(ps);
    }

    public static class QueryInfo {
        String whereClause;
        List<? super Object> values = new LinkedList<Object>();

        public QueryInfo() {
        }

        public QueryInfo(String whereClause) {
            this.whereClause = whereClause;
        }
    }

    public static class UpdateQueryInfo {
        String query;
        List<? super Object> setValues = new LinkedList<Object>();
        List<Integer> sqlTypes = new LinkedList<Integer>();
        List<Boolean> nullSetList = new LinkedList<Boolean>();
        List<? super Object> whereValues = new LinkedList<Object>();
    }
}

