/*
 * Decompiled with CFR 0.152.
 */
package clinical.server.dao.postgres;

import clinical.server.vo.Databasecolumn;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DatabasecolumnDAO
implements clinical.server.dao.DatabasecolumnDAO {
    @Override
    public void insert(Connection con, Databasecolumn bean) throws Exception {
        PreparedStatement ps = null;
        StringBuffer buf = new StringBuffer(200);
        if (bean == null) {
            return;
        }
        try {
            buf.append("INSERT INTO nc_databasecolumn VALUES ");
            buf.append('(');
            int i = 0;
            while (i < 9) {
                buf.append('?');
                if (i < 8) {
                    buf.append(',');
                }
                ++i;
            }
            buf.append(")");
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            ps.setObject(1, (Object)bean.getColumnname(), 12);
            ps.setObject(2, (Object)bean.getTablename(), 12);
            ps.setObject(3, (Object)bean.getParentcolumn(), 12);
            ps.setObject(4, (Object)bean.getTableid(), 2);
            ps.setObject(5, (Object)bean.getUniqueid(), 2);
            ps.setObject(6, (Object)bean.getOwner(), 2);
            ps.setObject(7, bean.getModtime() == null ? null : new Timestamp(bean.getModtime().getTime()));
            ps.setObject(8, (Object)bean.getModuser(), 2);
            ps.setObject(9, (Object)bean.getDescription(), 12);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.close(ps);
            throw throwable;
        }
        DBUtils.close(ps);
    }

    protected String prepareColList(Databasecolumn bean) {
        StringBuffer buf = new StringBuffer(200);
        buf.append("columnname");
        buf.append(',');
        buf.append("tablename");
        buf.append(',');
        buf.append("parentcolumn");
        buf.append(',');
        buf.append("tableid");
        buf.append(',');
        buf.append("uniqueid");
        buf.append(',');
        buf.append("owner");
        buf.append(',');
        buf.append("modtime");
        buf.append(',');
        buf.append("moduser");
        buf.append(',');
        buf.append("description");
        buf.append(' ');
        return buf.toString();
    }

    protected QueryInfo prepareWhereClause(Databasecolumn bean) {
        StringBuffer buf = new StringBuffer(200);
        QueryInfo qi = new QueryInfo();
        boolean valueSet = false;
        buf.append("WHERE ");
        if (bean.getColumnname() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("columnname=?");
            qi.values.add(bean.getColumnname());
            valueSet = true;
        }
        if (bean.getTablename() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("tablename=?");
            qi.values.add(bean.getTablename());
            valueSet = true;
        }
        if (bean.getParentcolumn() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("parentcolumn=?");
            qi.values.add(bean.getParentcolumn());
            valueSet = true;
        }
        if (bean.getTableid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("tableid=?");
            qi.values.add(bean.getTableid());
            valueSet = true;
        }
        if (bean.getUniqueid() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("uniqueid=?");
            qi.values.add(bean.getUniqueid());
            valueSet = true;
        }
        if (bean.getOwner() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("owner=?");
            qi.values.add(bean.getOwner());
            valueSet = true;
        }
        if (bean.getModtime() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("modtime=?");
            qi.values.add(new Date(bean.getModtime().getTime()));
            valueSet = true;
        }
        if (bean.getModuser() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("moduser=?");
            qi.values.add(bean.getModuser());
            valueSet = true;
        }
        if (bean.getDescription() != null) {
            if (valueSet) {
                buf.append(" AND ");
            }
            buf.append("description=?");
            qi.values.add(bean.getDescription());
            valueSet = true;
        }
        qi.whereClause = !valueSet ? "" : buf.toString();
        return qi;
    }

    protected UpdateQueryInfo prepareUpdateQuery(Databasecolumn bean, Databasecolumn criteria) throws ValidationException {
        StringBuffer buf = new StringBuffer(200);
        UpdateQueryInfo uqi = new UpdateQueryInfo();
        boolean valueSet = false;
        buf.append("UPDATE nc_databasecolumn SET ");
        if (bean.getColumnname() != null || bean.isNull("columnname")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("columnname=? ");
            uqi.setValues.add(bean.getColumnname());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("columnname"), uqi);
            valueSet = true;
        }
        if (bean.getTablename() != null || bean.isNull("tablename")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("tablename=? ");
            uqi.setValues.add(bean.getTablename());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("tablename"), uqi);
            valueSet = true;
        }
        if (bean.getParentcolumn() != null || bean.isNull("parentcolumn")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("parentcolumn=? ");
            uqi.setValues.add(bean.getParentcolumn());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("parentcolumn"), uqi);
            valueSet = true;
        }
        if (bean.getTableid() != null || bean.isNull("tableid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("tableid=? ");
            uqi.setValues.add(bean.getTableid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("tableid"), uqi);
            valueSet = true;
        }
        if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("uniqueid=? ");
            uqi.setValues.add(bean.getUniqueid());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
            valueSet = true;
        }
        if (bean.getOwner() != null || bean.isNull("owner")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("owner=? ");
            uqi.setValues.add(bean.getOwner());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("owner"), uqi);
            valueSet = true;
        }
        if (bean.getModtime() != null || bean.isNull("modtime")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("modtime=? ");
            uqi.setValues.add(new Timestamp(bean.getModtime().getTime()));
            uqi.sqlTypes.add(new Integer(93));
            this.prepareNullSetListValue(bean.isNull("modtime"), uqi);
            valueSet = true;
        }
        if (bean.getModuser() != null || bean.isNull("moduser")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("moduser=? ");
            uqi.setValues.add(bean.getModuser());
            uqi.sqlTypes.add(new Integer(2));
            this.prepareNullSetListValue(bean.isNull("moduser"), uqi);
            valueSet = true;
        }
        if (bean.getDescription() != null || bean.isNull("description")) {
            if (valueSet) {
                buf.append(", ");
            }
            buf.append("description=? ");
            uqi.setValues.add(bean.getDescription());
            uqi.sqlTypes.add(new Integer(12));
            this.prepareNullSetListValue(bean.isNull("description"), uqi);
            valueSet = true;
        }
        if (!valueSet) {
            throw new ValidationException("At least one field needs to be set for update!");
        }
        uqi.query = buf.toString();
        QueryInfo qi = this.prepareWhereClause(criteria);
        uqi.query = String.valueOf(uqi.query) + qi.whereClause;
        uqi.whereValues = qi.values;
        return uqi;
    }

    protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
        if (wasNull) {
            uqi.nullSetList.add(new Boolean(true));
        } else {
            uqi.nullSetList.add(new Boolean(false));
        }
    }

    public Databasecolumn createObject(ResultSet rs) throws SQLException {
        Databasecolumn obj = new Databasecolumn();
        obj.setColumnname((String)rs.getObject(1));
        obj.setTablename((String)rs.getObject(2));
        obj.setParentcolumn((String)rs.getObject(3));
        obj.setTableid(rs.getObject(4) != null ? new BigDecimal(rs.getObject(4).toString()) : null);
        obj.setUniqueid(rs.getObject(5) != null ? new BigDecimal(rs.getObject(5).toString()) : null);
        obj.setOwner(rs.getObject(6) != null ? new BigDecimal(rs.getObject(6).toString()) : null);
        obj.setModtime(rs.getObject(7) != null ? new java.util.Date(((Timestamp)rs.getObject(7)).getTime()) : null);
        obj.setModuser(rs.getObject(8) != null ? new BigDecimal(rs.getObject(8).toString()) : null);
        obj.setDescription((String)rs.getObject(9));
        return obj;
    }

    @Override
    public List<Databasecolumn> find(Connection con, Databasecolumn criteria) throws Exception {
        PreparedStatement ps = null;
        ResultSet rs = null;
        LinkedList<Databasecolumn> results = new LinkedList<Databasecolumn>();
        StringBuffer buf = new StringBuffer(200);
        if (criteria == null) {
            return null;
        }
        buf.append("SELECT ");
        buf.append(this.prepareColList(criteria));
        buf.append(" FROM nc_databasecolumn ");
        QueryInfo qi = this.prepareWhereClause(criteria);
        buf.append(qi.whereClause);
        try {
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            int i = 0;
            Iterator<? super Object> it = qi.values.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                Databasecolumn item = this.createObject(rs);
                results.add(item);
            }
        }
        catch (Throwable throwable) {
            DBUtils.close(ps, rs);
            throw throwable;
        }
        DBUtils.close(ps, rs);
        return results;
    }

    @Override
    public void update(Connection con, Databasecolumn bean, Databasecolumn criteria) throws Exception {
        PreparedStatement ps = null;
        if (bean == null) {
            return;
        }
        UpdateQueryInfo uqi = this.prepareUpdateQuery(bean, criteria);
        try {
            ps = con.prepareStatement(uqi.query);
            ps.clearParameters();
            int i = 0;
            Iterator<Integer> it2 = uqi.sqlTypes.iterator();
            Iterator<Boolean> it3 = uqi.nullSetList.iterator();
            for (Object object : uqi.setValues) {
                Integer sqlType = it2.next();
                boolean nullSet = it3.next();
                if (nullSet) {
                    ps.setNull(++i, sqlType);
                    continue;
                }
                ps.setObject(++i, object);
            }
            Iterator<? super Object> it = uqi.whereValues.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.close(ps);
            throw throwable;
        }
        DBUtils.close(ps);
    }

    @Override
    public void delete(Connection con, Databasecolumn criteria) throws Exception {
        PreparedStatement ps = null;
        StringBuffer buf = new StringBuffer(200);
        buf.append("DELETE FROM nc_databasecolumn ");
        QueryInfo qi = this.prepareWhereClause(criteria);
        buf.append(qi.whereClause);
        try {
            ps = con.prepareStatement(buf.toString());
            ps.clearParameters();
            int i = 0;
            Iterator<? super Object> it = qi.values.iterator();
            while (it.hasNext()) {
                ps.setObject(++i, it.next());
            }
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.close(ps);
            throw throwable;
        }
        DBUtils.close(ps);
    }

    public static class QueryInfo {
        String whereClause;
        List<? super Object> values = new LinkedList<Object>();

        public QueryInfo() {
        }

        public QueryInfo(String whereClause) {
            this.whereClause = whereClause;
        }
    }

    public static class UpdateQueryInfo {
        String query;
        List<? super Object> setValues = new LinkedList<Object>();
        List<Integer> sqlTypes = new LinkedList<Integer>();
        List<Boolean> nullSetList = new LinkedList<Boolean>();
        List<? super Object> whereValues = new LinkedList<Object>();
    }
}

