/*
 * Decompiled with CFR 0.152.
 */
package clinical.server.dao.postgres;

import clinical.server.dao.postgres.ExpcomponentDAO;
import clinical.server.dao.postgres.ExpcomponentViewDAO;
import clinical.server.vo.Expcomponent;
import clinical.server.vo.ExpcomponentView;
import clinical.utils.GenUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ExpComponentDAOAdapter
implements clinical.server.dao.ExpcomponentDAO {
    protected boolean useView = false;
    protected ExpcomponentViewDAO viewDAO;
    protected ExpcomponentDAO dao;

    public ExpComponentDAOAdapter(Map availableTablesMap) {
        if (availableTablesMap.get("NC_EXPCOMPONENT") != null) {
            this.useView = false;
            this.dao = new ExpcomponentDAO();
        } else if (availableTablesMap.get("NC_EXPCOMPONENT_VIEW") != null) {
            this.useView = true;
            this.viewDAO = new ExpcomponentViewDAO();
        } else {
            throw new RuntimeException("No table NC_EXPCOMPONENT or view NC_EXPCOMPONENT_VIEW is found!");
        }
    }

    @Override
    public void insert(Connection con, Expcomponent bean) throws Exception {
        if (this.useView) {
            ExpcomponentView view = this.toView(bean);
            this.viewDAO.insert(con, view);
        } else {
            this.dao.insert(con, bean);
        }
    }

    @Override
    public List<Expcomponent> find(Connection con, Expcomponent criteria) throws Exception {
        if (this.useView) {
            ExpcomponentView view = this.toView(criteria);
            List<ExpcomponentView> r = this.viewDAO.find(con, view);
            LinkedList<Expcomponent> results = new LinkedList<Expcomponent>();
            Iterator<ExpcomponentView> iter = r.iterator();
            while (iter.hasNext()) {
                ExpcomponentView v = iter.next();
                results.add(this.toVisit(v));
                iter.remove();
            }
            return results;
        }
        return this.dao.find(con, criteria);
    }

    @Override
    public void update(Connection con, Expcomponent bean, Expcomponent criteria) throws Exception {
        if (this.useView) {
            ExpcomponentView beanView = this.toView(bean);
            ExpcomponentView cView = this.toView(criteria);
            this.viewDAO.update(con, beanView, cView);
        } else {
            this.dao.update(con, bean, criteria);
        }
    }

    @Override
    public void delete(Connection con, Expcomponent criteria) throws Exception {
        if (this.useView) {
            this.viewDAO.delete(con, this.toView(criteria));
        } else {
            this.dao.delete(con, criteria);
        }
    }

    protected ExpcomponentView toView(Expcomponent visit) {
        ExpcomponentView view = new ExpcomponentView();
        view.setComponentid(visit.getComponentid());
        view.setSubjectid(visit.getSubjectid());
        view.setModuser(visit.getModuser());
        view.setNcExperimentUniqueid(visit.getNcExperimentUniqueid());
        view.setOwner(visit.getOwner());
        view.setTableid(visit.getTableid());
        view.setUniqueid(visit.getUniqueid());
        view.setVisittype(visit.getVisittype());
        return view;
    }

    protected Expcomponent toVisit(ExpcomponentView view) {
        Expcomponent visit = new Expcomponent();
        visit.setComponentid(view.getComponentid());
        visit.setSubjectid(view.getSubjectid());
        visit.setModuser(view.getModuser());
        visit.setNcExperimentUniqueid(view.getNcExperimentUniqueid());
        visit.setOwner(view.getOwner());
        visit.setTableid(view.getTableid());
        visit.setUniqueid(view.getUniqueid());
        visit.setVisittype(view.getVisittype());
        return visit;
    }

    protected void findProperDatabaseObject(Connection con) throws SQLException {
        block14: {
            Statement st = null;
            try {
                try {
                    st = con.createStatement();
                    ResultSet rs = st.executeQuery("select 1 from nc_expcomponent");
                    rs.close();
                    DatabaseMetaData md = con.getMetaData();
                    String[] tableTypes = new String[]{"TABLE", "VIEW"};
                    rs = md.getTables("", "UCSD_FMRI", "%", tableTypes);
                    while (rs.next()) {
                        String tableName = rs.getString(3);
                        if (!tableName.startsWith("NC_") || !ExpComponentDAOAdapter.canAccessTable(con, tableName)) continue;
                        System.out.println(tableName);
                    }
                }
                catch (SQLException x) {
                    if (x.getMessage().indexOf("ORA-00942") != -1) {
                        System.out.println("table does not exists using the view");
                        this.useView = true;
                    }
                    if (st == null) break block14;
                    try {
                        st.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    public static boolean canAccessTable(Connection con, String tableName) {
        Statement st;
        block12: {
            st = null;
            st = con.createStatement();
            ResultSet rs = st.executeQuery("select 1 from " + tableName);
            rs.close();
            if (st == null) break block12;
            try {
                st.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
        catch (SQLException x) {
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
            catch (Throwable throwable) {
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    public static void main(String[] args) {
        block12: {
            Connection con = null;
            try {
                try {
                    Class.forName("oracle.jdbc.driver.OracleDriver");
                    Properties props = GenUtils.loadProperties("test.properties");
                    String dbURL = props.getProperty("mbirn.dburl");
                    String user = props.getProperty("mbirn.user");
                    String pwd = props.getProperty("mbirn.pwd");
                    con = DriverManager.getConnection(dbURL, user, pwd);
                    ExpComponentDAOAdapter dao = new ExpComponentDAOAdapter(null);
                    dao.findProperDatabaseObject(con);
                }
                catch (Exception x) {
                    x.printStackTrace();
                    if (con == null) break block12;
                    try {
                        con.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

