/*
 * Decompiled with CFR 0.152.
 */
package clinical.tools.install;

import clinical.tools.install.DBUserInfo;
import clinical.tools.install.DatabaseInfo;
import clinical.tools.install.PrivilegeInfo;
import clinical.tools.install.RoleInfo;
import clinical.tools.install.WebUserInfo;
import java.util.LinkedList;
import java.util.List;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Element;

public class UsersFileInfo {
    List<DatabaseInfo> databases = new LinkedList<DatabaseInfo>();
    List<PrivilegeInfo> privileges = new LinkedList<PrivilegeInfo>();
    List<DBUserInfo> dbUsers = new LinkedList<DBUserInfo>();
    List<WebUserInfo> webUsers = new LinkedList<WebUserInfo>();
    List<RoleInfo> roles = new LinkedList<RoleInfo>();

    public void addDatabase(DatabaseInfo dbInfo) {
        this.databases.add(dbInfo);
    }

    public void addDBUser(DBUserInfo dbUserInfo) {
        this.dbUsers.add(dbUserInfo);
    }

    public void addWebUser(WebUserInfo wuInfo) {
        this.webUsers.add(wuInfo);
    }

    public void addPrivilege(PrivilegeInfo pi) {
        this.privileges.add(pi);
    }

    public void addRole(RoleInfo role) {
        this.roles.add(role);
    }

    public DatabaseInfo findDatabase(String dbID) {
        for (DatabaseInfo dbi : this.databases) {
            if (!dbi.dbID.equals(dbID)) continue;
            return dbi;
        }
        return null;
    }

    public WebUserInfo findWebUser(String webUserName, String dbID, String dbUser) {
        for (WebUserInfo wui : this.webUsers) {
            if (!wui.name.equals(webUserName) || !wui.dbID.equals(dbID) || !wui.dbID.equals(dbUser)) continue;
            return wui;
        }
        return null;
    }

    public DBUserInfo findDBUser(String dbUserName, String dbID) {
        for (DBUserInfo dui : this.dbUsers) {
            if (!dui.name.equals(dbUserName) || !dui.dbID.equals(dbID)) continue;
            return dui;
        }
        return null;
    }

    public Element toXML() {
        Element parent = new Element("user-info");
        parent.addContent((Content)new Comment("Define the set of available databases the web application can connect\nOne of them needs to have default=true."));
        Element de = new Element("databases");
        parent.addContent((Content)de);
        for (DatabaseInfo dbi : this.databases) {
            dbi.toXML(de);
        }
        Element pe = new Element("privileges");
        parent.addContent((Content)pe);
        for (PrivilegeInfo pi : this.privileges) {
            pi.toXML(pe);
        }
        Element re = new Element("roles");
        parent.addContent((Content)re);
        for (RoleInfo ri : this.roles) {
            ri.toXML(re);
        }
        parent.addContent((Content)new Comment("the list of named database users for each database instance"));
        Element due = new Element("dbusers");
        parent.addContent((Content)due);
        for (DBUserInfo dui : this.dbUsers) {
            dui.toXML(due);
        }
        parent.addContent((Content)new Comment("the list of web application users mapped to the named database users\nThe web application does its own authentication."));
        Element wue = new Element("users");
        parent.addContent((Content)wue);
        for (WebUserInfo wui : this.webUsers) {
            wui.toXML(wue);
        }
        return parent;
    }
}

