/*
 * Decompiled with CFR 0.152.
 */
package clinical.web.common;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.ietf.jgss.GSSCredential;

public class UserInfo
implements Serializable {
    private static final long serialVersionUID = -497049932290818753L;
    private final String name;
    private String email;
    private String[] roles;
    private GSSCredential credential;
    private Map<String, String> availableTables = new HashMap<String, String>();

    public UserInfo(String name, String[] roles, Map<String, String> availableTables) {
        this.name = name;
        this.roles = roles;
        this.availableTables = availableTables;
    }

    public UserInfo(String name, String[] roles, Map<String, String> availableTables, GSSCredential credential) {
        this.name = name;
        this.roles = roles;
        this.availableTables = availableTables;
        this.credential = credential;
    }

    public UserInfo(String name, String email, String[] roles, Map<String, String> availableTables) {
        this.name = name;
        this.roles = roles;
        this.availableTables = availableTables;
        this.email = email;
    }

    public String getName() {
        return this.name;
    }

    public String getPerceivedName() {
        if (this.email != null) {
            return this.email;
        }
        return this.name;
    }

    public String[] getRoles() {
        return this.roles;
    }

    public boolean isTableAvailable(String tableName) {
        return this.availableTables.get(tableName) != null;
    }

    public Map<String, String> getAvailableTables() {
        return this.availableTables;
    }

    public String getEmail() {
        return this.email;
    }

    public GSSCredential getCredential() {
        return this.credential;
    }
}

