/*
 * Decompiled with CFR 0.152.
 */
package clinical.web.common.query;

import clinical.utils.Assertion;
import clinical.web.ISQLDialect;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;

public class PostgresSQLDialect
implements ISQLDialect {
    @Override
    public String prepareSchemaObjectName(String schemaObjName) {
        return schemaObjName;
    }

    @Override
    public String prepareString(String value) {
        StringBuffer buf = new StringBuffer();
        value = PostgresSQLDialect.escapeQuotes(value);
        buf.append("'").append(value).append("'");
        return buf.toString();
    }

    public static String escapeQuotes(String str) {
        if (str == null) {
            return str;
        }
        if (str.indexOf(39) != -1) {
            str = str.replaceAll("'", "\\'");
        }
        if (str.indexOf(34) != -1) {
            str = str.replaceAll("\"", "\\\"");
        }
        return str;
    }

    @Override
    public String prepareBooleanPredicate(String prefix, boolean value) {
        StringBuffer buf = new StringBuffer();
        buf.append(prefix).append(' ').append(value ? "true" : "false");
        return buf.toString();
    }

    @Override
    public String prepareBooleanValue(Boolean value) {
        return value != false ? "true" : "false";
    }

    @Override
    public String getDialectName() {
        return "PostgresDialect";
    }

    @Override
    public void invokeSetter(Method m, Object vo, Object value, int colType) throws InvocationTargetException, IllegalArgumentException, IllegalAccessException {
        if (value != null && value instanceof Long) {
            m.invoke(vo, new BigDecimal(value.toString()));
        } else {
            m.invoke(vo, value);
        }
    }

    @Override
    public String endsWithFunction(String schemaColName, String suffix) {
        Assertion.assertNotNull(suffix);
        String colName = this.prepareSchemaObjectName(schemaColName);
        StringBuilder sb = new StringBuilder(50);
        sb.append("substring(").append(colName).append(" from char_length(");
        sb.append(colName).append(") - ").append(suffix.length() - 1);
        sb.append(" for ").append(suffix.length()).append(") = ");
        sb.append(this.prepareString(suffix));
        return sb.toString();
    }
}

