/*
 * Decompiled with CFR 0.152.
 */
package clinical.web.common.query;

import clinical.web.common.query.ISymbol;
import clinical.web.common.query.SQLTokens;
import clinical.web.common.query.TSQLParserException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class TSQLParser
implements SQLTokens {
    protected Map<String, ColumnInfo> columnTable = new HashMap<String, ColumnInfo>();
    protected Map<String, VOInfo> voTable = new HashMap<String, VOInfo>();
    protected List<ISymbol> symbolList = new ArrayList<ISymbol>();
    protected boolean verbose = false;

    public List<ISymbol> parse(String tsqlStr) throws TSQLParserException {
        TSQLTokenizer tokenizer = new TSQLTokenizer(new StringReader(tsqlStr));
        int tokCode = -1;
        try {
            while ((tokCode = tokenizer.nextToken()) != 2000) {
                if (this.verbose) {
                    System.out.println(String.valueOf(tokenizer.getTokenString()) + " code:" + tokCode);
                }
                this.symbolList.add(new SQLTokenInfo(tokenizer.getTokenString()));
                switch (tokCode) {
                    case 100: {
                        this.parseSelectList(tokenizer);
                        break;
                    }
                    case 101: {
                        this.parseTableList(tokenizer);
                        break;
                    }
                    case 102: {
                        this.parseWhereCondition(tokenizer);
                        break;
                    }
                    case 106: {
                        this.parseOrderClause(tokenizer);
                        break;
                    }
                    default: {
                        throw new TSQLParserException("Unrecognized token: " + tokenizer.getTokenString());
                    }
                }
            }
        }
        catch (Exception x) {
            this.handleException(x);
        }
        this.expandWildcards();
        this.validateSelectList();
        if (this.verbose) {
            for (ISymbol symbol : this.symbolList) {
                System.out.print(String.valueOf(symbol.toString()) + " ");
            }
            System.out.println();
        }
        return this.symbolList;
    }

    protected void expandWildcards() {
        ArrayList<ISymbol> newSymbolList = new ArrayList<ISymbol>();
        for (ISymbol symbol : this.symbolList) {
            if (symbol instanceof ColumnInfo) {
                ColumnInfo ci = (ColumnInfo)symbol;
                if (ci.name.endsWith("*")) {
                    String[] properties = ci.voInfo.getProperties();
                    int i = 0;
                    while (i < properties.length) {
                        newSymbolList.add(new ColumnInfo(properties[i], ci.voInfo));
                        if (i + 1 < properties.length) {
                            newSymbolList.add(new SQLTokenInfo(","));
                        }
                        ++i;
                    }
                    continue;
                }
                newSymbolList.add(symbol);
                continue;
            }
            newSymbolList.add(symbol);
        }
        this.symbolList = newSymbolList;
    }

    protected void validateSelectList() throws TSQLParserException {
        boolean inSelect = false;
        for (ISymbol symbol : this.symbolList) {
            ColumnInfo ci;
            if (symbol.getName().equals("select")) {
                inSelect = true;
                continue;
            }
            if (symbol.getName().equals("from")) {
                inSelect = false;
                break;
            }
            if (!inSelect || !(symbol instanceof ColumnInfo) || this.voTable.get((ci = (ColumnInfo)symbol).getVoInfo().getName()) != null) continue;
            throw new TSQLParserException("Select list of columns cannot contain columns from tables other than the ones in the <from> list of tables!: " + ci.getVoInfo());
        }
    }

    protected void validateSelectListOld() throws TSQLParserException {
        boolean inSelect = false;
        VOInfo theVOI = null;
        for (ISymbol symbol : this.symbolList) {
            if (symbol.getName().equals("select")) {
                inSelect = true;
                theVOI = null;
                continue;
            }
            if (symbol.getName().equals("from")) {
                inSelect = false;
                continue;
            }
            if (!inSelect || !(symbol instanceof ColumnInfo)) continue;
            ColumnInfo ci = (ColumnInfo)symbol;
            if (theVOI == null) {
                theVOI = ci.getVoInfo();
                continue;
            }
            if (theVOI == ci.getVoInfo()) continue;
            throw new TSQLParserException("Only column(s) from one table is allowed in select list! : <" + theVOI.getName() + "> , second table (object) :" + ci.getVoInfo());
        }
    }

    public String getKey(VOInfo voInfo, String id) {
        if (voInfo.getName() != null) {
            return String.valueOf(voInfo.getName()) + "_" + id;
        }
        return String.valueOf(voInfo.getAlias()) + "_" + id;
    }

    protected void parseSelectList(TSQLTokenizer tokenizer) throws TSQLParserException {
        int tokCode = -1;
        String id = null;
        try {
            while ((tokCode = tokenizer.nextToken()) != 101) {
                if (tokCode == 1001) {
                    id = tokenizer.getTokenString();
                    VOInfo voInfo = null;
                    ISymbol symbol = this.voTable.get(id);
                    if (symbol == null) {
                        Class<?> clazz = TSQLParser.getVOClass(id);
                        voInfo = clazz != null ? new VOInfo(id, TSQLParser.getFullyQualifedClassName(id)) : new VOInfo(id);
                        this.voTable.put(id, voInfo);
                    } else {
                        voInfo = (VOInfo)symbol;
                    }
                    tokCode = tokenizer.nextToken();
                    if (tokCode == 1) {
                        tokCode = tokenizer.nextToken();
                        if (tokCode == 1001) {
                            id = tokenizer.getTokenString();
                            String key = this.getKey(voInfo, id);
                            ColumnInfo ci = this.columnTable.get(key);
                            if (ci == null) {
                                ci = new ColumnInfo(id, voInfo);
                                this.columnTable.put(key, ci);
                            }
                            this.symbolList.add(ci);
                            continue;
                        }
                        if (tokCode == 4) {
                            voInfo.setAllColumns(true);
                            ColumnInfo ci = this.columnTable.get(String.valueOf(voInfo.getAlias()) + "_*");
                            assert (ci == null);
                            ci = new ColumnInfo(String.valueOf(voInfo.getAlias()) + "_*", voInfo);
                            this.columnTable.put(String.valueOf(voInfo.getAlias()) + "_*", ci);
                            this.symbolList.add(ci);
                            continue;
                        }
                        throw new IOException("Unexpected token for select list:" + tokenizer.getTokenString());
                    }
                    tokenizer.pushBack();
                    continue;
                }
                if (tokCode == 2 || tokCode == 8 || tokCode == 9 || tokCode == 119 || tokCode == 120 || tokCode == 122 || tokCode == 121 || tokCode == 123 || tokCode == 117 || tokCode == 118) {
                    this.symbolList.add(new SQLTokenInfo(tokenizer.getTokenString()));
                    continue;
                }
                throw new IOException("Unexpected token for select list:" + tokenizer.getTokenString());
            }
            if (tokCode == 101) {
                tokenizer.pushBack();
            }
        }
        catch (Exception x) {
            this.handleException(x);
        }
    }

    protected void parseTableList(TSQLTokenizer tokenizer) throws TSQLParserException {
        int tokCode = -1;
        String id = null;
        try {
            tokCode = tokenizer.nextToken();
            while (tokCode != 2000 && tokCode != 102 && tokCode != 106) {
                if (tokCode == 1001) {
                    ISymbol symbol;
                    id = tokenizer.getTokenString();
                    VOInfo voInfo = null;
                    String voName = id;
                    if (TSQLParser.isFullyQualifiedClass(id)) {
                        voName = TSQLParser.extractVOName(id);
                    }
                    if ((symbol = (ISymbol)this.voTable.get(voName)) == null) {
                        Class<?> clazz = TSQLParser.getVOClass(id);
                        if (clazz == null) {
                            throw new IOException("Not a valid value object:" + id);
                        }
                        voInfo = new VOInfo(voName, TSQLParser.getFullyQualifedClassName(id));
                        this.voTable.put(voName, voInfo);
                    } else {
                        voInfo = (VOInfo)symbol;
                    }
                    this.symbolList.add(voInfo);
                    tokCode = tokenizer.nextToken();
                    if (tokCode == 116) {
                        tokCode = tokenizer.nextToken();
                        if (tokCode != 1001) {
                            throw new IOException("Unexpected token in from list:" + tokenizer.getTokenString());
                        }
                        voInfo.setAlias(tokenizer.getTokenString());
                    } else if (tokCode == 2) {
                        tokenizer.pushBack();
                    }
                } else if (tokCode == 2) {
                    this.symbolList.add(new SQLTokenInfo(tokenizer.getTokenString()));
                } else {
                    throw new IOException("Unexpected token in from list:" + tokenizer.getTokenString());
                }
                tokCode = tokenizer.nextToken();
            }
            if (tokCode == 102 || tokCode == 106) {
                tokenizer.pushBack();
            }
            this.syncSymbolTables();
        }
        catch (Exception x) {
            this.handleException(x);
        }
    }

    protected void syncSymbolTables() {
        VOInfo ivi;
        HashMap<String, VOInfo> map = new HashMap<String, VOInfo>(7);
        for (VOInfo voInfo : this.voTable.values()) {
            if (!voInfo.isFullyInitialized()) continue;
            map.put(voInfo.getName(), voInfo);
            if (voInfo.getAlias() == null) continue;
            ivi = this.voTable.get(voInfo.getAlias());
            if (ivi != null) {
                voInfo.setAllColumns(ivi.isAllColumns());
            }
            map.put(voInfo.getAlias(), voInfo);
        }
        this.voTable = map;
        for (ColumnInfo ci : this.columnTable.values()) {
            ivi = ci.voInfo;
            ci.voInfo = ivi.name != null ? this.voTable.get(ivi.name) : this.voTable.get(ivi.getAlias());
            assert (ci.voInfo != null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parseWhereCondition(TSQLTokenizer tokenizer) throws TSQLParserException {
        int tokCode = -1;
        String id = null;
        try {
            tokCode = tokenizer.nextToken();
            while (tokCode != 2000 && tokCode != 106 && tokCode != 110) {
                if (tokCode == 1001) {
                    id = tokenizer.getTokenString();
                    VOInfo voInfo = this.voTable.get(id);
                    if (voInfo == null) {
                        if (id.equals("true") || id.equals("false")) {
                            this.symbolList.add(new BoolTokenInfo(id));
                            tokCode = tokenizer.nextToken();
                            continue;
                        }
                        if (!id.equals("endsWith")) throw new TSQLParserException("Unrecognized table or alias in where clause: " + tokenizer.getTokenString());
                        FunctionInfo fi = new FunctionInfo(id);
                        tokCode = tokenizer.nextToken();
                        if (tokCode == 8) {
                            this.parseFunctionParams(tokenizer, fi);
                            this.symbolList.add(fi);
                        }
                        tokCode = tokenizer.nextToken();
                        continue;
                    }
                    tokCode = tokenizer.nextToken();
                    if (tokCode != 1) {
                        throw new TSQLParserException("A period is expected after table or alias in where clause:" + tokenizer.getTokenString());
                    }
                    tokCode = tokenizer.nextToken();
                    if (tokCode != 1001) throw new IOException("Unexpected token after '.' in where clause: " + tokenizer.getTokenString());
                    id = tokenizer.getTokenString();
                    String key = this.getKey(voInfo, id);
                    ColumnInfo ci = this.columnTable.get(key);
                    if (ci == null) {
                        if (!voInfo.isValidProperty(id)) {
                            throw new IOException("Not a valid property for VO '" + voInfo.getName() + "' : " + id);
                        }
                        ci = new ColumnInfo(id, voInfo);
                        this.columnTable.put(key, ci);
                    }
                    this.symbolList.add(ci);
                } else if (tokCode == 1004) {
                    this.symbolList.add(new StringInfo(tokenizer.getTokenString()));
                } else {
                    this.symbolList.add(new SQLTokenInfo(tokenizer.getTokenString()));
                }
                tokCode = tokenizer.nextToken();
            }
            if (tokCode != 106 && tokCode != 110) return;
            tokenizer.pushBack();
            return;
        }
        catch (Exception x) {
            this.handleException(x);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parseFunctionParams(TSQLTokenizer tokenizer, FunctionInfo fi) throws IOException, TSQLParserException {
        int tokCode = tokenizer.nextToken();
        while (tokCode != 9) {
            if (tokCode == 1001) {
                String id = tokenizer.getTokenString();
                VOInfo voInfo = this.voTable.get(id);
                if (voInfo == null) {
                    throw new TSQLParserException("A column declaration or a string is expected as the argument for function " + fi.getName());
                }
                tokCode = tokenizer.nextToken();
                if (tokCode != 1) {
                    throw new TSQLParserException("A period is expected after table or alias in where clause:" + tokenizer.getTokenString());
                }
                tokCode = tokenizer.nextToken();
                if (tokCode != 1001) throw new TSQLParserException("Unexpected token after '.' in function arguments: " + tokenizer.getTokenString());
                id = tokenizer.getTokenString();
                String key = this.getKey(voInfo, id);
                ColumnInfo ci = this.columnTable.get(key);
                if (ci == null) {
                    if (!voInfo.isValidProperty(id)) {
                        throw new IOException("Not a valid property for VO '" + voInfo.getName() + "' : " + id);
                    }
                    ci = new ColumnInfo(id, voInfo);
                    this.columnTable.put(key, ci);
                }
                fi.addParam(ci);
            } else if (tokCode == 1004) {
                fi.addParam(new StringInfo(tokenizer.getTokenString()));
            } else if (tokCode != 2 || tokCode == 2000) {
                throw new TSQLParserException("Unexpected token in function arguments: " + tokenizer.getTokenString());
            }
            tokCode = tokenizer.nextToken();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parseOrderClause(TSQLTokenizer tokenizer) throws TSQLParserException {
        int tokCode = -1;
        String id = null;
        try {
            tokCode = tokenizer.nextToken();
            if (tokCode != 107) {
                throw new TSQLParserException("The keyword 'by' is expected after 'order'!");
            }
            this.symbolList.add(new SQLTokenInfo(tokenizer.getTokenString()));
            tokCode = tokenizer.nextToken();
            while (tokCode != 2000 && tokCode != 110) {
                if (tokCode == 1001) {
                    id = tokenizer.getTokenString();
                    VOInfo voInfo = this.voTable.get(id);
                    if (voInfo == null) {
                        throw new TSQLParserException("Unrecognized table or alias in order clause: " + tokenizer.getTokenString());
                    }
                    tokCode = tokenizer.nextToken();
                    if (tokCode != 1) {
                        throw new TSQLParserException("A period is expected after table or alias in order clause:" + tokenizer.getTokenString());
                    }
                    tokCode = tokenizer.nextToken();
                    if (tokCode != 1001) throw new IOException("Unexpected token after '.' in order clause: " + tokenizer.getTokenString());
                    id = tokenizer.getTokenString();
                    String key = this.getKey(voInfo, id);
                    ColumnInfo ci = this.columnTable.get(key);
                    if (ci != null) {
                        this.symbolList.add(ci);
                    } else {
                        if (!voInfo.isValidProperty(id)) {
                            throw new IOException("Not a valid property for VO '" + voInfo.getName() + "' : " + id);
                        }
                        ci = new ColumnInfo(id, voInfo);
                        this.columnTable.put(key, ci);
                        this.symbolList.add(ci);
                    }
                } else {
                    this.symbolList.add(new SQLTokenInfo(tokenizer.getTokenString()));
                }
                tokCode = tokenizer.nextToken();
            }
            if (tokCode != 110) return;
            tokenizer.pushBack();
            return;
        }
        catch (Exception x) {
            this.handleException(x);
        }
    }

    protected void handleException(Exception x) throws TSQLParserException {
        if (x instanceof TSQLParserException) {
            throw (TSQLParserException)x;
        }
        throw new TSQLParserException(x);
    }

    protected static String getFullyQualifedClassName(String voName) {
        if (TSQLParser.isFullyQualifiedClass(voName)) {
            return voName;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("clinical.server.vo.").append(voName);
        return buf.toString();
    }

    protected static boolean isFullyQualifiedClass(String className) {
        return className.indexOf(46) != -1;
    }

    protected static String extractVOName(String fqClassName) {
        int idx = fqClassName.lastIndexOf(46);
        return fqClassName.substring(idx + 1);
    }

    protected static Class<?> getVOClass(String voName) {
        String fqName = TSQLParser.getFullyQualifedClassName(voName);
        Class<?> clazz = null;
        try {
            clazz = Class.forName(fqName);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public static void main(String[] args) throws Exception {
        TSQLParser parser = new TSQLParser();
        String s = "select r.* from Rawdata as r where r.subjectid in ('000894468383', '000862323007') order by r.componentid, r.segmentid asc";
        String s1 = "SELECT number, quantity  FROM Order  WHERE quantity > +5.6 ORDER BY number DESC";
        String s2 = "select a.scorename, a.textvalue from Assessmentdata as a where a.subjectid in ('000894468383', '000862323007') and a.isvalidated = 1 order by a.assessmentid, a.scorename asc";
        String s3 = "select a.* from Assessmentdata as a, Storedassessment as s where a.ncStoredassessmentUniqueid = s.uniqueid and s.isvalidated = 1 and s.subjectid in ('000894468383', '000862323007')  and a.isvalidated = 1 order by a.assessmentid, a.scorename asc";
        String s4 = "select r.*, d.objectsize, d.objecttype from Rawdata as r, Dataobject as d where  r.subjectid ='000602155404' and r.uniqueid = d.dataid and  d.objecttype = '3_LOCAL COL DICOM' order by r.ncExperimentUniqueid, r.subjectid, r.componentid, r.segmentid";
        String s5 = "select d.* from Deriveddata as d where endsWith(d.datauri,'.xml') and d.israw = false";
        parser.parse(s5);
    }

    public static class BoolTokenInfo
    implements ISymbol {
        String name;

        public BoolTokenInfo(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isFullyInitialized() {
            return true;
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    public static class ColumnInfo
    implements ISymbol {
        String name;
        VOInfo voInfo;

        public ColumnInfo(String name, VOInfo voInfo) {
            this.name = name;
            this.voInfo = voInfo;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isFullyInitialized() {
            return this.voInfo != null && this.voInfo.isFullyInitialized();
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("ColumnInfo[");
            buf.append(this.voInfo.getName()).append('.').append(this.name);
            buf.append(']');
            return buf.toString();
        }

        public VOInfo getVoInfo() {
            return this.voInfo;
        }
    }

    public static class FunctionInfo
    implements ISymbol {
        String name;
        List<ISymbol> params = new ArrayList<ISymbol>(2);

        public FunctionInfo(String name) {
            this.name = name;
        }

        public void addParam(ISymbol param) {
            this.params.add(param);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isFullyInitialized() {
            return true;
        }
    }

    public static class SQLTokenInfo
    implements ISymbol {
        String name;

        public SQLTokenInfo(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isFullyInitialized() {
            return true;
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    public static class StringInfo
    implements ISymbol {
        String name;

        public StringInfo(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isFullyInitialized() {
            return true;
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("StringInfo::[");
            buf.append(this.name);
            buf.append(']');
            return buf.toString();
        }
    }

    public static class TSQLTokenizer
    implements SQLTokens {
        StreamTokenizer stok;
        Map<String, Integer> specialCharMap = new HashMap<String, Integer>();
        Map<String, Integer> keywordMap = new HashMap<String, Integer>();
        TokenInfo curTokenInfo;
        Stack<TokenInfo> tokenStack = new Stack();

        public TSQLTokenizer(Reader in) {
            this.stok = new StreamTokenizer(in);
            this.stok.resetSyntax();
            this.stok.eolIsSignificant(false);
            this.stok.wordChars(97, 122);
            this.stok.wordChars(65, 90);
            this.stok.wordChars(95, 95);
            this.stok.wordChars(48, 57);
            this.stok.ordinaryChar(46);
            this.stok.ordinaryChar(44);
            this.stok.ordinaryChar(59);
            this.stok.ordinaryChar(42);
            this.stok.ordinaryChar(47);
            this.stok.ordinaryChar(43);
            this.stok.ordinaryChar(45);
            this.stok.ordinaryChar(40);
            this.stok.ordinaryChar(41);
            this.stok.ordinaryChar(37);
            this.stok.ordinaryChar(39);
            String[] tokStrs = new String[]{".", ",", ";", "*", "/", "+", "-", "(", ")", "%", ">", "<", "=", "<>", ">=", "<=", "'", "select", "from", "where", "and", "or", "like", "order", "by", "asc", "desc", "group", "having", "null", "is", "not", "in", "as", "distinct", "all", "max", "min", "avg", "count", "sum", "endsWith"};
            int[] tokCodes = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 5000};
            int i = 0;
            while (i < 17) {
                this.specialCharMap.put(tokStrs[i], new Integer(tokCodes[i]));
                ++i;
            }
            i = 17;
            while (i < tokStrs.length) {
                this.keywordMap.put(tokStrs[i], new Integer(tokCodes[i]));
                ++i;
            }
        }

        public void pushBack() {
            if (this.curTokenInfo != null) {
                this.tokenStack.push(this.curTokenInfo);
            }
        }

        public boolean isKeyword(String token) {
            return this.keywordMap.get(token.toLowerCase()) != null;
        }

        public Integer getSpecialChar(String token) {
            return this.specialCharMap.get(token);
        }

        public int nextToken() throws IOException {
            if (!this.tokenStack.isEmpty()) {
                this.curTokenInfo = this.tokenStack.pop();
                return this.curTokenInfo.tokCode;
            }
            int ttype = this.stok.nextToken();
            Integer sc = null;
            while (ttype == 32 || ttype == 9) {
                ttype = this.stok.nextToken();
            }
            if (ttype == -3) {
                if (TSQLTokenizer.isAllDigits(this.stok.sval)) {
                    String curTok = this.handleNumber(this.stok.sval);
                    this.curTokenInfo = new TokenInfo(1000, curTok);
                    return 1000;
                }
                if (this.isKeyword(this.stok.sval)) {
                    Integer kw = this.keywordMap.get(this.stok.sval.toLowerCase());
                    this.curTokenInfo = new TokenInfo(kw, this.stok.sval);
                    return kw;
                }
                this.curTokenInfo = new TokenInfo(1001, this.stok.sval);
                return 1001;
            }
            sc = this.getSpecialChar(String.valueOf((char)this.stok.ttype));
            if (sc != null) {
                if (this.stok.ttype == 45 || this.stok.ttype == 43) {
                    int curTType = this.stok.ttype;
                    ttype = this.stok.nextToken();
                    if (ttype == -3) {
                        if (TSQLTokenizer.isAllDigits(this.stok.sval)) {
                            StringBuilder buf = new StringBuilder();
                            buf.append((char)curTType).append(this.stok.sval);
                            String curTok = this.handleNumber(buf.toString());
                            this.curTokenInfo = new TokenInfo(1000, curTok);
                            return 1000;
                        }
                        this.stok.pushBack();
                        this.curTokenInfo = new TokenInfo(sc, String.valueOf((char)this.stok.ttype));
                        return sc;
                    }
                    this.stok.pushBack();
                    this.curTokenInfo = new TokenInfo(sc, String.valueOf((char)this.stok.ttype));
                    return sc;
                }
                if (this.stok.ttype == 39) {
                    String curTok = this.handleString();
                    this.curTokenInfo = new TokenInfo(1004, curTok);
                    return 1004;
                }
                this.curTokenInfo = new TokenInfo(sc, String.valueOf((char)this.stok.ttype));
                return sc;
            }
            if (this.stok.ttype == -1) {
                return 2000;
            }
            throw new IOException("Unrecognized token:" + String.valueOf((char)this.stok.ttype));
        }

        protected String handleString() throws IOException {
            StringBuilder buf = new StringBuilder();
            int ttype = -1;
            while ((ttype = this.stok.nextToken()) != -1) {
                if (ttype == 39) {
                    ttype = this.stok.nextToken();
                    if (ttype == 39) {
                        buf.append('\'');
                        continue;
                    }
                    this.stok.pushBack();
                    break;
                }
                if (ttype == -3) {
                    buf.append(this.stok.sval);
                    continue;
                }
                buf.append((char)ttype);
            }
            return buf.toString();
        }

        protected String handleNumber(String numTok) throws IOException {
            StringBuilder buf = new StringBuilder();
            buf.append(numTok);
            int ttype = this.stok.nextToken();
            if (ttype == 46) {
                buf.append('.');
                ttype = this.stok.nextToken();
                if (ttype != -3) {
                    buf.append(ttype);
                    throw new IOException("Not a valid number: " + buf.toString());
                }
                buf.append(this.stok.sval);
                if (!TSQLTokenizer.isAllDigits(this.stok.sval)) {
                    throw new IOException("Not a valid number: " + buf.toString());
                }
            } else {
                this.stok.pushBack();
            }
            return buf.toString();
        }

        public static boolean isAllDigits(String token) {
            boolean ok = true;
            char[] carr = token.toCharArray();
            int i = 0;
            while (i < carr.length) {
                if (!Character.isDigit(carr[i])) {
                    return false;
                }
                ++i;
            }
            return ok;
        }

        public String getTokenString() {
            return this.curTokenInfo.token;
        }
    }

    public static class TokenInfo {
        int tokCode;
        String token;

        public TokenInfo(int code, String token) {
            this.tokCode = code;
            this.token = token;
        }
    }

    public static class VOInfo
    implements ISymbol {
        String name;
        String fqName;
        String alias;
        Class<?> voClass;
        boolean allColumns = false;
        protected BeanInfo bi;
        protected Map<String, PropertyDescriptor> propMap = new LinkedHashMap<String, PropertyDescriptor>(19);

        public VOInfo(String alias) {
            this.alias = alias;
        }

        public VOInfo(String name, String fqName) throws ClassNotFoundException, IntrospectionException {
            this.name = name;
            this.fqName = fqName;
            this.voClass = Class.forName(fqName);
            this.bi = Introspector.getBeanInfo(this.voClass, Object.class);
            PropertyDescriptor[] pds = this.bi.getPropertyDescriptors();
            int i = 0;
            while (i < pds.length) {
                this.propMap.put(pds[i].getName().toLowerCase(), pds[i]);
                ++i;
            }
        }

        public String[] getProperties() {
            String[] propNames = new String[this.propMap.size()];
            int i = 0;
            for (String propertyName : this.propMap.keySet()) {
                propNames[i++] = propertyName;
            }
            return propNames;
        }

        public PropertyDescriptor getPD(String propertyName) {
            return this.propMap.get(propertyName);
        }

        public boolean isValidProperty(String propertyName) {
            return this.propMap.get(propertyName.toLowerCase()) != null;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isFullyInitialized() {
            return this.fqName != null && this.voClass != null;
        }

        public boolean isAllColumns() {
            return this.allColumns;
        }

        public void setAllColumns(boolean allColumns) {
            this.allColumns = allColumns;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("VOInfo::[");
            buf.append(this.name);
            buf.append(']');
            return buf.toString();
        }

        public Class<?> getVoClass() {
            return this.voClass;
        }
    }
}

