/*
 * Decompiled with CFR 0.152.
 */
package clinical.web.helpers.security;

import clinical.server.dao.ConfDatabaseDAO;
import clinical.server.dao.ConfDbuserDAO;
import clinical.server.dao.ConfPrivilegeDAO;
import clinical.server.dao.ConfWebuserDAO;
import clinical.server.dao.ConfWebuserPrivDAO;
import clinical.server.dao.SiteDAO;
import clinical.server.vo.ConfDatabase;
import clinical.server.vo.ConfDbuser;
import clinical.server.vo.ConfPrivilege;
import clinical.server.vo.ConfWebuser;
import clinical.server.vo.ConfWebuserPriv;
import clinical.server.vo.Databaseuser;
import clinical.server.vo.Site;
import clinical.utils.Assertion;
import clinical.utils.GenUtils;
import clinical.web.ConnectionSupportMixin;
import clinical.web.DAOFactory;
import clinical.web.ISQLDialect;
import clinical.web.ISequenceHelper;
import clinical.web.MinimalServiceFactory;
import clinical.web.common.query.TSQLProcessor;
import clinical.web.common.security.DBConfig;
import clinical.web.common.security.Privilege;
import clinical.web.common.security.User;
import clinical.web.exception.BaseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.input.InputRequest;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class UsersXml2DBConverter {
    protected BufferedReader console;
    protected Project project;
    protected ConnectionSupportMixin csm;
    protected ISQLDialect sqlDialect;
    protected Connection con;
    protected DBConfig currentDBConfig;
    private Map<String, DBConfig> dbConfigMap = new LinkedHashMap<String, DBConfig>(7);
    private Map<String, Privilege> privilegesMap = new LinkedHashMap<String, Privilege>(23);

    public UsersXml2DBConverter() throws Exception {
        this(null);
    }

    public UsersXml2DBConverter(Project project) throws Exception {
        this.project = project;
        MinimalServiceFactory.setMimimalOpMode(true);
        this.csm = new ConnectionSupportMixin("users.xml");
        this.csm.startup();
        this.con = this.csm.getConnection();
        this.sqlDialect = this.csm.getSqlDialect();
        if (project == null) {
            this.console = new BufferedReader(new InputStreamReader(System.in));
        }
    }

    public void shutdown() throws Exception {
        if (this.csm != null) {
            this.csm.shutdown();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void populateDB(String usersXmlFile) throws Exception {
        this.loadDataFromUsersXml(usersXmlFile);
        TSQLProcessor tsp = new TSQLProcessor(this.sqlDialect);
        List<?> results = tsp.executeQuery(this.con, "select u.* from Databaseuser as u where u.name ='ADMIN' and u.isgroup = false");
        Assertion.assertFalse(results.isEmpty());
        Databaseuser dbUser = (Databaseuser)results.get(0);
        String dbID = this.csm.getDbID();
        ISequenceHelper sequenceHelper = MinimalServiceFactory.getSequenceHelper(dbID);
        ConfPrivilegeDAO cpDAO = DAOFactory.createConfPrivilegeDAO(dbID);
        ConfDatabaseDAO cdDAO = DAOFactory.createConfDatabaseDAO(dbID);
        SiteDAO siteDAO = DAOFactory.createSiteDAO(dbID);
        this.con.setAutoCommit(false);
        try {
            List<ConfPrivilege> existingPrivList = cpDAO.find(this.con, new ConfPrivilege());
            HashSet<String> existingPrivNames = new HashSet<String>(7);
            for (ConfPrivilege confPrivilege : existingPrivList) {
                existingPrivNames.add(confPrivilege.getName());
            }
            for (Privilege privilege : this.privilegesMap.values()) {
                if (existingPrivNames.contains(privilege.getName())) continue;
                ConfPrivilege cp = new ConfPrivilege();
                cp.setName(privilege.getName());
                cp.setDescription(privilege.getDescription());
                cp.setProjectSpecific(privilege.isProjSpec());
                cp.setModTime(new Date());
                cp.setOwner(dbUser.getUniqueid());
                cp.setModUser(dbUser.getUniqueid());
                System.out.println(cp);
                cpDAO.insert(this.con, cp);
            }
            boolean bl = false;
            List<ConfDatabase> existingCDList = cdDAO.find(this.con, new ConfDatabase());
            HashMap<String, ConfDatabase> existingDbIdMap = new HashMap<String, ConfDatabase>(7);
            for (ConfDatabase cd : existingCDList) {
                existingDbIdMap.put(cd.getDbId(), cd);
            }
            for (DBConfig dbConfig : this.dbConfigMap.values()) {
                void var12_18;
                BigDecimal dbUniqueId = new BigDecimal((int)var12_18);
                ConfDatabase cd = null;
                boolean newDB = true;
                if (existingDbIdMap.containsKey(dbConfig.getId())) {
                    cd = (ConfDatabase)existingDbIdMap.get(dbConfig.getId());
                    dbUniqueId = cd.getUniqueId();
                    newDB = false;
                } else {
                    Site siteCR = new Site();
                    siteCR.setSiteid(dbConfig.getSiteID());
                    List<Site> sites = siteDAO.find(this.con, siteCR);
                    Assertion.assertTrue(sites.size() == 1);
                    Site theSite = sites.get(0);
                    dbUniqueId = sequenceHelper.getNextUID(this.con, "nc_conf_database", "uniqueId");
                    cd = new ConfDatabase();
                    cd.setUniqueId(dbUniqueId);
                    cd.setDbId(dbConfig.getId());
                    cd.setDbType(dbConfig.getDbType());
                    cd.setIsDefault(new Boolean(dbConfig.isDefaultDB()));
                    cd.setDbUrl(dbConfig.getDbURL());
                    cd.setModTime(new Date());
                    cd.setOwner(dbUser.getUniqueid());
                    cd.setModUser(dbUser.getUniqueid());
                    cd.setForceSchemaOwnerCheck(new Boolean(false));
                    cd.setSiteUniqueId(theSite.getUniqueid());
                }
                if (newDB) {
                    System.out.println("adding " + cd);
                    cdDAO.insert(this.con, cd);
                }
                Map<String, User> dbUserMap = dbConfig.getDBUserMap();
                this.persistDBUsers(sequenceHelper, dbUniqueId, dbUserMap, dbUser);
                Map<String, User> webUserMap = dbConfig.getUserMap();
                this.persistWebUsers(dbUniqueId, sequenceHelper, webUserMap, dbUser);
                ++var12_18;
            }
            this.con.commit();
            System.out.println("finished populating HID with database and user admin data.");
        }
        catch (Exception x) {
            x.printStackTrace();
            this.con.rollback();
        }
    }

    protected void persistDBUsers(ISequenceHelper seqHelper, BigDecimal dbUniqueId, Map<String, User> dbUserMap, Databaseuser owner) throws Exception {
        ConfDbuserDAO dao = DAOFactory.createConfDBuserDAO(this.csm.getDbID());
        List<ConfDbuser> existingDBUserList = dao.find(this.con, new ConfDbuser());
        HashSet<String> existingDBUserSet = new HashSet<String>(7);
        for (ConfDbuser confDbuser : existingDBUserList) {
            existingDBUserSet.add(confDbuser.getName());
        }
        for (User user : dbUserMap.values()) {
            if (existingDBUserSet.contains(user.getName())) continue;
            BigDecimal uniqueId = seqHelper.getNextUID(this.con, "nc_conf_dbuser", "uniqueId");
            ConfDbuser cu = new ConfDbuser();
            cu.setUniqueId(uniqueId);
            cu.setName(user.getName());
            cu.setPwd(user.getPwd());
            cu.setDbUniqueId(dbUniqueId);
            cu.setModTime(new Date());
            cu.setOwner(owner.getUniqueid());
            cu.setModUser(owner.getUniqueid());
            System.out.println(cu);
            dao.insert(this.con, cu);
        }
    }

    protected void persistWebUsers(BigDecimal dbUniqueId, ISequenceHelper seqHelper, Map<String, User> webUserMap, Databaseuser owner) throws Exception {
        ConfWebuserDAO dao = DAOFactory.createConfWebuserDAO(this.csm.getDbID());
        ConfWebuserPrivDAO privDAO = DAOFactory.createConfWebuserPrivDAO(this.csm.getDbID());
        ConfDbuserDAO duDAO = DAOFactory.createConfDBuserDAO(this.csm.getDbID());
        ConfDbuser duCR = new ConfDbuser();
        duCR.setDbUniqueId(dbUniqueId);
        List<ConfDbuser> duList = duDAO.find(this.con, duCR);
        HashMap<String, ConfDbuser> duMap = new HashMap<String, ConfDbuser>(7);
        for (ConfDbuser du : duList) {
            duMap.put(du.getName(), du);
        }
        duList = null;
        List<ConfWebuser> existingWebUserList = dao.find(this.con, new ConfWebuser());
        HashSet<String> existingWebUserSet = new HashSet<String>(7);
        for (ConfWebuser wu : existingWebUserList) {
            existingWebUserSet.add(wu.getName());
        }
        int idx = 1;
        for (User webUser : webUserMap.values()) {
            if (existingWebUserSet.contains(webUser.getName())) {
                this.pwd2MD5(webUser, dao);
                continue;
            }
            ConfWebuser wu = new ConfWebuser();
            BigDecimal wuUniqueId = new BigDecimal(idx);
            wuUniqueId = seqHelper.getNextUID(this.con, "nc_conf_webuser", "uniqueId");
            wu.setUniqueId(wuUniqueId);
            wu.setDbUniqueId(dbUniqueId);
            wu.setName(webUser.getName());
            ConfDbuser du = (ConfDbuser)duMap.get(webUser.getDbUser().getName());
            Assertion.assertNotNull(du);
            wu.setDbuserId(du.getUniqueId());
            String digest = webUser.getPwd();
            if (!UsersXml2DBConverter.isAMD5Digest(webUser.getPwd())) {
                digest = GenUtils.getMD5Digest(webUser.getPwd());
            }
            wu.setPwd(digest);
            wu.setModTime(new Date());
            wu.setOwner(owner.getUniqueid());
            wu.setModUser(owner.getUniqueid());
            System.out.println(wu);
            dao.insert(this.con, wu);
            List<Privilege> privList = webUser.listPrivileges();
            int privIdx = 1;
            for (Privilege priv : privList) {
                ConfWebuserPriv cwp = new ConfWebuserPriv();
                BigDecimal privUniqueId = new BigDecimal(privIdx);
                privUniqueId = seqHelper.getNextUID(this.con, "nc_conf_webuser_priv", "uniqueId");
                cwp.setUniqueId(privUniqueId);
                cwp.setWebuserId(wuUniqueId);
                cwp.setPrivName(priv.getName());
                cwp.setModTime(new Date());
                cwp.setOwner(owner.getUniqueid());
                cwp.setModUser(owner.getUniqueid());
                System.out.println(cwp);
                privDAO.insert(this.con, cwp);
                ++privIdx;
            }
            ++idx;
        }
    }

    protected void pwd2MD5(User webUser, ConfWebuserDAO dao) throws Exception {
        ConfWebuser cr = new ConfWebuser();
        cr.setName(webUser.getName());
        List<ConfWebuser> list = dao.find(this.con, cr);
        if (list.isEmpty()) {
            return;
        }
        ConfWebuser wu = list.get(0);
        if (!UsersXml2DBConverter.isAMD5Digest(wu.getPwd())) {
            String digest = GenUtils.getMD5Digest(wu.getPwd());
            cr.setUniqueId(wu.getUniqueId());
            ConfWebuser bean = new ConfWebuser();
            bean.setPwd(digest);
            dao.update(this.con, bean, cr);
        }
    }

    public static boolean isAMD5Digest(String s) {
        if (s.length() != 32) {
            return false;
        }
        char[] carr = s.toCharArray();
        int i = 0;
        while (i < carr.length) {
            char c = carr[i];
            if (!Character.isDigit(c) && c != 'a' && c != 'b' && c != 'c' && c != 'd' && c != 'e' && c != 'f') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getInput(String prompt) throws IOException {
        String ans;
        while (true) {
            if (this.console != null) {
                System.out.print(prompt);
                String ans2 = this.console.readLine().trim();
                if (ans2.length() <= 0) continue;
                return ans2;
            }
            InputRequest request = new InputRequest(prompt);
            this.project.getInputHandler().handleInput(request);
            ans = request.getInput().trim();
            if (ans.length() > 0) break;
        }
        return ans;
    }

    public void loadDataFromUsersXml(String usersXmlFile) throws Exception {
        DBConfig dbConfig;
        SAXBuilder builder = null;
        builder = new SAXBuilder(false);
        Document doc = builder.build(new File(usersXmlFile));
        Element root = doc.getRootElement();
        Element databasesElem = root.getChild("databases");
        List dbChildren = databasesElem.getChildren("database");
        boolean first = true;
        for (Element elem : dbChildren) {
            String dbID = elem.getAttributeValue("id");
            String siteId = null;
            String siteName = null;
            if (elem.getAttribute("siteId") != null) {
                siteId = elem.getAttributeValue("siteId");
            }
            if (elem.getAttribute("siteName") != null) {
                siteName = elem.getAttributeValue("siteName");
            }
            if (siteName == null || siteId == null) {
                System.out.println("Site Information:");
                System.out.println("This information must match the corresponding row for '" + dbID + "' in nc_site table of your HID.");
                siteId = this.getInput("Zero padded four Digit SiteID (e.g. 0008):");
                siteName = this.getInput("Site Name (e.g. UCSD):");
            }
            dbConfig = new DBConfig(elem.getAttributeValue("id"), siteName, siteId);
            Element dbURLElem = elem.getChild("db-url");
            dbConfig.setDbURL(dbURLElem.getText().trim());
            this.dbConfigMap.put(dbConfig.getId(), dbConfig);
            Element dbTypeElem = elem.getChild("db-type");
            if (dbTypeElem != null) {
                dbConfig.setDbType(dbTypeElem.getText().trim());
            } else {
                dbConfig.setDbType("oracle");
            }
            if (first) {
                this.currentDBConfig = dbConfig;
                first = false;
            }
            if (elem.getAttribute("default") != null && elem.getAttributeValue("default").equalsIgnoreCase("true")) {
                this.currentDBConfig = dbConfig;
                dbConfig.setDefaultDB(true);
            }
            if (elem.getAttribute("force-schema-owner-check") == null || !elem.getAttributeValue("force-schema-owner-check").equalsIgnoreCase("true")) continue;
            dbConfig.setForceSchemaOwnerCheck(true);
        }
        this.currentDBConfig.setDefaultDB(true);
        Element dbUsersElem = root.getChild("dbusers");
        List children = dbUsersElem.getChildren("dbuser");
        for (Element elem : children) {
            String dbID = elem.getAttributeValue("dbid");
            dbConfig = this.dbConfigMap.get(dbID);
            if (dbConfig == null) {
                throw new BaseException(String.valueOf(dbID) + " is not a valid database id!");
            }
            User dbUser = new User(elem.getAttributeValue("name"), elem.getAttributeValue("pwd"));
            dbConfig.addDbUser(dbUser);
        }
        Element privsElem = root.getChild("privileges");
        children = privsElem.getChildren("privilege");
        for (Element elem : children) {
            String name = elem.getAttributeValue("name");
            boolean projSpec = false;
            if (elem.getAttribute("project-specific") != null) {
                projSpec = elem.getAttributeValue("project-specific").equalsIgnoreCase("true");
            }
            Privilege privilege = new Privilege(name, projSpec);
            Element descElem = elem.getChild("description");
            if (descElem != null) {
                privilege.setDescription(descElem.getText());
            }
            this.privilegesMap.put(name, privilege);
        }
        Element usersElem = root.getChild("users");
        children = usersElem.getChildren("user");
        for (Element elem : children) {
            String dbUserName = elem.getAttributeValue("dbuser");
            String dbID = elem.getAttributeValue("dbid");
            DBConfig dbConfig2 = this.dbConfigMap.get(dbID);
            if (dbConfig2 == null) {
                throw new BaseException(String.valueOf(dbID) + " is not a valid database id!");
            }
            User user = new User(elem.getAttributeValue("name"), elem.getAttributeValue("pwd"));
            User dbUser = dbConfig2.getDBUser(dbUserName);
            if (dbUser == null) {
                throw new BaseException("Database User <" + dbUserName + "> does not exists!");
            }
            user.setDbUser(dbUser);
            this.setUserPrivileges(elem, user);
            dbConfig2.addUser(user);
        }
    }

    protected void setUserPrivileges(Element userElm, User user) {
        Element privsElem = userElm.getChild("privileges");
        if (privsElem == null) {
            return;
        }
        List children = privsElem.getChildren("privilege");
        for (Element privElem : children) {
            if (privElem.getAttributeValue("name").equals("all")) {
                Iterator<Privilege> it2 = this.privilegesMap.values().iterator();
                while (it2.hasNext()) {
                    user.addPrivilege(it2.next());
                }
                break;
            }
            Privilege priv = this.privilegesMap.get(privElem.getAttributeValue("name"));
            if (priv == null) continue;
            user.addPrivilege(priv);
        }
    }

    public static void main(String[] args) throws Exception {
        UsersXml2DBConverter converter = null;
        String usersXmlFile = "/home/bozyurt/dev/java/BIRN/clinical/conf/users.xml";
        try {
            converter = new UsersXml2DBConverter();
            converter.populateDB(usersXmlFile);
        }
        finally {
            if (converter != null) {
                converter.shutdown();
            }
        }
    }
}

