/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.data;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DA_TM;
import org.dcm4che2.data.DateRange;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.DicomObjectSerializer;
import org.dcm4che2.data.DicomObjectToStringParam;
import org.dcm4che2.data.ElementSerializer;
import org.dcm4che2.data.FilteredDicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.util.DateUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractDicomObject
implements DicomObject {
    AbstractDicomObject() {
    }

    protected Object writeReplace() {
        return new DicomObjectSerializer(this);
    }

    @Override
    public void serializeElements(ObjectOutputStream oos) throws IOException {
        oos.writeObject(new ElementSerializer(this));
    }

    @Override
    public void copyTo(final DicomObject dest) {
        this.accept(new DicomObject.Visitor(){

            public boolean visit(DicomElement attr) {
                dest.add(attr);
                return true;
            }
        });
    }

    @Override
    public boolean containsAll(DicomObject keys) {
        return keys.accept(new DicomObject.Visitor(){

            public boolean visit(DicomElement key) {
                DicomObject itemKeys;
                DicomElement el = AbstractDicomObject.this.get(key.tag());
                if (el == null) {
                    return false;
                }
                if (key.hasDicomObjects() && (itemKeys = key.getDicomObject()) != null && !itemKeys.isEmpty()) {
                    if (!el.hasDicomObjects() || el.isEmpty()) {
                        return false;
                    }
                    int n = el.countItems();
                    for (int i = 0; i < n; ++i) {
                        if (el.getDicomObject(i).containsAll(itemKeys)) continue;
                        return false;
                    }
                }
                return true;
            }
        });
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        this.toStringBuffer(sb, null);
        return sb.toString();
    }

    @Override
    public int toStringBuffer(StringBuffer sb, DicomObjectToStringParam param) {
        if (sb == null) {
            throw new NullPointerException();
        }
        if (param == null) {
            param = DicomObjectToStringParam.getDefaultParam();
        }
        int lines = 0;
        Iterator<DicomElement> it = this.iterator();
        while (lines < param.numLines && it.hasNext()) {
            DicomElement e = it.next();
            if (++lines == param.numLines) {
                sb.append("...").append(param.lineSeparator);
                break;
            }
            int maxLen = sb.length() + param.lineLength;
            sb.append(param.indent);
            e.toStringBuffer(sb, param.valueLength);
            if (param.name) {
                sb.append(" ");
                sb.append(this.nameOf(e.tag()));
            }
            if (sb.length() > maxLen) {
                sb.setLength(maxLen);
            }
            sb.append(param.lineSeparator);
            if (e.countItems() <= 0) continue;
            DicomObjectToStringParam param1 = new DicomObjectToStringParam(param.name, param.valueLength, param.numItems, param.lineLength, param.numLines - lines, param.indent + '>', param.lineSeparator);
            if (e.hasDicomObjects()) {
                lines += AbstractDicomObject.itemsToStringBuffer(e, sb, param1);
                continue;
            }
            lines += AbstractDicomObject.fragsToStringBuffer(e, sb, param1);
        }
        return lines;
    }

    private static int fragsToStringBuffer(DicomElement e, StringBuffer sb, DicomObjectToStringParam param) {
        int lines = 0;
        int n = e.countItems();
        for (int i = 0; i < n; ++i) {
            if (++lines >= param.numLines) {
                sb.append("...").append(param.lineSeparator);
                break;
            }
            sb.append(param.indent);
            sb.append("ITEM #");
            sb.append(i + 1);
            if (i >= param.numItems) {
                sb.append("...").append(param.lineSeparator);
                break;
            }
            sb.append(" [");
            sb.append(e.getFragment(i).length + 1 & 0xFFFFFFFE);
            sb.append(" bytes]");
            sb.append(param.lineSeparator);
        }
        return lines;
    }

    private static int itemsToStringBuffer(DicomElement e, StringBuffer sb, DicomObjectToStringParam param) {
        DicomObjectToStringParam param1;
        DicomObject item;
        int lines = 0;
        int n = e.countItems();
        for (int i = 0; i < n && lines < param.numLines; lines += item.toStringBuffer(sb, param1), ++i) {
            if (++lines == param.numLines) {
                sb.append("...").append(param.lineSeparator);
                break;
            }
            item = e.getDicomObject(i);
            long off = item.getItemOffset();
            sb.append(param.indent);
            sb.append("ITEM #");
            sb.append(i + 1);
            if (i >= param.numItems) {
                sb.append("...").append(param.lineSeparator);
                break;
            }
            if (off != -1L) {
                sb.append(" @");
                sb.append(off);
            }
            sb.append(":");
            sb.append(param.lineSeparator);
            param1 = new DicomObjectToStringParam(param.name, param.valueLength, param.numItems, param.lineLength, param.numLines - lines, param.indent, param.lineSeparator);
        }
        return lines;
    }

    @Override
    public boolean matches(final DicomObject keys, final boolean ignoreCaseOfPN) {
        return keys.accept(new DicomObject.Visitor(){

            public boolean visit(DicomElement test) {
                if (test.isEmpty()) {
                    return true;
                }
                int tag = test.tag();
                DicomElement attr = AbstractDicomObject.this.get(tag);
                if (attr == null || attr.isEmpty()) {
                    return true;
                }
                VR vr = test.vr();
                if (vr instanceof VR.Fragment) {
                    return true;
                }
                if (vr == VR.SQ) {
                    return AbstractDicomObject.this.matchSQ(attr, test.getDicomObject(), ignoreCaseOfPN);
                }
                if (vr == VR.DA) {
                    int tmTag = DA_TM.getTMTag(tag);
                    return tmTag != 0 ? AbstractDicomObject.this.matchRange(AbstractDicomObject.this.getDates(tag, tmTag), keys.getDateRange(tag, tmTag)) : AbstractDicomObject.this.matchRange(attr.getDates(AbstractDicomObject.this.cacheGet()), test.getDateRange(keys.cacheGet()));
                }
                if (vr == VR.TM) {
                    int daTag = DA_TM.getDATag(tag);
                    return daTag != 0 && AbstractDicomObject.this.containsValue(daTag) ? true : AbstractDicomObject.this.matchRange(attr.getDates(AbstractDicomObject.this.cacheGet()), test.getDateRange(keys.cacheGet()));
                }
                if (vr == VR.DT) {
                    return AbstractDicomObject.this.matchRange(attr.getDates(AbstractDicomObject.this.cacheGet()), test.getDateRange(keys.cacheGet()));
                }
                return AbstractDicomObject.this.matchValue(attr.getStrings(AbstractDicomObject.this.getSpecificCharacterSet(), AbstractDicomObject.this.cacheGet()), test.getPattern(keys.getSpecificCharacterSet(), vr == VR.PN ? ignoreCaseOfPN : false, keys.cacheGet()));
            }
        });
    }

    private boolean matchValue(String[] value, Pattern pattern) {
        for (int i = 0; i < value.length; ++i) {
            if (!pattern.matcher(value[i]).matches()) continue;
            return true;
        }
        return false;
    }

    private boolean matchRange(Date[] dates, DateRange dateRange) {
        for (int i = 0; i < dates.length; ++i) {
            if (!this.matchRange(dates[i], dateRange.getStart(), dateRange.getEnd())) continue;
            return true;
        }
        return false;
    }

    private boolean matchRange(Date date, Date start, Date end) {
        if (start != null && start.after(date)) {
            return false;
        }
        return end == null || !end.before(date);
    }

    private boolean matchSQ(DicomElement sq, DicomObject keys, boolean ignoreCaseOfPN) {
        if (keys.isEmpty()) {
            return true;
        }
        int n = sq.countItems();
        for (int i = 0; i < n; ++i) {
            if (sq.getDicomObject(i).matches(keys, ignoreCaseOfPN)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isRoot() {
        return this.getParent() == null;
    }

    @Override
    public boolean isEmpty() {
        return this.accept(new DicomObject.Visitor(){

            public boolean visit(DicomElement attr) {
                return false;
            }
        });
    }

    @Override
    public int size() {
        final int[] count = new int[]{0};
        this.accept(new DicomObject.Visitor(){

            public boolean visit(DicomElement attr) {
                count[0] = count[0] + 1;
                return true;
            }
        });
        return count[0];
    }

    @Override
    public Iterator<DicomElement> commandIterator() {
        return this.iterator(0, 65535);
    }

    @Override
    public Iterator<DicomElement> fileMetaInfoIterator() {
        return this.iterator(131072, 196607);
    }

    @Override
    public Iterator<DicomElement> datasetIterator() {
        return this.iterator(196608, -1);
    }

    @Override
    public DicomObject command() {
        return this.subSet(0, 65535);
    }

    @Override
    public DicomObject dataset() {
        return this.subSet(196608, -1);
    }

    @Override
    public DicomObject fileMetaInfo() {
        return this.subSet(131072, 196607);
    }

    @Override
    public DicomObject exclude(int[] tags) {
        return tags != null && tags.length > 0 ? new FilteredDicomObject.Exclude(this, tags) : this;
    }

    @Override
    public DicomObject excludePrivate() {
        return new FilteredDicomObject.ExcludePrivate(this);
    }

    @Override
    public DicomObject subSet(DicomObject filter) {
        return filter != null ? new FilteredDicomObject.FilterSet(this, filter) : null;
    }

    @Override
    public DicomObject subSet(int fromTag, int toTag) {
        return new FilteredDicomObject.Range(this, fromTag, toTag);
    }

    @Override
    public DicomObject subSet(int[] tags) {
        return tags != null && tags.length > 0 ? new FilteredDicomObject.Include(this, tags) : this;
    }

    @Override
    public int vm(int tag) {
        DicomElement attr = this.get(tag);
        return attr != null ? attr.vm(this.getSpecificCharacterSet()) : -1;
    }

    @Override
    public boolean containsValue(int tag) {
        DicomElement attr = this.get(tag);
        return attr != null && !attr.isEmpty();
    }

    @Override
    public byte[] getBytes(int tag) {
        return this.toBytes(this.get(tag), false);
    }

    @Override
    public byte[] getBytes(int tag, boolean bigEndian) {
        return this.toBytes(this.get(tag), bigEndian);
    }

    private byte[] toBytes(DicomElement a, boolean bigEndian) {
        return a == null ? null : a.bigEndian(bigEndian).getBytes();
    }

    @Override
    public DicomObject getNestedDicomObject(int tag) {
        DicomElement a = this.get(tag);
        return a == null || a.isEmpty() ? null : a.getDicomObject();
    }

    @Override
    public int getInt(int tag) {
        return this.toInt(this.get(tag), 0);
    }

    @Override
    public int getInt(int tag, int defVal) {
        return this.toInt(this.get(tag), defVal);
    }

    private int toInt(DicomElement a, int defVal) {
        return a == null || a.isEmpty() ? defVal : a.getInt(this.cacheGet());
    }

    @Override
    public int[] getInts(int tag) {
        return this.toInts(this.get(tag));
    }

    @Override
    public int[] getInts(int tag, int[] defVal) {
        return this.toInts(this.get(tag), defVal);
    }

    private int[] toInts(DicomElement a) {
        return a == null ? null : a.getInts(this.cacheGet());
    }

    private int[] toInts(DicomElement a, int[] defVal) {
        return a == null || a.isEmpty() ? defVal : a.getInts(this.cacheGet());
    }

    @Override
    public short[] getShorts(int tag) {
        return this.toShorts(this.get(tag));
    }

    @Override
    public short[] getShorts(int tag, short[] defVal) {
        return this.toShorts(this.get(tag), defVal);
    }

    private short[] toShorts(DicomElement a) {
        return a == null ? null : a.getShorts(this.cacheGet());
    }

    private short[] toShorts(DicomElement a, short[] defVal) {
        return a == null || a.isEmpty() ? defVal : a.getShorts(this.cacheGet());
    }

    @Override
    public float getFloat(int tag) {
        return this.toFloat(this.get(tag), 0.0f);
    }

    @Override
    public float getFloat(int tag, float defVal) {
        return this.toFloat(this.get(tag), defVal);
    }

    private float toFloat(DicomElement a, float defVal) {
        return a == null || a.isEmpty() ? defVal : a.getFloat(this.cacheGet());
    }

    @Override
    public float[] getFloats(int tag) {
        return this.toFloats(this.get(tag));
    }

    @Override
    public float[] getFloats(int tag, float[] defVal) {
        return this.toFloats(this.get(tag), defVal);
    }

    private float[] toFloats(DicomElement a) {
        return a == null ? null : a.getFloats(this.cacheGet());
    }

    private float[] toFloats(DicomElement a, float[] defVal) {
        return a == null || a.isEmpty() ? defVal : a.getFloats(this.cacheGet());
    }

    @Override
    public double getDouble(int tag) {
        return this.toDouble(this.get(tag), 0.0);
    }

    @Override
    public double getDouble(int tag, double defVal) {
        return this.toDouble(this.get(tag), defVal);
    }

    private double toDouble(DicomElement a, double defVal) {
        return a == null || a.isEmpty() ? defVal : a.getDouble(this.cacheGet());
    }

    @Override
    public double[] getDoubles(int tag) {
        return this.toDoubles(this.get(tag));
    }

    @Override
    public double[] getDoubles(int tag, double[] defVal) {
        return this.toDoubles(this.get(tag), defVal);
    }

    private double[] toDoubles(DicomElement a) {
        return a == null ? null : a.getDoubles(this.cacheGet());
    }

    private double[] toDoubles(DicomElement a, double[] defVal) {
        return a == null || a.isEmpty() ? defVal : a.getDoubles(this.cacheGet());
    }

    @Override
    public String getString(int tag) {
        return this.toString(this.get(tag), null);
    }

    @Override
    public String getString(int tag, String defVal) {
        return this.toString(this.get(tag), defVal);
    }

    private String toString(DicomElement a, String defVal) {
        return a == null || a.isEmpty() ? defVal : a.getString(this.getSpecificCharacterSet(), this.cacheGet());
    }

    @Override
    public String[] getStrings(int tag) {
        return this.toStrings(this.get(tag));
    }

    @Override
    public String[] getStrings(int tag, String[] defVal) {
        return this.toStrings(this.get(tag), defVal);
    }

    private String[] toStrings(DicomElement a) {
        return a == null ? null : a.getStrings(this.getSpecificCharacterSet(), this.cacheGet());
    }

    private String[] toStrings(DicomElement a, String[] defVal) {
        return a == null || a.isEmpty() ? defVal : a.getStrings(this.getSpecificCharacterSet(), this.cacheGet());
    }

    @Override
    public Date getDate(int tag) {
        return this.toDate(this.get(tag), null);
    }

    @Override
    public Date getDate(int tag, Date defVal) {
        return this.toDate(this.get(tag), defVal);
    }

    private Date toDate(DicomElement a, Date defVal) {
        return a == null || a.isEmpty() ? defVal : a.getDate(this.cacheGet());
    }

    @Override
    public Date[] getDates(int tag) {
        return this.toDates(this.get(tag));
    }

    @Override
    public Date[] getDates(int tag, Date[] defVal) {
        return this.toDates(this.get(tag), defVal);
    }

    private Date[] toDates(DicomElement a) {
        return a == null ? null : a.getDates(this.cacheGet());
    }

    private Date[] toDates(DicomElement a, Date[] defVal) {
        return a == null || a.isEmpty() ? defVal : a.getDates(this.cacheGet());
    }

    @Override
    public DateRange getDateRange(int tag) {
        return this.toDateRange(this.get(tag), null);
    }

    @Override
    public DateRange getDateRange(int tag, DateRange defVal) {
        return this.toDateRange(this.get(tag), defVal);
    }

    private DateRange toDateRange(DicomElement a, DateRange defVal) {
        return a == null || a.isEmpty() ? defVal : a.getDateRange(this.cacheGet());
    }

    @Override
    public Date getDate(int daTag, int tmTag) {
        return this.getDate(daTag, tmTag, null);
    }

    @Override
    public Date getDate(int daTag, int tmTag, Date defVal) {
        Date da = this.getDate(daTag);
        return da == null ? defVal : DateUtils.toDateTime(da, this.getDate(tmTag));
    }

    @Override
    public Date[] getDates(int daTag, int tmTag) {
        return this.getDates(daTag, tmTag, null);
    }

    @Override
    public Date[] getDates(int daTag, int tmTag, Date[] defVal) {
        Date[] da = this.getDates(daTag);
        Date[] tm = this.getDates(tmTag);
        if (da == null) {
            return defVal;
        }
        if (tm != null) {
            int n = Math.min(da.length, tm.length);
            for (int i = 0; i < n; ++i) {
                da[i] = DateUtils.toDateTime(da[i], tm[i]);
            }
        }
        return da;
    }

    @Override
    public DateRange getDateRange(int daTag, int tmTag) {
        return this.getDateRange(daTag, tmTag, null);
    }

    @Override
    public DateRange getDateRange(int daTag, int tmTag, DateRange defVal) {
        DateRange da = this.getDateRange(daTag);
        if (da == null) {
            return defVal;
        }
        DateRange tm = this.getDateRange(tmTag);
        if (tm == null) {
            return da;
        }
        return new DateRange(DateUtils.toDateTime(da.getStart(), tm.getStart()), DateUtils.toDateTime(da.getEnd(), tm.getEnd()));
    }

    @Override
    public DicomElement get(int[] tagPath) {
        this.checkTagPathLength(tagPath);
        int last = tagPath.length - 1;
        DicomObject item = this.getItem(tagPath, last, true);
        return item != null ? item.get(tagPath[last]) : null;
    }

    @Override
    public DicomObject getNestedDicomObject(int[] itemPath) {
        if ((itemPath.length & 1) != 0) {
            throw new IllegalArgumentException("itemPath.length: " + itemPath.length);
        }
        return this.getItem(itemPath, itemPath.length, true);
    }

    private DicomObject getItem(int[] itemPath, int pathLen, boolean readonly) {
        DicomObject item = this;
        for (int i = 0; i < pathLen; ++i) {
            DicomElement sq = item.get(itemPath[i]);
            if (sq == null || !sq.hasItems()) {
                if (readonly) {
                    return null;
                }
                sq = item.putSequence(itemPath[i]);
            }
            while (sq.countItems() <= itemPath[i + 1]) {
                if (readonly) {
                    return null;
                }
                sq.addDicomObject(new BasicDicomObject());
            }
            item = sq.getDicomObject(itemPath[i + 1]);
            ++i;
        }
        return item;
    }

    @Override
    public byte[] getBytes(int[] tagPath) {
        return this.toBytes(this.get(tagPath), false);
    }

    @Override
    public byte[] getBytes(int[] tagPath, boolean bigEndian) {
        return this.toBytes(this.get(tagPath), bigEndian);
    }

    @Override
    public int getInt(int[] tagPath) {
        return this.toInt(this.get(tagPath), 0);
    }

    @Override
    public int getInt(int[] tagPath, int defVal) {
        return this.toInt(this.get(tagPath), defVal);
    }

    @Override
    public int[] getInts(int[] tagPath) {
        return this.toInts(this.get(tagPath));
    }

    @Override
    public int[] getInts(int[] tagPath, int[] defVal) {
        return this.toInts(this.get(tagPath), defVal);
    }

    @Override
    public short[] getShorts(int[] tagPath) {
        return this.toShorts(this.get(tagPath));
    }

    @Override
    public short[] getShorts(int[] tagPath, short[] defVal) {
        return this.toShorts(this.get(tagPath), defVal);
    }

    @Override
    public float getFloat(int[] tagPath) {
        return this.toFloat(this.get(tagPath), 0.0f);
    }

    @Override
    public float getFloat(int[] tagPath, float defVal) {
        return this.toFloat(this.get(tagPath), defVal);
    }

    @Override
    public float[] getFloats(int[] tagPath) {
        return this.toFloats(this.get(tagPath));
    }

    @Override
    public float[] getFloats(int[] tagPath, float[] defVal) {
        return this.toFloats(this.get(tagPath), defVal);
    }

    @Override
    public double getDouble(int[] tagPath) {
        return this.toDouble(this.get(tagPath), 0.0);
    }

    @Override
    public double getDouble(int[] tagPath, double defVal) {
        return this.toDouble(this.get(tagPath), defVal);
    }

    @Override
    public double[] getDoubles(int[] tagPath) {
        return this.toDoubles(this.get(tagPath));
    }

    @Override
    public double[] getDoubles(int[] tagPath, double[] defVal) {
        return this.toDoubles(this.get(tagPath), defVal);
    }

    @Override
    public String getString(int[] tagPath) {
        return this.toString(this.get(tagPath), null);
    }

    @Override
    public String getString(int[] tagPath, String defVal) {
        return this.toString(this.get(tagPath), defVal);
    }

    @Override
    public String[] getStrings(int[] tagPath) {
        return this.toStrings(this.get(tagPath));
    }

    @Override
    public String[] getStrings(int[] tagPath, String[] defVal) {
        return this.toStrings(this.get(tagPath), defVal);
    }

    @Override
    public Date getDate(int[] tagPath) {
        return this.toDate(this.get(tagPath), null);
    }

    @Override
    public Date getDate(int[] tagPath, Date defVal) {
        return this.toDate(this.get(tagPath), defVal);
    }

    @Override
    public Date[] getDates(int[] tagPath) {
        return this.toDates(this.get(tagPath));
    }

    @Override
    public Date[] getDates(int[] tagPath, Date[] defVal) {
        return this.toDates(this.get(tagPath), defVal);
    }

    @Override
    public DateRange getDateRange(int[] tagPath) {
        return this.toDateRange(this.get(tagPath), null);
    }

    @Override
    public DateRange getDateRange(int[] tagPath, DateRange defVal) {
        return this.toDateRange(this.get(tagPath), defVal);
    }

    @Override
    public Date getDate(int[] itemPath, int daTag, int tmTag) {
        return this.getDate(itemPath, daTag, tmTag, null);
    }

    @Override
    public Date getDate(int[] itemPath, int daTag, int tmTag, Date defVal) {
        DicomObject item = this.getNestedDicomObject(itemPath);
        return item != null ? item.getDate(daTag, tmTag, defVal) : null;
    }

    @Override
    public Date[] getDates(int[] itemPath, int daTag, int tmTag) {
        return this.getDates(itemPath, daTag, tmTag);
    }

    @Override
    public Date[] getDates(int[] itemPath, int daTag, int tmTag, Date[] defVal) {
        DicomObject item = this.getNestedDicomObject(itemPath);
        return item != null ? item.getDates(daTag, tmTag, defVal) : null;
    }

    @Override
    public DateRange getDateRange(int[] itemPath, int daTag, int tmTag) {
        return this.getDateRange(itemPath, daTag, tmTag, null);
    }

    @Override
    public DateRange getDateRange(int[] itemPath, int daTag, int tmTag, DateRange defVal) {
        DicomObject item = this.getNestedDicomObject(itemPath);
        return item != null ? item.getDateRange(daTag, tmTag, defVal) : null;
    }

    private void checkTagPathLength(int[] tagPath) {
        if ((tagPath.length & 1) == 0) {
            throw new IllegalArgumentException("tagPath.length: " + tagPath.length);
        }
    }

    @Override
    public DicomElement putBytes(int tag, VR vr, byte[] val) {
        return this.putBytes(tag, vr, val, false);
    }

    @Override
    public DicomElement putBytes(int[] tagPath, VR vr, byte[] val) {
        return this.putBytes(tagPath, vr, val);
    }

    @Override
    public DicomElement putBytes(int[] tagPath, VR vr, byte[] val, boolean bigEndian) {
        this.checkTagPathLength(tagPath);
        int last = tagPath.length - 1;
        DicomObject item = this.getItem(tagPath, last, false);
        return item.putBytes(tagPath[last], vr, val, bigEndian);
    }

    @Override
    public DicomElement putDate(int[] tagPath, VR vr, Date val) {
        this.checkTagPathLength(tagPath);
        int last = tagPath.length - 1;
        DicomObject item = this.getItem(tagPath, last, false);
        return item.putDate(tagPath[last], vr, val);
    }

    @Override
    public DicomElement putDateRange(int[] tagPath, VR vr, DateRange val) {
        this.checkTagPathLength(tagPath);
        int last = tagPath.length - 1;
        DicomObject item = this.getItem(tagPath, last, false);
        return item.putDateRange(tagPath[last], vr, val);
    }

    @Override
    public DicomElement putDates(int[] tagPath, VR vr, Date[] val) {
        this.checkTagPathLength(tagPath);
        int last = tagPath.length - 1;
        DicomObject item = this.getItem(tagPath, last, false);
        return item.putDates(tagPath[last], vr, val);
    }

    @Override
    public DicomElement putDouble(int[] tagPath, VR vr, double val) {
        this.checkTagPathLength(tagPath);
        int last = tagPath.length - 1;
        DicomObject item = this.getItem(tagPath, last, false);
        return item.putDouble(tagPath[last], vr, val);
    }

    @Override
    public DicomElement putDoubles(int[] tagPath, VR vr, double[] val) {
        this.checkTagPathLength(tagPath);
        int last = tagPath.length - 1;
        DicomObject item = this.getItem(tagPath, last, false);
        return item.putDoubles(tagPath[last], vr, val);
    }

    @Override
    public DicomElement putFloat(int[] tagPath, VR vr, float val) {
        this.checkTagPathLength(tagPath);
        int last = tagPath.length - 1;
        DicomObject item = this.getItem(tagPath, last, false);
        return item.putFloat(tagPath[last], vr, val);
    }

    @Override
    public DicomElement putFloats(int[] tagPath, VR vr, float[] val) {
        this.checkTagPathLength(tagPath);
        int last = tagPath.length - 1;
        DicomObject item = this.getItem(tagPath, last, false);
        return item.putFloats(tagPath[last], vr, val);
    }

    @Override
    public DicomElement putFragments(int[] tagPath, VR vr, boolean bigEndian, int capacity) {
        this.checkTagPathLength(tagPath);
        int last = tagPath.length - 1;
        DicomObject item = this.getItem(tagPath, last, false);
        return item.putFragments(tagPath[last], vr, bigEndian, capacity);
    }

    @Override
    public DicomElement putFragments(int[] tagPath, VR vr, boolean bigEndian) {
        this.checkTagPathLength(tagPath);
        int last = tagPath.length - 1;
        DicomObject item = this.getItem(tagPath, last, false);
        return item.putFragments(tagPath[last], vr, bigEndian);
    }

    @Override
    public DicomElement putShorts(int[] tagPath, VR vr, short[] val) {
        this.checkTagPathLength(tagPath);
        int last = tagPath.length - 1;
        DicomObject item = this.getItem(tagPath, last, false);
        return item.putShorts(tagPath[last], vr, val);
    }

    @Override
    public DicomElement putInt(int[] tagPath, VR vr, int val) {
        this.checkTagPathLength(tagPath);
        int last = tagPath.length - 1;
        DicomObject item = this.getItem(tagPath, last, false);
        return item.putInt(tagPath[last], vr, val);
    }

    @Override
    public DicomElement putInts(int[] tagPath, VR vr, int[] val) {
        this.checkTagPathLength(tagPath);
        int last = tagPath.length - 1;
        DicomObject item = this.getItem(tagPath, last, false);
        return item.putInts(tagPath[last], vr, val);
    }

    @Override
    public DicomElement putNestedDicomObject(int[] tagPath, DicomObject item) {
        this.checkTagPathLength(tagPath);
        int last = tagPath.length - 1;
        DicomObject parent = this.getItem(tagPath, last, false);
        return parent.putNestedDicomObject(tagPath[last], item);
    }

    @Override
    public DicomElement putNull(int[] tagPath, VR vr) {
        this.checkTagPathLength(tagPath);
        int last = tagPath.length - 1;
        DicomObject item = this.getItem(tagPath, last, false);
        return item.putNull(tagPath[last], vr);
    }

    @Override
    public DicomElement putSequence(int[] tagPath, int capacity) {
        this.checkTagPathLength(tagPath);
        int last = tagPath.length - 1;
        DicomObject item = this.getItem(tagPath, last, false);
        return item.putSequence(tagPath[last], capacity);
    }

    @Override
    public DicomElement putSequence(int[] tagPath) {
        this.checkTagPathLength(tagPath);
        int last = tagPath.length - 1;
        DicomObject item = this.getItem(tagPath, last, false);
        return item.putSequence(tagPath[last]);
    }

    @Override
    public DicomElement putString(int[] tagPath, VR vr, String val) {
        this.checkTagPathLength(tagPath);
        int last = tagPath.length - 1;
        DicomObject item = this.getItem(tagPath, last, false);
        return item.putString(tagPath[last], vr, val);
    }

    @Override
    public DicomElement putStrings(int[] tagPath, VR vr, String[] val) {
        this.checkTagPathLength(tagPath);
        int last = tagPath.length - 1;
        DicomObject item = this.getItem(tagPath, last, false);
        return item.putStrings(tagPath[last], vr, val);
    }
}

