/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.data;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.List;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.dcm4che2.data.ConfigurationError;
import org.dcm4che2.data.ResourceLocator;
import org.dcm4che2.util.IntHashtable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ElementDictionary
implements Serializable {
    private static final long serialVersionUID = 2010071664961951181L;
    private static final String USAGE = "Usage: mkelmdic <xml-file> <resource-file>\n         (Store serialized dictionary in <resource-file>).\n       mkelmdic <xml-file> <resource-name> <zip-file>\n         (Create <zip-file> with serialized dictionary under <resource-name>\n          and appendant META-INF/dcm4che/org.dcm4che2.data.ElementDictionary.)\n";
    private static String unkown = "?";
    public static final String PRIVATE_CREATOR = "Private Creator Data Element";
    public static final String GROUP_LENGTH = "Group Length";
    private static final ElementDictionary EMPTY = new ElementDictionary();
    private static ElementDictionary stdDict;
    private static Hashtable<String, ElementDictionary> privDicts;
    private transient IntHashtable<String> table;
    private transient String tagClassName;
    private transient String privateCreator;
    private Class<?> tagClass;

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println(USAGE);
            System.exit(1);
        }
        ElementDictionary dict = new ElementDictionary(2300);
        try {
            dict.loadXML(new File(args[0]));
            if (args.length > 2) {
                ResourceLocator.createResource(args[1], dict, new File(args[2]));
                System.out.println("Create Dictionary Resource  - " + args[2]);
            } else {
                ResourceLocator.serializeTo(dict, new File(args[1]));
                System.out.println("Serialize Dictionary to - " + args[1]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void reloadDictionaries() {
        ElementDictionary newStdDict = null;
        Hashtable<String, ElementDictionary> newPrivDicts = new Hashtable<String, ElementDictionary>();
        List<String> list = ResourceLocator.findResources(ElementDictionary.class);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ElementDictionary d = (ElementDictionary)ResourceLocator.loadResource(list.get(i));
            if (d.getPrivateCreator() == null) {
                newStdDict = d;
                continue;
            }
            newPrivDicts.put(d.getPrivateCreator(), d);
        }
        stdDict = newStdDict;
        privDicts = newPrivDicts;
    }

    public static void loadDictionary(String resourceName) {
        ElementDictionary d = (ElementDictionary)ResourceLocator.loadResource(resourceName);
        if (d.getPrivateCreator() == null) {
            stdDict = d;
        } else {
            privDicts.put(d.getPrivateCreator(), d);
        }
    }

    public static final String getUnkown() {
        return unkown;
    }

    public static final void setUnkown(String unkown) {
        ElementDictionary.unkown = unkown;
    }

    public final String getPrivateCreator() {
        return this.privateCreator;
    }

    public final String getTagClassName() {
        return this.tagClassName;
    }

    public static ElementDictionary getDictionary() {
        return ElementDictionary.maskNull(stdDict);
    }

    public static ElementDictionary getPrivateDictionary(String creatorID) {
        return ElementDictionary.maskNull(creatorID != null && creatorID.length() != 0 ? privDicts.get(creatorID) : stdDict);
    }

    private static ElementDictionary maskNull(ElementDictionary dict) {
        return dict != null ? dict : EMPTY;
    }

    private ElementDictionary() {
    }

    private ElementDictionary(int initialCapacity) {
        this.table = new IntHashtable(initialCapacity);
    }

    private void writeObject(final ObjectOutputStream os) throws IOException {
        os.defaultWriteObject();
        os.writeObject(this.tagClassName);
        os.writeObject(this.privateCreator);
        os.writeInt(this.table.size());
        try {
            this.table.accept(new IntHashtable.Visitor(){

                public boolean visit(int key, Object value) {
                    try {
                        os.writeInt(key);
                        os.writeUTF((String)value);
                        return true;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (Exception e) {
            throw (IOException)e;
        }
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        is.defaultReadObject();
        this.tagClassName = (String)is.readObject();
        this.privateCreator = (String)is.readObject();
        int size = is.readInt();
        this.table = new IntHashtable(size);
        for (int i = 0; i < size; ++i) {
            int tag = is.readInt();
            this.table.put(tag, is.readUTF());
        }
    }

    public String nameOf(int tag) {
        if ((tag & 0xFFFF) == 0) {
            return GROUP_LENGTH;
        }
        if ((tag & 0x10000) != 0) {
            if ((tag & 0xFF00) == 0) {
                return PRIVATE_CREATOR;
            }
            tag &= 0xFFFF00FF;
        } else if ((tag & 0xFFFFFF00) == 2109696) {
            tag &= 0xFFFFFF00;
        } else {
            int ggg00000 = tag & 0xFFE00000;
            if (ggg00000 == 0x50000000 || ggg00000 == 0x60000000) {
                tag &= 0xFF00FFFF;
            }
        }
        if (this.table == null) {
            return unkown;
        }
        String name = this.table.get(tag);
        return name != null ? name : unkown;
    }

    public int tagForName(String name) {
        if (this.tagClassName == null) {
            throw new UnsupportedOperationException("No tag class associated to dictionary");
        }
        try {
            if (this.tagClass == null) {
                this.tagClass = ResourceLocator.loadClass(this.tagClassName);
            }
            return this.tagClass.getField(name).getInt(null);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("Unknown Tag Name: " + name);
        }
        catch (Exception e) {
            throw new ConfigurationError(e);
        }
    }

    public void loadXML(File f) throws IOException, SAXException {
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(f, (DefaultHandler)new SAXAdapter());
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            ElementDictionary.reloadDictionaries();
        }
        catch (Throwable e) {
            e.printStackTrace();
            while (e.getCause() != null) {
                e = e.getCause();
                e.printStackTrace();
            }
        }
    }

    private final class SAXAdapter
    extends DefaultHandler {
        int tag = -1;
        StringBuffer name = new StringBuffer(80);

        private SAXAdapter() {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.tag != -1) {
                this.name.append(ch, start, length);
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("element".equals(qName)) {
                this.tag = (int)Long.parseLong(attributes.getValue("tag").replace('x', '0'), 16);
            } else if ("dictionary".equals(qName)) {
                ElementDictionary.this.tagClassName = attributes.getValue("tagclass");
                ElementDictionary.this.privateCreator = attributes.getValue("creator");
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("element".equals(qName)) {
                ElementDictionary.this.table.put(this.tag, this.name.toString());
                this.name.setLength(0);
                this.tag = -1;
            }
        }
    }
}

