/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.media;

import java.io.File;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.media.FileMetaInformation;
import org.dcm4che2.util.StringUtils;
import org.dcm4che2.util.UIDUtils;

public class FilesetInformation
extends FileMetaInformation {
    public static final int NO_KNOWN_INCONSISTENCIES = 0;
    public static final int KNOWN_INCONSISTENCIES = 65535;

    public FilesetInformation(DicomObject dcmobj) {
        super(dcmobj);
    }

    public FilesetInformation() {
    }

    public void init() {
        super.init();
        this.dcmobj.putNull(266544, VR.CS);
        this.setOffsetFirstRootRecord(0);
        this.setOffsetLastRootRecord(0);
        this.setFilesetConsistencyFlag(0);
    }

    public String getFilesetID() {
        return this.dcmobj.getString(266544);
    }

    public void setFilesetID(String id) {
        this.dcmobj.putString(266544, VR.CS, id);
    }

    public String[] getFilesetDescriptorFileID() {
        return this.dcmobj.getStrings(266561);
    }

    public void setFilesetDescriptorFileID(String[] cs) {
        this.dcmobj.putStrings(266561, VR.CS, cs);
    }

    public File getFilesetDescriptorFile(File basedir) {
        return FilesetInformation.toFile(this.getFilesetDescriptorFileID(), basedir);
    }

    public void setFilesetDescriptorFile(File file, File basedir) {
        this.setFilesetDescriptorFileID(FilesetInformation.toFileID(file, basedir));
    }

    public String getSpecificCharacterSetofFilesetDescriptorFile() {
        return this.dcmobj.getString(266562);
    }

    public void setSpecificCharacterSetofFilesetDescriptorFile(String cs) {
        this.dcmobj.putString(266544, VR.CS, cs);
    }

    public int getOffsetFirstRootRecord() {
        return this.dcmobj.getInt(266752);
    }

    public void setOffsetFirstRootRecord(int offset) {
        this.dcmobj.putInt(266752, VR.UL, offset);
    }

    public int getOffsetLastRootRecord() {
        return this.dcmobj.getInt(266754);
    }

    public void setOffsetLastRootRecord(int offset) {
        this.dcmobj.putInt(266754, VR.UL, offset);
    }

    public boolean isEmpty() {
        return this.getOffsetFirstRootRecord() == 0;
    }

    public int getFilesetConsistencyFlag() {
        return this.dcmobj.getInt(266770);
    }

    public void setFilesetConsistencyFlag(int flag) {
        this.dcmobj.putInt(266770, VR.US, flag);
    }

    public boolean isNoKnownInconsistencies() {
        return this.getFilesetConsistencyFlag() == 0;
    }

    protected String getSOPClassUID() {
        return "1.2.840.10008.1.3.10";
    }

    protected String getSOPInstanceUID() {
        return UIDUtils.createUID();
    }

    public static File toFile(String[] fileID, File basedir) {
        if (fileID == null || fileID.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer(basedir.getPath());
        for (int i = 0; i < fileID.length; ++i) {
            sb.append(File.separatorChar).append(fileID[i]);
        }
        return new File(sb.toString());
    }

    public static String[] toFileID(File file, File basedir) {
        String dirpath = basedir.getAbsolutePath();
        String filepath = file.getAbsolutePath();
        int start = dirpath.length();
        if (!filepath.startsWith(dirpath) || start == filepath.length()) {
            throw new IllegalArgumentException("file " + file + " not included in file-set " + basedir);
        }
        if (filepath.charAt(start) == File.separatorChar) {
            ++start;
        }
        return StringUtils.split(filepath.substring(start), File.separatorChar);
    }
}

