/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.binding.soap;

import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPBinding;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.Soap12;
import org.apache.cxf.binding.soap.model.SoapBindingInfo;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxws.binding.BindingImpl;
import org.apache.cxf.service.model.BindingInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPBindingImpl
extends BindingImpl
implements SOAPBinding {
    private static final Logger LOG = LogUtils.getL7dLogger(SOAPBindingImpl.class);
    private static final ResourceBundle BUNDLE = LOG.getResourceBundle();
    private BindingInfo soapBinding;
    private Set<String> roles;

    public SOAPBindingImpl(BindingInfo sb) {
        this.soapBinding = sb;
        this.addRequiredRoles();
    }

    private void addRequiredRoles() {
        if (this.roles == null) {
            this.roles = new HashSet<String>();
        }
        if (this.soapBinding instanceof SoapBindingInfo) {
            SoapBindingInfo bindingInfo = (SoapBindingInfo)this.soapBinding;
            if (bindingInfo.getSoapVersion() instanceof Soap11) {
                this.roles.add(bindingInfo.getSoapVersion().getNextRole());
            } else if (bindingInfo.getSoapVersion() instanceof Soap12) {
                this.roles.add(bindingInfo.getSoapVersion().getNextRole());
                this.roles.add(bindingInfo.getSoapVersion().getUltimateReceiverRole());
            }
        }
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<String> set) {
        if (set != null && (set.contains(Soap11.getInstance().getNoneRole()) || set.contains(Soap12.getInstance().getNoneRole()))) {
            throw new WebServiceException(BUNDLE.getString("NONE_ROLE_ERR"));
        }
        this.roles = set;
        this.addRequiredRoles();
    }

    public boolean isMTOMEnabled() {
        return Boolean.TRUE.equals(this.soapBinding.getProperty("mtom-enabled"));
    }

    public void setMTOMEnabled(boolean flag) {
        this.soapBinding.setProperty("mtom-enabled", flag);
    }

    public MessageFactory getMessageFactory() {
        if (this.soapBinding instanceof SoapBindingInfo) {
            SoapBindingInfo bindingInfo = (SoapBindingInfo)this.soapBinding;
            try {
                if (bindingInfo.getSoapVersion() instanceof Soap11) {
                    return MessageFactory.newInstance();
                }
                if (bindingInfo.getSoapVersion() instanceof Soap12) {
                    return MessageFactory.newInstance((String)"SOAP 1.2 Protocol");
                }
            }
            catch (SOAPException e) {
                throw new WebServiceException(BUNDLE.getString("SAAJ_FACTORY_ERR"), (Throwable)e);
            }
        }
        return null;
    }

    public SOAPFactory getSOAPFactory() {
        if (this.soapBinding instanceof SoapBindingInfo) {
            SoapBindingInfo bindingInfo = (SoapBindingInfo)this.soapBinding;
            try {
                if (bindingInfo.getSoapVersion() instanceof Soap11) {
                    return SOAPFactory.newInstance();
                }
                if (bindingInfo.getSoapVersion() instanceof Soap12) {
                    return SOAPFactory.newInstance((String)"SOAP 1.2 Protocol");
                }
            }
            catch (SOAPException e) {
                throw new WebServiceException(BUNDLE.getString("SAAJ_FACTORY_ERR"), (Throwable)e);
            }
        }
        return null;
    }
}

