/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.interceptors;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlElement;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxb.JAXBUtils;
import org.apache.cxf.jaxws.interceptors.WrapperHelperCompiler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WrapperHelper {
    private static final Class[] NO_PARAMS = new Class[0];

    public abstract Object createWrapperObject(List<?> var1) throws Fault;

    public abstract List<Object> getWrapperParts(Object var1) throws Fault;

    public static WrapperHelper createWrapperHelper(Class<?> wrapperType, List<String> partNames, List<String> elTypeNames, List<Class<?>> partClasses) {
        ArrayList<Method> getMethods = new ArrayList<Method>(partNames.size());
        ArrayList<Method> setMethods = new ArrayList<Method>(partNames.size());
        ArrayList<Method> jaxbMethods = new ArrayList<Method>(partNames.size());
        ArrayList<Field> fields = new ArrayList<Field>(partNames.size());
        Method[] allMethods = wrapperType.getMethods();
        String objectFactoryClassName = wrapperType.getPackage().getName() + ".ObjectFactory";
        Object objectFactory = null;
        try {
            objectFactory = wrapperType.getClassLoader().loadClass(objectFactoryClassName).newInstance();
        }
        catch (Exception e) {
            // empty catch block
        }
        Method[] allOFMethods = objectFactory != null ? objectFactory.getClass().getMethods() : new Method[]{};
        for (int x = 0; x < partNames.size(); ++x) {
            String partName = partNames.get(x);
            if (partName == null) {
                getMethods.add(null);
                setMethods.add(null);
                fields.add(null);
                jaxbMethods.add(null);
                continue;
            }
            String elementType = elTypeNames.get(x);
            String getAccessor = JAXBUtils.nameToIdentifier(partName, JAXBUtils.IdentifierType.GETTER);
            String setAccessor = JAXBUtils.nameToIdentifier(partName, JAXBUtils.IdentifierType.SETTER);
            Method getMethod = null;
            Method setMethod = null;
            try {
                getMethod = wrapperType.getMethod(getAccessor, NO_PARAMS);
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
            Field elField = WrapperHelper.getElField(partName, wrapperType);
            if (getMethod == null && elementType != null && "boolean".equals(elementType.toLowerCase()) && (elField == null || !Collection.class.isAssignableFrom(elField.getType()) && !elField.getType().isArray())) {
                try {
                    String newAcc = getAccessor.replaceFirst("get", "is");
                    getMethod = wrapperType.getMethod(newAcc, NO_PARAMS);
                }
                catch (NoSuchMethodException ex) {
                    // empty catch block
                }
            }
            if (getMethod == null && "return".equals(partName)) {
                try {
                    getMethod = wrapperType.getMethod("get_return", NO_PARAMS);
                }
                catch (NoSuchMethodException ex) {
                    try {
                        getMethod = wrapperType.getMethod("is_return", new Class[0]);
                    }
                    catch (NoSuchMethodException ex2) {
                        // empty catch block
                    }
                }
            }
            String setAccessor2 = setAccessor;
            if ("return".equals(partName)) {
                setAccessor2 = "set_return";
            }
            for (Method method : allMethods) {
                if (method.getParameterTypes() == null || method.getParameterTypes().length != 1 || !setAccessor.equals(method.getName()) && !setAccessor2.equals(method.getName())) continue;
                setMethod = method;
                break;
            }
            getMethods.add(getMethod);
            setMethods.add(setMethod);
            if (setMethod != null && JAXBElement.class.isAssignableFrom(setMethod.getParameterTypes()[0])) {
                String methodName = "create" + wrapperType.getSimpleName() + setMethod.getName().substring(3);
                for (Method m : allOFMethods) {
                    if (!m.getName().equals(methodName)) continue;
                    jaxbMethods.add(m);
                }
            } else {
                jaxbMethods.add(null);
            }
            if (elField != null) {
                XmlElement el = elField.getAnnotation(XmlElement.class);
                if (el != null && partName.equals(el.name())) {
                    elField.setAccessible(true);
                    fields.add(elField);
                    continue;
                }
                fields.add(null);
                continue;
            }
            fields.add(null);
        }
        return WrapperHelper.createWrapperHelper(wrapperType, setMethods.toArray(new Method[setMethods.size()]), getMethods.toArray(new Method[getMethods.size()]), jaxbMethods.toArray(new Method[jaxbMethods.size()]), fields.toArray(new Field[fields.size()]), objectFactory);
    }

    private static Field getElField(String partName, Class<?> wrapperType) {
        String fieldName = JAXBUtils.nameToIdentifier(partName, JAXBUtils.IdentifierType.VARIABLE);
        for (Field field : wrapperType.getDeclaredFields()) {
            XmlElement el = field.getAnnotation(XmlElement.class);
            if (el != null && partName.equals(el.name())) {
                return field;
            }
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    private static Object getValue(Method method, Object in) throws IllegalAccessException, InvocationTargetException {
        if ("javax.xml.bind.JAXBElement".equals(method.getReturnType().getCanonicalName())) {
            JAXBElement je = (JAXBElement)method.invoke(in, new Object[0]);
            return je == null ? je : je.getValue();
        }
        return method.invoke(in, new Object[0]);
    }

    private static WrapperHelper createWrapperHelper(Class<?> wrapperType, Method[] setMethods, Method[] getMethods, Method[] jaxbMethods, Field[] fields, Object objectFactory) {
        WrapperHelper wh = WrapperHelper.compileWrapperHelper(wrapperType, setMethods, getMethods, jaxbMethods, fields, objectFactory);
        if (wh == null) {
            wh = new ReflectWrapperHelper(wrapperType, setMethods, getMethods, jaxbMethods, fields, objectFactory);
        }
        return wh;
    }

    private static WrapperHelper compileWrapperHelper(Class<?> wrapperType, Method[] setMethods, Method[] getMethods, Method[] jaxbMethods, Field[] fields, Object objectFactory) {
        try {
            Class.forName("org.objectweb.asm.ClassWriter");
            return WrapperHelperCompiler.compileWrapperHelper(wrapperType, setMethods, getMethods, jaxbMethods, fields, objectFactory);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ReflectWrapperHelper
    extends WrapperHelper {
        final Class<?> wrapperType;
        final Method[] setMethods;
        final Method[] getMethods;
        final Method[] jaxbObjectMethods;
        final Field[] fields;
        final Object objectFactory;

        ReflectWrapperHelper(Class<?> wt, Method[] sets, Method[] gets, Method[] jaxbs, Field[] f, Object of) {
            this.setMethods = sets;
            this.getMethods = gets;
            this.fields = f;
            this.jaxbObjectMethods = jaxbs;
            this.wrapperType = wt;
            this.objectFactory = of;
        }

        @Override
        public Object createWrapperObject(List<?> lst) throws Fault {
            try {
                Object ret = this.wrapperType.newInstance();
                for (int x = 0; x < this.setMethods.length; ++x) {
                    if (this.setMethods[x] == null && this.fields[x] == null) continue;
                    Object o = lst.get(x);
                    if (this.jaxbObjectMethods[x] != null) {
                        o = this.jaxbObjectMethods[x].invoke(this.objectFactory, o);
                    }
                    if (o instanceof List) {
                        List col = CastUtils.cast((List)this.getMethods[x].invoke(ret, new Object[0]));
                        if (col == null) {
                            if (this.setMethods[x] != null) {
                                this.setMethods[x].invoke(ret, o);
                                continue;
                            }
                            this.fields[x].set(ret, lst.get(x));
                            continue;
                        }
                        List olst = CastUtils.cast((List)o);
                        col.addAll(olst);
                        continue;
                    }
                    if (this.setMethods[x] != null) {
                        this.setMethods[x].invoke(ret, o);
                        continue;
                    }
                    if (this.fields[x] == null) continue;
                    this.fields[x].set(ret, lst.get(x));
                }
                return ret;
            }
            catch (Exception ex) {
                throw new Fault(ex);
            }
        }

        @Override
        public List<Object> getWrapperParts(Object o) throws Fault {
            try {
                ArrayList<Object> ret = new ArrayList<Object>(this.getMethods.length);
                for (int x = 0; x < this.getMethods.length; ++x) {
                    if (this.getMethods[x] != null) {
                        ret.add(WrapperHelper.getValue(this.getMethods[x], o));
                        continue;
                    }
                    if (this.fields[x] != null) {
                        ret.add(this.fields[x].get(o));
                        continue;
                    }
                    ret.add(null);
                }
                return ret;
            }
            catch (Exception ex) {
                throw new Fault(ex);
            }
        }
    }
}

