/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http_jetty;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.URL;
import java.nio.channels.ServerSocketChannel;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.transport.HttpUriMapper;
import org.apache.cxf.transport.http_jetty.JettyConnectorFactory;
import org.apache.cxf.transport.http_jetty.JettyHTTPHandler;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngineFactory;
import org.apache.cxf.transport.http_jetty.ServerEngine;
import org.apache.cxf.transport.http_jetty.ThreadingParameters;
import org.apache.cxf.transport.https_jetty.JettySslConnectorFactory;
import org.mortbay.jetty.AbstractConnector;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.SessionIdManager;
import org.mortbay.jetty.SessionManager;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.handler.DefaultHandler;
import org.mortbay.jetty.handler.HandlerList;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.security.SslSocketConnector;
import org.mortbay.jetty.servlet.HashSessionIdManager;
import org.mortbay.jetty.servlet.HashSessionManager;
import org.mortbay.jetty.servlet.SessionHandler;
import org.mortbay.thread.BoundedThreadPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyHTTPServerEngine
implements ServerEngine {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogUtils.getL7dLogger(JettyHTTPServerEngine.class);
    private Bus bus;
    private JettyHTTPServerEngineFactory factory;
    private int port;
    private String protocol = "http";
    private Boolean isSessionSupport = false;
    private Boolean isReuseAddress = true;
    private int servantCount;
    private Server server;
    private Connector connector;
    private List<Handler> handlers;
    private JettyConnectorFactory connectorFactory;
    private ContextHandlerCollection contexts;
    private TLSServerParameters tlsServerParameters;
    private ThreadingParameters threadingParameters;
    private boolean configFinalized;

    JettyHTTPServerEngine(JettyHTTPServerEngineFactory fac, Bus bus, int port) {
        this.bus = bus;
        this.factory = fac;
        this.port = port;
    }

    public JettyHTTPServerEngine() {
    }

    public void setJettyHTTPServerEngineFactory(JettyHTTPServerEngineFactory fac) {
        this.factory = fac;
    }

    public void setPort(int p) {
        this.port = p;
    }

    @Resource(name="bus")
    public void setBus(Bus b) {
        this.bus = b;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public int getPort() {
        return this.port;
    }

    public void shutdown() {
        if (this.shouldDestroyPort()) {
            if (this.factory != null && this.servantCount == 0) {
                this.factory.destroyForPort(this.port);
            } else {
                LOG.log(Level.WARNING, "FAILED_TO_SHUTDOWN_ENGINE_MSG", this.port);
            }
        }
    }

    private boolean shouldDestroyPort() {
        String s = System.getProperty("org.apache.cxf.transports.http_jetty.DontClosePort");
        return Boolean.valueOf(s) == false;
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server s) {
        this.server = s;
    }

    public void setConnector(Connector c) {
        this.connector = c;
    }

    public void setHandlers(List<Handler> h) {
        this.handlers = h;
    }

    public void setSessionSupport(boolean support) {
        this.isSessionSupport = support;
    }

    public boolean isSessionSupport() {
        return this.isSessionSupport;
    }

    public List<Handler> getHandlers() {
        return this.handlers;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public boolean isReuseAddress() {
        return this.isReuseAddress;
    }

    public void setReuseAddress(boolean reuse) {
        this.isReuseAddress = reuse;
    }

    @Override
    public synchronized void addServant(URL url, JettyHTTPHandler handler) {
        if (this.server == null) {
            DefaultHandler defaultHandler = null;
            this.server = new Server();
            if (this.connector == null) {
                this.connector = this.connectorFactory.createConnector(this.port);
            }
            this.server.addConnector(this.connector);
            if (this.handlers != null && this.handlers.size() > 0) {
                HandlerList handlerList = new HandlerList();
                for (Handler h : this.handlers) {
                    if (h instanceof DefaultHandler) {
                        defaultHandler = (DefaultHandler)h;
                        continue;
                    }
                    handlerList.addHandler(h);
                }
                this.server.addHandler((Handler)handlerList);
            }
            this.contexts = new ContextHandlerCollection();
            this.server.addHandler((Handler)this.contexts);
            if (defaultHandler != null) {
                this.server.addHandler(defaultHandler);
            }
            try {
                AbstractConnector aconn;
                this.server.start();
                if (this.isReuseAddress()) {
                    this.setReuseAddress(this.connector);
                }
                if ((aconn = (AbstractConnector)this.connector).getThreadPool() instanceof BoundedThreadPool && this.isSetThreadingParameters()) {
                    BoundedThreadPool pool = (BoundedThreadPool)aconn.getThreadPool();
                    if (this.getThreadingParameters().isSetMinThreads()) {
                        pool.setMinThreads(this.getThreadingParameters().getMinThreads());
                    }
                    if (this.getThreadingParameters().isSetMaxThreads()) {
                        pool.setMaxThreads(this.getThreadingParameters().getMaxThreads());
                    }
                }
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "START_UP_SERVER_FAILED_MSG", new Object[]{e.getMessage()});
                try {
                    this.server.stop();
                    this.server.destroy();
                }
                catch (Exception ex) {
                    LOG.log(Level.SEVERE, "START_UP_SERVER_FAILED_MSG", new Object[]{e.getMessage()});
                }
            }
        }
        String contextName = HttpUriMapper.getContextName(url.getPath());
        ContextHandler context = new ContextHandler();
        context.setContextPath(contextName);
        context.setHandler((Handler)handler);
        if (this.isSessionSupport.booleanValue()) {
            HashSessionManager sessionManager = new HashSessionManager();
            SessionHandler sessionHandler = new SessionHandler((SessionManager)sessionManager);
            HashSessionIdManager idManager = new HashSessionIdManager();
            sessionManager.setIdManager((SessionIdManager)idManager);
            context.addHandler((Handler)sessionHandler);
        }
        this.contexts.addHandler((Handler)context);
        String smap = HttpUriMapper.getResourceBase(url.getPath());
        handler.setName(smap);
        if (this.contexts.isStarted()) {
            try {
                context.start();
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "ADD_HANDLER_FAILED_MSG", new Object[]{ex.getMessage()});
            }
        }
        ++this.servantCount;
    }

    private void setReuseAddress(Connector conn) throws IOException {
        if (conn.getConnection() == null) {
            conn.open();
        }
        ServerSocket socket = null;
        if (conn instanceof SelectChannelConnector) {
            ServerSocketChannel channel = (ServerSocketChannel)conn.getConnection();
            socket = channel.socket();
        } else if (conn instanceof SocketConnector) {
            socket = (ServerSocket)conn.getConnection();
        } else {
            LOG.info("UNKNOWN_CONNECTOR_MSG");
            return;
        }
        socket.setReuseAddress(true);
    }

    @Override
    public synchronized void removeServant(URL url) {
        String contextName = HttpUriMapper.getContextName(url.getPath());
        boolean found = false;
        if (this.server != null) {
            for (Handler handler : this.contexts.getChildHandlersByClass(ContextHandler.class)) {
                ContextHandler contextHandler = null;
                if (!(handler instanceof ContextHandler)) continue;
                contextHandler = (ContextHandler)handler;
                if (contextName.equals(contextHandler.getContextPath())) {
                    try {
                        this.contexts.removeHandler(handler);
                        handler.stop();
                        handler.destroy();
                    }
                    catch (Exception ex) {
                        LOG.log(Level.WARNING, "REMOVE_HANDLER_FAILED_MSG", new Object[]{ex.getMessage()});
                    }
                }
                found = true;
            }
        }
        if (!found) {
            LOG.log(Level.WARNING, "CAN_NOT_FIND_HANDLER_MSG", new Object[]{url});
        }
        --this.servantCount;
    }

    @Override
    public synchronized Handler getServant(URL url) {
        String contextName = HttpUriMapper.getContextName(url.getPath());
        Handler ret = null;
        if (this.server != null) {
            for (Handler handler : this.server.getChildHandlersByClass(ContextHandler.class)) {
                ContextHandler contextHandler = null;
                if (!(handler instanceof ContextHandler) || !contextName.equals((contextHandler = (ContextHandler)handler).getContextPath())) continue;
                ret = contextHandler.getHandler();
                break;
            }
        }
        return ret;
    }

    public synchronized ContextHandler getContextHandler(URL url) {
        String contextName = HttpUriMapper.getContextName(url.getPath());
        ContextHandler ret = null;
        if (this.server != null) {
            for (Handler handler : this.server.getChildHandlersByClass(ContextHandler.class)) {
                ContextHandler contextHandler = null;
                if (!(handler instanceof ContextHandler) || !contextName.equals((contextHandler = (ContextHandler)handler).getContextPath())) continue;
                ret = contextHandler;
                break;
            }
        }
        return ret;
    }

    protected void retrieveListenerFactory() {
        if (this.tlsServerParameters != null) {
            if (null != this.connector && !(this.connector instanceof SslSocketConnector)) {
                throw new RuntimeException("Connector " + this.connector + " for JettyServerEngine Port " + this.port + " does not support SSL connections.");
            }
            this.connectorFactory = this.getHTTPSConnectorFactory(this.tlsServerParameters);
            this.protocol = "https";
        } else {
            if (this.connector instanceof SslSocketConnector) {
                throw new RuntimeException("Connector " + this.connector + " for JettyServerEngine Port " + this.port + " does not support non-SSL connections.");
            }
            this.connectorFactory = this.getHTTPConnectorFactory();
            this.protocol = "http";
        }
        LOG.fine("Configured port " + this.port + " for \"" + this.protocol + "\".");
    }

    protected JettyConnectorFactory getHTTPConnectorFactory() {
        return new JettyConnectorFactory(){

            public AbstractConnector createConnector(int porto) {
                SelectChannelConnector result = new SelectChannelConnector();
                assert (porto == JettyHTTPServerEngine.this.port);
                result.setPort(porto);
                return result;
            }
        };
    }

    protected JettyConnectorFactory getHTTPSConnectorFactory(TLSServerParameters tlsParams) {
        return new JettySslConnectorFactory(tlsParams);
    }

    @PostConstruct
    protected void finalizeConfig() throws GeneralSecurityException, IOException {
        this.retrieveEngineFactory();
        this.retrieveListenerFactory();
        this.checkConnectorPort();
        this.configFinalized = true;
    }

    private void retrieveEngineFactory() {
        if (null != this.bus && null == this.factory) {
            this.factory = this.bus.getExtension(JettyHTTPServerEngineFactory.class);
        }
    }

    private void checkConnectorPort() throws IOException {
        if (null != this.connector && this.port != this.connector.getPort()) {
            throw new IOException("Error: Connector port " + this.connector.getPort() + " does not match" + " with the server engine port " + this.port);
        }
    }

    protected void stop() throws Exception {
        if (this.server != null) {
            this.connector.close();
            this.server.stop();
            this.server.destroy();
            this.server = null;
        }
    }

    public void setTlsServerParameters(TLSServerParameters params) throws IOException {
        this.tlsServerParameters = params;
        if (this.configFinalized) {
            this.retrieveListenerFactory();
        }
    }

    public TLSServerParameters getTlsServerParameters() {
        return this.tlsServerParameters;
    }

    public void setThreadingParameters(ThreadingParameters params) {
        this.threadingParameters = params;
    }

    public boolean isSetThreadingParameters() {
        return this.threadingParameters != null;
    }

    public ThreadingParameters getThreadingParameters() {
        return this.threadingParameters;
    }
}

