/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.wsdl11;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Types;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaImport;
import org.apache.cxf.Bus;
import org.apache.cxf.catalog.CatalogXmlSchemaURIResolver;
import org.apache.cxf.catalog.OASISCatalogManager;
import org.apache.cxf.common.util.FixedExtensionDeserializer;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.extensions.ExtensionDeserializer;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SchemaUtil {
    private final Map<String, Element> schemaList;
    private final Bus bus;
    private Map<String, String> catalogResolvedMap;

    public SchemaUtil(Bus b, Map<String, Element> s) {
        this.bus = b;
        this.schemaList = s;
    }

    public void getSchemas(Definition def, ServiceInfo serviceInfo) {
        XmlSchemaCollection schemaCol = serviceInfo.getXmlSchemaCollection();
        schemaCol.getExtReg().setDefaultExtensionDeserializer((ExtensionDeserializer)new FixedExtensionDeserializer());
        ArrayList<Definition> defList = new ArrayList<Definition>();
        this.parseImports(def, defList);
        this.extractSchema(def, schemaCol, serviceInfo);
        this.getSchemaList(def);
        for (Definition def2 : defList) {
            this.extractSchema(def2, schemaCol, serviceInfo);
            this.getSchemaList(def2);
        }
    }

    private void extractSchema(Definition def, XmlSchemaCollection schemaCol, ServiceInfo serviceInfo) {
        Types typesElement = def.getTypes();
        if (typesElement != null) {
            int schemaCount = 1;
            for (Object obj : typesElement.getExtensibilityElements()) {
                Element elem;
                Element schemaElem = null;
                if (obj instanceof Schema) {
                    Schema schema = (Schema)obj;
                    schemaElem = schema.getElement();
                } else if (obj instanceof UnknownExtensibilityElement && (elem = ((UnknownExtensibilityElement)obj).getElement()).getLocalName().equals("schema")) {
                    schemaElem = elem;
                }
                if (schemaElem == null) continue;
                for (Object prefix : def.getNamespaces().keySet()) {
                    String ns = (String)def.getNamespaces().get(prefix);
                    if ("".equals(prefix) || schemaElem.hasAttribute("xmlns:" + prefix)) continue;
                    schemaElem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, ns);
                }
                String systemId = def.getDocumentBaseURI() + "#types" + schemaCount;
                schemaCol.setBaseUri(def.getDocumentBaseURI());
                CatalogXmlSchemaURIResolver schemaResolver = new CatalogXmlSchemaURIResolver(OASISCatalogManager.getCatalogManager(this.bus));
                schemaCol.setSchemaResolver((URIResolver)schemaResolver);
                XmlSchema xmlSchema = schemaCol.read(schemaElem, systemId);
                SchemaInfo schemaInfo = new SchemaInfo(serviceInfo, xmlSchema.getTargetNamespace());
                schemaInfo.setElement(schemaElem);
                schemaInfo.setSchema(xmlSchema);
                schemaInfo.setSystemId(systemId);
                serviceInfo.addSchema(schemaInfo);
                ++schemaCount;
            }
        }
    }

    private void parseImports(Definition def, List<Definition> defList) {
        ArrayList importList = new ArrayList();
        Collection<List> ilist = CastUtils.cast(def.getImports().values());
        for (List list : ilist) {
            importList.addAll(list);
        }
        for (Import impt : importList) {
            if (defList.contains(impt.getDefinition())) continue;
            defList.add(impt.getDefinition());
            this.parseImports(impt.getDefinition(), defList);
        }
    }

    private void getSchemaList(Definition def) {
        Types typesElement = def.getTypes();
        if (typesElement != null) {
            for (Object obj : typesElement.getExtensibilityElements()) {
                if (!(obj instanceof Schema)) continue;
                Schema schema = (Schema)obj;
                this.addSchema(schema.getDocumentBaseURI(), schema);
            }
        }
    }

    private void addSchema(String docBaseURI, Schema schema) {
        String tns;
        Element schemaEle = schema.getElement();
        if (this.schemaList.get(docBaseURI) == null) {
            this.schemaList.put(docBaseURI, schemaEle);
        } else if (!(this.schemaList.get(docBaseURI) != null && this.schemaList.containsValue(schemaEle) || this.schemaList.get(tns = schema.getDocumentBaseURI() + "#" + schema.getElement().getAttribute("targetNamespace")) != null)) {
            this.schemaList.put(tns, schema.getElement());
        }
        Map imports = CastUtils.cast(schema.getImports());
        if (imports != null && imports.size() > 0) {
            Set importKeys = imports.keySet();
            for (String importNamespace : importKeys) {
                List<SchemaImport> schemaImports = CastUtils.cast((List)imports.get(importNamespace));
                for (SchemaImport schemaImport : schemaImports) {
                    Schema tempImport = schemaImport.getReferencedSchema();
                    String key = schemaImport.getSchemaLocationURI();
                    if (importNamespace == null && tempImport != null) {
                        importNamespace = tempImport.getDocumentBaseURI();
                    }
                    if (!(this.catalogResolvedMap != null && this.catalogResolvedMap.containsKey(key) || tempImport == null)) {
                        key = tempImport.getDocumentBaseURI();
                    }
                    if (tempImport == null || this.isSchemaParsed(key, importNamespace) || this.schemaList.containsValue(tempImport.getElement())) continue;
                    this.addSchema(key, tempImport);
                }
            }
        }
    }

    private boolean isSchemaParsed(String baseUri, String ns) {
        Element ele;
        String tns;
        return this.schemaList.get(baseUri) != null && ns.equals(tns = (ele = this.schemaList.get(baseUri)).getAttribute("targetNamespace"));
    }

    public void setCatalogResolvedMap(Map<String, String> resolvedMap) {
        this.catalogResolvedMap = resolvedMap;
    }
}

