/*
 * Decompiled with CFR 0.152.
 */
package clinical.tools.install;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.input.InputRequest;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class UsersFileCreator {
    protected BufferedReader in;
    protected Project project;

    public UsersFileCreator() {
        this.in = new BufferedReader(new InputStreamReader(System.in));
    }

    public UsersFileCreator(Project project) {
        this.project = project;
    }

    public String getInput(String prompt) throws IOException {
        if (this.in != null) {
            System.out.print(prompt);
            return this.in.readLine().trim();
        }
        InputRequest request = new InputRequest(prompt);
        this.project.getInputHandler().handleInput(request);
        String value = request.getInput();
        return value.trim();
    }

    public String getUserInput(String prompt, String[] posValues) throws IOException {
        StringBuffer buf = new StringBuffer(128);
        buf.append(prompt);
        if (posValues != null) {
            buf.append(" (");
            int i = 0;
            while (i < posValues.length) {
                if (i == 0) {
                    buf.append('[');
                }
                buf.append(posValues[i]);
                if (i == 0) {
                    buf.append(']');
                }
                if (i + 1 < posValues.length) {
                    buf.append(",");
                }
                ++i;
            }
            buf.append(" ) ");
        }
        buf.append(" >> ");
        String answer = this.getInput(buf.toString());
        boolean ok = true;
        do {
            if (answer.length() > 0) {
                if (posValues != null && UsersFileCreator.validAnswer(answer, posValues) || posValues == null) {
                    break;
                }
            } else if (posValues != null) {
                return posValues[0];
            }
            answer = this.getInput(buf.toString());
        } while (!ok);
        return answer;
    }

    public static boolean validAnswer(String answer, String[] posValues) {
        int i = 0;
        while (i < posValues.length) {
            if (answer.equals(posValues[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String[] getDbUsers(List dbUsers, String dbID) {
        LinkedList<String> l = new LinkedList<String>();
        Iterator iter = dbUsers.iterator();
        while (iter.hasNext()) {
            DBUserInfo dbui = (DBUserInfo)iter.next();
            if (!dbui.dbID.equals(dbID)) continue;
            l.add(dbui.name);
        }
        String[] dbUsersArr = new String[l.size()];
        return l.toArray(dbUsersArr);
    }

    public static String[] getPrivilegeNames(List privileges) {
        String[] privNames = new String[privileges.size()];
        int i = 0;
        Iterator iter = privileges.iterator();
        while (iter.hasNext()) {
            PrivilegeInfo pi = (PrivilegeInfo)iter.next();
            privNames[i++] = pi.name;
        }
        return privNames;
    }

    public static String[] updatePrivilegeNames(String[] privNames, String usedPriv) {
        if (privNames.length == 1) {
            return null;
        }
        String[] npnArr = new String[privNames.length - 1];
        int idx = 0;
        int i = 0;
        while (i < privNames.length) {
            if (!privNames[i].equals(usedPriv)) {
                npnArr[idx++] = privNames[i];
            }
            ++i;
        }
        return npnArr;
    }

    public static boolean testJDBCConnection(DatabaseInfo dbi, DBUserInfo dbUserInfo) {
        Connection con = null;
        Statement st = null;
        String testQuery = "select 2 from dual";
        try {
            try {
                if (dbi.dbType.equalsIgnoreCase("oracle")) {
                    Class.forName("oracle.jdbc.driver.OracleDriver");
                } else if (dbi.dbType.equalsIgnoreCase("postgres")) {
                    Class.forName("org.postgresql.Driver");
                    testQuery = "select 2";
                }
                con = DriverManager.getConnection(dbi.getDBURL(), dbUserInfo.name, dbUserInfo.password);
                st = con.createStatement();
                ResultSet rs = st.executeQuery(testQuery);
                rs.close();
            }
            catch (Exception x) {
                x.printStackTrace();
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return false;
            }
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception exception) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    public void prepareUsersFile(String xmlFilename) throws IOException {
        UsersFileInfo ui = new UsersFileInfo();
        String ans = "";
        System.out.println("Preparing users.xml file...");
        System.out.println("------------------ Database Section -----------------");
        String[] yesNo = new String[]{"y", "n"};
        do {
            DatabaseInfo dbi = new DatabaseInfo();
            dbi.dbType = this.getUserInput("Please enter the database type", new String[]{"oracle", "postgres"});
            dbi.hostName = this.getUserInput("In most cases, the fully qualified hostname of your gpop is the host name\n Please enter the database server host name", null);
            dbi.dbID = this.getUserInput("The database id is expected of this format <site-name>_[mbirn|fbirn]\nA valid database ID is, for example, ucsd_fbirn or mgh_mbirn.\n The database id is used to identify different data sources by the web app.\n\n Please enter the database id", null);
            dbi.defaultDB = this.getUserInput("The default database flag determines to which database the web app will be connected by default.\n\n Please enter if this database is the default database", yesNo).equals("y");
            if (dbi.dbType.equalsIgnoreCase("oracle")) {
                dbi.port = Integer.parseInt(this.getUserInput("In most cases, the Oracle database connection port is 1521.\n\n Please enter the database server connection port", null));
                dbi.SID = this.getUserInput("For most default BIRN rack Oracle installation the SID is orcl1\n\nPlease enter the SID of your database", null);
            } else if (dbi.dbType.equalsIgnoreCase("postgres")) {
                dbi.SID = this.getUserInput("Please enter the name of your Postgres database", null);
            }
            ui.addDatabase(dbi);
        } while ((ans = this.getUserInput("\nDo you want to enter another database", yesNo)).equals("y"));
        PrivilegeInfo pi = new PrivilegeInfo("manageExperiment", "Any user with this privilege can add/or update\nexperiment(s), enroll subjects to an experiment and/or changetheir study group");
        ui.addPrivilege(pi);
        pi = new PrivilegeInfo("manageSubject", "");
        ui.addPrivilege(pi);
        String[] dbIDs = new String[ui.databases.size()];
        int i = 0;
        Iterator iter = ui.databases.iterator();
        while (iter.hasNext()) {
            DatabaseInfo dbi = (DatabaseInfo)iter.next();
            dbIDs[i++] = dbi.dbID;
        }
        System.out.println("------------------ Database Users Section -----------------");
        do {
            DBUserInfo dbui = new DBUserInfo();
            dbui.name = this.getUserInput("Please enter the named database connection user name", null);
            dbui.password = this.getUserInput("Please enter the named database connection password", null);
            dbui.dbID = this.getUserInput("Please enter the database id this database user belongs", dbIDs);
            ans = this.getUserInput("\nDo you want to test the database connection for this user", yesNo);
            if (ans.equals("y")) {
                if (!UsersFileCreator.testJDBCConnection(ui.findDatabase(dbui.dbID), dbui)) continue;
                System.out.println("Database connection test is successful for user " + dbui.name + ".");
                System.out.println("==============================================================");
                System.out.println();
            }
            ui.addDBUser(dbui);
            ans = this.getUserInput("\nDo you want to enter another database user ", yesNo);
        } while (ans.equals("y"));
        System.out.println("------------------ Web App Users Section -----------------\n");
        System.out.println("IMPORTANT: At least one user named 'admin' with all privileges");
        System.out.println("assigned must be entered in this section for the app to work\n");
        do {
            WebUserInfo wui = new WebUserInfo();
            wui.name = this.getUserInput("Please enter the web user name", null);
            wui.password = this.getUserInput("Please enter the web user password", null);
            wui.dbID = this.getUserInput("Please enter the database id for the database this web user uses", dbIDs);
            String[] dbUsers = UsersFileCreator.getDbUsers(ui.dbUsers, wui.dbID);
            wui.dbUser = this.getUserInput("Please enter the database user, this web user will be associated", dbUsers);
            ui.addWebUser(wui);
            String[] privNames = UsersFileCreator.getPrivilegeNames(ui.privileges);
            do {
                if (!(ans = this.getUserInput("\nDo you want to enter a privilege for this web user ", yesNo)).equals("y")) continue;
                String privName = this.getUserInput("Please enter a privilege for this user", privNames);
                wui.addPrivilege(new PrivilegeInfo(privName, null));
                privNames = UsersFileCreator.updatePrivilegeNames(privNames, privName);
            } while (privNames != null && ans.equals("y"));
        } while ((ans = this.getUserInput("\nDo you want to enter another web user ", yesNo)).equals("y"));
        FilterOutputStream bout = null;
        try {
            bout = new BufferedOutputStream(new FileOutputStream(xmlFilename));
            this.saveAsXML(bout, ui.toXML());
        }
        finally {
            if (bout != null) {
                try {
                    bout.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void saveAsXML(OutputStream out, Element parent) throws IOException {
        Format format = Format.getPrettyFormat();
        format.setLineSeparator(System.getProperty("line.separator"));
        XMLOutputter xmlOut = new XMLOutputter(format);
        xmlOut.output(parent, out);
    }

    public static void main(String[] args) {
        try {
            UsersFileCreator inst = new UsersFileCreator();
            inst.prepareUsersFile("/home/bozyurt/users.xml");
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public static class DBUserInfo {
        String dbID;
        String name;
        String password;

        public void toXML(Element parent) {
            Element e = new Element("dbuser");
            parent.addContent((Content)e);
            e.setAttribute("dbid", this.dbID);
            e.setAttribute("name", this.name);
            e.setAttribute("pwd", this.password);
        }
    }

    public static class DatabaseInfo {
        String dbID;
        String hostName;
        String dbType = "oracle";
        String SID = "orcl1";
        int port = 1521;
        boolean defaultDB = false;

        public String getDBURL() {
            StringBuffer buf = new StringBuffer(128);
            if (this.dbType.equalsIgnoreCase("oracle")) {
                buf.append("jdbc:").append(this.dbType).append(":thin:@").append(this.hostName).append(":");
                buf.append(this.port).append(":").append(this.SID);
            } else if (this.dbType.equalsIgnoreCase("postgres")) {
                buf.append("jdbc:postgresql://").append(this.hostName);
                buf.append("/").append(this.SID);
            } else {
                throw new RuntimeException("Not a supported DB type:" + this.dbType);
            }
            return buf.toString();
        }

        public void toXML(Element parent) {
            Element e = new Element("database");
            parent.addContent((Content)e);
            e.setAttribute("id", this.dbID);
            e.setAttribute("default", this.defaultDB ? "true" : "false");
            Element ue = new Element("db-url");
            String dbURL = null;
            dbURL = this.dbType.equalsIgnoreCase("oracle") ? "jdbc:" + this.dbType + ":thin:@" + this.hostName + ":" + this.port + ":" + this.SID : "jdbc:postgresql://" + this.hostName + "/" + this.SID;
            ue.addContent(dbURL);
            e.addContent((Content)ue);
            Element dbTypeElem = new Element("db-type");
            dbTypeElem.addContent(this.dbType.toLowerCase());
            e.addContent((Content)dbTypeElem);
        }
    }

    public static class PrivilegeInfo {
        String name;
        String description;

        public PrivilegeInfo(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public void toXML(Element parent) {
            Element e = new Element("privilege");
            parent.addContent((Content)e);
            e.setAttribute("name", this.name);
            if (this.description != null) {
                Element de = new Element("description");
                de.addContent(this.description);
                e.addContent((Content)de);
            }
        }
    }

    public static class UsersFileInfo {
        List databases = new LinkedList();
        List privileges = new LinkedList();
        List dbUsers = new LinkedList();
        List webUsers = new LinkedList();

        public void addDatabase(DatabaseInfo dbInfo) {
            this.databases.add(dbInfo);
        }

        public void addDBUser(DBUserInfo dbUserInfo) {
            this.dbUsers.add(dbUserInfo);
        }

        public void addWebUser(WebUserInfo wuInfo) {
            this.webUsers.add(wuInfo);
        }

        public void addPrivilege(PrivilegeInfo pi) {
            this.privileges.add(pi);
        }

        public DatabaseInfo findDatabase(String dbID) {
            Iterator iter = this.databases.iterator();
            while (iter.hasNext()) {
                DatabaseInfo dbi = (DatabaseInfo)iter.next();
                if (!dbi.dbID.equals(dbID)) continue;
                return dbi;
            }
            return null;
        }

        public Element toXML() {
            Element parent = new Element("user-info");
            parent.addContent((Content)new Comment("Define the set of available databases the web application can connect\n One of them needs to have default=true."));
            Element de = new Element("databases");
            parent.addContent((Content)de);
            Iterator iter = this.databases.iterator();
            while (iter.hasNext()) {
                DatabaseInfo dbi = (DatabaseInfo)iter.next();
                dbi.toXML(de);
            }
            Element pe = new Element("privileges");
            parent.addContent((Content)pe);
            Iterator iter2 = this.privileges.iterator();
            while (iter2.hasNext()) {
                PrivilegeInfo pi = (PrivilegeInfo)iter2.next();
                pi.toXML(pe);
            }
            parent.addContent((Content)new Comment("the list of named database users for each database instance"));
            Element due = new Element("dbusers");
            parent.addContent((Content)due);
            Iterator iter3 = this.dbUsers.iterator();
            while (iter3.hasNext()) {
                DBUserInfo dui = (DBUserInfo)iter3.next();
                dui.toXML(due);
            }
            parent.addContent((Content)new Comment("the list of web application users mapped to the named database users\nThe web application does its own authentication."));
            Element wue = new Element("users");
            parent.addContent((Content)wue);
            Iterator iter4 = this.webUsers.iterator();
            while (iter4.hasNext()) {
                WebUserInfo wui = (WebUserInfo)iter4.next();
                wui.toXML(wue);
            }
            return parent;
        }
    }

    public static class WebUserInfo
    extends DBUserInfo {
        String dbUser;
        List privileges = new LinkedList();

        public void addPrivilege(PrivilegeInfo pi) {
            this.privileges.add(pi);
        }

        public void toXML(Element parent) {
            Element e = new Element("user");
            parent.addContent((Content)e);
            e.setAttribute("name", this.name);
            e.setAttribute("pwd", this.password);
            e.setAttribute("dbid", this.dbID);
            e.setAttribute("dbuser", this.dbUser);
            Element pe = new Element("privileges");
            e.addContent((Content)pe);
            Iterator iter = this.privileges.iterator();
            while (iter.hasNext()) {
                PrivilegeInfo pi = (PrivilegeInfo)iter.next();
                pi.toXML(pe);
            }
        }
    }
}

