/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.interceptor;

import java.util.List;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.RPCInInterceptor;
import org.apache.cxf.binding.soap.model.SoapHeaderInfo;
import org.apache.cxf.headers.Header;
import org.apache.cxf.interceptor.AbstractInDatabindingInterceptor;
import org.apache.cxf.interceptor.BareInInterceptor;
import org.apache.cxf.interceptor.DocLiteralInInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.w3c.dom.Node;

public class SoapHeaderInterceptor
extends AbstractInDatabindingInterceptor {
    public SoapHeaderInterceptor() {
        super("unmarshal");
        this.addAfter(BareInInterceptor.class.getName());
        this.addAfter(RPCInInterceptor.class.getName());
        this.addAfter(DocLiteralInInterceptor.class.getName());
    }

    public void handleMessage(Message m) throws Fault {
        boolean client;
        BindingMessageInfo bmi;
        BindingOperationInfo bop;
        SoapMessage message = (SoapMessage)m;
        Exchange exchange = message.getExchange();
        MessageContentsList parameters = MessageContentsList.getContentsList(message);
        if (null == parameters) {
            parameters = new MessageContentsList();
        }
        if (null == (bop = exchange.get(BindingOperationInfo.class))) {
            return;
        }
        if (bop.isUnwrapped()) {
            bop = bop.getWrappedOperation();
        }
        BindingMessageInfo bindingMessageInfo = bmi = (client = this.isRequestor(message)) ? bop.getOutput() : bop.getInput();
        if (bmi == null) {
            return;
        }
        List<SoapHeaderInfo> headers = bmi.getExtensors(SoapHeaderInfo.class);
        if (headers == null || headers.size() == 0) {
            return;
        }
        for (SoapHeaderInfo header : headers) {
            MessagePartInfo mpi = header.getPart();
            Header param = this.findHeader(message, mpi);
            Object object = null;
            if (param != null) {
                message.getHeaders().remove(param);
                if (param.getDataBinding() == null) {
                    Node source = (Node)param.getObject();
                    object = this.getNodeDataReader(message).read(mpi, source);
                } else {
                    object = param.getObject();
                }
            }
            if (object == null || mpi.getTypeClass() == null) continue;
            parameters.put(mpi, object);
        }
        if (parameters.size() > 0) {
            message.setContent(List.class, parameters);
        }
    }

    private Header findHeader(SoapMessage message, MessagePartInfo mpi) {
        return message.getHeader(mpi.getConcreteName());
    }
}

