/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.buslifecycle;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.cxf.Bus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;

public class CXFBusLifeCycleManager
implements BusLifeCycleManager {
    private final List<BusLifeCycleListener> listeners = new ArrayList<BusLifeCycleListener>();
    private Bus bus;

    @Resource
    public void setBus(Bus b) {
        this.bus = b;
    }

    @PostConstruct
    public void register() {
        if (null != this.bus) {
            this.bus.setExtension(this, BusLifeCycleManager.class);
        }
    }

    public void registerLifeCycleListener(BusLifeCycleListener listener) {
        this.listeners.add(listener);
    }

    public void unregisterLifeCycleListener(BusLifeCycleListener listener) {
        this.listeners.remove(listener);
    }

    public void initComplete() {
        for (BusLifeCycleListener listener : this.listeners) {
            listener.initComplete();
        }
    }

    public void preShutdown() {
        for (BusLifeCycleListener listener : this.listeners) {
            listener.preShutdown();
        }
    }

    public void postShutdown() {
        for (BusLifeCycleListener listener : this.listeners) {
            listener.postShutdown();
        }
    }
}

