/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.configuration.spring;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.bus.spring.BusApplicationContext;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.Configurable;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.extension.BusExtension;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.wiring.BeanConfigurerSupport;
import org.springframework.beans.factory.wiring.BeanWiringInfo;
import org.springframework.beans.factory.wiring.BeanWiringInfoResolver;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.ClassPathResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurerImpl
extends BeanConfigurerSupport
implements Configurer,
ApplicationContextAware,
BusExtension {
    private static final Logger LOG = LogUtils.getL7dLogger(ConfigurerImpl.class);
    private static final String DEFAULT_USER_CFG_FILE = "cxf.xml";
    private ApplicationContext appContext;
    private final Map<String, String> wildCardBeanDefinitions = new HashMap<String, String>();

    public ConfigurerImpl() {
        this(DEFAULT_USER_CFG_FILE);
    }

    public ConfigurerImpl(String cfgFile) {
        ClassPathResource cpr;
        if (null == cfgFile) {
            cfgFile = System.getProperty("cxf.config.file");
        }
        if (null == cfgFile) {
            cfgFile = DEFAULT_USER_CFG_FILE;
        }
        if ((cpr = new ClassPathResource(cfgFile)).exists()) {
            try {
                BusApplicationContext ac = new BusApplicationContext(cfgFile, false);
                ac.refresh();
                this.setApplicationContext((ApplicationContext)ac);
            }
            catch (BeansException ex) {
                LogUtils.log(LOG, Level.WARNING, "APP_CONTEXT_CREATION_FAILED_MSG", (Throwable)ex, (Object[])null);
            }
        } else {
            LogUtils.log(LOG, Level.INFO, "USER_CFG_FILE_NOT_FOUND_MSG", cfgFile);
        }
    }

    public ConfigurerImpl(ApplicationContext ac) {
        this.setApplicationContext(ac);
    }

    private void initWildcardDefinitionMap() {
        if (null != this.appContext) {
            for (String n : this.appContext.getBeanDefinitionNames()) {
                if (!this.isWildcardBeanName(n)) continue;
                AutowireCapableBeanFactory bf = this.appContext.getAutowireCapableBeanFactory();
                BeanDefinitionRegistry bdr = (BeanDefinitionRegistry)bf;
                BeanDefinition bd = bdr.getBeanDefinition(n);
                String className = bd.getBeanClassName();
                if (null != className) {
                    if (!this.wildCardBeanDefinitions.containsKey(className)) {
                        this.wildCardBeanDefinitions.put(className, n);
                        continue;
                    }
                    LogUtils.log(LOG, Level.WARNING, "ONE_WILDCARD_BEAN_ID_PER_CLASS_MSG", new String[]{this.wildCardBeanDefinitions.get(className), className, n});
                    continue;
                }
                LogUtils.log(LOG, Level.WARNING, "WILDCARD_BEAN_ID_WITH_NO_CLASS_MSG", n);
            }
        }
    }

    @Override
    public void configureBean(Object beanInstance) {
        this.configureBean(null, beanInstance);
    }

    @Override
    public void configureBean(String bn, Object beanInstance) {
        block6: {
            if (null == this.appContext) {
                return;
            }
            if (null == bn) {
                bn = this.getBeanName(beanInstance);
            }
            if (null == bn) {
                return;
            }
            this.configureWithWildCard(bn, beanInstance);
            final String beanName = bn;
            this.setBeanWiringInfoResolver(new BeanWiringInfoResolver(){

                public BeanWiringInfo resolveWiringInfo(Object instance) {
                    if (null != beanName && !"".equals(beanName)) {
                        return new BeanWiringInfo(beanName);
                    }
                    return null;
                }
            });
            try {
                super.configureBean(beanInstance);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Successfully performed injection.");
                }
            }
            catch (NoSuchBeanDefinitionException ex) {
                if (!LOG.isLoggable(Level.FINE)) break block6;
                LOG.log(Level.FINE, "NO_MATCHING_BEAN_MSG", beanName);
            }
        }
    }

    private void configureWithWildCard(String bn, Object beanInstance) {
        String wildCardBeanId;
        String className;
        if (!this.wildCardBeanDefinitions.isEmpty() && !this.isWildcardBeanName(bn) && this.wildCardBeanDefinitions.containsKey(className = beanInstance.getClass().getName()) && bn.endsWith(this.stripStar(wildCardBeanId = this.wildCardBeanDefinitions.get(className)))) {
            this.configureBean(wildCardBeanId, beanInstance);
        }
    }

    private boolean isWildcardBeanName(String bn) {
        return bn.charAt(0) == '*';
    }

    private String stripStar(String wildCardBeanId) {
        return wildCardBeanId.substring(1);
    }

    protected String getBeanName(Object beanInstance) {
        if (beanInstance instanceof Configurable) {
            return ((Configurable)beanInstance).getBeanName();
        }
        String beanName = null;
        Method m = null;
        try {
            m = beanInstance.getClass().getDeclaredMethod("getBeanName", null);
        }
        catch (NoSuchMethodException ex) {
            try {
                m = beanInstance.getClass().getMethod("getBeanName", null);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        if (m != null) {
            try {
                beanName = (String)m.invoke(beanInstance, new Object[0]);
            }
            catch (Exception ex) {
                LogUtils.log(LOG, Level.WARNING, "ERROR_DETERMINING_BEAN_NAME_EXC", ex);
            }
        }
        if (null == beanName) {
            LogUtils.log(LOG, Level.INFO, "COULD_NOT_DETERMINE_BEAN_NAME_MSG", beanInstance.getClass().getName());
        }
        return beanName;
    }

    public final void setApplicationContext(ApplicationContext ac) {
        this.appContext = ac;
        this.setBeanFactory((BeanFactory)this.appContext.getAutowireCapableBeanFactory());
        this.initWildcardDefinitionMap();
    }

    @Override
    public Class<?> getRegistrationType() {
        return Configurer.class;
    }
}

