/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.phase.PhaseManager;
import org.apache.cxf.transport.MessageObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleEndpointObserver
implements MessageObserver {
    public static final String ENDPOINTS = "multipleEndpointObserver.endpoints";
    protected Bus bus;
    protected List<Interceptor> bindingInterceptors = new CopyOnWriteArrayList<Interceptor>();
    protected List<Interceptor> routingInterceptors = new CopyOnWriteArrayList<Interceptor>();
    private Set<Endpoint> endpoints = new CopyOnWriteArraySet<Endpoint>();

    public MultipleEndpointObserver(Bus bus) {
        this.bus = bus;
    }

    @Override
    public void onMessage(Message message) {
        Exchange exchange = (message = this.createMessage(message)).getExchange();
        if (exchange == null) {
            exchange = new ExchangeImpl();
            exchange.setInMessage(message);
        }
        this.setExchangeProperties(exchange, message);
        PhaseInterceptorChain chain = this.createChain();
        message.setInterceptorChain(chain);
        chain.add(this.bus.getInInterceptors());
        if (this.bindingInterceptors != null) {
            chain.add(this.bindingInterceptors);
        }
        if (this.routingInterceptors != null) {
            chain.add(this.routingInterceptors);
        }
        if (this.endpoints != null) {
            exchange.put(ENDPOINTS, this.endpoints);
        }
        chain.doIntercept(message);
    }

    protected Message createMessage(Message message) {
        return message;
    }

    protected PhaseInterceptorChain createChain() {
        PhaseInterceptorChain chain = new PhaseInterceptorChain(this.bus.getExtension(PhaseManager.class).getInPhases());
        return chain;
    }

    protected void setExchangeProperties(Exchange exchange, Message m) {
        exchange.put(Bus.class, this.bus);
        if (exchange.getDestination() == null) {
            exchange.setDestination(m.getDestination());
        }
    }

    public List<Interceptor> getBindingInterceptors() {
        return this.bindingInterceptors;
    }

    public List<Interceptor> getRoutingInterceptors() {
        return this.routingInterceptors;
    }

    public Set<Endpoint> getEndpoints() {
        return this.endpoints;
    }
}

