/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http_jetty;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.transport.http_jetty.JettyHTTPDestination;
import org.mortbay.jetty.handler.AbstractHandler;

public class JettyHTTPHandler
extends AbstractHandler {
    private String urlName;
    private boolean contextMatchExact;
    private JettyHTTPDestination jettyHTTPDestination;

    public JettyHTTPHandler(JettyHTTPDestination jhd, boolean cmExact) {
        this.contextMatchExact = cmExact;
        this.jettyHTTPDestination = jhd;
    }

    public void setName(String name) {
        this.urlName = name;
    }

    public String getName() {
        return this.urlName;
    }

    public void handle(String target, HttpServletRequest req, HttpServletResponse resp, int dispatch) throws IOException {
        if (this.contextMatchExact) {
            if (target.equals(this.urlName)) {
                this.jettyHTTPDestination.doService(req, resp);
            }
        } else if (target.startsWith(this.urlName)) {
            this.jettyHTTPDestination.doService(req, resp);
        }
    }
}

