/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.List;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.cxf.Bus;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.jms.AddressType;
import org.apache.cxf.transport.jms.JMSMessageHeadersType;
import org.apache.cxf.transport.jms.JMSPropertyType;
import org.apache.cxf.transport.jms.JMSSessionFactory;
import org.apache.cxf.transport.jms.JMSTransport;

public class JMSTransportBase {
    protected Destination targetDestination;
    protected Destination replyDestination;
    protected JMSSessionFactory sessionFactory;
    protected Bus bus;
    protected EndpointInfo endpointInfo;
    protected String beanNameSuffix;
    private JMSTransport transport;

    public JMSTransportBase(Bus b, EndpointInfo endpoint, boolean isServer, String suffix, JMSTransport transport) {
        this.bus = b;
        this.endpointInfo = endpoint;
        this.beanNameSuffix = suffix;
        this.transport = transport;
    }

    protected void connected(Destination target, Destination reply, JMSSessionFactory factory) {
        this.targetDestination = target;
        this.replyDestination = reply;
        this.sessionFactory = factory;
    }

    protected javax.jms.Message marshal(Object payload, Session session, Destination replyTo, String messageType) throws JMSException {
        TextMessage message = null;
        if ("text".equals(messageType)) {
            message = session.createTextMessage((String)payload);
        } else if ("byte".equals(messageType)) {
            message = session.createBytesMessage();
            ((BytesMessage)message).writeBytes((byte[])payload);
        } else {
            message = session.createObjectMessage();
            ((ObjectMessage)message).setObject((Serializable)((byte[])payload));
        }
        if (replyTo != null) {
            message.setJMSReplyTo(replyTo);
        }
        return message;
    }

    protected Object unmarshal(javax.jms.Message message) throws JMSException {
        Object ret = null;
        if (message instanceof TextMessage) {
            ret = ((TextMessage)message).getText();
        } else if (message instanceof BytesMessage) {
            byte[] retBytes = new byte[(int)((BytesMessage)message).getBodyLength()];
            ((BytesMessage)message).readBytes(retBytes);
            ret = retBytes;
        } else {
            ret = (byte[])((ObjectMessage)message).getObject();
        }
        return ret;
    }

    protected JMSMessageHeadersType populateIncomingContext(javax.jms.Message message, Message inMessage, String headerType) throws JMSException {
        JMSMessageHeadersType headers = null;
        headers = (JMSMessageHeadersType)inMessage.get(headerType);
        if (headers == null) {
            headers = new JMSMessageHeadersType();
            inMessage.put(headerType, headers);
        }
        headers.setJMSCorrelationID(message.getJMSCorrelationID());
        headers.setJMSDeliveryMode(new Integer(message.getJMSDeliveryMode()));
        headers.setJMSExpiration(new Long(message.getJMSExpiration()));
        headers.setJMSMessageID(message.getJMSMessageID());
        headers.setJMSPriority(new Integer(message.getJMSPriority()));
        headers.setJMSRedelivered(message.getJMSRedelivered());
        headers.setJMSTimeStamp(new Long(message.getJMSTimestamp()));
        headers.setJMSType(message.getJMSType());
        List<JMSPropertyType> props = headers.getProperty();
        Enumeration enm = message.getPropertyNames();
        while (enm.hasMoreElements()) {
            String name = (String)enm.nextElement();
            String val = message.getStringProperty(name);
            JMSPropertyType prop = new JMSPropertyType();
            prop.setName(name);
            prop.setValue(val);
            props.add(prop);
        }
        return headers;
    }

    protected int getJMSDeliveryMode(JMSMessageHeadersType headers) {
        int deliveryMode = 2;
        if (headers != null && headers.isSetJMSDeliveryMode()) {
            deliveryMode = headers.getJMSDeliveryMode();
        }
        return deliveryMode;
    }

    protected int getJMSPriority(JMSMessageHeadersType headers) {
        int priority = 4;
        if (headers != null && headers.isSetJMSPriority()) {
            priority = headers.getJMSPriority();
        }
        return priority;
    }

    protected long getTimeToLive(JMSMessageHeadersType headers) {
        long ttl = -1L;
        if (headers != null && headers.isSetTimeToLive()) {
            ttl = headers.getTimeToLive();
        }
        return ttl;
    }

    protected String getCorrelationId(JMSMessageHeadersType headers) {
        String correlationId = null;
        if (headers != null && headers.isSetJMSCorrelationID()) {
            correlationId = headers.getJMSCorrelationID();
        }
        return correlationId;
    }

    protected void setMessageProperties(JMSMessageHeadersType headers, javax.jms.Message message) throws JMSException {
        if (headers != null && headers.isSetProperty()) {
            List<JMSPropertyType> props = headers.getProperty();
            for (int x = 0; x < props.size(); ++x) {
                message.setStringProperty(props.get(x).getName(), props.get(x).getValue());
            }
        }
    }

    protected String getAddrUriFromJMSAddrPolicy() {
        AddressType jmsAddressPolicy = this.transport.getJMSAddress();
        return "jms:" + jmsAddressPolicy.getJndiConnectionFactoryName() + "#" + jmsAddressPolicy.getJndiDestinationName();
    }

    protected String getReplyTotAddrUriFromJMSAddrPolicy() {
        AddressType jmsAddressPolicy = this.transport.getJMSAddress();
        return "jms:" + jmsAddressPolicy.getJndiConnectionFactoryName() + "#" + jmsAddressPolicy.getJndiReplyDestinationName();
    }

    protected boolean isDestinationStyleQueue() {
        return "queue".equals(this.transport.getJMSAddress().getDestinationStyle().value());
    }
}

