/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.local;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.AbstractDestination;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.local.LocalConduit;
import org.apache.cxf.transport.local.LocalTransportFactory;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

public class LocalDestination
extends AbstractDestination {
    private static final Logger LOG = LogUtils.getL7dLogger(LocalDestination.class);
    private LocalTransportFactory localDestinationFactory;

    public LocalDestination(LocalTransportFactory localDestinationFactory, EndpointReferenceType epr, EndpointInfo ei) {
        super(epr, ei);
        this.localDestinationFactory = localDestinationFactory;
    }

    public void shutdown() {
        this.localDestinationFactory.remove(this);
    }

    protected Logger getLogger() {
        return LOG;
    }

    protected Conduit getInbuiltBackChannel(Message inMessage) {
        Conduit conduit = (Conduit)inMessage.get(LocalConduit.IN_CONDUIT);
        if (conduit instanceof LocalConduit) {
            return new SynchronousConduit((LocalConduit)conduit);
        }
        return null;
    }

    static class SynchronousConduit
    extends AbstractConduit {
        private LocalConduit conduit;

        public SynchronousConduit(LocalConduit conduit) {
            super(null);
            this.conduit = conduit;
        }

        public void prepare(Message message) throws IOException {
            if (!Boolean.TRUE.equals(message.getExchange().get(LocalConduit.DIRECT_DISPATCH))) {
                final Exchange exchange = (Exchange)message.getExchange().get(LocalConduit.IN_EXCHANGE);
                final PipedInputStream stream = new PipedInputStream();
                Runnable receiver = new Runnable(){

                    public void run() {
                        MessageImpl m = new MessageImpl();
                        if (exchange != null) {
                            exchange.setInMessage(m);
                        }
                        m.setContent(InputStream.class, stream);
                        SynchronousConduit.this.conduit.getMessageObserver().onMessage(m);
                    }
                };
                PipedOutputStream outStream = new PipedOutputStream(stream);
                message.setContent(OutputStream.class, outStream);
                new Thread(receiver).start();
            } else {
                PipedInputStream stream = new PipedInputStream();
                message.setContent(InputStream.class, stream);
                message.setContent(OutputStream.class, new PipedOutputStream(stream));
            }
        }

        public void close(Message message) throws IOException {
            if (Boolean.TRUE.equals(message.getExchange().get(LocalConduit.DIRECT_DISPATCH))) {
                Exchange exchange = (Exchange)message.getExchange().get(LocalConduit.IN_EXCHANGE);
                MessageImpl copy = new MessageImpl();
                copy.putAll(message);
                MessageImpl.copyContent(message, copy);
                if (exchange != null && exchange.getInMessage() == null) {
                    exchange.setInMessage(copy);
                }
                this.conduit.getMessageObserver().onMessage(copy);
                return;
            }
            super.close(message);
        }

        protected Logger getLogger() {
            return LOG;
        }
    }
}

