/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.data;

public class TransferSyntax {
    public static final TransferSyntax ImplicitVRLittleEndian = new TransferSyntax("1.2.840.10008.1.2", false, false, false, false);
    public static final TransferSyntax ImplicitVRBigEndian = new TransferSyntax(null, false, true, false, false);
    public static final TransferSyntax ExplicitVRLittleEndian = new TransferSyntax("1.2.840.10008.1.2.1", true, false, false, false);
    public static final TransferSyntax ExplicitVRBigEndian = new TransferSyntax("1.2.840.10008.1.2.2", true, true, false, false);
    public static final TransferSyntax DeflatedExplicitVRLittleEndian = new TransferSyntax("1.2.840.10008.1.2.1.99", true, false, true, false);
    public static final TransferSyntax NoPixelData = new TransferSyntax("1.2.840.10008.1.2.4.96", true, false, false, false);
    public static final TransferSyntax NoPixelDataDeflate = new TransferSyntax("1.2.840.10008.1.2.4.97", true, false, true, false);
    final String uid;
    final boolean bigEndian;
    final boolean explicitVR;
    final boolean deflated;
    final boolean encapsulated;

    public static TransferSyntax valueOf(String uid) {
        if (uid == null) {
            throw new NullPointerException("uid");
        }
        if (uid.equals(TransferSyntax.ImplicitVRLittleEndian.uid)) {
            return ImplicitVRLittleEndian;
        }
        if (uid.equals(TransferSyntax.ExplicitVRLittleEndian.uid)) {
            return ExplicitVRLittleEndian;
        }
        if (uid.equals(TransferSyntax.ExplicitVRBigEndian.uid)) {
            return ExplicitVRBigEndian;
        }
        if (uid.equals(TransferSyntax.DeflatedExplicitVRLittleEndian.uid)) {
            return DeflatedExplicitVRLittleEndian;
        }
        if (uid.equals(TransferSyntax.NoPixelData.uid)) {
            return NoPixelData;
        }
        if (uid.equals(TransferSyntax.NoPixelDataDeflate.uid)) {
            return NoPixelDataDeflate;
        }
        return new TransferSyntax(uid, true, false, false, true);
    }

    private TransferSyntax(String uid, boolean explicitVR, boolean bigEndian, boolean deflated, boolean encapsulated) {
        this.uid = uid;
        this.explicitVR = explicitVR;
        this.bigEndian = bigEndian;
        this.deflated = deflated;
        this.encapsulated = encapsulated;
    }

    public final String uid() {
        return this.uid;
    }

    public final boolean bigEndian() {
        return this.bigEndian;
    }

    public final boolean explicitVR() {
        return this.explicitVR;
    }

    public final boolean deflated() {
        return this.deflated;
    }

    public final boolean encapsulated() {
        return this.encapsulated;
    }

    public final boolean uncompressed() {
        return !this.deflated && !this.encapsulated;
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof TransferSyntax)) {
            return false;
        }
        return this.uid().equals(((TransferSyntax)o2).uid());
    }
}

