/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.media;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.TransferSyntax;
import org.dcm4che2.data.VR;
import org.dcm4che2.io.DicomInputStream;
import org.dcm4che2.io.StopTagInputHandler;
import org.dcm4che2.media.FilesetInformation;
import org.dcm4che2.util.IntHashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DicomDirReader {
    protected static Logger log = LoggerFactory.getLogger(DicomDirReader.class);
    protected static final int INACTIVE = 0;
    protected static final int INUSE = 65535;
    protected final RandomAccessFile raf;
    protected final DicomInputStream in;
    protected final FilesetInformation filesetInfo;
    protected final IntHashtable<DicomObject> cache = new IntHashtable();
    protected File file;
    protected boolean showInactiveRecords;

    protected DicomDirReader(RandomAccessFile raf, FilesetInformation fileSetInfo) throws IOException {
        this.raf = raf;
        this.in = new DicomInputStream(raf, TransferSyntax.ExplicitVRLittleEndian);
        this.filesetInfo = fileSetInfo;
    }

    public DicomDirReader(File file) throws IOException {
        this(new RandomAccessFile(file, "r"));
        this.file = file;
    }

    public DicomDirReader(RandomAccessFile raf) throws IOException {
        this.raf = raf;
        this.in = new DicomInputStream(raf);
        this.in.setHandler(new StopTagInputHandler(266784));
        this.filesetInfo = new FilesetInformation();
        this.in.readDicomObject(this.filesetInfo.getDicomObject(), -1);
        this.in.setHandler(this.in);
    }

    public int getFilesetConsistencyFlag() {
        return this.filesetInfo.getFilesetConsistencyFlag();
    }

    public boolean isNoKnownInconsistencies() {
        return this.filesetInfo.isNoKnownInconsistencies();
    }

    public File getFilesetDescriptorFile() {
        if (this.file == null) {
            throw new IllegalStateException("Unknown File-set Base Directory");
        }
        return this.filesetInfo.getFilesetDescriptorFile(this.file.getParentFile());
    }

    public String getMediaStorageSOPInstanceUID() {
        return this.filesetInfo.getMediaStorageSOPInstanceUID();
    }

    public String getSpecificCharacterSetofFilesetDescriptorFile() {
        return this.filesetInfo.getSpecificCharacterSetofFilesetDescriptorFile();
    }

    public boolean isEmpty() {
        return this.filesetInfo.isEmpty();
    }

    public final File getFile() {
        return this.file;
    }

    public File toReferencedFile(DicomObject rec) {
        if (this.file == null) {
            throw new IllegalStateException("Unknown File-set Base Directory");
        }
        return FilesetInformation.toFile(rec.getStrings(267520), this.file.getParentFile());
    }

    public String[] toFileID(File f) {
        if (this.file == null) {
            throw new IllegalStateException("Unknown File-set Base Directory");
        }
        return FilesetInformation.toFileID(f, this.file.getParentFile());
    }

    public void clearCache() {
        this.cache.clear();
    }

    public FilesetInformation getFilesetInformation() {
        return this.filesetInfo;
    }

    public final boolean isShowInactiveRecords() {
        return this.showInactiveRecords;
    }

    public final void setShowInactiveRecords(boolean showInactiveRecords) {
        this.showInactiveRecords = showInactiveRecords;
    }

    public DicomObject findFirstRootRecord() throws IOException {
        return this.findFirstMatchingRootRecord(null, false);
    }

    protected DicomObject lastRootRecord() throws IOException {
        return this.readRecord(this.filesetInfo.getOffsetLastRootRecord());
    }

    public DicomObject findFirstMatchingRootRecord(DicomObject keys, boolean ignoreCaseOfPN) throws IOException {
        return this.readRecord(this.filesetInfo.getOffsetFirstRootRecord(), keys, ignoreCaseOfPN);
    }

    public DicomObject findPatientRecord(String pid) throws IOException {
        BasicDicomObject keys = new BasicDicomObject();
        keys.putString(267312, VR.CS, "PATIENT");
        keys.putString(0x100020, VR.LO, pid);
        return this.findFirstMatchingRootRecord(keys, false);
    }

    public DicomObject findNextSiblingRecord(DicomObject prevRecord) throws IOException {
        return this.findNextMatchingSiblingRecord(prevRecord, null, false);
    }

    public DicomObject findNextMatchingSiblingRecord(DicomObject prevRecord, DicomObject keys, boolean ignoreCaseOfPN) throws IOException {
        return this.readRecord(prevRecord.getInt(267264), keys, ignoreCaseOfPN);
    }

    public DicomObject findFirstChildRecord(DicomObject parentRecord) throws IOException {
        return this.findFirstMatchingChildRecord(parentRecord, null, false);
    }

    public DicomObject findFirstMatchingChildRecord(DicomObject parentRecord, DicomObject keys, boolean ignoreCaseOfPN) throws IOException {
        return this.readRecord(parentRecord.getInt(267296), keys, ignoreCaseOfPN);
    }

    public DicomObject findStudyRecord(DicomObject patrec, String uid) throws IOException {
        BasicDicomObject keys = new BasicDicomObject();
        keys.putString(267312, VR.CS, "STUDY");
        keys.putString(0x20000D, VR.UI, uid);
        keys.putString(267537, VR.UI, uid);
        return this.findFirstMatchingChildRecord(patrec, keys, false);
    }

    public DicomObject findSeriesRecord(DicomObject styrec, String uid) throws IOException {
        BasicDicomObject keys = new BasicDicomObject();
        keys.putString(267312, VR.CS, "SERIES");
        keys.putString(0x20000E, VR.UI, uid);
        return this.findFirstMatchingChildRecord(styrec, keys, false);
    }

    public DicomObject findInstanceRecord(DicomObject serrec, String uid) throws IOException {
        BasicDicomObject keys = new BasicDicomObject();
        keys.putString(267537, VR.UI, uid);
        return this.findFirstMatchingChildRecord(serrec, keys, false);
    }

    private DicomObject readRecord(int offset, DicomObject keys, boolean ignoreCaseOfPN) throws IOException {
        while (offset != 0) {
            DicomObject item = this.readRecord(offset);
            if ((this.showInactiveRecords || item.getInt(267280) != 0) && (keys == null || item.matches(keys, ignoreCaseOfPN))) {
                return item;
            }
            offset = item.getInt(267264);
        }
        return null;
    }

    protected DicomObject readRecord(int offset) throws IOException {
        if (offset == 0) {
            return null;
        }
        DicomObject item = this.cache.get(offset);
        long off = (long)offset & 0xFFFFFFFFL;
        if (item != null) {
            log.debug("Get record @ {} from cache", (Object)new Long(off));
        } else {
            log.debug("Load record @ {} from file {}", (Object)new Long(off), (Object)this.file);
            this.raf.seek(off);
            this.in.setStreamPosition(off);
            item = new BasicDicomObject();
            this.in.readItem(item);
            this.cache.put(offset, item);
        }
        return item;
    }

    protected DicomObject lastChildRecord(DicomObject parentRec) throws IOException {
        DicomObject child = this.readRecord(parentRec.getInt(267296));
        return child != null ? this.lastSiblingOrThis(child) : null;
    }

    protected DicomObject lastSiblingOrThis(DicomObject rec) throws IOException {
        DicomObject next;
        while ((next = this.readRecord(rec.getInt(267264))) != null) {
            rec = next;
        }
        return rec;
    }

    public void close() throws IOException {
        this.raf.close();
    }
}

