/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.ttc7.TTCColumn;
import oracle.jdbc.ttc7.TTCItem;
import oracle.jdbc.ttc7.TTIoac;

public class PlsqlTTCColumn
extends TTCColumn {
    private TTCItem in;
    private TTCItem out;

    protected PlsqlTTCColumn(TTIoac tTIoac) {
        super(tTIoac, 1);
    }

    protected void marshal() throws SQLException, IOException {
        if (this.in == null && this.out == null) {
            DBError.check_error(426);
        }
        if (this.in != null) {
            this.in.marshal();
        } else {
            this.out.marshalPLSQL();
        }
    }

    protected boolean unmarshal() throws SQLException, IOException {
        if (this.in == null && this.out == null) {
            DBError.check_error(426);
        }
        if (this.out != null) {
            this.out.unmarshal();
            this.out.unmarshalIndicator();
        } else {
            this.in.unmarshal();
            this.in.unmarshalIndicator();
        }
        return false;
    }

    protected void setIN(TTCItem tTCItem) {
        this.in = tTCItem;
    }

    protected void setOUT(TTCItem tTCItem) {
        this.out = tTCItem;
    }

    protected void print(int n, int n2, int n3) {
        OracleLog.print(this, n, n2, n3, "           ---- Enter: PlsqlTTCColumn.print  --- ");
        super.print(n, n2, n3);
        OracleLog.print(this, n, n2, n3, "          +++++ IN Item information: ");
        if (this.in != null) {
            this.in.print(n, n2, n3);
        } else {
            OracleLog.print(this, n, n2, n3, "              IN bind is NULL ");
        }
        OracleLog.print(this, n, n2, n3, "          +++++ OUT Item information: ");
        if (this.out != null) {
            this.out.print(n, n2, n3);
        } else {
            OracleLog.print(this, n, n2, n3, "              OUT bind is NULL ");
        }
        OracleLog.print(this, n, n2, n3, "           ---- Exit: PlsqlTTCColumn.print --- ");
    }
}

