/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.InputStream;
import java.io.OutputStream;
import oracle.net.ano.Ano;
import oracle.net.ns.ClientProfile;
import oracle.net.ns.NetException;
import oracle.net.ns.NetInputStream;
import oracle.net.ns.NetOutputStream;
import oracle.net.ns.SQLnetDef;
import oracle.net.nt.ConnOption;
import oracle.net.nt.NTAdapter;

public class SessionAtts
implements SQLnetDef {
    private int sdu;
    private int tdu;
    protected NTAdapter nt;
    protected InputStream ntInputStream;
    protected OutputStream ntOutputStream;
    protected NetInputStream nsInputStream;
    protected NetOutputStream nsOutputStream;
    protected ConnOption cOption;
    protected boolean dataEOF;
    protected boolean connected;
    public boolean onBreakReset;
    public ClientProfile profile;
    public Ano ano;
    public boolean anoEnabled;
    public boolean isEncryptionActive;
    public boolean isChecksumActive;
    public boolean areEncryptionAndChecksumActive;

    public SessionAtts(int n, int n2) {
        this.sdu = n;
        this.tdu = n2;
    }

    public int getANOFlags() {
        int n = 1;
        if (this.ano != null) {
            n = this.ano.getNAFlags();
        }
        return n;
    }

    public InputStream getInputStream() {
        return this.nsInputStream;
    }

    public OutputStream getOutputStream() {
        return this.nsOutputStream;
    }

    public int getSDU() {
        return this.sdu;
    }

    public int getTDU() {
        return this.tdu;
    }

    public void print() {
        System.out.println("Session Attributes: ");
        System.out.println("sdu            : " + this.sdu);
        System.out.println("tdu            : " + this.tdu);
        System.out.println("nt             : " + this.nt);
        System.out.println("ntInputStream  : " + this.ntInputStream);
        System.out.println("ntOutputStream : " + this.ntOutputStream);
        System.out.println("nsInputStream  : " + this.nsInputStream);
        System.out.println("nsOutputStream : " + this.nsOutputStream);
        System.out.println("profile        : " + this.profile);
        System.out.println("cOption        : " + this.cOption);
        System.out.println("onBreakReset   : " + this.onBreakReset);
        System.out.println("dataEOF        : " + this.dataEOF);
        System.out.println("connected      : " + this.connected);
    }

    public void setSDU(int n) {
        this.sdu = n <= 0 ? 2048 : (n > Short.MAX_VALUE ? Short.MAX_VALUE : (n < 512 ? 512 : n));
    }

    public void setTDU(int n) {
        this.tdu = n <= 0 ? Short.MAX_VALUE : (n > Short.MAX_VALUE ? Short.MAX_VALUE : (n < 255 ? 255 : n));
    }

    public void turnEncryptionOn(NetInputStream netInputStream, NetOutputStream netOutputStream) throws NetException {
        if (netInputStream == null || netOutputStream == null) {
            throw new NetException(300);
        }
        this.nsInputStream = netInputStream;
        this.nsOutputStream = netOutputStream;
    }
}

