/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import oracle.net.TNSAddress.SOException;
import oracle.net.jndi.JndiAttrs;
import oracle.net.nl.NLException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVNavigator;
import oracle.net.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.nt.ConnOption;
import oracle.net.nt.ConnStrategy;
import oracle.net.resolver.NavSchemaObjectFactory;
import oracle.net.resolver.NavServiceAlias;

public class AddrResolution {
    private ConnStrategy cs;
    private Properties up;
    private static final String default_proxy_rules = "__jdbc__";
    private static final String service_alias_name = "ora-net-service-alias";
    private static final String service_attr_name = "orclnetdescstring";
    private static final int length_of_alias_prefix = 6;
    private JndiAttrs ja;
    private boolean newSyntax = true;
    public boolean jndi = false;
    public boolean connection_revised = false;
    private String TNSAddress;

    public AddrResolution(String string, Properties properties) throws NetException {
        String[] stringArray = new String[1];
        this.up = properties;
        this.TNSAddress = string;
        if (((Hashtable)this.up).containsKey("java.naming.provider.url") || string.startsWith("ldap:")) {
            if (string.startsWith("ldap:")) {
                ((Hashtable)this.up).put("java.naming.provider.url", string.substring(string.indexOf("ldap:"), string.lastIndexOf(47)));
                this.TNSAddress = string.substring(string.lastIndexOf(47) + 1, string.length());
            }
            this.ja = new JndiAttrs(this.up);
            this.jndi = true;
            stringArray[0] = service_attr_name;
            Vector vector = this.ja.getAttrs(this.TNSAddress, stringArray);
            this.TNSAddress = (String)vector.firstElement();
            this.connection_revised = true;
        }
        if (this.up.getProperty("oracle.net.oldSyntax") == "YES") {
            this.newSyntax = false;
        }
    }

    public JndiAttrs getJndi() {
        return this.ja;
    }

    public String getTNSAddress() {
        return this.TNSAddress.toUpperCase();
    }

    public Properties getUp() {
        return this.up;
    }

    private StringBuffer insertCID(String string) throws NetException {
        NVFactory nVFactory = new NVFactory();
        NVNavigator nVNavigator = new NVNavigator();
        StringBuffer stringBuffer = new StringBuffer(2048);
        NVPair nVPair = nVNavigator.findNVPairRecurse(nVFactory.createNVPair(string), "description");
        NVPair nVPair2 = nVNavigator.findNVPairRecurse(nVFactory.createNVPair(string), "address_list");
        NVPair nVPair3 = nVNavigator.findNVPairRecurse(nVFactory.createNVPair(string), "address");
        NVPair nVPair4 = nVNavigator.findNVPairRecurse(nVFactory.createNVPair(string), "connect_data");
        NVPair nVPair5 = nVNavigator.findNVPairRecurse(nVFactory.createNVPair(string), "source_route");
        NVPair nVPair6 = null;
        NVPair nVPair7 = null;
        NVPair nVPair8 = null;
        if (nVPair4 == null) {
            throw new NetException(105);
        }
        nVPair6 = nVNavigator.findNVPair(nVPair4, "SID");
        nVPair7 = nVNavigator.findNVPair(nVPair4, "CID");
        nVPair8 = nVNavigator.findNVPair(nVPair4, "SERVICE_NAME");
        if (nVPair6 == null && nVPair8 == null) {
            throw new NetException(106);
        }
        stringBuffer.append("(DESCRIPTION=");
        if (nVPair2 != null && nVPair2.getListSize() > 0) {
            int n = 0;
            while (n < nVPair2.getListSize()) {
                NVPair nVPair9 = nVPair2.getListElement(n);
                stringBuffer.append(nVPair9.toString());
                ++n;
            }
        } else if (nVPair3 != null) {
            stringBuffer.append(nVPair3.toString());
        } else {
            throw new NetException(107);
        }
        if (nVPair8 != null) {
            stringBuffer.append("(CONNECT_DATA=" + nVPair8.toString() + "(CID=(PROGRAM=)(HOST=__jdbc__)(USER=)))");
        } else {
            stringBuffer.append("(CONNECT_DATA=" + nVPair6.toString() + "(CID=(PROGRAM=)(HOST=__jdbc__)(USER=)))");
        }
        if (nVPair5 != null) {
            stringBuffer.append(nVPair5.toString());
        }
        stringBuffer.append(")");
        return stringBuffer;
    }

    private void resolveAddr(String string) throws NetException {
        Object object;
        if (string.startsWith("alias=")) {
            object = string;
            string = ((String)object).substring(((String)object).indexOf("alias=") + 6, ((String)object).length());
        }
        object = new ConnOption();
        NVFactory nVFactory = new NVFactory();
        NVNavigator nVNavigator = new NVNavigator();
        NVPair nVPair = nVNavigator.findNVPairRecurse(nVFactory.createNVPair(string), "CID");
        NVPair nVPair2 = nVNavigator.findNVPairRecurse(nVFactory.createNVPair(string), "address");
        NVPair nVPair3 = nVNavigator.findNVPair(nVPair2, "protocol");
        if (nVPair3 == null) {
            throw new NetException(100);
        }
        ((ConnOption)object).protocol = nVPair3.getAtom();
        if (!(((ConnOption)object).protocol.equals("TCP") || ((ConnOption)object).protocol.equals("tcp") || ((ConnOption)object).protocol.equals("SSL") || ((ConnOption)object).protocol.equals("ssl") || ((ConnOption)object).protocol.equals("ANO") || ((ConnOption)object).protocol.equals("ano"))) {
            throw new NetException(102);
        }
        nVPair3 = nVNavigator.findNVPair(nVPair2, "Host");
        if (nVPair3 == null) {
            throw new NetException(103);
        }
        ((ConnOption)object).host = nVPair3.getAtom();
        nVPair3 = nVNavigator.findNVPair(nVPair2, "Port");
        if (nVPair3 == null) {
            throw new NetException(104);
        }
        ((ConnOption)object).port = Integer.parseInt(nVPair3.getAtom());
        nVPair3 = nVNavigator.findNVPair(nVPair2, "sduSize");
        if (nVPair3 != null) {
            ((ConnOption)object).sdu = Integer.parseInt(nVPair3.getAtom());
        }
        if ((nVPair3 = nVNavigator.findNVPair(nVPair2, "tduSize")) != null) {
            ((ConnOption)object).tdu = Integer.parseInt(nVPair3.getAtom());
        }
        NVPair nVPair4 = nVNavigator.findNVPairRecurse(nVFactory.createNVPair(string), "connect_data");
        StringBuffer stringBuffer = new StringBuffer(string);
        ((ConnOption)object).conn_data = nVPair4 != null ? this.insertCID(string) : stringBuffer;
        ((ConnOption)object).addr = "(ADDRESS=(PROTOCOL=tcp)(HOST=" + ((ConnOption)object).host + ")(PORT=" + ((ConnOption)object).port + "))";
        this.cs.addOption((ConnOption)object);
    }

    private void resolveAddrTree(String string) throws NetException {
        NavSchemaObjectFactory navSchemaObjectFactory = new NavSchemaObjectFactory();
        NavServiceAlias navServiceAlias = (NavServiceAlias)navSchemaObjectFactory.create(4);
        try {
            String string2 = string.startsWith("alias=") ? string : "alias=" + string;
            navServiceAlias.initFromString(string2);
        }
        catch (NLException nLException) {
            throw new NetException(501);
        }
        catch (SOException sOException) {
            throw new NetException(502, sOException.getMessage());
        }
        navServiceAlias.navigate(this.cs, null);
    }

    public ConnOption resolveAndExecute(String string) throws NetException, IOException {
        if (string != null) {
            this.cs = new ConnStrategy(this.up);
            if (string.indexOf("//") != -1) {
                this.resolveUrl(string);
            } else if (string.indexOf(58) != -1 && string.indexOf(41) == -1) {
                this.resolveSimple(string);
            } else if (this.newSyntax) {
                this.resolveAddrTree(string);
            } else {
                this.resolveAddr(string);
            }
            if (this.cs.optAvailable()) {
                return this.cs.getOption();
            }
        } else if (this.cs == null || !this.cs.hasMoreOptions()) {
            return null;
        }
        return this.cs.execute();
    }

    private void resolveSimple(String string) throws NetException {
        ConnOption connOption = new ConnOption();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        n = string.indexOf(58);
        if (n == -1 || (n2 = string.indexOf(58, n + 1)) == -1) {
            throw new NetException(115);
        }
        n3 = string.indexOf(58, n2 + 1);
        if (n3 != -1) {
            throw new NetException(115);
        }
        try {
            connOption.host = string.substring(0, n);
            connOption.port = Integer.parseInt(string.substring(n + 1, n2));
            connOption.addr = "(ADDRESS=(PROTOCOL=tcp)(HOST=" + connOption.host + ")(PORT=" + connOption.port + "))";
            connOption.sid = string.substring(n2 + 1, string.length());
            String string2 = "(DESCRIPTION=(CONNECT_DATA=(SID=" + connOption.sid + ")(CID=(PROGRAM=)(HOST=__jdbc__)(USER=)))" + "(ADDRESS=" + "(PROTOCOL=tcp)(HOST=" + connOption.host + ")(PORT=" + connOption.port + ")))";
            connOption.protocol = "TCP";
            connOption.conn_data = new StringBuffer(string2);
            this.cs.addOption(connOption);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NetException(116);
        }
    }

    private void resolveUrl(String string) throws NetException {
        ConnOption connOption = new ConnOption();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        n = string.indexOf("//");
        if (n == -1 || (n2 = string.indexOf(58, n + 2)) == -1 || (n3 = string.indexOf(47, n2 + 1)) == -1 || n3 + 1 == string.length()) {
            throw new NetException(117);
        }
        try {
            connOption.host = string.substring(n + 2, n2);
            connOption.port = Integer.parseInt(string.substring(n2 + 1, n3));
            connOption.addr = "(ADDRESS=(PROTOCOL=tcp)(HOST=" + connOption.host + ")(PORT=" + connOption.port + "))";
            connOption.service_name = string.substring(n3 + 1, string.length());
            String string2 = "(DESCRIPTION=(CONNECT_DATA=(SERVICE_NAME=" + connOption.service_name + ")(CID=(PROGRAM=)(HOST=__jdbc__)(USER=)))" + "(ADDRESS=" + "(PROTOCOL=tcp)(HOST=" + connOption.host + ")(PORT=" + connOption.port + ")))";
            connOption.protocol = "TCP";
            connOption.conn_data = new StringBuffer(string2);
            this.cs.addOption(connOption);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NetException(116);
        }
    }
}

