/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql.converter;

import java.sql.SQLException;
import java.util.Vector;
import oracle.sql.converter.CharacterConverter12Byte;

public class CharacterConverterGB18030
extends CharacterConverter12Byte {
    protected static int MAXLIMIT = 64000;
    static final int BMPSTART = -2127527632;
    static final int BMPEND = -2077121479;
    static final int GBBMPSTART = 1687218;
    static final int GBBMPEND = 1726637;
    static final int USURSTART = 65536;
    static final int USUREND = 0x10FFFF;
    static final int GBSURSTART = 1876218;
    static final int GBSUREND = 2924793;
    static char[][] gbMapping;

    static {
        char[][] cArrayArray = new char[206][];
        char[] cArray = new char[4];
        cArray[0] = 128;
        cArray[1] = 163;
        cArray[3] = 35;
        cArrayArray[0] = cArray;
        cArrayArray[1] = new char[]{'\u00a5', '\u00a6', '$', '%'};
        cArrayArray[2] = new char[]{'\u00a9', '\u00af', '&', ','};
        cArrayArray[3] = new char[]{'\u00b2', '\u00b6', '-', '1'};
        cArrayArray[4] = new char[]{'\u00b8', '\u00d6', '2', 'P'};
        cArrayArray[5] = new char[]{'\u00d8', '\u00df', 'Q', 'X'};
        cArrayArray[6] = new char[]{'\u00e2', '\u00e7', 'Y', '^'};
        cArrayArray[7] = new char[]{'\u00eb', '\u00eb', '_', '_'};
        cArrayArray[8] = new char[]{'\u00ee', '\u00f1', '`', 'c'};
        cArrayArray[9] = new char[]{'\u00f4', '\u00f6', 'd', 'f'};
        cArrayArray[10] = new char[]{'\u00f8', '\u00f8', 'g', 'g'};
        cArrayArray[11] = new char[]{'\u00fb', '\u00fb', 'h', 'h'};
        cArrayArray[12] = new char[]{'\u00fd', '\u0100', 'i', 'l'};
        cArrayArray[13] = new char[]{'\u0102', '\u0112', 'm', '}'};
        cArrayArray[14] = new char[]{'\u0114', '\u011a', '~', '\u0084'};
        cArrayArray[15] = new char[]{'\u011c', '\u012a', '\u0085', '\u0093'};
        cArrayArray[16] = new char[]{'\u012c', '\u0143', '\u0094', '\u00ab'};
        cArrayArray[17] = new char[]{'\u0145', '\u0147', '\u00ac', '\u00ae'};
        cArrayArray[18] = new char[]{'\u0149', '\u014c', '\u00af', '\u00b2'};
        cArrayArray[19] = new char[]{'\u014e', '\u016a', '\u00b3', '\u00cf'};
        cArrayArray[20] = new char[]{'\u016c', '\u01cd', '\u00d0', '\u0131'};
        cArrayArray[21] = new char[]{'\u01cf', '\u01cf', '\u0132', '\u0132'};
        cArrayArray[22] = new char[]{'\u01d1', '\u01d1', '\u0133', '\u0133'};
        cArrayArray[23] = new char[]{'\u01d3', '\u01d3', '\u0134', '\u0134'};
        cArrayArray[24] = new char[]{'\u01d5', '\u01d5', '\u0135', '\u0135'};
        cArrayArray[25] = new char[]{'\u01d7', '\u01d7', '\u0136', '\u0136'};
        cArrayArray[26] = new char[]{'\u01d9', '\u01d9', '\u0137', '\u0137'};
        cArrayArray[27] = new char[]{'\u01db', '\u01db', '\u0138', '\u0138'};
        cArrayArray[28] = new char[]{'\u01dd', '\u01f8', '\u0139', '\u0154'};
        cArrayArray[29] = new char[]{'\u01fa', '\u0250', '\u0155', '\u01ab'};
        cArrayArray[30] = new char[]{'\u0252', '\u0260', '\u01ac', '\u01ba'};
        cArrayArray[31] = new char[]{'\u0262', '\u02c6', '\u01bb', '\u021f'};
        cArrayArray[32] = new char[]{'\u02c8', '\u02c8', '\u0220', '\u0220'};
        cArrayArray[33] = new char[]{'\u02cc', '\u02d8', '\u0221', '\u022d'};
        cArrayArray[34] = new char[]{'\u02da', '\u0390', '\u022e', '\u02e4'};
        cArrayArray[35] = new char[]{'\u03a2', '\u03a2', '\u02e5', '\u02e5'};
        cArrayArray[36] = new char[]{'\u03aa', '\u03b0', '\u02e6', '\u02ec'};
        cArrayArray[37] = new char[]{'\u03c2', '\u03c2', '\u02ed', '\u02ed'};
        cArrayArray[38] = new char[]{'\u03ca', '\u0400', '\u02ee', '\u0324'};
        cArrayArray[39] = new char[]{'\u0402', '\u040f', '\u0325', '\u0332'};
        cArrayArray[40] = new char[]{'\u0450', '\u0450', '\u0333', '\u0333'};
        cArrayArray[41] = new char[]{'\u0452', '\u200f', '\u0334', '\u1ef1'};
        cArrayArray[42] = new char[]{'\u2011', '\u2012', '\u1ef2', '\u1ef3'};
        cArrayArray[43] = new char[]{'\u2017', '\u2017', '\u1ef4', '\u1ef4'};
        cArrayArray[44] = new char[]{'\u201a', '\u201b', '\u1ef5', '\u1ef6'};
        cArrayArray[45] = new char[]{'\u201e', '\u2024', '\u1ef7', '\u1efd'};
        cArrayArray[46] = new char[]{'\u2027', '\u202f', '\u1efe', '\u1f06'};
        cArrayArray[47] = new char[]{'\u2031', '\u2031', '\u1f07', '\u1f07'};
        cArrayArray[48] = new char[]{'\u2034', '\u2034', '\u1f08', '\u1f08'};
        cArrayArray[49] = new char[]{'\u2036', '\u203a', '\u1f09', '\u1f0d'};
        cArrayArray[50] = new char[]{'\u203c', '\u20ab', '\u1f0e', '\u1f7d'};
        cArrayArray[51] = new char[]{'\u20ad', '\u2102', '\u1f7e', '\u1fd3'};
        cArrayArray[52] = new char[]{'\u2104', '\u2104', '\u1fd4', '\u1fd4'};
        cArrayArray[53] = new char[]{'\u2106', '\u2108', '\u1fd5', '\u1fd7'};
        cArrayArray[54] = new char[]{'\u210a', '\u2115', '\u1fd8', '\u1fe3'};
        cArrayArray[55] = new char[]{'\u2117', '\u2120', '\u1fe4', '\u1fed'};
        cArrayArray[56] = new char[]{'\u2122', '\u215f', '\u1fee', '\u202b'};
        cArrayArray[57] = new char[]{'\u216c', '\u216f', '\u202c', '\u202f'};
        cArrayArray[58] = new char[]{'\u217a', '\u218f', '\u2030', '\u2045'};
        cArrayArray[59] = new char[]{'\u2194', '\u2195', '\u2046', '\u2047'};
        cArrayArray[60] = new char[]{'\u219a', '\u2207', '\u2048', '\u20b5'};
        cArrayArray[61] = new char[]{'\u2209', '\u220e', '\u20b6', '\u20bb'};
        cArrayArray[62] = new char[]{'\u2210', '\u2210', '\u20bc', '\u20bc'};
        cArrayArray[63] = new char[]{'\u2212', '\u2214', '\u20bd', '\u20bf'};
        cArrayArray[64] = new char[]{'\u2216', '\u2219', '\u20c0', '\u20c3'};
        cArrayArray[65] = new char[]{'\u221b', '\u221c', '\u20c4', '\u20c5'};
        cArrayArray[66] = new char[]{'\u2221', '\u2222', '\u20c6', '\u20c7'};
        cArrayArray[67] = new char[]{'\u2224', '\u2224', '\u20c8', '\u20c8'};
        cArrayArray[68] = new char[]{'\u2226', '\u2226', '\u20c9', '\u20c9'};
        cArrayArray[69] = new char[]{'\u222c', '\u222d', '\u20ca', '\u20cb'};
        cArrayArray[70] = new char[]{'\u222f', '\u2233', '\u20cc', '\u20d0'};
        cArrayArray[71] = new char[]{'\u2238', '\u223c', '\u20d1', '\u20d5'};
        cArrayArray[72] = new char[]{'\u223e', '\u2247', '\u20d6', '\u20df'};
        cArrayArray[73] = new char[]{'\u2249', '\u224b', '\u20e0', '\u20e2'};
        cArrayArray[74] = new char[]{'\u224d', '\u2251', '\u20e3', '\u20e7'};
        cArrayArray[75] = new char[]{'\u2253', '\u225f', '\u20e8', '\u20f4'};
        cArrayArray[76] = new char[]{'\u2262', '\u2263', '\u20f5', '\u20f6'};
        cArrayArray[77] = new char[]{'\u2268', '\u226d', '\u20f7', '\u20fc'};
        cArrayArray[78] = new char[]{'\u2270', '\u2294', '\u20fd', '\u2121'};
        cArrayArray[79] = new char[]{'\u2296', '\u2298', '\u2122', '\u2124'};
        cArrayArray[80] = new char[]{'\u229a', '\u22a4', '\u2125', '\u212f'};
        cArrayArray[81] = new char[]{'\u22a6', '\u22be', '\u2130', '\u2148'};
        cArrayArray[82] = new char[]{'\u22c0', '\u2311', '\u2149', '\u219a'};
        cArrayArray[83] = new char[]{'\u2313', '\u245f', '\u219b', '\u22e7'};
        cArrayArray[84] = new char[]{'\u246a', '\u2473', '\u22e8', '\u22f1'};
        cArrayArray[85] = new char[]{'\u249c', '\u24ff', '\u22f2', '\u2355'};
        cArrayArray[86] = new char[]{'\u254c', '\u254f', '\u2356', '\u2359'};
        cArrayArray[87] = new char[]{'\u2574', '\u2580', '\u235a', '\u2366'};
        cArrayArray[88] = new char[]{'\u2590', '\u2592', '\u2367', '\u2369'};
        cArrayArray[89] = new char[]{'\u2596', '\u259f', '\u236a', '\u2373'};
        cArrayArray[90] = new char[]{'\u25a2', '\u25b1', '\u2374', '\u2383'};
        cArrayArray[91] = new char[]{'\u25b4', '\u25bb', '\u2384', '\u238b'};
        cArrayArray[92] = new char[]{'\u25be', '\u25c5', '\u238c', '\u2393'};
        cArrayArray[93] = new char[]{'\u25c8', '\u25ca', '\u2394', '\u2396'};
        cArrayArray[94] = new char[]{'\u25cc', '\u25cd', '\u2397', '\u2398'};
        cArrayArray[95] = new char[]{'\u25d0', '\u25e1', '\u2399', '\u23aa'};
        cArrayArray[96] = new char[]{'\u25e6', '\u2604', '\u23ab', '\u23c9'};
        cArrayArray[97] = new char[]{'\u2607', '\u2608', '\u23ca', '\u23cb'};
        cArrayArray[98] = new char[]{'\u260a', '\u263f', '\u23cc', '\u2401'};
        cArrayArray[99] = new char[]{'\u2641', '\u2641', '\u2402', '\u2402'};
        cArrayArray[100] = new char[]{'\u2643', '\u2e80', '\u2403', '\u2c40'};
        cArrayArray[101] = new char[]{'\u2e82', '\u2e83', '\u2c41', '\u2c42'};
        cArrayArray[102] = new char[]{'\u2e85', '\u2e87', '\u2c43', '\u2c45'};
        cArrayArray[103] = new char[]{'\u2e89', '\u2e8a', '\u2c46', '\u2c47'};
        cArrayArray[104] = new char[]{'\u2e8d', '\u2e96', '\u2c48', '\u2c51'};
        cArrayArray[105] = new char[]{'\u2e98', '\u2ea6', '\u2c52', '\u2c60'};
        cArrayArray[106] = new char[]{'\u2ea8', '\u2ea9', '\u2c61', '\u2c62'};
        cArrayArray[107] = new char[]{'\u2eab', '\u2ead', '\u2c63', '\u2c65'};
        cArrayArray[108] = new char[]{'\u2eaf', '\u2eb2', '\u2c66', '\u2c69'};
        cArrayArray[109] = new char[]{'\u2eb4', '\u2eb5', '\u2c6a', '\u2c6b'};
        cArrayArray[110] = new char[]{'\u2eb8', '\u2eba', '\u2c6c', '\u2c6e'};
        cArrayArray[111] = new char[]{'\u2ebc', '\u2ec9', '\u2c6f', '\u2c7c'};
        cArrayArray[112] = new char[]{'\u2ecb', '\u2fef', '\u2c7d', '\u2da1'};
        cArrayArray[113] = new char[]{'\u2ffc', '\u2fff', '\u2da2', '\u2da5'};
        cArrayArray[114] = new char[]{'\u3004', '\u3004', '\u2da6', '\u2da6'};
        cArrayArray[115] = new char[]{'\u3018', '\u301c', '\u2da7', '\u2dab'};
        cArrayArray[116] = new char[]{'\u301f', '\u3020', '\u2dac', '\u2dad'};
        cArrayArray[117] = new char[]{'\u302a', '\u303d', '\u2dae', '\u2dc1'};
        cArrayArray[118] = new char[]{'\u303f', '\u3040', '\u2dc2', '\u2dc3'};
        cArrayArray[119] = new char[]{'\u3094', '\u309a', '\u2dc4', '\u2dca'};
        cArrayArray[120] = new char[]{'\u309f', '\u30a0', '\u2dcb', '\u2dcc'};
        cArrayArray[121] = new char[]{'\u30f7', '\u30fb', '\u2dcd', '\u2dd1'};
        cArrayArray[122] = new char[]{'\u30ff', '\u3104', '\u2dd2', '\u2dd7'};
        cArrayArray[123] = new char[]{'\u312a', '\u321f', '\u2dd8', '\u2ecd'};
        cArrayArray[124] = new char[]{'\u322a', '\u3230', '\u2ece', '\u2ed4'};
        cArrayArray[125] = new char[]{'\u3232', '\u32a2', '\u2ed5', '\u2f45'};
        cArrayArray[126] = new char[]{'\u32a4', '\u338d', '\u2f46', '\u302f'};
        cArrayArray[127] = new char[]{'\u3390', '\u339b', '\u3030', '\u303b'};
        cArrayArray[128] = new char[]{'\u339f', '\u33a0', '\u303c', '\u303d'};
        cArrayArray[129] = new char[]{'\u33a2', '\u33c3', '\u303e', '\u305f'};
        cArrayArray[130] = new char[]{'\u33c5', '\u33cd', '\u3060', '\u3068'};
        cArrayArray[131] = new char[]{'\u33cf', '\u33d0', '\u3069', '\u306a'};
        cArrayArray[132] = new char[]{'\u33d3', '\u33d4', '\u306b', '\u306c'};
        cArrayArray[133] = new char[]{'\u33d6', '\u3446', '\u306d', '\u30dd'};
        cArrayArray[134] = new char[]{'\u3448', '\u3472', '\u30de', '\u3108'};
        cArrayArray[135] = new char[]{'\u3474', '\u359d', '\u3109', '\u3232'};
        cArrayArray[136] = new char[]{'\u359f', '\u360d', '\u3233', '\u32a1'};
        cArrayArray[137] = new char[]{'\u360f', '\u3619', '\u32a2', '\u32ac'};
        cArrayArray[138] = new char[]{'\u361b', '\u3917', '\u32ad', '\u35a9'};
        cArrayArray[139] = new char[]{'\u3919', '\u396d', '\u35aa', '\u35fe'};
        cArrayArray[140] = new char[]{'\u396f', '\u39ce', '\u35ff', '\u365e'};
        cArrayArray[141] = new char[]{'\u39d1', '\u39de', '\u365f', '\u366c'};
        cArrayArray[142] = new char[]{'\u39e0', '\u3a72', '\u366d', '\u36ff'};
        cArrayArray[143] = new char[]{'\u3a74', '\u3b4d', '\u3700', '\u37d9'};
        cArrayArray[144] = new char[]{'\u3b4f', '\u3c6d', '\u37da', '\u38f8'};
        cArrayArray[145] = new char[]{'\u3c6f', '\u3cdf', '\u38f9', '\u3969'};
        cArrayArray[146] = new char[]{'\u3ce1', '\u4055', '\u396a', '\u3cde'};
        cArrayArray[147] = new char[]{'\u4057', '\u415e', '\u3cdf', '\u3de6'};
        cArrayArray[148] = new char[]{'\u4160', '\u4336', '\u3de7', '\u3fbd'};
        cArrayArray[149] = new char[]{'\u4338', '\u43ab', '\u3fbe', '\u4031'};
        cArrayArray[150] = new char[]{'\u43ad', '\u43b0', '\u4032', '\u4035'};
        cArrayArray[151] = new char[]{'\u43b2', '\u43dc', '\u4036', '\u4060'};
        cArrayArray[152] = new char[]{'\u43de', '\u44d5', '\u4061', '\u4158'};
        cArrayArray[153] = new char[]{'\u44d7', '\u464b', '\u4159', '\u42cd'};
        cArrayArray[154] = new char[]{'\u464d', '\u4660', '\u42ce', '\u42e1'};
        cArrayArray[155] = new char[]{'\u4662', '\u4722', '\u42e2', '\u43a2'};
        cArrayArray[156] = new char[]{'\u4724', '\u4728', '\u43a3', '\u43a7'};
        cArrayArray[157] = new char[]{'\u472a', '\u477b', '\u43a8', '\u43f9'};
        cArrayArray[158] = new char[]{'\u477d', '\u478c', '\u43fa', '\u4409'};
        cArrayArray[159] = new char[]{'\u478e', '\u4946', '\u440a', '\u45c2'};
        cArrayArray[160] = new char[]{'\u4948', '\u4979', '\u45c3', '\u45f4'};
        cArrayArray[161] = new char[]{'\u497b', '\u497c', '\u45f5', '\u45f6'};
        cArrayArray[162] = new char[]{'\u497e', '\u4981', '\u45f7', '\u45fa'};
        cArrayArray[163] = new char[]{'\u4984', '\u4984', '\u45fb', '\u45fb'};
        cArrayArray[164] = new char[]{'\u4987', '\u499a', '\u45fc', '\u460f'};
        cArrayArray[165] = new char[]{'\u499c', '\u499e', '\u4610', '\u4612'};
        cArrayArray[166] = new char[]{'\u49a0', '\u49b5', '\u4613', '\u4628'};
        cArrayArray[167] = new char[]{'\u49b8', '\u4c76', '\u4629', '\u48e7'};
        cArrayArray[168] = new char[]{'\u4c78', '\u4c9e', '\u48e8', '\u490e'};
        cArrayArray[169] = new char[]{'\u4ca4', '\u4d12', '\u490f', '\u497d'};
        cArrayArray[170] = new char[]{'\u4d1a', '\u4dad', '\u497e', '\u4a11'};
        cArrayArray[171] = new char[]{'\u4daf', '\u4dff', '\u4a12', '\u4a62'};
        cArrayArray[172] = new char[]{'\u9fa6', '\ud7ff', '\u4a63', '\u82bc'};
        cArrayArray[173] = new char[]{'\ue76c', '\ue76c', '\u82bd', '\u82bd'};
        cArrayArray[174] = new char[]{'\ue7c8', '\ue7c8', '\u82be', '\u82be'};
        cArrayArray[175] = new char[]{'\ue7e7', '\ue7f3', '\u82bf', '\u82cb'};
        cArrayArray[176] = new char[]{'\ue815', '\ue815', '\u82cc', '\u82cc'};
        cArrayArray[177] = new char[]{'\ue819', '\ue81d', '\u82cd', '\u82d1'};
        cArrayArray[178] = new char[]{'\ue81f', '\ue825', '\u82d2', '\u82d8'};
        cArrayArray[179] = new char[]{'\ue827', '\ue82a', '\u82d9', '\u82dc'};
        cArrayArray[180] = new char[]{'\ue82d', '\ue830', '\u82dd', '\u82e0'};
        cArrayArray[181] = new char[]{'\ue833', '\ue83a', '\u82e1', '\u82e8'};
        cArrayArray[182] = new char[]{'\ue83c', '\ue842', '\u82e9', '\u82ef'};
        cArrayArray[183] = new char[]{'\ue844', '\ue853', '\u82f0', '\u82ff'};
        cArrayArray[184] = new char[]{'\ue856', '\ue863', '\u8300', '\u830d'};
        cArrayArray[185] = new char[]{'\ue865', '\uf92b', '\u830e', '\u93d4'};
        cArrayArray[186] = new char[]{'\uf92d', '\uf978', '\u93d5', '\u9420'};
        cArrayArray[187] = new char[]{'\uf97a', '\uf994', '\u9421', '\u943b'};
        cArrayArray[188] = new char[]{'\uf996', '\uf9e6', '\u943c', '\u948c'};
        cArrayArray[189] = new char[]{'\uf9e8', '\uf9f0', '\u948d', '\u9495'};
        cArrayArray[190] = new char[]{'\uf9f2', '\ufa0b', '\u9496', '\u94af'};
        cArrayArray[191] = new char[]{'\ufa10', '\ufa10', '\u94b0', '\u94b0'};
        cArrayArray[192] = new char[]{'\ufa12', '\ufa12', '\u94b1', '\u94b1'};
        cArrayArray[193] = new char[]{'\ufa15', '\ufa17', '\u94b2', '\u94b4'};
        cArrayArray[194] = new char[]{'\ufa19', '\ufa1e', '\u94b5', '\u94ba'};
        cArrayArray[195] = new char[]{'\ufa22', '\ufa22', '\u94bb', '\u94bb'};
        cArrayArray[196] = new char[]{'\ufa25', '\ufa26', '\u94bc', '\u94bd'};
        cArrayArray[197] = new char[]{'\ufa2a', '\ufe2f', '\u94be', '\u98c3'};
        cArrayArray[198] = new char[]{'\ufe32', '\ufe32', '\u98c4', '\u98c4'};
        cArrayArray[199] = new char[]{'\ufe45', '\ufe48', '\u98c5', '\u98c8'};
        cArrayArray[200] = new char[]{'\ufe53', '\ufe53', '\u98c9', '\u98c9'};
        cArrayArray[201] = new char[]{'\ufe58', '\ufe58', '\u98ca', '\u98ca'};
        cArrayArray[202] = new char[]{'\ufe67', '\ufe67', '\u98cb', '\u98cb'};
        cArrayArray[203] = new char[]{'\ufe6c', '\uff00', '\u98cc', '\u9960'};
        cArrayArray[204] = new char[]{'\uff5f', '\uffdf', '\u9961', '\u99e1'};
        cArrayArray[205] = new char[]{'\uffe6', '\uffff', '\u99e2', '\u99fb'};
        gbMapping = cArrayArray;
    }

    public CharacterConverterGB18030() {
        this.m_groupId = 9;
    }

    private int bMPLinear(int n) {
        return (((n >> 24 & 0xFF) * 10 + (n >> 16 & 0xFF)) * 126 + (n >> 8 & 0xFF)) * 10 + (n & 0xFF) - 1687218;
    }

    private int bMPOracle2Unicode(int n) {
        int n2 = this.searchgbMapping((char)this.bMPLinear(n), false);
        if (n2 == -1) {
            return 0;
        }
        return n2;
    }

    private int bMPUnicode2Oracle(char c) {
        int n = this.searchgbMapping(c, true);
        if (n == -1) {
            return 0;
        }
        return this.bMPunLinear(n);
    }

    private int bMPunLinear(int n) {
        int n2 = 0;
        n2 = 48 + n % 10 & 0xFF;
        n2 += (129 + (n /= 10) % 126 & 0xFF) << 8;
        n2 += (48 + (n /= 126) % 10 & 0xFF) << 16;
        return n2 += (129 + (n /= 10) & 0xFF) << 24;
    }

    public void buildUnicodeToOracleMapping() {
        int n;
        int n2;
        int n3;
        this.m_oraCharLevel1 = new int[256];
        char[] cArray = new char[MAXLIMIT];
        int n4 = 0;
        int[][] nArray = new int[MAXLIMIT][2];
        int n5 = 0;
        int n6 = 0;
        while (n6 < 256) {
            this.m_oraCharLevel1[n6] = -1;
            ++n6;
        }
        int n7 = 0;
        while (n7 < MAXLIMIT) {
            cArray[n7] = 65535;
            ++n7;
        }
        int n8 = 0;
        while (n8 < 65535) {
            try {
                nArray[n5][0] = this.toUnicode(n8);
                nArray[n5][1] = n8;
                ++n5;
            }
            catch (SQLException sQLException) {}
            ++n8;
        }
        int n9 = 0;
        while (n9 < nArray.length) {
            n3 = nArray[n9][0] >>> 8 & 0xFF;
            n2 = nArray[n9][0] & 0xFF;
            if (this.m_oraCharLevel1[n3] == -1) {
                this.m_oraCharLevel1[n3] = n4;
                n4 += 256;
            }
            if (cArray[this.m_oraCharLevel1[n3] + n2] == '\uffff') {
                cArray[this.m_oraCharLevel1[n3] + n2] = (char)(nArray[n9][1] & 0xFFFF);
            }
            ++n9;
        }
        if (this.extraUnicodeToOracleMapping != null) {
            int n10 = this.extraUnicodeToOracleMapping.length;
            n = 0;
            while (n < n10) {
                int n11 = this.extraUnicodeToOracleMapping[n][0];
                n3 = n11 >>> 8 & 0xFF;
                n2 = n11 & 0xFF;
                n3 = nArray[n][0] >>> 8 & 0xFF;
                n2 = nArray[n][0] & 0xFF;
                if (this.m_oraCharLevel1[n3] == -1) {
                    this.m_oraCharLevel1[n3] = n4;
                    n4 += 256;
                }
                if (cArray[this.m_oraCharLevel1[n3] + n2] == '\uffff') {
                    cArray[this.m_oraCharLevel1[n3] + n2] = (char)(nArray[n][1] & 0xFFFF);
                }
                ++n;
            }
        }
        this.m_oraCharLevel2 = new char[n4];
        n = 0;
        while (n < n4) {
            this.m_oraCharLevel2[n] = cArray[n];
            ++n;
        }
    }

    public void extractCodepoints(Vector vector) {
        int n = 0;
        int n2 = 65535;
        int n3 = n;
        while (n3 <= n2) {
            try {
                int[] nArray = new int[]{n3, (char)this.toUnicode(n3)};
                vector.addElement(nArray);
            }
            catch (SQLException sQLException) {}
            ++n3;
        }
    }

    public void extractExtraMappings(Vector vector) {
        if (this.extraUnicodeToOracleMapping == null) {
            return;
        }
        int n = 0;
        while (n < this.extraUnicodeToOracleMapping.length) {
            int[] nArray = new int[]{this.extraUnicodeToOracleMapping[n][0], this.extraUnicodeToOracleMapping[n][1]};
            vector.addElement(nArray);
            ++n;
        }
    }

    public char getOraChar1ByteRep() {
        return this.m_1ByteOraCharReplacement;
    }

    public char getOraChar2ByteRep() {
        return this.m_2ByteOraCharReplacement;
    }

    public int getUCS2CharRep() {
        return this.m_ucsCharReplacement;
    }

    public boolean hasExtraMappings() {
        return this.extraUnicodeToOracleMapping != null;
    }

    public static void main(String[] stringArray) throws SQLException {
        CharacterConverterGB18030 characterConverterGB18030 = new CharacterConverterGB18030();
        System.out.println(characterConverterGB18030.bMPLinear(-2127527632));
        System.out.println(characterConverterGB18030.bMPunLinear(characterConverterGB18030.bMPLinear(-2127527632)));
        System.out.println(characterConverterGB18030.bMPLinear(-1875869392));
        System.out.println(characterConverterGB18030.bMPunLinear(characterConverterGB18030.bMPLinear(-1875869392)));
        System.out.println(characterConverterGB18030.bMPUnicode2Oracle('\u0080'));
        System.out.println(characterConverterGB18030.bMPOracle2Unicode(-2127525063));
        System.out.println((int)characterConverterGB18030.toOracleCharacterWithReplacement('\ud800', '\udc00'));
        System.out.println((int)characterConverterGB18030.toOracleCharacterWithReplacement('\udbff', '\udfff'));
        System.out.println((int)characterConverterGB18030.toOracleCharacter('\ud800', '\udc00'));
        System.out.println((int)characterConverterGB18030.toOracleCharacter('\udbff', '\udfff'));
        System.out.println(characterConverterGB18030.toUnicode(-1875869392));
        System.out.println(characterConverterGB18030.toUnicode(-483222987));
    }

    private int searchgbMapping(char c, boolean bl) {
        int n;
        int n2;
        int n3;
        if (bl) {
            n3 = 1;
            n2 = 0;
            n = 2;
        } else {
            n3 = 3;
            n2 = 2;
            n = 0;
        }
        int n4 = gbMapping.length;
        int n5 = 0;
        while (n4 >= n5) {
            int n6 = (n4 + n5) / 2;
            if (gbMapping[n6][n2] <= c && c <= gbMapping[n6][n3]) {
                return c - gbMapping[n6][n2] + gbMapping[n6][n];
            }
            if (c < gbMapping[n6][n2]) {
                n4 = n6 - 1;
                continue;
            }
            if (c <= gbMapping[n6][n3]) continue;
            n5 = n6 + 1;
        }
        return -1;
    }

    private int surrogateUcs4ToUtf16(int n) {
        return (n - 65536 >> 10 | 0xD800) << 16 | (n & 0x3FF | 0xDC00);
    }

    private int surrogateUtf16ToUcs4(char c, char c2) {
        return ((0x3FF & c) << 10 | c2 & 0x3FF) + 65536;
    }

    int toOracleCharacterGB(char c, char c2) throws SQLException {
        int n;
        if (c2 != '\u0000') {
            int n2 = this.surrogateUtf16ToUcs4(c, c2);
            if (n2 >= 65536 && n2 <= 0x10FFFF) {
                return this.bMPunLinear(1876218 + (n2 - 65536) - 1687218);
            }
            throw new SQLException("Cannot map Unicode to Oracle character.");
        }
        int n3 = c >> 8 & 0xFF;
        int n4 = c & 0xFF;
        if (this.m_oraCharLevel1[n3] != -1 && this.m_oraCharLevel2[this.m_oraCharLevel1[n3] + n4] != '\uffff') {
            n = this.m_oraCharLevel2[this.m_oraCharLevel1[n3] + n4] & 0xFFFF;
        } else {
            n = this.bMPUnicode2Oracle(c);
            if (n == 0) {
                throw new SQLException("Cannot map Unicode to Oracle character.");
            }
        }
        return n;
    }

    int toOracleCharacterWithReplacementGB(char c, char c2) {
        int n;
        if (c2 != '\u0000') {
            int n2 = this.surrogateUtf16ToUcs4(c, c2);
            if (n2 >= 65536 && n2 <= 0x10FFFF) {
                return this.bMPunLinear(1876218 + (n2 - 65536) - 1687218);
            }
            return this.m_2ByteOraCharReplacement;
        }
        int n3 = c >> 8 & 0xFF;
        int n4 = c & 0xFF;
        if (this.m_oraCharLevel1[n3] != -1 && this.m_oraCharLevel2[this.m_oraCharLevel1[n3] + n4] != '\uffff') {
            n = this.m_oraCharLevel2[this.m_oraCharLevel1[n3] + n4] & 0xFFFF;
        } else {
            n = this.bMPUnicode2Oracle(c);
            if (n == 0) {
                if (c > '\u2fff') {
                    return this.m_2ByteOraCharReplacement;
                }
                return this.m_1ByteOraCharReplacement;
            }
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] toOracleString(String string) throws SQLException {
        int n = string.length();
        if (n == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        byte[] byArray = new byte[n * 4];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            if (cArray[n3] >= '\ud800' && cArray[n3] < '\udc00') {
                if (n3 + 1 >= n || cArray[n3 + 1] < '\udc00' || cArray[n3 + 1] > '\udfff') throw new SQLException("Cannot map Unicode to Oracle character.");
                n4 = this.toOracleCharacterWithReplacementGB(cArray[n3], cArray[n3 + 1]);
                ++n3;
            } else {
                n4 = this.toOracleCharacterGB(cArray[n3], '\u0000');
            }
            if (n4 >> 16 != 0) {
                byArray[n2++] = (byte)(n4 >> 24);
                byArray[n2++] = (byte)(n4 >> 16);
                byArray[n2++] = (byte)(n4 >> 8);
                byArray[n2++] = (byte)n4;
            } else if (n4 >> 8 != 0) {
                byArray[n2++] = (byte)(n4 >> 8);
                byArray[n2++] = (byte)n4;
            } else {
                byArray[n2++] = (byte)n4;
            }
            ++n3;
        }
        if (n2 >= byArray.length) return byArray;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    public byte[] toOracleStringWithReplacement(String string) {
        int n = string.length();
        if (n == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        byte[] byArray = new byte[n * 4];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            block10: {
                int n4;
                block9: {
                    block7: {
                        block8: {
                            if (cArray[n3] < '\ud800' || cArray[n3] > '\udbff') break block7;
                            if (n3 + 1 >= n || cArray[n3 + 1] < '\udc00' || cArray[n3 + 1] > '\udfff') break block8;
                            n4 = this.toOracleCharacterWithReplacementGB(cArray[n3], cArray[n3 + 1]);
                            ++n3;
                            break block9;
                        }
                        byArray[n2++] = (byte)(this.m_2ByteOraCharReplacement >> 8);
                        byArray[n2++] = (byte)this.m_2ByteOraCharReplacement;
                        break block10;
                    }
                    n4 = this.toOracleCharacterWithReplacementGB(cArray[n3], '\u0000');
                }
                if (n4 >> 16 != 0) {
                    byArray[n2++] = (byte)(n4 >> 24);
                    byArray[n2++] = (byte)(n4 >> 16);
                    byArray[n2++] = (byte)(n4 >> 8);
                    byArray[n2++] = (byte)n4;
                } else if (n4 >> 8 != 0) {
                    byArray[n2++] = (byte)(n4 >> 8);
                    byArray[n2++] = (byte)n4;
                } else {
                    byArray[n2++] = (byte)n4;
                }
            }
            ++n3;
        }
        if (n2 < byArray.length) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            return byArray2;
        }
        return byArray;
    }

    int toUnicode(int n) throws SQLException {
        if (this.bMPLinear(n) >= 39419) {
            int n2 = 1752754 + this.bMPLinear(n) - 1876218;
            return this.surrogateUcs4ToUtf16(n2);
        }
        if (n >> 16 != 0) {
            int n3 = this.bMPOracle2Unicode(n);
            if (n3 == 0) {
                throw new SQLException("Cannot map Oracle character to Unicode.");
            }
            return n3;
        }
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        if (this.m_ucsCharLevel1[n4] == '\uffff' || this.m_ucsCharLevel2[this.m_ucsCharLevel1[n4] + n5] == -1) {
            throw new SQLException("Cannot map Oracle character to Unicode.");
        }
        int n6 = this.m_ucsCharLevel2[this.m_ucsCharLevel1[n4] + n5];
        return n6;
    }

    public String toUnicodeString(byte[] byArray, int n, int n2) throws SQLException {
        int n3 = n + n2;
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n4 = n;
        while (n4 < n3) {
            int n5 = byArray[n4] & 0xFF;
            if (n5 > 127) {
                if (n4 + 1 < n3) {
                    if ((byArray[n4] & 0xFF) >= 129 && (byArray[n4] & 0xFF) <= 254 && (byArray[n4 + 1] & 0xFF) >= 48 && (byArray[n4 + 1] & 0xFF) <= 57) {
                        if (n4 + 3 < n3 && (byArray[n4 + 2] & 0xFF) >= 129 && (byArray[n4 + 2] & 0xFF) <= 254 && (byArray[n4 + 3] & 0xFF) >= 48 && (byArray[n4 + 3] & 0xFF) <= 57) {
                            n5 = (byArray[n4] & 0xFF) << 24 | (byArray[n4 + 1] & 0xFF) << 16 | (byArray[n4 + 2] & 0xFF) << 8 | byArray[n4 + 3] & 0xFF;
                            n4 += 4;
                            int n6 = this.toUnicode(n5);
                            if (n6 >> 16 == 0) {
                                stringBuffer.append((char)n6);
                                continue;
                            }
                            stringBuffer.append((char)(n6 >> 16 & 0xFFFF));
                            stringBuffer.append((char)(n6 & 0xFFFF));
                            continue;
                        }
                        throw new SQLException("Cannot map Oracle character to Unicode.");
                    }
                    n5 = byArray[n4] << 8 & 0xFF00 | byArray[n4 + 1] & 0xFF;
                    stringBuffer.append((char)this.toUnicode(n5));
                    n4 += 2;
                    continue;
                }
                throw new SQLException("Cannot map Oracle character to Unicode.");
            }
            stringBuffer.append((char)this.toUnicode(n5));
            ++n4;
        }
        return stringBuffer.toString();
    }

    public String toUnicodeStringWithReplacement(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n4 = n;
        while (n4 < n3) {
            int n5 = byArray[n4] & 0xFF;
            if (n5 > 127) {
                if (n4 + 1 < n3) {
                    if ((byArray[n4] & 0xFF) >= 129 && (byArray[n4] & 0xFF) <= 254 && (byArray[n4 + 1] & 0xFF) >= 48 && (byArray[n4 + 1] & 0xFF) <= 57) {
                        if (n4 + 3 < n3 && (byArray[n4 + 2] & 0xFF) >= 129 && (byArray[n4 + 2] & 0xFF) <= 254 && (byArray[n4 + 3] & 0xFF) >= 48 && (byArray[n4 + 3] & 0xFF) <= 57) {
                            n5 = (byArray[n4] & 0xFF) << 24 | (byArray[n4 + 1] & 0xFF) << 16 | (byArray[n4 + 2] & 0xFF) << 8 | byArray[n4 + 3] & 0xFF;
                            n4 += 4;
                            int n6 = this.toUnicodeWithReplacement(n5);
                            if (n6 >> 16 == 0) {
                                stringBuffer.append((char)n6);
                                continue;
                            }
                            stringBuffer.append((char)(n6 >> 16 & 0xFFFF));
                            stringBuffer.append((char)(n6 & 0xFFFF));
                            continue;
                        }
                        stringBuffer.append((char)this.m_ucsCharReplacement);
                        n4 += 4;
                        continue;
                    }
                    n5 = byArray[n4] << 8 & 0xFF00 | byArray[n4 + 1] & 0xFF;
                    stringBuffer.append((char)this.toUnicodeWithReplacement(n5));
                    n4 += 2;
                    continue;
                }
                stringBuffer.append((char)this.m_ucsCharReplacement);
                ++n4;
                continue;
            }
            stringBuffer.append((char)this.toUnicodeWithReplacement(n5));
            ++n4;
        }
        return stringBuffer.toString();
    }

    int toUnicodeWithReplacement(int n) {
        if (this.bMPLinear(n) >= 39419) {
            int n2 = 1752754 + this.bMPLinear(n) - 1876218;
            return this.surrogateUcs4ToUtf16(n2);
        }
        if (n >> 16 != 0) {
            int n3 = this.bMPOracle2Unicode(n);
            if (n3 == 0) {
                n3 = this.m_ucsCharReplacement;
            }
            return n3;
        }
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        int n6 = this.m_ucsCharLevel1[n4] != '\uffff' && this.m_ucsCharLevel2[this.m_ucsCharLevel1[n4] + n5] != -1 ? this.m_ucsCharLevel2[this.m_ucsCharLevel1[n4] + n5] : this.m_ucsCharReplacement;
        return n6;
    }
}

